.TH iSBC214/215/220
.SH NAME
iSBC 214/215/220 Device Driver
.SH DESCRIPTION
The iSBC 214/215/220 device driver supports several controllers that
use a compatible firmware interface. The iSBC 214 is a single board
integrated controller that can simultaneously manage a Winchester disk,
flexible media, and tape drives in a full 24-bit address space. The
iSBC 215 and 215G are Winchester controllers and can manage flexible
media and tape devices with the iSBX 218A and 217 MULTIMODULE boards
respectively.  The iSBC 220 controller is an SMD disk 
controller board only.
.sp
The device driver is structured with two driver interfaces, one
interface for Winchester and flexible devices and one for tape devices.
Different major numbers are used to access tape devices and disks, so
tape support is separately configurable.
The device driver can support up to four hard disks, four flexible disk drives,
and four tape drives. Up to four controller boards can be supported.
.sp
The device driver configuration file 
.B c215g.c 
contains the information
required to reconfigure the driver so it can converse with different
drive and controller configurations.
.sp
.na
.nf
.B Drive Size Characteristics Table
	struct	i215cdrt {
		unsigned	cdr_ncyl;
		char		cdr_nfheads;
		char		cdr_nrheads;
		char		cdr_nsec;
		unsigned	cdr_secsiz;
		char		cdr_nalt;
		struct i215part	*cdr_part;
	};
Where:
.B	cdr_ncyl
		Number of cylinders on the disk.
.B	cdr_nfheads
		Number of fixed heads on the drive.
.B	cdr_nrheads
		Number of removable heads on the drive.
.B	cdr_nsec
		Number of sectors on a track.
.B	cdr_secsiz
		Size of a sector, in bytes.
.B	cdr_nalt
		Number of alternate tracks to reserve on a
		Winchester, and used on flexible media drives
		to indicate recording density.
.sp
The following are device size characteristics
tables for tape, flexible disk, and Winchester devices.
.sp
/*
 * 215 Board 0 unit 8 (Tape) Device-Table Definitions (drtabs)
 */
struct	i215cdrt i215t00[] = {
/*Unit, no-op, no-op, no-op, no-op, !Rew?, Partition	*/
  01,	0,	0,	0,	0,   0,    Mmt0, /* Streamer  */
  01,	0,	0,	0,	0,   1,    Mmt0  /* No rewind */
};
.sp
/*
 * Flexible Disk Device-Table Definitions (drtabs)
 */
struct	i215cdrt i215f00[] = {
/*Cyls,  Fixed,  Remov,  #Sec,  SecSiz,  Nalt,    Part,  Drive */
   40,	  0,	  2,       8,     512   FLPY_MFM   PF0  /* dnf0 */  
   40,	  0,	  2,       4,    1024   FLPY_MFM   PF0  /* df0 */  
   40,	  0,	  1,      16,     128   FLPY_FM    PF0  /* syf0 */  
   40,	  0,	  2,       8,     512   FLPY_MFM   PF0  /* dzf0 */  
   40,	  0,	  2,       9,     512   FLPY_MFM   PF0  /* dvf0 */  
   40,	  0,	  2,       4,    1024   FLPY_MFM   PF0  /* boot */  
   40,	  0,	  2,       4,    1024   FLPY_MFM   PF0  /* ram */  
/*
 * Winchester Device-Table Definitions (drtabs)
 */
struct	i215cdrt i215d00[] = {
/*Cyls,    Fixed, Remov,  #Sec,  SecSiz,  Nalt, Partitions */
CYLINDERS, HEADS,  0,    SECTORS,  1024,  W_ALTS, Piw0
};
.sp
.B Drive Partition Table
	struct	i215part {
		daddr_t		p_fsec;
		daddr_t		p_nsec;
	};
Where:
.B	p_fsec
		Number of first sector of partition from
		the beginning of the drive.
.B	p_nsec
		Total number of sectors in partition.
.sp
The following are drive partition tables for tape, flexible disk,
and Winchester devices (drivers).
.bp
/*
 * Tape Partition Table (dummy).
 */
struct	i215part Mmt0[] = {
	0,		0 /* Archive streamer  */
};
.sp
/*
 * Flexible Disk Partition Tables.
*/
struct	i215part Pf0[] = {
	8,	632,    /* [0] (minor 07) dnf0	*/
	4,	316,    /* [1] (minor 08) df0	*/
	0,	1280,   /* [2] (minor 09) syf0	*/
	0,	640,    /* [3] (minor 10) dzf0	*/
	0,	720,    /* [4] (minor 11) dvf0	*/
	8,	184,    /* [5] (minor 12) boot	*/
	192,	128     /* [6] (minor 13) ram	*/
};
.sp
/*
 * Winchester Partitions.
*/
struct	i215part Piw0[] = {
	0,			DISKSIZ,        /* [0] whole disk */
	SECTORS,		ROOTSIZ,        /* [1] "root"	  */
	ROOTSIZ+SECTORS,	SWPSIZE,        /* [2] "swap"	  */
	SWPSIZE+ROOTSIZ+SECTORS, RESTSIZ,       /* [3] "rest"	  */
	SWPSIZE+ROOTSIZ+SECTORS+RESTSIZ, SECTORS/* [4] "error"	  */
};
.sp
.B Controller Configuration Table
	struct	i215cfg {
		long		c_wua;
		char		c_devcd[NUMSPINDLES/FIRST_FLOPPY];
		char		c_level;
		struct i215cdrt	*c_drtab[NUMSPINDLE];
	};
Where:
.B	c_wua
		Wake up address of controller.
.B	c_devcd
		Device code for each device unit type. Units
		0 - 3 are Winchester devices (types: DEVWINI for
		215A/B; DEVWINIG for 214/215G; DEV220 for 220).
		Units 4 - 7 are flexible media devices (types:
		DEV5FLPY for 5.25 inch; DEV8FLPY for 8 inch).
		Units 8 - 11 are tape devices (type: STREAMER).
.B	c_level
		MULTIBUS interrupt level. Used by controller
		to interrupt the host processor.
.bp
.B	c_drtab
		A pointer for each of the 12 units to its
		device characteristics table entry.
.sp
The following is the default configuration table for a controller.
.sp
/*
 * 215 Board configuration.
 */
struct	i215cfg	 i215cfg[] = {
/* WUA, DevCode[0], [1],       [2],   Int, Device Table[unit] */
0x01000L, DEVWINIG, DEV5FLPY, STREAMER, 5, i215d00,/* Wini 0 */
					   0,	   /* Wini 1 */
					   0,	   /* Wini 2 */
					   0,	   /* Wini 3 */
					   i215f00,/* Floppy 0 */
					   0,	   /* Floppy 1 */
					   0,	   /* Floppy 2 */
					   0,	   /* Floppy 3 */
					   i215t00,/* Tape 0 */
					   0,	   /* Tape 1 */
					   0,	   /* Tape 2 */
					   0,	   /* Tape 3 */
};

.ad
.fi
.sp
The minor number in the special device file is used as an index
into the driver's minor table. The minor table entry for each
defined minor number contains the partition number, drtab entry,
drive unit, and controller board number.
.sp
The iSBC 214/215/220 device driver uses the same standard format
structure used by the 
.I format 
utility. The ioctl interface
structure for formatting provides the format type commands
necessary to do alternate track mapping.
.sp
.na
.nf
.B	FORMAT_DATA		0x00
		Format the specified data track.
.B	FORMAT_BAD		0x80
		Format the specified track as a bad track.
.B	FORMAT_ALTERNATE	0x40
		Format the specified track as an alternate
		track.
.ad
.fi
.sp
If the controller runs out of alternate tracks, an ENXIO error
is returned by the driver.
.bp
.SH FILES
sys/h/i215g.h 

sys/cfg/c215g.c

dev/makefile 

sys/conf/master

sys/conf/xenixconf
.SH SEE ALSO
iSBC 214 Winchester Disk Controller Hardware Reference Manual.

iSBC 215 Generic Winchester Disk Controller Hardware Reference Manual.

iSBX 218A Flexible Disk Controller Board Hardware Reference Manual.

iSBC 220 SMD Disk Controller Hardware Reference Manual.
.SH DIAGNOSTICS
For any soft or hard error generated by the controller, the driver
will print at the system console an appropriate error message
stating the controller and the drive on which the error occurred.
The cylinder, head, and sector being accessed when the error
occurred will also be printed at the console for disks and flexible
media drives. In all cases, the kind of error is given.
In addition, the appropriate error number is returned to the user
process for exception handling.
