.DA "September 7, 1984"
.TH FORMAT
.SH Name
format \- Format a volume and optionally install a bootstrap
loader.
.SH Syntax
format\^
.I [ options ] <dev> 
.sp
.SH Description
.I Format\^
will format a volume (flexible diskette, Winchester
disk, or cartridge tape) and optionally install a bootstrap loader on
track 0 of the
volume.  A volume is formatted a track at a time until the driver returns an
error not of the type EIO. 
Since EIO indicates an I/O error, the track it occurred on is assumed
to be bad and is replaced with the alternate-track ioctl calls.
Since the iSBC 215/218/220 driver and the iSBC 208
drivers return other errors if a request is outside the partition,
this algorithm formats the entire partition.
While formatting, format prints a "." for every five cylinders
formatted; this allows quick visual verification of correct operation.
Upon completion, format reports to the user how many tracks were
formatted and which tracks they were.  All track numbers are
relative to the partition being formatted.  dev must specify
a raw device.  These are the formatting options:
.TP
.B -a
Assign alternate tracks by using the iSBC 215
alternate tracking capabilities.
.TP
.B -b 
Look for bad block data on the disk.  To be used with
rigid media disks only.
.TP
.B -B <file>
Look for bad block data in file.  To be used
with rigid media disks only.
.TP
.B -t <track>
Used with -b.  Look on track number <track> for
bad block data.
.TP
.B -n <numalts> 
Number of alternate cylinders.  Rigid media
disk only.
.TP
.B -A <altstart> 
Alternate tracks start at track <altstart>.
.TP
.B -f <first>
Start formatting at track <first>.
.TP
.B -l <last> 
Stop formatting at track <last>.
.TP
.B -i <interleave> 
Format volume with interleave <interleave>.
.TP
.B -v
Set verbose mode.  Print out alternate track mapping.
.TP
.B -q
Set query mode.  Get bad track data from user.
.TP
.B -V[e]
Set verify mode.  if the <e> is specified, testing is exhaustive,
i.e. every sector formatted will be tested.  If the <e> is omitted, only
one sector on every track will be tested.  Note that this increases the
time to format a drive significantly.
.PP
These switches are to be used only when installing the
bootstrap loader:
.TP
.B -S
Install the second-stage bootstrap loader on track 0
of this device.
.TP
.B -d
Do not format this device.  This option implies -S
since otherwise nothing would occur at all.
.TP
.B -bf <file>
Second stage bootstrap loader is in <file>.
.TP
.B -D <fsdelta>
File system starts at sector number <fsdelta>.
.TP
.B -c <cyls> 
There are <cyls> cylinders on the device.
.TP
.B -fh <fheads>
There are <fheads> fixed read/write heads on
the device.a
.TP
.B -rh <rheads>
There are <rheads> removable read/write heads
on the device.a
.TP
.B -g <gran>
There are <gran> bytes per sector.a
.TP
.B -s <sec/trk>
There are <sec/trk> sectors per track.
.TP
.B -h <heads/cyl>
There are <heads/cyl> heads per cylinder.
.TP
.bp
.B -o <offset>
There is (or soon will be) a file system on
this disk starting at block <offset>.  The file system will
be copied into a section of RAM at boot time.  RAM locations
are specified with the -r option, a description of which 
follows.
.TP
.B -r <ramloc ramsiz>
The file system image at <offset> is to
be loaded into RAM starting at location <ramloc> and extending
no further than <ramsiz>.  The -r and -o options enable you to boot
a XENIX that is entirely RAM-resident. This option
is useful at installation.
.TP
.B -w
Sets up correct values for a Quantum Q540 Winchester
drive (default).
.TP
.B -W
Sets up correct values for a PRIAM 3450 Winchester
drive.
.TP
.B -F
Sets up correct values for a 5?-inch double-sided,
double-density, 1024 bytes-per-sector, 4 sectors-per-track
boot diskette.
.TP
.B -X
Sets up correct values for an 8-inch double-sided,
double-density, 256 bytes-per-sector, 26 sectors-per-track
boot diskette.
.TP
.B <dev>
Raw device to be formatted.  If a bootstrap loader
is to be installed on a 5 1/4-inch diskette, two devices must
be specified, since the bootstrap loader will not fit on the
first track alone.
.sp
.SH DIAGNOSTICS
The error messages produced by \fBformat\fP are self-explanatory.
