.DA "September 7, 1984"
.TH CC
'
.SH Name
'
cc \- Invokes the C compiler.
'
.SH Syntax
'
\fBcc\fP [ \fIoptions\fP ] \fIfilename\fP ...
'
.SH Description
'
.I Cc
is the 
.SM XENIX 
C compiler command.  It creates executable programs
by compiling and linking the files named by the
.I filename
arguments.
.I Cc
creates the resulting program in the file
.B a.out
by default.
.PP
The 
.I filename
can name any C or assembly language source file or
any object or library file.  C source files must have 
a ``.c'' filename extension.  Assembly language source 
files must have ``.s'', object files ``.o'', and library files 
\&``.a'' extensions.
.I Cc
invokes the C compiler for each C source file and copies 
the result to an object file whose basename is the same as 
the source file but whose extension is ``.o''.
.I Cc
invokes the 
.SM XENIX
assembler,
.I as,
for each assembly source file and copies the 
result to an object file with extension ``.o''.
.I Cc
ignores object and library files until all 
source files have been compiled or assembled.  
It then invokes the 
.SM XENIX
link editor,
.I ld,
and combines all the object files it has created
together with object files and libraries given in
the command line to form a single program.
.PP
Files are processed in the order they are encountered 
in the command line, so the order of files
is important.  Library files are examined only 
if symbols referenced in previous files have 
not yet been defined.  Only those modules 
which define unresolved references are concatenated.
A number of ``standard'' libraries are searched
automatically.  These libraries support the standard C
library functions and program startup routines.
Which libraries are used depends on the program's
memory model (see ``Memory Models'' below).
Execution of the resulting program will 
begin in the ``main'' program function. 
.PP
There are the following options:
.TP
.B \-P	
Preprocess each source file and copy the 
result to a file whose basename is the same as the
source but whose extension is ``.i''.  Preprocessing
performs the actions specified by the preprocessing
directives in the source file, and inhibits compilation
and linking. 
.TP
.B \-E 
Preprocess each source file as described for
.B \-P,
but copy the result to the standard output. 
The option also places a #line directive with the current
input line number and source file name at the beginning 
of output for each file.
.TP
.B \-EP
Preprocesses each source file as described for
.B \-E,
but does not place a #line directive at the
beginning of the file. 
.TP
.B \-C
Preserves comments when preprocessing a file with
.B \-E 
or
.BR \-P.
That is, comments are not removed from the preprocessed
source.  This option may only be used in conjunction
with 
.B \-E 
or
.B \-P.
.TP
.BI \-D " name [ = string ]"
Defines 
.I name
to the preprocessor as if defined by a #define in each
source file.  The form ``\-D \fIname\fP'' sets 
.I name
to 1.  The form ``\-D \fIname = string\fP'' sets
.I name
to the given 
.IR string. 
.TP
.BI \-U " name [ = string ]"
Removes definition of 
.I name
so that the preprocessor removes the name defined by a #define
in each source file.  The form ``\-D \fIname\fP'' sets
.I name
to 0.  The form ``\-D \fIname = string\fP'' undefines
.I name 
for the given
.IR string.
.TP
.BI \-I " pathname"   
Adds 
.I pathname
to the list of directories to be searched when an 
#include file is not found in the directory 
containing the current source file or whenever
angle brackets (< >) enclose the filename.
There is a standard list of directories which are
searched automatically.
.TP
.B \-X            
Removes the standard directories from the list of
directories to be searched for #include files. 
.TP
.BI \-V " string"
Copies 
.I string 
to the object file created from the given
source file.  This option may be used for version
control.
.TP
.BI \-W " num"
Sets the output level for compiler warning messages.  If 
.I num 
is 0, no warning messages are issued.  If 1, only warnings 
about program structure and overt type mismatches are issued.  
If 2, warnings about strong typing mismatches are issued.  
If 3, warnings for all automatic conversions are issued.
This option does not affect compiler message output for
non-warning messages.
.TP
.B \-w
Prevents compiler warning messages from being issued. 
Same as ``\-W 0''.
.TP
.B \-p 
Adds code for program profiling.  Profiling code counts 
the number of calls to each routine in the program and
copies this information to the 
.B mon.out 
file.  This file can be examined using the
.IR prof 
command.  Profiling is supported only in small model.
.TP
.B  \-pack
Packs structure members.  Caution should be taken when using
the pack option since structures are no longer word aligned.
.TP
.B  \-i
Creates separate instruction and data spaces for
small model programs.  When the output file is 
executed, the program text and data areas are 
allocated separate physical segments.  The text 
portion will be read-only and may be shared by all users 
executing the file.  The option is implied when
creating middle, large, or huge model program.
.TP 
.BI \-F " num"
Sets the size of the program stack to 
.I num
bytes.  Default stack size if not given is 4
Kbytes.
.TP
.B \-K
Removes stack probes from a program. Stack probes
are used to detect stack overflow on entry to
program routines.
.TP
.BI \-nl " num"
Sets the maximum length of external symbols to
.I num.
Names longer than 
.I num
are truncated before being copied to the external
symbol table.
.TP
.B \-Alfu
Saves/restores the value of the ds register before 
and after procedure calls.  The value is saved on
the stack.
.TP
.BI \-M " string"
Sets the program configuration.  This configuration 
defines the program's memory model, word order, and data
threshold.  It also enables C language enhancements
such as advanced instruction sets and keywords. The 
.I string
may be any combination of the following (except that the ``s'',
\&``m'', ``l'', and ``h'' options are mutually exclusive,
as are ``0'', ``1'', and ``2''):
.br
s	Creates a small model program (default).
.br
m	Creates a middle model program.
.br
l	Creates a large model program.
.br
h	Creates a huge model program.
.br 
e	Enables the far and near keywords.
.br
0 	Enables 86 code generation.
.br
1 	Enables 186 code generation.
.br
2 	Enables 286 code generation(default).
.br
b	Reverses the word order for \fBlong\fP types.  High 
	order word is first.  Default is low order 
	word first.
.br
t \fInum\fP	Sets the size of the largest data item in the 
	data group to \fInum\fP.  Default is 32,767.  Items 
	larger than this threshold are placed in another 
	segment.
.br
d	Sets SS equal to DS. 
.TP
.B \-c
Suppresses linking of the object modules produced
by the compilation(s).  No executable
program is created.  
.TP
.BI \-o " filename" 
Defines 
.I filename 
to be the name of the final executable program.
This option overrides the default name
.B a.out
and is effective only when the linker is invoked.
.TP 
.B \-dos
Directs
.B cc
to create an executable program for MS-DOS systems.
.TP
.BI \-l library
Searches
.I library
for unresolved references to symbols.  The
.I library
must be an object file archive in 
.I ranlib
format.
.TP
.B \-O 
Invokes the object code optimizer during compilation.  Anyone
of the following strings can be appended after the O to provide
different levels of optimizer control.  Note without any letter
following the O, the normal optimization to favor code size and
execution speed is performed.
.br
d	disable optimization, performs no optimization
.br
a	relax aliasing checks
.br
s	favor code size
.br
t	favor execution time
.br
x	maximum optimization (equivalent to -Oas and -K).  
	This option should be used with caution.
.TP
.B \-S
Creates an assembly source listing of the compiled
C source file and copies this listing to the file whose
basename is the same as the source but whose extension
is ``.s''.
Linking is also suppressed.
It should be noted that this file is not suitable
for assembly.  This option provides code for inspection
only.
.TP
.B \-L
Creates an assembler listing file containing
assembled code and assembly source instructions.
The listing is copied to the file whose basename is the
same as the source but whose extension is ``.L''.
This option overrides the ``\-S'' option and suppresses linking.
.TP
.BI \-NM " name"
Sets the module name for each compiled or assembled
source file to 
.I name.
If not given, the filename of each source file is
used.
.TP
.BI \-NT " name"
Sets the text segment name for each compiled or
assembled source file to 
.I name.
If not given, the name ``\fImodule\fP_TEXT''
is used for middle model, and ``_TEXT'' for
small model.
.TP
.BI \-ND " name"
Sets the data segment name for each compiled or
assembled source file to 
.I name.
If not given, the name ``_DATA'' is used.
.PP
Many options (or equivalent forms of these options)
are passed to the link editor as the last phase
of compilation.  The ``s'', ``m'', and ``l'' configuration
options are passed to specify memory requirements.  The \-i,
\-F, and \-p are passed to specify other
characteristics of the final program.
.PP
The \-D and \-I
options may be used several times on the
command line.  The \-D option must not define the same name 
twice.  These options affect subsequent source files only.
'
.SH "Memory Models"
'
.I Cc
can create programs for four different memory 
models: small, middle, large, and huge.  In addition, small 
model programs can be pure or impure.
.TP
Impure-Text Small Model
These programs occupy one 64 Kbyte physical
segment in which both text (machine instructions) and data are combined.
.I Cc
creates impure small model programs by default.
They can also be created using the
``-Ms'' option.
.TP
Pure-Text Small Model
These programs occupy two 64 Kbyte physical 
segments.  Text and data are in separate segments.  
The text is read-only and may be shared by several 
processes at once.   The maximum program size is 128
Kbytes.  Pure small model programs are created using 
the ``-i'' flag when linking small model programs.
.TP
Middle Model 
These programs occupy several physical segments when linked, but 
only one segment contains data.  A text segment is allocated per
source module, but all data segments are combined.  Special call and
returns are used to access functions in other
segments.  The total amount of text can be any size. Data must not
exceed 64 Kbytes.  Middle models programs are created 
using the ``-Mm'' option.  These programs are always pure.
.TP
Large Model 
These programs occupy several physical segments with 
both text and data in as many segments as required.  
Text is handled as in Middle Model.
Special addresses
are used to access data in other segments.  Text and
data may be any size, but no data item may be larger
than 64 Kbytes.  Large model programs are created using
the ``-Ml'' option.  These programs are always
pure.
.TP
Huge Model 
These programs occupy several physical segments with 
both text and data as in Large Model, but arrays may
span segments, allowing them to be larger than 64K.
Arrays which span more than 2 segments (128K) must
contain an integral number of array elements per 64K
segment.
.PP
Small and middle model object files can only be 
linked with object files and libraries of the same
model.  Large and huge model object files can be
linked only with large and huge model object files
and libraries.
It is not possible to combine small, medium, 
and large/huge model object files into one executable program.
.I Cc
automatically selects the correct small, middle, or 
large versions of the standard libraries based 
on the configuration option.  It is up to the user to 
make sure that all of his own object files and private 
libraries are properly compiled in the appropriate model.
.PP
The special calls and returns used in middle and large 
model programs may affect execution time, particularly
if frequent calls are made to very short routines.
.PP
In middle, large, and huge model programs, function pointers 
are 32 bits long.   In large and huge model programs, data
pointers are 32 bits long.  Programs making use of such 
pointers must be written carefully to avoid
incorrect declaration and use of these types.  
.IR Lint 
will help to check for correct use.
.PP
The user should keep the following in mind when programming
in huge model:
.TP
Objects
No object can cross a segment boundary. (An object is defined
as data structures that can be elements of an array: scalar 
objects (intergers and floating point numbers) and composite
objects (structures and unions).)
.TP
Address Space
The address space must simulate a linear address space.
.TP
Array Alignment
Arrays of objects requiring more than one segment must align
to 64Kb boundaries.
.TP
Structure Size
No structure or union can b > 64Kb.  If an array is >64Kb
but <128Kb, then it can be offset within a segment to ensure 
that the objects align to the 64Kb boundary.  If the array
requires three or more segments (128Kb), then the size of
the objects in the array must be a power of two (this is true
for scalar objects).
.PP
The \-NM, \-NT, and \-ND options may be
used with middle, large and huge model programs to direct
the text and data of specific object files to 
named physical segments.   All text having the same 
text segment name is placed in a single physical
segment.  Similarly, all data having the same
data segment name is placed in a single physical
segment. 
'
.SH Files
'
/bin/cc, /lib/p0, /lib/p1, /lib/p2, /lib/p3
'
.SH "See Also"
'
as, ar, ld, lint, ranlib 
'
.SH Notes
'
Error messages are produced by the program that
detects the error.  These messages are usually produced
by the C compiler, but may occasionally be produced 
by the assembler or the link loader.
.PP
All object module libraries must have a current
.I ranlib
directory.


