.TH iSBC226
.SH NAME
iSBC 226 Device Driver
.SH DESCRIPTION
The iSBC 226 device driver supports the iSBC 226 SMD controller board
under XENIX 286 R3.0 and R5.0. The iSBC 226 controller is a single board
disk controller for fixed or removable media SMD drives. Each drive may
be up to 2.4 gigabytes with a maximum data rate of 1.9 megabytes/second.
.sp
The driver can support up to four controller boards, and up to four drives
per controller. The drives may be of different sizes and from different
manufacturers. The maximum number of partitions per drive is sixteen (16),
of which the last physical partition on each drive must be defined as
an error logging partition. Typically one track of drive storage is
allocated for error logging.
.sp
There are three data structures in the iSBC 226 configuration file 
.B c226.c
that are statically defined and provide all the information 
the driver needs to converse with your hardware configuration. These are
the size structure, the partition structure, and the per controller
configuration structure.
The size structure provides the drive-specific information, the partition
structure, the logical partitioning of the drive into file systems, and the
configuration structure the interrupt, base status register address
for the controller, and pointers to the size and partition structures for
each drive attached to the controller.
.br
.nf
.na
.sp
.B Drive Size Characteristics Table
	struct	i226size {
			ushort	s_ncyl;
			ushort	s_fhds;
			ushort	s_rhds;
			char		s_hdoff;
			ushort	s_sec;
			ushort	s_secsiz;
			ushort	s_altsec;
	};
Where:
.B	s_ncyl
		Number of cylinders on the drive.
.B	s_fhds
		Number of fixed heads on the drive.
.B	s_rhds
		Number of removable heads on the drive.
.B	s_hdoff
		Removable platters head offset, MSB must
		be set for embedded servo (hard sectored)
		drives.
.bp
.B	s_sec
		Number of virtual sectors used per track,
		excluding the number of slipped sectors
		per track.
.B	s_secsiz
		Number of bytes per sector.
.B	s_altsec
		Number of reserved sectors per track.
.sp
The following are drive size tables.
.sp
/*
 * List of standard drives
 * supported by the iSBC 226 driver.
 * The eighth (MSB) bit must be set in
 * the header offset field (hdoff)
 * for embedded servo (hard sector) drives.
 *
 * Size fields:
 *      Cylin,  Fhds,   Rhds,   Hdoff,  Sec,  Secsiz,  Altsec
 */
struct i226size
  /* Century 315-1, 315 MB Drive, 3 Slipped Sectors */
     s_ams315_3[] = {
		845,   19,     0,      SERVO,  15,   1024,    3, 
     },
  /* Fujitsu 2312, 84 MB Drive, 1 Slipped Sector */
     s_fuj2312_1[] = {
		589,    7,     0,      0,      17,   1024,    1,
     },
  /* Fujitsu 2312, 84 MB Drive, 3 Slipped Sectors */
     s_fuj2312_3[] = {
		589,    7,     0,      0,      15,   1024,    3
     };
.sp
.B Drive Partition Table
	struct	i226part {
			daddr_t	p_fsec;
			daddr_t	p_nsec;
	};
Where:
.B	p_fsec
		Number of first sector of partition from
		the beginning of the drive.
.B	p_nsec
		Total number of sectors in the partition.
.bp
The following are drive partition tables.
.sp
/*
 * List of standard partition configurations.
 * Partitions must start on track boundaries.
 *
 * Fields:
 *        First Sec     Size      Part            Tracks
 */
struct i226part
  /* Century 315-1, 315 MB Drive, 3 Slipped Sectors */
	p_ams315_3[] = {
		0,      240825, /* 0 entire disk  16055 */
		15,     51195,  /* 1              3413  */
		51210,  51195,  /* 2              3413  */
		102405, 51195,  /* 3              3413  */
		153600, 51195,  /* 4              3413  */
		204795, 35985,  /* 5              2399  */
		240780, 45,     /* 6 bad block    3     */
	},
  /* Fujitsu 2312, 84 MB Drive, 1 Slipped Sector */
	p_fuj2312_1[] = {
		0,      70091,  /* 0 entire disk  4123 */
		17,     5712,   /* 1 "root"       336  */
		5729,   1904,   /* 2 "swap"       112  */
		7633,   61030,  /* 3 "usr"        3590 */
		68663,  34      /* 4 bad block    2    */
	},
   /* Fujitsu 2312, 84 MB Drive, 3 Slipped Sectors */
	p_fuj2312_3[] = {
		0,      60600,  /* 0 entire disk  4040 */
		15,     5040,   /* 1              336  */
		5055,   1680,   /* 2              112  */
		6735,   53850,  /* 3              3590 */
		60585,  30,     /* 4 bad block    2    */
	};
.sp
.B Controller Configuration Table
	struct	i226cfg	{
			ushort	c_level;
			ushort	c_pbase;
			struct	i226dr_cfg {
				char	dc_pnum;
				struct	i226size dc_sp;
				struct	i226part dc_pp;
			} c_drv[4];
	};
Where:
.B	c_level
		MULTIBUS interrupt level. Used by board
		to interrupt the host processor.
.bp
.B	c_pbase
		Base address for the controller status registers.
.B	dc_pnum
		Number of partitions in the drive.
.B	dc_sp
		Address of drive's size structure.
.B	dc_pp
		Address of drive's partition structure.
.sp
The following is the default controller configuration
entry.
.sp
/*
 * Configuration table. One entry for each controller.
 */
struct i226cfg i226cfg[] = {
	  /* Configuration Table For Board 0 */
	0x04,        /* interrupt level */
	0xee40,      /* base address for I/O ports */
	5,           /* number partitions for drive 0 */
	s_fuj2312_3, /* size for drive 0 */
	p_fuj2312_3, /* partitions for drive 0 */
	0,           /* number partitions for drive 1 */
	0,           /* size for drive 1 */
	0,           /* partitions for drive 1 */
	0,           /* number partitions for drive 2 */
	0,           /* size for drive 2 */
	0,           /* partitions for drive 2 */
	0,           /* number partitions for drive 3 */
	0,           /* size for drive 3 */
	0,           /* partitions for drive 3 */
};
.fi
.ad
.sp
The default driver configuration is for one iSBC 226 board.
The board is in the 24-bit addressing mode,
MULTIBUS interrupt level of 0x04, control status register base
address of 0xee40.
.sp
The minor number in the special device file for the iSBC 226 is
divided into the following partition, drive, and controller
bit fields.
.na
.nf
.sp
\fB	0 - 3\fP Partition number on a drive, 0 to 15.
\fB	4 - 5\fP Number of drive on a controller, 0 to 3.
\fF	6 - 7\fP Number of controller in system, 0 to 3.
.fi
.ad
.sp
You use the same format command for the iSBC 226 and the iSBC 215 
drivers since their ictl structures are comparable.  Because the
iSBC 226 controller uses sector slipping within a track instead of
alternate track mapping the semantics of the format type commands
are different. The meaning of the format type commands are:
.na
.nf
.bp
.B	FORMAT_DATA		0x00
		Format the specified data track.
.B	FORMAT_BAD		0x80
		Slip sector specified in pat[3] on the specified
		track.
.B	FORMAT_ALTERNATE	0x40
		No action taken.
.B	FORMAT_READ		0x01
		Return a copy of sector headers for the specified
		track.
.fi
.ad
.sp
If a track runs out of spare sectors to slip, the error returned 
(ENXIO)is the same as when a controller that does alternate track mapping 
runs out of alternate tracks.
.sp
You can use the FORMAT_READ command in conjunction with the
FORMAT_BAD command to allow the mapping out of bad sectors listed
by the drive manufacturer.
.sp
You can also make an ioctl call to get the drive status.  If the 
drive is offline, EFAULT is the value returned.
.SH FILES
sys/h/i226.h

sys/cfg/c226.c

sys/conf/master

sys/conf/xenixconf
.SH SEE ALSO
iSBC 226 Hardware Reference Manual. Intel Corp. 1984.
Document order number: 147047.
.SH DIAGNOSTICS
For any soft or hard error generated by the controller, the driver will
print at the system console an appropriate error message stating the
controller and the drive on which the error occurred. The cylinder,
head, and sector being accessed when the error occurred are provided
along with the kind of error.
Also, the appropriate error number is returned to the user process
for exception handling.
.SH NOTES
When using the driver with chained IOPBs configured on a 
two-drive version of the iSBC 226 board,
multiple controller and drive configurations may cause
random, non-fatal soft errors.  We recommend that you configure
the driver using single IOPBs.  Do this by setting 'PB_SIZE' in 
.B c226.c 
to '(1 * N226)'.
For example, setting 'PB_SIZE' to  '(4 * N226)' will provide four
IOPBs for each controller and thus allow command chaining of up to
four IOPBs at one time.
