.DA "September 7, 1984"
.TH DOSLD
.SH Name
dosld \- Xenix to MS-DOS cross linker.
.SH Syntax
dosld [
.I
options
] file ...
.SH Description
.I Dosld
links the object file(s) given by
.I file
to create a program for execution under MS-DOS. Although 
similar to
.IR ld ,
.I dosld
has many options that differ significantly from 
.I ld .
The options are described below:
.TP 5n
.B \-D
DS Allocate.  This option instructs 
.I dosld 
to perform DS allocation.
It is generally used in conjunction with the
.B -H 
option.
.TP
.B \-H
Load high.  This option instructs 
.I dosld 
to set a field in the
header of the executable file to tell MS-DOS to load the program
at the highest available position in memory.  It is most often
used with programs in which data precedes code in the memory image.
.TP
.B \-L
Include line numbers.  This option instructs 
.I dosld 
to include line
numbers in the listing file (if any).  Note that 
.I dosld 
cannot put
line numbers in the listing file if the source translator hasn't put
them in the object file.
.TP
.B \-M
Include public symbols.  This option instructs 
.I dosld 
to include
public symbols in the list file.  The symbols are sorted twice,
lexicographically and by address.
.TP
.B \-C
Ignore case.  This option instructs 
.I dosld 
to treat upper and lower
case characters in symbol names as identical.
.TP
.B \-F \fInum\fP
Set stack size.  This option should be followed by a hexadecimal
number.  
.I Dosld 
will use this number for the size in bytes of the
stack segment in the output file.
.TP
.B \-S \fInum\fP
Set segment limit.  This option should be followed by a decimal
number between 1 and 1024.  The number sets the limit on the
number of different segments that may be linked together.  The
default is 128.  Note that the higher the value given, the slower
the link will be.
.TP
.B \-m \fIfilename\fP
Create map file.  This option should be followed by a filename.
.I Dosld 
will create a file with the given name in which it will
put information about the segments and groups in the executable.
Additionally, public symbols and line numbers will be listed in
this file if the 
.B \-M 
and 
.B \-L 
options are given.
.TP
.B \-nl \fInum\fP
Set name length.  This option should be followed by a decimal
number.  The option instructs 
.I dosld 
to truncate all public
and external symbols longer than 
.I num
characters.
.TP
.B \-o \fIfilename\fP
Name output file.  This option should be followed by a filename
which 
.I dosld 
will use as the name of the executable file it creates.
The default name is 
.B a.out.
.TP
.B \-u \fIname\fP
Name undefined symbol.  This option should be followed by a symbol
name.  
.I Dosld 
will enter the given name into its symbol table as an
undefined symbol.  The 
.B \-u 
option may appear more than once on the
command line.
.TP
.B \-G
Ignore group associations.  This option instructs 
.I dosld
to ignore any group definitions it may find in the input files.
This option is provided for compatibility with old versions of 
MS-LINK; generally, it should never be used.
.PP
As with 
.IR ld , 
the files passed to 
.I dosld 
may be either Xenix-style libraries (objects collected using 
.IR ar)
and indexed using 
.IR ranlib 
or ordinary 8086 object files.  Unless the 
.B \-u 
option appears,
at least one of the files passed to 
.I dosld 
must be an ordinary
object file.  Libraries are searched only after all the ordinary
object files have been processed.
.SH Files
/usr/bin/dosld
.SH "See Also"
ar, as, cc, ld, ranlib
