/*
	ASCII2PT - convert display ASCII to archive paper tape.

			   The program takes two arguments - input ASCII filename
												 output archive filename
*/

#include <stdio.h>
#include <string.h>
#include "cvtables.h"

void main(int argc, char *argv[])
{
	int i;
	int j;
	char ch;
	char savechr;
	char eof;
	FILE *iF;
	FILE *oF;
	char iN[80];
	char oN[80];
	int cp;

	cp = 0;
	eof = EOF;

	printf("Convert display ASCII to archive paper tape.\n");

	if (argc > 1) {
		strcpy(iN, argv[1]);
	} else {
		strcpy(iN, "input.asc");
	}
	printf("  Input file: %s\n", iN);
	iF = fopen(iN, "r");
	if (iF == 0) {
		printf("No such input file - %s\n", iN);
		exit();
	}

	if (argc > 2) {
		strcpy(oN, argv[2]);
	} else {
		strcpy(oN, "output.pt");
	}
	printf("  Output file: %s\n", oN);
	oF = fopen(oN, "wb");
	if (oF == 0) {
		printf("Cannot open output file - %s\n", oN);
		fclose(iF);
		exit();
	}

	while ((ch=fgetc(iF))!=eof) {
		if ((ch=='\r') || (ch=='\n')) continue;
		cp++;
		savechr=T5[ch&127];
		fputc(T5[ch&127], oF);
	}
	printf("%d\n", savechr);

	fclose(iF);
	fclose(oF);

	printf("  Characters processed: %d\n", cp);
	printf("Conversion complete.\n\n");
}
