
            case ADDREXPRSTART: /* Address operator found */
               switch ( lachar )
               {

                  case '[':
                  case '{':
                     lachar = '(';
                  case '(':
                     token = lachar;
                     break;

                  case ']':
                  case '}':
                     lachar = ')';
                  case ')':
                     token = lachar;
                     break;

                 default:
                     if (latran == 1)
                        token = EOS;
                     else
                        token = lachar;
               }
               break;

            case 2: /* Address symbol found */
            case 11: /* Data symbol found */
               {
                  int iii;

                  value = 0;
                  token = SYM;
                  for (iii = 0; symbol[iii] != '\0'; iii++ ) 
		     if (islower(symbol[iii]))
			symbol[iii] = toupper(symbol[iii]);
		  if (fapmode)
		     qualsym[0] = '\0';
		  else
		     strcpy (qualsym, qualtable[qualindex]);
               }
               break;

            case 3: /* Address qualified Symbol found */
            case 12: /* Data qualified Symbol found */
               {
		  char *iiicp;
                  int iii;

                  value = 0;
                  token = SYM;
                  for (iii = 0; symbol[iii] != '\0'; iii++ ) 
		     if (islower(symbol[iii]))
			symbol[iii] = toupper(symbol[iii]);
		  iiicp = (char *)strchr(symbol, '$');
		  *iiicp = '\0';
		  iiicp++;
		  strcpy (qualsym, symbol);
		  strcpy (symbol, iiicp);
		  if (strlen(qualsym) == 0 && strlen(symbol) == 0)
		  {
		     Parse_Error (SCAN_ERROR, INVSYMBOL, defer);
		     *svalue = 0;
		     strcpy (toksym, "0");
		     return (0);
		  }
               }
               break;

            case 4: /* Address number found */
	       if (radix == 10)
	       {
		  value = value * 10 + dignum;
		  evalue = evalue * 10 + dignum;
		  token = DECNUM;
	       }
	       else if (radix == 8)
	       {
		  token = OCTNUM;
		  if (dignum > 7)
		  {
		     Parse_Error (SCAN_ERROR, INVOCTNUM, defer);
		     *svalue = 0;
		     strcpy (toksym, "0");
		     return (0);
		  }
		  else
		     value = (value << 3) | dignum;
	       }
               break;

            case 5: /* PC symbol found */
            case 24: /* recognize nulsym "**" */
	       value = pc;
	       token = ASTER;
	       relocatable++;
	       break;

            case 6: /* End of expression */
	       token = EOS;
	       break;

            case BOOLEXPRSTART: /* Boolean Operator found */
               switch ( lachar )
               {
	       case '+':
		  token = OR;
		  break;
	       case '-':
		  token = XOR;
		  break;
	       case '/':
		  token = NOT;
		  break;
	       case '*':
		  token = AND;
		  break;
	       default:
		  if (latran == 1)
		     token = EOS;
		  else
		     token = lachar;
               }
               break;

            case 8: /* Boolean Symbol found */
               {
                  int iii;

                  value = 0;
                  token = BSYM;
                  for (iii = 0; symbol[iii] != '\0'; iii++ ) 
		     if (islower(symbol[iii]))
			symbol[iii] = toupper(symbol[iii]);
		  if (fapmode)
		     qualsym[0] = '\0';
		  else
		     strcpy (qualsym, qualtable[qualindex]);
               }
               break;

            case 9: /* Boolean Number found */
	       if (radix == 10)
	       {
		     Parse_Error (SCAN_ERROR, INVOCTNUM, defer);
		     *svalue = 0;
		     strcpy (toksym, "0");
		     return (0);
	       }
	       else if (radix == 8)
	       {
		  token = BOCTNUM;
		  if (dignum > 7)
		  {
		     Parse_Error (SCAN_ERROR, INVOCTNUM, defer);
		     *svalue = 0;
		     strcpy (toksym, "0");
		     return (0);
		  }
		  else
		     value = (value << 3) | dignum;
	       }
               break;

            case DATAEXPRSTART: /* Data operator found */
               switch ( lachar )
               {

                  case '[':
                  case '{':
                     lachar = '(';
                  case '(':
                     token = lachar;
                     break;

                  case ']':
                  case '}':
                     lachar = ')';
                  case ')':
                     token = lachar;
                     break;

                 default:
                     if (latran == 1)
                        token = EOS;
                     else
                        token = lachar;
               }
               break;

            case 13: /* Data number found */
	       if (radix == 10)
	       {
		  value = value * 10 + dignum;
		  evalue = evalue * 10 + dignum;
		  token = DECNUM;
	       }
	       else if (radix == 8)
	       {
		  token = OCTNUM;
		  if (dignum > 7)
		  {
		     Parse_Error (SCAN_ERROR, INVOCTNUM, defer);
		     *svalue = 0;
		     strcpy (toksym, "0");
		     return (0);
		  }
		  else
		     value = (value << 3) | dignum;
	       }
               break;

            case 14: /* process data fraction */
               token = SNGLFNUM;
	       if (dignum == 0)
	       {
		  if (!digitfound)
		     leadingzero++;
	       }
	       else digitfound = TRUE;
               sfrc = sfrc * 10 + dignum;
	       break;

            case 15: /* recognize floating point exponent sign*/
               token = SNGLFNUM;
	       if (lachar == 'E') /* Two E's ddddEEddd, DBL precision */
	          dblprecision = TRUE;
               break;

	    case 16: /* process floating point exponent sign */
               token = SNGLFNUM;
               if (lachar == '-')
                  expsgn = -1;
	       break;

            case 17: /* recognize floating point exponent */
               token = SNGLFNUM;
               sexp = sexp * 10 + dignum;
               break;

            case 18: /* build floating point number */
	       {
		  t_uint64 result;
		  double cvtfrac;
		  long temp;
		  char ftemp[32];
		  char ztemp[32];

		  if (dblprecision)
		     token = DBLFNUM;
		  else
		     token = SNGLFNUM;

		  if (sexp > 38)
		  {
		     Parse_Error (SCAN_ERROR, INVEXPONENT, defer);
		     *svalue = 0;
		     strcpy (toksym, "0");
		     result = 0;
		  }
		  else
		  {
		     temp = leadingzero;
		     ztemp[0] = '\0';
		     while (temp)
		     {
			strcat (ztemp, "0");
			temp--;
		     }
		     sprintf (ftemp, "0.%s%ld", 
			      ztemp, sfrc);
		     sscanf (ftemp, "%lf", &cvtfrac);
		     sprintf (ftemp, "%ld.%s%ld%s%c%ld", 
			      evalue, ztemp, sfrc,
			      dblprecision ? "EE": "E", 
			      expsgn > 0 ? '+' : '-', sexp);
#ifdef DEBUG_FLOAT
		     printf ( " Float format: \n");
		     printf (
		     "   evalue = %ld(%lo), leadzero = %ld, sfrc = %ld(%lo)\n",
				 evalue, evalue, leadingzero, sfrc, sfrc);
		     printf ("   cvtfrac = %f, ftemp = %s\n", cvtfrac, ftemp);
		     printf ("   sexp = %ld(%lo), expsgn = %ld\n",
				 sexp, sexp, expsgn);
		     printf ("   num = %s, sym = %s\n", ftemp, symbol);
#endif
		     ibm_strtod (ftemp, &result);
#ifdef DEBUG_FLOAT
		     printf ("ibm_strtod returns\n");
#endif
                  }
#ifdef WIN32
                  sprintf (symbol, "%21.21i64o", result);
#else
                  sprintf (symbol, "%21.21llo", result);
#endif

#ifdef DEBUG_FLOAT
		  printf ("   symbol = %s\n", symbol);
#endif
	       }
	       break;

            case 19: /* recognize binary point exponent sign*/
               token = SNGLBNUM;
	       if (lachar == 'B') /* Two B's ddddBBddd, DBL precision */
	          dblprecision = TRUE;
               break;

	    case 20: /* process binary point exponent sign */
               token = SNGLBNUM;
               if (lachar == '-')
                  expsgn = -1;
	       break;

            case 21: /* recognize binary point exponent */
               token = SNGLBNUM;
               sexp = sexp * 10 + dignum;
               break;

            case 22: /* build binary point number */
	       {
		  t_uint64 result;
		  double cvtfrac;
		  short exponent = 0;
		  long fraction = 0;
		  long residual = 0;
		  long temp;
		  char ftemp[32];
		  char ztemp[32];

		  if (dblprecision)
		     token = DBLBNUM;
		  else
		     token = SNGLBNUM;

		  temp = leadingzero;
		  ztemp[0] = '\0';
		  while (temp)
		  {
		     strcat (ztemp, "0");
		     temp--;
		  }
		  sprintf (ftemp, "0.%s%ld", 
			   ztemp, sfrc);
		  sscanf (ftemp, "%lf", &cvtfrac);
#ifdef DEBUG_BINPOINT
		  printf ( " Binary point format: \n");
		  printf (
		  "   evalue = %ld(%lo), leadzero = %ld, sfrc = %ld(%lo)\n",
			      evalue, evalue, leadingzero, sfrc, sfrc);
		  printf ("   cvtfrac = %f, ftemp = %s\n", cvtfrac, ftemp);
		  printf ("   sexp = %ld(%lo), expsgn = %ld\n",
			      sexp, sexp, expsgn);
		  sprintf (ftemp, "%ld.%s%ld%s%c%ld", 
			   evalue, ztemp, sfrc,
			   dblprecision ? "BB": "B", 
			   expsgn > 0 ? '+' : '-', sexp);
		  printf ("   num = %s, sym = %s\n", ftemp, symbol);
#endif

		  if (evalue > 0)
		  {
		     temp = evalue;
		     while (temp)
		     {
			temp >>= 1;
			exponent++;
		     }
		  }
		  if (sfrc)
		  {
		     fraction = 1; /* Guard bit */
		     while (!(fraction & 0010000000000))
		     {
			int d;
		        
			cvtfrac *= 8.0;
			d = cvtfrac;
			cvtfrac = cvtfrac - d;
			fraction = (fraction << 3) | d;
		     }
		     residual = 010 | (fraction & 07);
		     fraction >>= 3;
		     while (!(residual & 0001000000000))
		     {
			int d;
		        
			cvtfrac *= 8.0;
			d = cvtfrac;
			cvtfrac = cvtfrac - d;
			residual = (residual << 3) | d;
		     }
		  }

#ifdef DEBUG_BINPOINT
		  printf ("   exponent = %o\n", exponent);
		  printf ("   evalue   = %o\n", evalue);
		  printf ("   fraction = %o\n", fraction);
		  printf ("   residual = %o\n", residual);
#endif
		  result = evalue;
		  result <<= 62 - sexp;

                  if (sfrc)
		  {
		     t_uint64 fresult;

		     fresult = ((t_uint64)fraction & 0000777777777) << 35;
		     fresult |= ((t_uint64)residual & 0000777777777) << 8;
		     fresult >>= sexp;
#ifdef DEBUG_BINPOINT
                     printf ("   fresult = %llo\n", fresult);
#endif
		     result |= fresult;
		  }
#ifdef WIN32
                  sprintf (symbol, "%21.21i64o", result);
#else
                  sprintf (symbol, "%21.21llo", result);
#endif
#ifdef DEBUG_BINPOINT
		  printf ("   symbol = %s\n", symbol);
#endif
	       }
	       break;

            case 23: /* recognize nulsym "**" */
	       token = NULSYM;
	       break;
		  
            case 25: /* recognize boolean AND "*" */
	    case 27:
		  token = AND;
		  break;

            case 26: /* recognize boolean nulsym "**" */
	       token = BNULSYM;
	       break;


