/***********************************************************************
*
* asmoptab.c - Opcode table for the IBM 7090 assembler.
*
* Changes:
*   05/21/03   DGP   Original.
*	
***********************************************************************/


#include "asmdef.h"

OpCode optable[NUMOPS] =
{
   { "...", 00000, 00000, TYPE_E },
   { "ACL", 00361, 0, TYPE_B },
   { "ADD", 00400, 0, TYPE_B },
   { "ADM", 00401, 0, TYPE_B },
   { "ALS", 00767, 0, TYPE_B },
   { "ANA", 04320, 0, TYPE_B },
   { "ANS", 00320, 0, TYPE_B },
   { "ARS", 00771, 0, TYPE_B },
   { "AXC", 04774, 0, TYPE_B },
   { "AXT", 00774, 0, TYPE_B },
   { "BCD", BCD_T, 0, TYPE_P },
   { "BCI", BCI_T, 0, TYPE_P },
   { "BES", BES_T, 0, TYPE_P },
   { "BSF", 04764, 0, TYPE_B },
   { "BSR", 00764, 0, TYPE_B },
   { "BSS", BSS_T, 0, TYPE_P },
   { "BTTA", 00760, 01000, TYPE_E },
   { "BTTB", 00760, 02000, TYPE_E },
   { "CAL", 04500, 0, TYPE_B },
   { "CAQ", 04114, 0, TYPE_C },
   { "CAS", 00340, 0, TYPE_B },
   { "CHS", 00760, 00002, TYPE_E },
   { "CLA", 00500, 0, TYPE_B },
   { "CLM", 00760, 00000, TYPE_E },
   { "CLS", 00502, 0, TYPE_B },
   { "COM", 00760, 00006, TYPE_E },
   { "CRQ", 04154, 0, TYPE_C },
   { "CVR", 00114, 0, TYPE_C },
   { "DCT", 00760, 00012, TYPE_E },
   { "DEC", DEC_T, 0, TYPE_P },
   { "DFAD", 00301, 0, TYPE_B },
   { "DFAM", 00305, 0, TYPE_B },
   { "DFDH", 04240, 0, TYPE_B },
   { "DFDP", 04241, 0, TYPE_B },
   { "DFMP", 00261, 0, TYPE_B },
   { "DFSB", 00303, 0, TYPE_B },
   { "DFSM", 00307, 0, TYPE_B },
   { "DLD", 00443, 0, TYPE_B },
   { "DST", 04603, 0, TYPE_B },
   { "DUAM", 04305, 0, TYPE_B },
   { "DUFA", 04301, 0, TYPE_B },
   { "DUFM", 04261, 0, TYPE_B },
   { "DUFS", 04303, 0, TYPE_B },
   { "DUSM", 04307, 0, TYPE_B },
   { "DVH", 00220, 0, TYPE_B },
   { "DVP", 00221, 0, TYPE_B },
   { "ECTM", 04760, 00006, TYPE_E },
   { "EFTM", 04760, 00002, TYPE_E },
   { "EJECT", EJE_T, 0, TYPE_P },
   { "EMTM", 04760, 00016, TYPE_E },
   { "ENB", 00564, 0, TYPE_B },
   { "END", END_T, 0, TYPE_P },
   { "ENK", 00760, 00004, TYPE_E },
   { "ENTRY", ENT_T, 0, TYPE_P },
   { "EQU", EQU_T, 0, TYPE_P },
   { "ERA", 00322, 0, TYPE_B },
   { "ESNT", 04021, 0, TYPE_B },
   { "ESTM", 04760, 00005, TYPE_E },
   { "ETM", 00760, 00007, TYPE_E },
   { "ETTA", 04760, 01000, TYPE_E },
   { "ETTB", 04760, 02000, TYPE_E },
   { "EXTERN", EXT_T, 0, TYPE_P },
   { "FAD", 00300, 0, TYPE_B },
   { "FAM", 00304, 0, TYPE_B },
   { "FDH", 00240, 0, TYPE_B },
   { "FDP", 00241, 0, TYPE_B },
   { "FIVE", 05000, 0, TYPE_A },
   { "FMP", 00260, 0, TYPE_B },
   { "FOR", 04000, 0, TYPE_A },
   { "FOUR", 04000, 0, TYPE_A },
   { "FRN", 00760, 00011, TYPE_E },
   { "FSB", 00302, 0, TYPE_B },
   { "FSM", 00306, 0, TYPE_B },
   { "FVE", 05000, 0, TYPE_A },
   { "HPR", 00420, 0, TYPE_B },
   { "HTR", 00000, 0, TYPE_B },
   { "IIA", 00041, 0, TYPE_D },
   { "IIL", 04051, 0, TYPE_D },
   { "IIR", 00051, 0, TYPE_D },
   { "IIS", 00440, 0, TYPE_B },
   { "IOCD", 00000, 0, TYPE_A },
   { "IOCP", 04000, 0, TYPE_A },
   { "IOCT", 05000, 0, TYPE_A },
   { "IORP", 02000, 0, TYPE_A },
   { "IORT", 03000, 0, TYPE_A },
   { "IOSP", 06000, 0, TYPE_A },
   { "IOST", 07000, 0, TYPE_A },
   { "IOT", 00760, 00005, TYPE_E },
   { "LAC", 00535, 0, TYPE_B },
   { "LAS", 04340, 0, TYPE_B },
   { "LBT", 00760, 00001, TYPE_E },
   { "LCHA", 00544, 0, TYPE_B },
   { "LCHB", 04544, 0, TYPE_B },
   { "LDC", 04535, 0, TYPE_B },
   { "LDI", 00441, 0, TYPE_B },
   { "LDQ", 00560, 0, TYPE_B },
   { "LFT", 04054, 0, TYPE_D },
   { "LFTM", 04760, 00004, TYPE_E },
   { "LGL", 04763, 0, TYPE_B },
   { "LGR", 04765, 0, TYPE_B },
   { "LLS", 00763, 0, TYPE_B },
   { "LMTM", 00760, 00016, TYPE_E },
   { "LNT", 04056, 0, TYPE_D },
   { "LRS", 00765, 0, TYPE_B },
   { "LSNM", 04760, 00010, TYPE_E },
   { "LTM", 04760, 00007, TYPE_E },
   { "LXA", 00534, 0, TYPE_B },
   { "LXD", 04534, 0, TYPE_B },
   { "MON", 05000, 0, TYPE_A },
   { "MPR", 04200, 0, TYPE_B },
   { "MPY", 00200, 0, TYPE_B },
   { "MSE", 00760, 00000, TYPE_E },
   { "MTH", 07000, 0, TYPE_A },
   { "MTW", 06000, 0, TYPE_A },
   { "MZE", 04000, 0, TYPE_A },
   { "NOP", 00762, 0, TYPE_B },
   { "NZT", 04520, 0, TYPE_B },
   { "OAI", 00043, 0, TYPE_B },
   { "OCT", OCT_T, 0, TYPE_P },
   { "OFT", 00444, 0, TYPE_B },
   { "ONE", 01000, 0, TYPE_A },
   { "ONT", 00446, 0, TYPE_B },
   { "ORA", 04501, 0, TYPE_B },
   { "ORG", ORG_T, 0, TYPE_P },
   { "ORS", 04602, 0, TYPE_B },
   { "OSI", 00442, 0, TYPE_B },
   { "PAC", 00737, 0, TYPE_B },
   { "PAI", 00044, 0, TYPE_B },
   { "PAX", 00734, 0, TYPE_B },
   { "PBT", 04760, 00001, TYPE_E },
   { "PCA", 00756, 0, TYPE_B }, 
   { "PCD", 04756, 0, TYPE_B },
   { "PDC", 04737, 0, TYPE_B },
   { "PDX", 04734, 0, TYPE_B },
   { "PIA", 04046, 0, TYPE_B },
   { "PON", 01000, 0, TYPE_A },
   { "PSE", 00760, 00000, TYPE_E },
   { "PTH", 03000, 0, TYPE_A },
   { "PTW", 02000, 0, TYPE_A },
   { "PXA", 00754, 0, TYPE_B },
   { "PXD", 04754, 0, TYPE_B },
   { "PZE", 00000, 0, TYPE_A },
   { "RCDA", 00762, 01321, TYPE_E },
   { "RCDB", 00762, 02321, TYPE_E },
   { "RCHA", 00540, 0, TYPE_B },
   { "RCHB", 04540, 0, TYPE_B },
   { "RCT", 00760, 00014, TYPE_E },
   { "RDCA", 00760, 01352, TYPE_E },
   { "RDCB", 00760, 02352, TYPE_E },
   { "RDS", 00762, 0, TYPE_B },
   { "REM", REM_T, 0, TYPE_P },
   { "REW", 00772, 0, TYPE_B },
   { "RFT", 00054, 0, TYPE_D },
   { "RIA", 04042, 0, TYPE_D },
   { "RICA", 00760, 01350, TYPE_E },
   { "RICB", 00760, 02350, TYPE_E },
   { "RIL", 04057, 0, TYPE_D },
   { "RIR", 00057, 0, TYPE_D },
   { "RIS", 00445, 0, TYPE_B },
   { "RND", 00760, 00010, TYPE_E },
   { "RNT", 00056, 0, TYPE_D },
   { "RPRA", 00762, 01361, TYPE_E },
   { "RPRB", 00762, 02361, TYPE_E },
   { "RQL", 04773, 0, TYPE_B },
   { "RSCA", 00540, 0, TYPE_B },
   { "RSCB", 04540, 0, TYPE_B },
   { "RTB", 00762, 00200, TYPE_E },
   { "RTD", 00762, 00200, TYPE_E },
   { "RUN", 04772, 0, TYPE_B },
   { "SBM", 04440, 0, TYPE_B },
   { "SCA", 00636, 0, TYPE_B },
   { "SCD", 04636, 0, TYPE_B },
   { "SCHA", 00640, 0, TYPE_B },
   { "SCHB", 04640, 0, TYPE_B },
   { "SDN", 00776, 0, TYPE_B },
   { "SIL", 04055, 0, TYPE_D },
   { "SIR", 00055, 0, TYPE_D },
   { "SIX", 06000, 0, TYPE_A },
   { "SLF", 00760, 00140, TYPE_E },
   { "SLN", 00760, 00140, TYPE_E },
   { "SLQ", 04620, 0, TYPE_B },
   { "SLT", 04760, 00140, TYPE_E },
   { "SLW", 00602, 0, TYPE_B },
   { "SPACE", SPC_T, 0, TYPE_P },
   { "SPRA", 00760, 01300, TYPE_E },
   { "SPRB", 00760, 02300, TYPE_E },
   { "SSM", 04760, 00003, TYPE_E },
   { "SSP", 00760, 00003, TYPE_E },
   { "STA", 00621, 0, TYPE_B },
   { "STCA", 00544, 0, TYPE_E },
   { "STCB", 04544, 0, TYPE_E },
   { "STD", 00622, 0, TYPE_B },
   { "STI", 00604, 0, TYPE_B },
   { "STL", 04625, 0, TYPE_B },
   { "STO", 00601, 0, TYPE_B },
   { "STP", 00630, 0, TYPE_B },
   { "STQ", 04600, 0, TYPE_B },
   { "STR", 05000, 0, TYPE_A },
   { "STT", 00625, 0, TYPE_B },
   { "STZ", 00600, 0, TYPE_B },
   { "SUB", 00402, 0, TYPE_B },
   { "SVN", 07000, 0, TYPE_A },
   { "SWT", 00760, 00160, TYPE_E },
   { "SXA", 00634, 0, TYPE_B },
   { "SXD", 04634, 0, TYPE_B },
   { "SYN", EQU_T, 0, TYPE_P },
   { "TCNA", 04060, 0, TYPE_B },
   { "TCNB", 04061, 0, TYPE_B },
   { "TCOA", 00060, 0, TYPE_B },
   { "TCOB", 00061, 0, TYPE_B },
   { "TEFA", 00030, 0, TYPE_B },
   { "TEFB", 04030, 0, TYPE_B },
   { "TIF", 00046, 0, TYPE_B },
   { "TIO", 00042, 0, TYPE_B },
   { "TIX", 02000, 0, TYPE_A },
   { "TLQ", 00040, 0, TYPE_B },
   { "TMI", 04120, 0, TYPE_B },
   { "TNO", 04140, 0, TYPE_B },
   { "TNX", 06000, 0, TYPE_B },
   { "TNZ", 04100, 0, TYPE_B },
   { "TOV", 00140, 0, TYPE_B },
   { "TPL", 00120, 0, TYPE_B },
   { "TQO", 00161, 0, TYPE_B },
   { "TQP", 00162, 0, TYPE_B },
   { "TRA", 00020, 0, TYPE_B },
   { "TRCA", 00022, 0, TYPE_B },
   { "TRCB", 04022, 0, TYPE_B },
   { "TSX", 00074, 0, TYPE_B },
   { "TTL", TTL_T, 0, TYPE_P },
   { "TTR", 00021, 0, TYPE_B },
   { "TWO", 02000, 0, TYPE_A },
   { "TXH", 03000, 0, TYPE_A },
   { "TXI", 01000, 0, TYPE_A },
   { "TXL", 07000, 0, TYPE_A },
   { "TZE", 00100, 0, TYPE_B },
   { "UAM", 04304, 0, TYPE_B },
   { "UFA", 04300, 0, TYPE_B },
   { "UFM", 04260, 0, TYPE_B },
   { "UFS", 04302, 0, TYPE_B },
   { "USM", 04306, 0, TYPE_B },
   { "VDH", 00224, 0, TYPE_C },
   { "VDP", 00225, 0, TYPE_C },
   { "VLM", 00204, 0, TYPE_C },
   { "WPBA", 00766, 01362, TYPE_E },
   { "WPBB", 00766, 02362, TYPE_E },
   { "WPDA", 00766, 01361, TYPE_E },
   { "WPDB", 00766, 02361, TYPE_E },
   { "WPRA", 00766, 01361, TYPE_E },
   { "WPRB", 00766, 02361, TYPE_E },
   { "WPUA", 00766, 01341, TYPE_E },
   { "WPUB", 00766, 02341, TYPE_E },
   { "XCA", 00131, 0, TYPE_B },
   { "XCL", 04131, 0, TYPE_B },
   { "XEC", 00522, 0, TYPE_B },
   { "ZET", 00520, 0, TYPE_B },
};

/***********************************************************************
* oplookup - Lookup opcode.
***********************************************************************/

OpCode *
oplookup (char *op)
{
   OpCode *ret = NULL;
   int done = FALSE;
   int mid;
   int last = 0;
   int lo;
   int up;
   int r;

#ifdef DEBUGOP
   printf ("oplookup: Entered: op = %s\n", op);
#endif

   lo = 0;
   up = NUMOPS;
   
   while (!done)
   {
      mid = (up - lo) / 2 + lo;
#ifdef DEBUGOP
      printf (" mid = %d, last = %d\n", mid, last);
#endif
      if (last == mid) break;
      r = strcmp (optable[mid].opcode, op);
      if (r == 0)
      {
         ret = &optable[mid];
	 done = TRUE;
      }
      else if (r < 0)
      {
         lo = mid;
      }
      else 
      {
         up = mid;
      }
      last = mid;
   }
#ifdef DEBUGOP
   printf (" ret = %8x\n", ret);
#endif
   return (ret);
}
