
#include <stdlib.h>
#include <stdio.h>
#include "asciibcd.h"
#include "cvtpar.h"
#include "prsf2.h"

char fin[300], fon[300];

/*
** ASCII to BCD conversion table. 
*/

static unsigned char tobcd[128] =
{
 /*00  NL   SH   SX   EX   ET   NQ   AK   BL */
      060, 060, 060, 060, 060, 060, 060, 060,
 /*08  BS   HT   LF   VT   FF   CR   SO   SI */
      060, 060, 060, 060, 060, 060, 060, 060,
 /*10  DL   D1   D2   D3   D4   NK   SN   EB */
      060, 060, 060, 060, 060, 060, 060, 060,
 /*18  CN   EM   SB   EC   FS   GS   RS   US */
      060, 060, 060, 060, 060, 060, 060, 060,
 /*20  SP    !    "    #    $    %    &    ' */
      060, 060, 060, 060, 053, 060, 060, 014,
 /*28   (    )    *    +    ,    -    .    / */
      074, 034, 054, 020, 073, 040, 033, 061,
 /*30   0    1    2    3    4    5    6    7 */
      000, 001, 002, 003, 004, 005, 006, 007,
 /*38   8    9    :    ;    <    =    >    ? */
      010, 011, 060, 060, 060, 013, 060, 060,
 /*40   @    A    B    C    D    E    F    G */
      060, 021, 022, 023, 024, 025, 026, 027,
 /*48   H    I    J    K    L    M    N    O */
      030, 031, 041, 042, 043, 044, 045, 046,
 /*50   P    Q    R    S    T    U    V    W */
      047, 050, 051, 062, 063, 064, 065, 066,
 /*58   X    Y    Z    [    \    ]    ^    _ */
      067, 070, 071, 060, 060, 060, 060, 060,
 /*60   `    a    b    c    d    e    f    g */
      060, 021, 022, 023, 024, 025, 026, 027,
 /*68   h    i    j    k    l    m    n    o */
      030, 031, 041, 042, 043, 044, 045, 046,
 /*70   p    q    r    s    t    u    v    w */
      047, 050, 051, 062, 063, 064, 065, 066,
 /*78   x    y    z    {    |    }    ~   DL */
      067, 070, 071, 060, 060, 060, 060, 060,
};


main(argc, argv)
   int   argc;
   char   **argv;
{
   register int c;
   static unsigned char buf[160];
   FILE *fi, *fo;
   int reclen;
   int chrcnt;

   reclen = 84;
   parsefiles(argc, argv, "txt", "bcd", &reclen);
   if ((fi = fopen(fin, "r")) == NULL)
   {
      perror(fin);
      exit(1);
   }
   if ((fo = fopen(fon, "wb")) == NULL)
   {
      perror(fon);
      exit(1);
   }


   chrcnt = 0;
   while ( (c = fgetc(fi)) != EOF )
   {
      if (c == '\r') ;
      else if (c == '\n')
      {
         while (chrcnt < reclen)
	 {
            if (chrcnt == 0)
	    {
               fputc(tobcd[' '] | 0200, fo);
            }
	    else
	    {
               fputc(tobcd[' '], fo);
            }
            chrcnt++;
         }
         chrcnt = 0;
      }
      else if (c == '\f')
      {
            fputc(0217, fo);
      }
      else if (c == '\t')
      {
         if (chrcnt == 0)
	 {
            fputc(tobcd[' '] | 0200, fo);
         }
	 else
	 {
            fputc(tobcd[' '], fo);
         }
         chrcnt++;
         while (chrcnt % 8 != 0)
	 {
            fputc(tobcd[' '], fo);
            chrcnt++;
         }
      }
      else if (chrcnt == 0)
      {
         fputc(evenpar[tobcd[c]] | 0200, fo);
         chrcnt++;
      }
      else
      {
         fputc(evenpar[tobcd[c]], fo);
         chrcnt++;
      }
   }
   if (chrcnt > 0)
   {
      while (chrcnt < reclen)
      {
         fputc(tobcd[' '], fo);
         chrcnt++;
      }
   }
   fputc (0217, fo);
}
