
#include "regs.h"
#include "arith.h"

void
sense_instr()
{
	unsigned select;

	switch (y) {

	case 00000:	/* CLM */
		ach = ach & SIGN;
		acl = 0;
		break;

	case 00001:	/* LBT/PBT */
		if ((op & 0100000) == 0) {
			if (acl & 00000000001)
				ic++;
		} else {
			if (ach & P)
				ic++;
		}
		break;

	case 00002:	/* CHS */
		ach = (~ach & SIGN) | (ach & (Q|P|HMSK));
		break;

	case 00003:	/* SSP/SSM */
		if ((op & 0100000) == 0) {
			ach = ach & (Q|P|HMSK);
		} else {
			ach = ach | SIGN;
		}
		break;

	case 00004:	/* ENK */
		mqh = kyh;
		mql = kyl;
		break;

	case 00005:	/* IOT */
		if (iochk)
			iochk = 0;
		else
			ic++;
		break;

	case 00006:	/* COM */
		ach = (ach & SIGN) | (~ach & (Q|P|HMSK));
		acl = ~acl;
		break;

	case 00007:	/* ETM/LTM */
		trap = 1 - (op >> 15);
		break;

	case 00010:	/* RND */
		rnd();
		break;

	case 00011:	/* FRN */
		frnd();
		break;

	case 00012:	/* DCT */
		if (divchk)
			divchk = 0;
		else
			ic++;
		break;

	case 00014:	/* RCT */
		ctrap_ind = 1;
		break;

	case 00016:	/* LMTM/EMTM */
		multtag = op >> 15;
		break;

	case 00140:	/* SLF */
		sl = 0;
		break;

	case 00141:	/* SLN */
	case 00142:
	case 00143:
	case 00144:
		select = 1 << (0144 - y);
		if ((op & 0100000) == 0) {
			sl |= select;
		} else {
			if (sl & select) {
				sl -= select;
				ic++;
			}
		}
		break;

	case 00161:	/* SWT */
	case 00162:
	case 00163:
	case 00164:
	case 00165:
	case 00166:
		if (ssw & (1 << (0166 - y)))
			ic++;
		break;

	case 01000:	/* BTT/ETT */
	case 02000:
	case 03000:
	case 04000:
	case 05000:
	case 06000:
	case 07000:
	case 10000:
		select = ((y & 00017000) >> 9) - 1;
		if (select >= NUMCHAN) {
			machchk = 1;
			run = 0;
			break;
		}
		if ((op & 0100000) == 0) {
			if (!cbot[select])
				ic++;
			else
				cbot[select] = 0;
		} else {
			if (!ceot[select])
				ic++;
			else
				ceot[select] = 0;
		}
		break;

	default:
		if ((y & 00700) == 00300) {	/* SPR, SPT, SPU */
			break;
		}
		break;				/* All others NOP */
	}
}

