
#include <stdlib.h>
#include <stdio.h>
#include "cvtpar.h"
#include "prsf2.h"


short bcdcbn[64] = {
/* 00  '0',   '1',   '2',   '3',   '4',   '5',   '6',   '7', */
       01000, 00400, 00200, 00100, 00040, 00020, 00010, 00004,
/* 10  '8',   '9',   ' ',   '=',   '\'',  ' ',   ' ',   ' ', */
       00002, 00001, 01000, 00102, 00042, 00000, 00000, 00000,
/* 20  '+',   'A',   'B',   'C',   'D',   'E',   'F',   'G', */
       04000, 04400, 04200, 04100, 04040, 04020, 04010, 04004,
/* 30  'H',   'I',   ' ',   '.',   '(',   ' ',   ' ',   ' ', */
       04002, 04001, 00000, 04102, 04042, 00000, 00000, 00000,
/* 40  '-',   'J',   'K',   'L',   'M',   'N',   'O',   'P', */
       02000, 02400, 02200, 02100, 02040, 02020, 02010, 02004,
/* 50  'Q',   'R',   ' ',   '$',   '*',   ' ',   ' ',   ' ', */
       02002, 02001, 00000, 02102, 02042, 00000, 00000, 00000,
/* 60  ' ',   '/',   'S',   'T',   'U',   'V',   'W',   'X', */
       00000, 01400, 01200, 01100, 01040, 01020, 01010, 01004,
/* 70  'Y',   'Z',   ' ',   ',',   ')',   ' ',   ' ',   ' '  */
       01002, 01001, 00000, 01102, 01042, 00000, 00000, 00000
#if 0
   00000, 00400, 00200, 00100, 00040, 00020, 00010, 00004,
   00002, 00001, 01000, 00102, 00042, 00022, 00012, 00006,

   01000, 01400, 01200, 01100, 01040, 01020, 01010, 01004,
   01002, 01001, 01202, 01102, 01042, 01022, 01012, 01006,

   02000, 02400, 02200, 02100, 02040, 02020, 02010, 02004,
   02002, 02001, 02202, 02102, 02042, 02022, 02012, 02006,

   04000, 04400, 04200, 04100, 04040, 04020, 04010, 04004,
   04002, 04001, 04202, 04102, 04042, 04022, 04012, 04006
#endif
};


char fin[300], fon[300];

main(argc, argv)
   int   argc;
   char   **argv;
{
   register int c;
   FILE *fi, *fo;
   int parerr = 0;
   int colerr = 0;
   short col;
   int recnum;
   int colnum;

   parsefiles(argc, argv, "bcd", "cbn", 0);
   if ((fi = fopen(fin, "rb")) == NULL)
   {
      perror(fin);
      exit(1);
   }
   if ((fo = fopen(fon, "wb")) == NULL)
   {
      perror(fon);
      exit(1);
   }
   recnum = 0;
   colnum = 0;
   while ( (c = fgetc(fi)) != EOF )
   {
      if ((c & 0200) != 0)
      {
         recnum++;
         colnum = 0;
      }
      colnum++;
      if (colnum > 80)
      {
         if (!colerr)
	 {
            colerr = 1;
            fprintf(stderr,
             "Too many columns in %s, record %d\n",
               fin, recnum);
         }
         continue;
      }
      if (!parerr && evenpar[c & 077] != (c & 0177))
      {
         parerr = 1;
         fprintf(stderr,
		 "Parity error in %s, %03o column %d record %d\n",
		 fin, c, colnum, recnum);
      }

      col = bcdcbn[c & 077];
      fputc(oddpar[col >> 6] | (c & 0200), fo);
      fputc(oddpar[col & 077], fo);
   }
}
