/*

  SETTIME -- generate a "set time" command for various HP operating systems.

  Writes to STDOUT.

*/


#include <stdio.h>
#include <time.h>

int main (int    argc,
          char **argv)

{
    char tsb_d_format[] = "%j/%y";
    char tsb_t_format[] = "%H%M";
    char dos_format[]   = ":DA,%d-%b-%y,%H,%M";
    char rte_format[]   = "TM,%Y,%j,%H,%M,%S";
    char fmgr_format[]  = ":SYTM,%Y,%j,%H,%M,%S";

    char *tm_format;

    time_t current_time;
    struct tm *time_and_date;
    char tm_string [80];

    if (argc == 2)
        if (stricmp (argv[1], "tsbd") == 0)
            tm_format = tsb_d_format;

        else if (stricmp (argv[1], "tsbt") == 0)
            tm_format = tsb_t_format;

        else if (stricmp (argv[1], "dos") == 0)
            tm_format = dos_format;

        else if (stricmp (argv[1], "rte") == 0)
            tm_format = rte_format;

        else if (stricmp (argv[1], "fmgr") == 0)
            tm_format = fmgr_format;

        else
            argc = 0;

    if (argc != 2) {
        puts ("\nUsage: settime [ tsbd | tsbt | dos | rte | fmgr ]");
        return (1);
    }


    /* Get the current time (allow one second for processing). */

    current_time = time (NULL) + 1;
    time_and_date = localtime (&current_time);


    /* Format the time into the desired command string. */

    if (strftime (tm_string, sizeof (tm_string), tm_format, time_and_date)) {
        puts (tm_string);
        return 0;
        }
    else
        return 1;
}
