ASMB,A,B,L,T,C
       HED  ***  SIO TALLY T-132 LINE PRINTER DRIVER  ***
**************  SYSTEM INPUT / OUTPUT DRIVER ***************
*
*  THIS SIO DRIVER IS FOR THE TALLY T-132 OR T-80
*  LINE PRINTER.
*
*  THIS DRIVER PROVIDES FOR ALL LIST OUTPUT FACILITES
*  REQUIRED BY THE ASSEMBLER, SYMBOLIC EDITOR, ALGOL
*  COMPLIER AND THE FORTRAN COMPLIER.
*
*
*  CALLING SEQUENCE:
*
*  A-REGISTER = LENGTH OF DATA BUFFER (CHARACTERS)
*
*  B-REGISTER = STARTING ADDRESS OF DATA BUFFER
*
*  (P)        JSB 102B,I      CALL TO THE SIO DRIVER
*  (P+1)      -RETURN-
*
*
*        HLT 52B = LINE PRINTER NOT READY........
*        TO CONTINUE READY THE PRINTER AND PRESS THE
*        'RUN' ........
*
*
*     THIS DRIVER MUST BE LOADED AFTER THE SIO
*     TELEPRINTER DRIVER (HP-24125).
*
*
*********** DRIVER INITIALIZATION SECTION ************
*
*  THE PURPOSE OF THIS SECTION IS TO SET THE I/O
*  INSTRUCTIONS TO REFERNCE A DESIGNATED I/O 
*  ADDRESS FOR THE LINE PRINTER. EXECUTION BEGINS
*  AT LOCATION 2 :  (2) = JMP 16000B
*  THE SWITCH REGISTER IS SET TO CONTAIN THE ADDRESS
*  OF THE PRINTER (SELECT CODE).
*
*  THIS SECTION IS RELEASED AFTER THE
*  INITIALIZATION IS COMPLETED.
*
*
       ORG 02B
       JMP 03B,I        GET STARTING POINT
       DEF ISECT        IN 2 AND 3
       ORG 16000B
       LIA 01B        GET AND
       AND .77        ISOLATE I/O ADDRESS AND
       STA BREG       SAVE  THE SELECT CODE
*
*
       LDA .LIA.
       IOR BREG
       STA .LIA1      LIA LPTR
       STA .LIA2
       STA .LIA3
*
*
       LDA .OTA.
       IOR BREG       OTA LPTR
       STA .OTA
*
*
       LDA .STC.
       IOR BREG       STC LPTR
       STA .STC
*
*
       LDA .CLC.
       IOR BREG       CLC LPTR
       STA .CLC
*
*
       LDA .STF.
       IOR BREG       STF LPTR
       STA .STF
*
*
       LDA .CLF.  
       IOR BREG       CLF LPTR
       STA .CLF
*
*
*
       LDA ENTRY      GET ENTRY POINT OF SIO DRIVER
       STA 102B       PLACE ENTRY POINT AT MEMORY 102B
*
*
       HLT 77B        WE ARE DONE.......
       JMP *-1        CAN NOT CONTINUE, GO TO HLT
*
*
.77    OCT 77         I/O ADDRESS MASK
BREG   EQU 1          B-REGISTER
ENTRY  DEF LPOUT      POINTER TO SIO DRIVER
ISECT  EQU 16000B     POINTER TO INT. SECTION
.LIA.  LIA 00B        INSTRUCTIONS DATA
.OTA.  OTA 00B
.STC.  STC 00B
.CLC.  CLC 00B
.STF.  STF 00B
.CLF.  CLF 00B        END OF INSTRUCTION DATA
*
*
*
*
*
********** SIO DRIVER SECTION **************
*
*
       ORG 17567B
LPOUT  EQU *           ** OUTPUT LIST ENTRY **
       NOP             POINTER TO CALLING ROUTINE
       STB BUFF        SAVE BUFFER POINTER
       CMA
       STA LEN         SAVE BUFFER LENGTH
*
*
.LIA1  EQU *           LABEL FOR SELECT CODE ADDITION
*
OLINE  EQU *           CHECK FOR LINE PRINTER ONLINE
       LIA 00B         GET STATUS FROM LINE PRINTER
       AND RUN         ISOLATE RUN FLAG
       SZA             IS PRINTER ONLINE?
        HLT 52B         NO; HALT......
*
*
.LIA2  EQU *           LABEL FOR SELECT CODE ADDITION
*
READY  EQU *           CHECK FOR LINE PRINTER 'READY'
       LIA 00B         GET STATUS FROM LINE PRINTER
       AND PRTRY       ISOLATE READY FLAG
       SZA,RSS         IS LINE PRINTER READY?
       JMP READY       NO; GO CHECK AGAIN
*
.STF   EQU *           LABEL FOR SELECT CODE ADDITION
       STF 00B         SEND COMMAND FOR DATA TO FOLLOW
*
*
.LIA3  EQU *           LABEL FOR SELECT CODE ADDITION
*
SENDD  EQU *           CHECK FOR LINE PRINTER DATA REQUEST
       LIA 00B         GET STATUS FROM LINE PRINTER
       AND SDATA       ISOLATE 'SEND DATA' FLAG
       SZA,RSS         DOES LINE PRINTER WANT DATA?
       JMP SENDD       NO; GO CHECK AGAIN
*
*
WRITE  EQU *           YES; START TRANSMITTING DATA
       LDA BUFF,I      GET A CHARACTER
       ALF,ALF         POSITION CHARATER FOR OUTPUT
       AND MASK        ISOLATE CHARACTER
       JSB OUT         OUTPUT CHARACTER (UPPER)
       JSB DELAY       WAIT UNTIL PRINTER GETS DATA
       ISZ LEN         IS THIS THE LAST CHARACTER?
       JMP NEXTC       NO: GET LOWER CHARACTER
       JMP PRINT       YES; PRINT THE LINE
*
NEXTC  EQU *           GET THE LOWER CHARACTER
       LDA BUFF,I      GET A CHARACTER
       AND MASK        ISOLATE CHARACTER
       JSB OUT         OUTPUT CHARACTER (LOWER)
       JSB DELAY       WAIT UNTIL PRINTER GETS DATA
       ISZ LEN         IS THIS THE LAST CHARACTER?
       JMP NEXTW       NO; GET NEXT CHARACTER
       JMP PRINT       YES; PRINT THE LINE
*
NEXTW  EQU *           GET NEXT CHARACTER
       ISZ BUFF        INCREMENT BUFFER POINTER
       JMP WRITE       CONTINUE TO OUTPUT MORE CHARACTERS
*
*
.CLF   EQU *           LABEL FOR SELECT CODE ADDITION
*
PRINT  EQU *           PRINT OUT LINE
       CLF 00B         ISSUE PRINT COMMAND
       JMP LPOUT,I     RETURN TO CALLING ROUTINE
*
*
*
DELAY  EQU *           ROUTINE TO SPACE DATA TRANSMITIONS
       NOP             POINTER TO CALLING ROUTINE
       LDA WAIT        GET DELAY FACTOR
       STA SLOW        SET THE COUNTER
       ISZ SLOW        IS DELAY OVER?
       JMP *-1         NO; WAIT LONGER
       JMP DELAY,I     YES; RETURN TO CALLING ROUTINE
*
*
*
OUT    EQU *           ROUTINE TO OUTPUT A CHARACTER
       NOP             POINTER TO CALLING ROUTINE
.OTA   EQU *           LABEL FOR SELECT CODE ADDITION
       OTA 00B         DATA TO I/O BUSS
.STC   EQU *           LABEL FOR SELECT CODE ADDITION
       STC 00B         STROBE DATA TO PRINTER
.CLC   EQU *           LABEL FOR SELECT CODE ADDITION
       CLC 00B         RESET THE DATA STROBE
       JMP OUT,I       RETURN TO THE CALLING ROUTINE
*
*
BUFF   NOP             POINTER TO THE BUFFER
LEN    NOP             BUFFER LENGTH
SLOW   NOP             COUNTER STORAGE
MASK   OCT 177         ISOLATE CHARACTER MASK
*
*
       ORG 17557B
       NOP             TRAP FOR PUNCH OUTPUT
       HLT 65B         HALT - NO PUNCH ROUTINE
       JMP *-1
*
WAIT   OCT 177000      DELAY FACTOR
RUN    OCT 40          MASK FOR RUN FLAG
PRTRY  OCT 20          MASK FOR READY FLAG
SDATA  OCT 4           MASK FOR SEND DATA FLAG
*
*
*                  JOSE J. PICAZO JR.
*                    APRIL 7, 1975
*
*
       END
