      HED ** RTE EDITOR READL SUBROUTINE ** JDR 
* SUBROUTINE TO INPUT A LINE AND TRANSFER IT TO A SPECIFIED 
* BUFFER. 
      SPC 1 
* CALLING SEQUENCE: 
*     A =  FMP FLAG 
*     B =  FMP DCB ADDRESS
*     JSB READL 
*     DEF FMP FILE NAME 
*     DEF BUFFER ADDRESS
*     RETURN - IERR NEGATIVE IF ERROR ON FMP READ 
*     NWDS = WORDS READ OR -1 IF EOF ENCOUNTERED
      SPC 1 
READL NOP 
      STB REDF1    STORE DCB ADDRESS IN FMP CALL
      LDB READL,I  GET FMP FILE NAME
      STB REDF3     & STORE IN FMP ERROR CHECK CALL 
      ISZ READL    GET BUFFER ADDRESS 
      LDB READL,I   AND STORE IN
      STB READ1      INPUT
      STB READ4       ROUTINES &
      STB REDF2        FMP CALL 
      ISZ READL    INDEX TO RETURN ADDRESS
      SZA          INPUT FROM LUN OR FMP? 
      JMP REDF      FMP - GO MAKE FMP CALL
      STA IERR      LUN - CLEAR ERROR FLAG
      LDA LNLU      GET LUN 
      CPA D2       SOURCE ON LS TRACKS? 
      RSS           YES - USE %READ 
      JMP RKYBD     YES - INPUT VIA EXEC CALL 
      JSB %READ     NO - USE % READ 
      DEF *+5        RETURN ADDRESS 
      DEF LNLU       LOGICAL UNIT 
READ1 NOP            BUFFER ADDRESS 
      DEF M80        MAXIUM 80 CHARACTERS 
      JMP READ3      EOF RETURN POINT 
      STA RTRKC    UPDATE CURRENT TRACK FOR AN LS 
      JMP READ5     CONVERT CHARACTERS TO WORDS 
READ3 CCB              YES - SET
      STB NWDS          NWDS TO -1
      JMP READL,I        & RETURN 
      SPC 1 
* KYBD DEVICE INPUT 
      SPC 1 
RKYBD JSB EXEC     USE EXEC 
      DEF *+5       INPUT CALL
      DEF D1         TO INPUT 
      DEF LNLU        FROM
READ4 NOP              KYBD 
      DEF M80           DEVICE
      SZB,RSS      ZERO TRANSMISSION LENGTH?
      JMP READ3     YES - EXIT WITH NWDS = -1 
      AND B40       NO -
      SZA          END OF TAPE BIT SET? 
      JMP READ3     YES - EXIT WITH NWDS = -1 
      JMP READ5     NO - CONVERT CHARS TO WORDS 
      SPC 1 
* FMP FILE INPUT
      SPC 1 
REDF  JSB READF    FMP CALL 
      DEF *+6       RETURN ADDRESS
REDF1 NOP           DCB ADDRESS 
      DEF IERR      ERROR RETURN
REDF2 NOP           BUFFER ADDRESS
      DEF D40       MAX 40 WORDS
      DEF NWDS      NUMBER OF WORDS READ
      JSB IFMGR    CHECK
      DEF *+5       ERROR 
      DEF IERR       CODE 
      DEF D11         & PRINT 
      DEF TTY          IF THERE 
REDF3 NOP               WAS A ERROR 
      SSA          ANY ERRORS?
      JMP READ3     YES - SET NWDS = - 1 & RETURN 
      LDA NWDS      NO - EOF
      SSA          ENCOUNTERED? 
      JMP READL,I   YES - RETURN
      JMP READ6     NO - FILL REST OF BUFFER WITH -1
      SPC 1 
* CONVERT CHARACTERS TO WORDS 
      SPC 1 
READ5 SLB           IF CHAR COUNT IS
      INB          ODD, ADD 1 
      BRS           DIVIDE BY 2 
      STB NWDS     AND SAVE WORD COUNT
      SPC 1 
* FILL REMAINDER OF BUFFER WITH -1'S
      SPC 1 
READ6 LDA NWDS     SET UP 
      ADA READ1     A POINTER 
      STA PNTR1      TO THE BUFFER
      CCB          -1 TO B
      LDA NWDS     GET NEGATE OF REMAING
      ADA M40       BUFFER WORD COUNT 
      SSA,RSS      ZERO OR POSITIVE 
      JMP READ7     YES - CHECK FOR SLASH OPTION
      STB PNTR1,I   NO - STORE A -1 IN THE BUFFER 
      ISZ PNTR1    INDEX BUFFER POINTER 
      INA          INCREMENT A
      JMP *-5      LOOP 
      SPC 1 
* CHECK FOR SLASH OPTION
      SPC 1 
READ7 LDA SLASH    SLASH OPTION 
      SZA,RSS       FLAG SET? 
      JMP READL,I    NO - RETURN
      LDA READ1,I    YES - GET 1ST WORD OF BUFFER 
      CPA /           IS IT A SLASH?
      JMP READ3        YES - SET EOF
      CPA !/            NO - IS IT A !/ ? 
      LDA /              YES - GET A /SPACE 
      STA READ1,I  PUT CHARACTER INTO BUFFER
      JMP READL,I   & RETURN
      HED ** RTE EDITOR REDWF SUBROUTINE ** JDR 
* SUBROUTINE TO READ A RECORD FROM THE EDITOR WORK
* FILE INTO THE WORK BUFFER, WBUF.
      SPC 1 
* CALL SEQUENCE 
*     A = RECORD NUMBER TO BE READ
*     JSB REDWF 
*     RETURN A = FMP READ STATUS
      SPC 1 
REDWF NOP 
      STA RCORD    SAVE RECORD NUMBER 
      JSB READF    MAKE 
      DEF *+7       CALL
      DEF WDCB1      TO 
      DEF IERR        FMP 
      DEF WBUF1        READF
      DEF D44           TO
      DEF LEN            READ 
      DEF RCORD           RECORD  
      JSB IFMGR    MAKE 
      DEF *+5       CALL
      DEF IERR        TO
      DEF D11          IFMGR
      DEF TTY           TO CHECK
      DEF WFILE+1        FOR READ ERRORS
      JMP REDWF,I  RETURN 
      HED ** RTE EDITOR SCANR SUBROUTINE ** JDR 
* SCANR SCANS THE INPUT FOR A STRING OF CHARACTERS CONTAINED
* BETWEEN TWO DELIMITERS, THE STRING IS CHECK FOR A LINE NUMBER,
* FILE NAME OR A CHARACTER STRING.
      SPC 1 
* CALL SEQUENCE 
*     LINE TO BE SCANNED IN CBUF
*     NCHAR = STARTING CHARACTER POSITION OF SCAN 
*     JSB SCANR 
*     RETURN
* A. TYPE = 1 - NUMBER ENCOUNTERED
*    1. CONTENTS OF CBUF UNCHANGED
*    2. TBUF(1) = 1ST PART OF LINE NUMBER OR LINE 
*                 INCREMENT 
*    3. TBUF(2) = 2ND PART OF LINE NUMBER 
*    4. NCHAR = POSITION OF CURRENT DELIMITER 
* B. TYPE = 0 - END OF LINE 
*    1. CONTENTS OF CBUF UNCHANGED
*    2. TBUF'S  1ST THREE WORDS FILLED WITH SPACES
*    3. NCHAR MEANINGLESS 
* C. TYPE = -1 & NCHAR > 0 - FILE NAME ENCOUNTERED
*    1. CONTENTS OF CBUF UNCHANGED
*    2. TBUF CONTAINS FILE NAME IN 1ST THREE WORDS
*    3. NCHAR = POSITION OF CURRENT DELIMITER 
* D. TYPE < 0 & NCHAR < 0 - CHARACTER STRINGS FOUND 
*    1.LBUF = UNPACKED NEW STRING 
*    2.TBUF = UNPACKED OLD STRING 
*    3.CBUF UNCHANGED 
*    4.TYPE = NUMBER OF CHARACTERS IN OLD STRING
*    5.NCHAR = NUMBER OF CHARACTERS IN NEW STRING 
* 
* IERR = 0  NO ERROR
* IERR = 1  ERROR ENCOUNTERED IN COMMAND LINE 
      SPC 1 
SCANR NOP 
      LDA M40      SET UP A 
      STA CNTR1     -40 COUNTER 
      LDA TBUFD    PUT TBUF'S 
      STA PNTR1     ADDRESS IN POINTER1 
      LDB SPACE    ASCII SPACE SPACE TO B 
      STB PNTR1,I  FILL 
      ISZ PNTR1     TBUF
      ISZ CNTR1      WITH 
      JMP *-3         40 SPACES 
      SPC 1 
* CALCULATE CURRENT WORD POSITION SAVE
      SPC 1 
      LDA NCHAR    GET CHARACTER POSITION 
      ADA M1        SUBTRACT 1
      ARS            AND DIVIDE BY 2
      ADA CBUFD       ADD CBUF ADDRESS
      STA PNTR1        AND SAVE AS POINTER 1
      SPC 1 
* CLEAR ALL FLAGS AND SET MAXIUM SCAN COUNTER 
      SPC 1 
      CLA          CLEAR THE
      STA TYPE      TYPE, 
      STA IERR       ERROR
      STA DFLAG       DELIMITER 
      STA PART2        LINE # 2 AND 
      STA CFLAG         CHARACTER IN FLAGS
      LDA M81      MAX. CHARS/LINE = -80
      ADA NCHAR    ADA CURRENT CHARACTER POSITION 
      STA MAXCH     AND SAVE AS MAXIUM SCAN COUNTER 
      LDA TBUFD    SET OUTPUT 
      STA PNTR2     POINTERS
      STA PNTR3      TO TBUF
      SPC 1 
* START SCAN - NOTE: 1ST CHARACTER MUST BE A DELIMITER
      SPC 1 
SR1   JSB CHAR     GET A CHARACTER IN A 
      CPA QUOTE    IS IT A QUOTE? 
      JMP SR2       YES - DELIMITER OR CHAR. STRING?
      CPA APSTP    IS IT A ' ?
      JMP SR2       YES - DELIMITER OR CHAR. STRING?
      CPA SSPAC    IS IT A SPACE
      JMP SR3       YES - DELIMITER FOUND 
      CPA COMMA    IS IT A COMMA? 
      JMP SR3       YES - DELIMITER FOUND 
      CPA B177     END OF LINE? 
      JMP SR3       YES - PROCESS AS DELIMITER
      CPA DASH     IS IT A DASH?
      JMP SR5       YES - SECOND PART OF A LINE # 
      LDB DFLAG    IS DELIMITER 
      SZB,RSS       FLAG SET? 
      JMP SR12       NO - ERROR 
      JSB PCHAR      YES - PACK CHARACTER 
      JMP SR1      GET NEXT CHARACTER 
SR2   LDB CFLAG    ANY
      SZB           CHARACTERS
      JMP SR4        YES - PROCESS THEM 
      JMP SR6        NO - PROCESS CHARACTER STRINGS 
      SPC 1 
* ROUTINE TO FETCH A CHARACTER FROM CBUF
      SPC 1 
CHAR  NOP 
      ISZ MAXCH    ANYMORE CHARACTERS?
      RSS           YES - GET IT
      JMP SR12      NO - ERROR
      LDA PNTR1,I  GET WORD FROM CBUF 
      LDB NCHAR    IS CHARACTER 
      SLB           IN HIGH HALF? 
      ALF,ALF        YES - ROTATE TO LOW
      AND B177     MASK OFF HIGH HALF OF WORD 
      SLB,RSS      IF CHAR WAS IN LOW,
      ISZ PNTR1     UPDATE CBUF POINTER 
      ISZ NCHAR    INCREMENT CHARACTER POSITION 
      JMP CHAR,I   RETURN WITH CHARACTER IN A 
      SPC 1 
* ROUTINE TO PACK A CHARACTER IN TBUF 
      SPC 1 
PCHAR NOP 
      STA TEMP     SAVE CHARACTER TO BE PACKED
      LDA PNTR2,I  GET WORD FROM TBUF 
      LDB CFLAG    GET CHARACTER FLAG 
      SLB,RSS      DO WE PUT CHAR IN HIGH?
      ALF,ALF       YES - ROTATE WORD 
      AND HIGH     SAVE HIGH CONTENTS AND 
      IOR TEMP      OR IN CURRENT CHARACTER 
      SLB,RSS      IF THIS IS A HIGH WORD CHARACTER 
      ALF,ALF       ROTATE WORD TO ORGINAL POSITION 
      STA PNTR2,I  PUT WORD BACK INTO TBUF
      SLB          THIS LOCATION FILLED?
      ISZ PNTR2     YES - UPDATE POINTER
      ISZ CFLAG    INCREMENT CHARACTER FLAG 
      JMP PCHAR,I  RETURN 
      SPC 1 
* PROCESS DELIMITER 
      SPC 1 
SR3   LDB DFLAG    IS THE DE- 
      SZB           LIMITER FLAG SET? 
      JMP SR4        YES - MUST BE 2ND DELIMITER
      CPA B177       NO - END OF LINE?
      JMP SR13        YES - SET END OF LINE FLAG
      ISZ DFLAG       NO - SET FLAG AND 
      JMP SR1          GET NEXT CHARACTER 
      SPC 1 
* PROCESS LINE NUMBER OR FILE NAME
      SPC 1 
SR4   LDB CFLAG    ANY
      SZB           CHARACTERS? 
      JMP *+4        YES - PROCESS THEM 
      CPA B177       NO - END OF LINE?
      JMP SR13        YES - SET EOL FLAG
      JMP SR1         NO - GET NEXT CHARACTER 
      LDA PNTR3    GET ADDRESS OF TBUF
      JSB NUM?     SEE IF IT IS A NUMBER
      LDA NERR     GET NUMBER CONVERSION ERR RETURN 
      SZA,RSS      ERROR? 
      INA           NO - SET TYPE = 1 
      STA TYPE     UPDATE SCAN TYPE 
      ISZ PNTR3    INDEX TBUF POINTER 
      CLB          SET B = 0
      SSA,RSS      IF NOT A FILE NAME, SET NXT WORD 
      STB PNTR3,I   IN TBUF = 0 
      LDB PART2    ARE WE PROCESSING
      SZB,RSS       A TWO PART LINE NUMBER? 
      JMP SR11       NO - EXIT
      SSA            YES - THEN WE MUST HAVE A NUMB 
      JMP SR12        NOT A NUMBER - ERROR
      JMP SR11        A NUMBER EXIT 
      SPC 1 
* PROCESS A TWO PART LINE NUMBER
      SPC 1 
SR5   LDA TBUFD    GET ADDRESS OF 1ST ASCII STRING
      JSB NUM?      CONVERT IT TO AN INTEGER
      LDA NERR     WAS THERE
      SZA           AN ERROR? 
      JMP SR12       YES - ERROR EXIT 
      ISZ PNTR3      NO - INDEX TBUF POINTER
      LDA M3       SET UP A 
      STA CNTR1     -3 COUNTER
      LDA PNTR3    GET NEW ADDRESS
      STA PNTR2     OF TBUF 
      LDB SPACE    ASCII SPACE-SPACE TO B 
      STB AREG,I   FILL THE 
      INA           NEXT THREE
      ISZ CNTR1      LOCATIONS WITH 
      JMP *-3         SPACES
      ISZ PART2    SET PART TWO FLAG
      CLA          RESET CHARACTER
      STA CFLAG     FLAG
      JMP SR1      GET PART TWO OF LINE NUMBER
      SPC 1 
* CHARACTER STRING PROCESSING SECTION 
      SPC 1 
SR6   STA CDLIM    SAVE CHARACTER STRING DELIMITER
      LDA TBUFD    SET POINTER TO STORE OLD STRING
      STA PNTR2     IN TBUF 
      CLA          ZERO 
      STA CNTR1     CNTR1 
      JSB GETUM    GET 1ST (OLD) STRING 
      LDA CNTR1    GET OLD STRING COUNT,
      CMA,INA       MAKE IT NEGATIVE
      STA TYPE       AND STORE IN TYPE
      ISZ PART2    SET FLAG TO INDICATE NEW STRING
      LDA LBUFD    SET POINTER
      STA PNTR2     TO LBUF 
      CLA          ZERO 
      STA CNTR1     CNTR1 
      STA DFLAG      & DELIMITER FLAG 
      JSB GETUM    GET 2ND (NEW) STRING 
      LDA CNTR1    GET CHARACTER
      CMA,INA       COUNT, MAKE IT NEGATIVE 
      STA NCHAR      AND STORE IN NCHAR 
      CLA          CLEAR THE
      STA IERR      ERROR FLAG
      JMP SCANR,I    & RETURN 
      SPC 1 
* CHARACTER STRING SCANNER
      SPC 1 
GETUM NOP 
SR7   JSB CHAR     GET A CHARACTER FROM CBUF
      CPA B177     END OF LINE
      JMP SR12      YES - ERROR 
      CPA CDLIM    IS IT A CHARACTER STRING DELIMIT?
      JMP SR8       YES - CHECK TO SEE WHERE WE ARE 
      STA PNTR2,I   NO - PUT CHARACTER IN BUFFER
      ISZ CNTR1    INCREMENT CHARACTER COUNTER
      ISZ PNTR2     AND BUFFER POINTER
      JMP SR7      GET NEXT CHARACTER 
SR8   LDA PART2    IS THIS
      SZA           THE OLD STRING? 
      JMP SR9        NO - MUST BE NEW 
      LDA CNTR1      YES - GET CHARACTER COUNT
      SZA          ANY CHARACTERS 
      JMP GETUM,I   YES - RETURN
      JMP SR12      NO - ERROR
SR9   LDA DFLAG    IS THIS THE START
      SZA           OF THE NEW STRING?
      JMP GETUM,I    NO - THE END - RETURN
      ISZ DFLAG      YES - SET THE DELIMIT FLAG 
      LDA CNTR1    GET CURRENT CHAR COUNT 
      CMA,INA       AND RESET 
      ADA PNTR2      THE BUFFER 
      STA PNTR2       POINTER 
      CLA          ZERO 
      STA CNTR1     CNTR1 
      JMP SR7      GET THE NEW STRING 
      SPC 1 
* CALL TO CONVERT AN ASCII STRING TO AN INTEGER 
      SPC 1 
NUM?  NOP 
      STA SR10     PUT BUFFER ADDRESS IN CALL 
      JSB NUM      MAKE 
      DEF *+3       CALL
SR10  NOP            TO 
      DEF NERR        NUM 
      JMP NUM?,I   RETURN 
      SPC 1 
* ERROR AND NORMAL EXIT RETURN
      SPC 1 
SR11  CLA,RSS      IERR = 0, NO ERROR 
SR12  CLA,INA      IERR = 1, ERROR
      STA IERR     SAVE ERROR STATUS
      CCA          DECREMENT
      ADA NCHAR     CHARACTER 
      STA NCHAR      POINTER
      JMP SCANR,I  RETURN 
      SPC 1 
* END OF LINE EXIT
      SPC 1 
SR13  CLA          SET TYPE 
      STA TYPE      & IERR
      JMP SR12+1     = 0
      HED ** RTE EDITOR SETLS SUBROUTINE ** JDR 
* SUBROUTINE TO SET THE BASE PAGE LS TRACK WORD ** JDR
      SPC 1 
* CALL SEQUENCE 
*     TRACK & LUN  IN RTRK1 
*     JSB SETLS 
*     RETURN
      SPC 1 
SETLS NOP 
      JSB $LIBR     TURN MEMORY 
      NOP          PROTECT OFF
      LDA RTRK1     GET LUN-TRACK 
      LSL 7        REFORMAT IT AND
      STA SFCUN    STORE IN BASE PAGE 
      JSB $LIBX     TURN MEMORY 
      DEF SETLS    PROTECT ON 
      HED ** RTE EDITOR WFIND SUBROUTINE ** JDR 
* SUBROUTINE TO FIND A SPECIFIED LINE NUMBER IN THE EDITOR
* WORK FILE AND TO UPDATE THE WORK FILE POINTERS IN THE 
* WL-- ARRAY. 
      SPC 1 
* CALL SEQUENCE 
*  SET WL11 & WL21 EQUAL TO THE LINE NUMBER TO BE LOCATED 
*     JSB WFIND 
*     RETURN (NORMAL) - LINE IN WBUF BUFFER 
*     A = 0 - REQUESTED LINE FOUND
*     A = 1 - REQUESTED LINE NOT FOUND - CLOSET LOWER LINE
*             NUMBER IN WBUF & POINTERS IN ARRAY WL-- 
*     RETURN - ERROR
*     PRINT ERROR MESSAGE & THEN REQUEST NEW DIRECTIVE
      SPC 1 
WFIND NOP 
      SPC 1 
* IF REQUEST IS TO LAST LINE & FILE IS EMPTY RETURN 
      SPC 1 
      LDA WL11     REQUEST
      ADA WL21      TO LAST 
      ADA WLAST      LINE IN AN 
      SZA,RSS         EMPTY FILE? 
      JMP WFIND,I      YES - RETURN 
      LDA WLAST        NO - IS THE
      SZA               FILE EMPTY? 
      JMP WF1            NO - CONTINUE
WF0   LDA D6             YES - OUTPUT 
      LDB TTY             ERROR 
      JSB PRINT            MESSAGE &
      JMP .D2               FETCH NEW DIRECTIVE 
      SPC 1 
* INITIALIZE THE RECORD POINTER 
      SPC 1 
WF1   CLA          CLEAR THE
      STA LINE      LINE FOUND FLAG 
      DLD WL11     GET THE REQUESTED LINE 
      CPA WL15     IS 
      RSS           IT
      JMP WF2        THE
      CPB WL25        LAST
      RSS              LINE 
      JMP WF2           ? 
      LDA WL45     YES - POSITION 
      JMP WF40      THE FILE
WF2   CMA,INA       NO - IS 1ST PART > LAST 
      ADA WBUF1      LINE 
      SSA             ACCESSED? 
      JMP WF3      YES - START AT CURRENT LINE
      SZA          MAYBE - ARE 1ST PARTS EQUAL? 
      JMP WF2.0     NO - START AT 1ST LINE
      CMB,INB       YES - IS 2ND PART > LAST
      ADB WBUF2      LINE 
      SSB             ACCESSED? 
      JMP WF3      YES - START AT CURRENT LINE
      SZB,RSS      NO - EQUAL?
      JMP WF3     YES - START AT -1 CURRENT LINE
WF2.0 LDA WL34     1ST LINE RECORD NUMBER 
      RSS          SKIP 
WF3   LDA WBUF3    CURRENT LINE RECORD NUMBER 
      SPC 1 
* FIND THE SPECIFIED LINE NUMBER
      SPC 1 
WF40  JSB REDWF    READ A LINE FROM THE WORK FILE 
      SSA          ANY READ ERRORS? 
      JMP WF90      YES - TAKE FMP ERROR MESS. EXIT 
      DLD WBUF1     NO -
      CPA WL11     IS 
      RSS           THIS THE
      JMP *+3        REQUESTED
      CPB WL21        LINE? 
      JMP WF80         YES - UPDATE THE POINTERS
      CPA WL15         NO - IS THIS 
      RSS               THE LAST
      JMP *+3             LINE IN THE 
      CPB WL25             WORK FILE? 
      JMP WF90      YES - TAKE FMP ERROR MESS. EXIT 
      CMA,INA       NO -
      ADA WL11     1ST PART OF LINE NUMBER GREATER
      SSA           THAN REQUESTED LINE?
      JMP WF44       YES - WE PASSED THE LINE 
      SZA            NO - IS IT EQUAL?
      JMP WF42        NO - READ NEXT LINE 
      CMB,INB         YES - COMPARE SECOND PARTS
      ADB WL21     IS 2ND PART OF LINE NUMBER 
      SSB           GREATER THAN REQUESTED LINE?
      JMP WF44       YES - WE PASSED THE LINE 
WF42  LDA WBUF4      NO - GET NEXT LINE RECORD POINT
      JMP WF40        ER & READ THE LINE. 
      SPC 1 
* PASSED THE LINE - SET WLX,2 POINTERS AND BACKUP 1 LINE
      SPC 1 
WF44  ISZ LINE     SET THE LINE INDICATOR FLAG
WF45  DLD WBUF1    UPDATE 
      DST WL12     "LINE FOLLOWING" 
      DLD WBUF3      LINE 
      DST WL32        POINTERS
      LDA WBUF3    GET THE
      JSB REDWF     PREVIOUS LINE AGAIN 
      SSA          ANYREAD ERRORS 
      JMP WF90      YES - TAKE FMP ERROR MESS. EXIT 
      DLD WBUF1     NO - UPDATE 
      DST WL11       THE CURRENT
      DLD WBUF3       LINE
      DST WL31         POINTERS 
      LDA LINE     GET THE FOUND LINE STATUS
      JMP WFIND,I   & RETURN
      SPC 1 
* EXACT LINE FOUND - IS THIS THE LAST LINE IN THE WORK FILE?
      SPC 1 
WF80  DLD WBUF1    IS THIS
      CPA WL15      THE 
      RSS            LAST LINE
      JMP *+3         IN THE
      CPB WL25         WORK 
      JMP WF85          FILE
      LDA WBUF4    NO - GET THE NEXT
      JSB REDWF     LINE
      SSA          ANY READ ERRORS? 
      JMP WF90      YES - TAKE FMP ERROR EXIT 
      JMP WF45      NO - UPDATE THE POINTERS
      SPC 1 
* LAST LINE - UPDATE CURRENT LINE POINTERS & ZERO NEXT LINE POINTERS
      SPC 1 
WF85  DLD WBUF3    UPDATE THE CURRENT 
      DST WL31      LINE POINTERS 
      CLA          ZERO 
      CLB           THE 
      DST WL12       NEXT LINE
      DST WL32        POINTERS
      JMP WFIND,I  RETURN 
      SPC 1 
* FMP REAR ERROR IN WORK FILE EXIT
      SPC 1 
WF90  LDA D7       OUTPUT 
      LDB TTY       ERROR 
      JSB PRINT      MESSAGE
      JMP .D2      FETCH NEXT DIRECTIVE 
      HED ** RTE EDITOR WRIWF SUBROUTE ** 
* SUBROUTINE TO WRITE THE WBUF BUFFER INTO THE EDITOR WORK FILE 
      SPC 1 
* CALL SEQUENCE 
*     A = RECORD NUMBER TO BE WRITTEN 
*     JSB WRIWF 
*     RETURN - A = WRITE ERROR STATUS 
      SPC 1 
WRIWF NOP 
      STA RCORD    SAVE RECORD NUMBER 
      JSB WRITF    MAKE 
      DEF *+6       CALL
      DEF WDCB1      TO 
      DEF IERR        WRITF 
      DEF WBUF1        TO 
      DEF D44           WRITE 
      DEF RCORD          WBUF 
      JSB IFMGR    MAKE 
      DEF *+5       CALL
      DEF IERR       TO 
      DEF D13         IFMGR 
      DEF TTY          TO REPORT
      DEF WFILE+1       ANY ERRORS
      JMP WRIWF,I        RETURN 
      HED ** RTE EDITOR YESNO SUBROUTINE ** JDR 
* SUBROUTINE TO INPUT A YES OR NO REPLY 
      SPC 1 
* CALL SEQUENCE 
*     JSB YESNO 
*     P+1  RETURN IF REPLY IS NO
*     P+2  RETURN IF REPLY IS YES 
      SPC 1 
YESNO NOP 
      JSB EXEC      CALL
      DEF *+5      EXEC 
      DEF D1       TO 
      DEF TTY      INPUT
      DEF IERR     1
      DEF D1       WORD 
      LDA IERR      GET REPLY 
      CPA NO       IS IT A NO?
      JMP YESNO,I  YES - RETURN 
      CPA YES      IS IT A YES? 
      JMP *+5      YES - EXIT P+2 
      LDA D14      NO - 
      LDB TTY      OUTPUT ANSWER MUST 
      JSB PRINT    BE A YES OR NO MESSAGE 
      JMP YESNO+1   INPUT REPLY AGAIN 
      ISZ YESNO     INCREMENT TO P+2
      JMP YESNO,I  & RETURN 
      HED ** RTE EDITOR CONSTANTS & STORAGE ALLOCATION ** JDR 
AREG  EQU 0        A REGISTER 
BREG  EQU 1        B REGISTER 
LGOC  EQU 1766B    CURRENT LGO TRACK/SECTOR ADDRESS 
LGOTK EQU 1765B    LOAD-N-GO;LU,STG TRAK;# OF TRACKS
SFCUN EQU 1767B    BASE PAGE LS TRACK POINTER 
      SPC 1 
.!    DEF *+1 
      ASC 1,! 
/     ASC 1,/ 
/A    ASC 1,/A
/C    ASC 1,/C
/D    ASC 1,/D
/E    ASC 1,/E
/G    ASC 1,/G
/I    ASC 1,/I
/L    ASC 1,/L
/M    ASC 1,/M
/N    ASC 1,/N
/O    ASC 1,/O
/R    ASC 1,/R
/S    ASC 1,/S
!/    ASC 1,!/
      SPC 1 
APSTP OCT 47
      SPC 1 
B40   OCT 40
B55   OCT 55
B60   OCT 60
B177  OCT 177 
B377  OCT 377 
B1000 OCT 1000
B1776 OCT 177600
BLOK  DEF *+1 
BLOCK NOP          NUMBER OF BLOCKS TO RELEASE
      SPC 1 
CBUFD DEF *+1 
CBUF  BSS 80       COMMAND LINE BUFFER
CDCB  DEF *+1 
      BSS 144      COMMAND FMP DCB
CDLIM NOP          CURRENT STRING DELIMITER 
CFILD DEF CFILE 
CFILE BSS 3        COMMAND FMP FILE NAME
CFLAG NOP          SCAN CHARACTER FLAG
CFMP  NOP          COMMANDS IN FMP FILE FLAG
CLINE DEC 1        COMMAND LINE NUMBER COUNTER
CMND  OCT 401      COMMAND INPUT LOGICAL UNIT # 
CNTR1 DEC -3       GENERAL
CNTR2 NOP           UTILITY 
CNTR3 NOP            COUNTERS 
COMMA OCT 54       ASCII COMMA
      SPC 1 
D1    DEC 1 
D2    DEC 2 
D3    DEC 3 
D4    DEC 4 
D5    DEC 5 
D6    DEC 6 
D7    DEC 7 
D8    DEC 8 
D9    DEC 9 
D10   DEC 10
D11   DEC 11
D12   DEC 12
D13   DEC 13
D14   DEC 14
D15   DEC 15
D16   DEC 16
D17   DEC 17
D18   DEC 18
D19   DEC 19
D20   DEC 20
D21   DEC 21
D22   DEC 22
D24   DEC 24
D40   DEC 40
D44   DEC 44
D80   DEC 80
D100  DEC 100 
D10K  DEC 10000 
DASH  OCT 55       ASCII DASH 
DFLAG NOP          SCAN DELIMITER FLAG
      SPC 1 
ECHO  OCT 400 
EOF1  NOP          END OF FILE/ END 
      SPC 1 
FIRST NOP          NEW 1ST LINE FLAG
FLAG  NOP          UTILITY FLAG 
      SPC 1 
HIGH  OCT 177400   HIGH WORD MASK 
      SPC 1 
IERR  NOP          UTILITY ERROR WORD 
ISERT NOP          INSERT LINE INCREMENY
      SPC 1 
KYBD  DEC 1        KYBD INPUT ECHO FLAG 
KYBDS DEF *+1 
      DEC 1,0      LIST OF KYBD DEVICES IN SYSTEM 
      SPC 1 
LAST  NOP          NEW LAST LINE FLAG 
LAST1 NOP          LAST LINE NUMBER OF WORK FILE TO 
LAST2 NOP           BE INCLUDED IN CURRENT OPERATION
LBUFD DEF LBUF
LBUF  BSS 80       LINE INPUT BUFFER
LDCB  DEF *+1 
LDCB1 BSS 144      LINE FMP WDCB
LEGAL DEC 1,2,4,6,0   LEGAL OUTPUT DEVICES  
LEN   NOP          FMP READF RETURN READ COUNT
LINE  NOP          FOUND LINE FLAG
LINES NOP          INPUT LINE COUNT 
LFILD DEF LFILE 
LFILE BSS 3        LINE INPUT FMP FILE NAME 
LFIL4 OCT 20137    SPACE BACKARROW
LFMP  NOP          LINE INPUT FROM FMP FILE FLAG
LINK  DEF LDCB1    POINTER TO LDCB
LKYBD NOP          LINE INPUT KYBD ECHO FLAG
LNLU  NOP 
LNLUD DEF LNLU
LNUM  NOP 
LUNDK NOP          LS TRACK LUN 
      SPC 1 
M1    DEC -1
M2    DEC -2
M3    DEC -3
M5    DEC -5
M6    DEC -6
M10   DEC -10 
M20   DEC -20 
M40   DEC -40 
M80   DEC -80 
M81   DEC -81 
M99   DEC -99 
M134  DEC -134
M10K  DEC -10000
MAXCH NOP          SCAN MAXIUM CHARACTER COUNTER
MLENG DEC 36       MAX LIST WORD OUTPUT COUNT 
      SPC 1 
NCHAR NOP          COMMAND LINE CHARACTER POINTER 
NERR  NOP          NUM ERROR RETURN 
NWDS  NOP          INPUT CHAR/WORD COUNT
NO    ASC 1,NO
      SPC 1 
PAGE  OCT 1106    LIST OUTPUT DEVICE PAGE COMMAND 
PART2 NOP          SCAN LINE # PART 2 FLAG
PLUS  ASC 1,+ 
PNTR1 NOP          UTILITY
PNTR2 NOP           BUFFER
PNTR3 NOP            POINTERS 
      SPC 1 
QUOTE OCT 42       ASCII QUOTE
      SPC 1 
RCORD NOP          CURRENT WORK FILE RECORD NUMBER
RFLAG NOP          REPLACE OPERATION FLAG 
RTRK1 NOP          1ST LS TRACK 
RTRKC NOP          CURRENT LS TRACK 
      SPC 1 
SAVED DEC 1        WORK FILE SAVED FLAG 
SECT2 OCT 1757     NUMBER OF SECTORS ON SYSTEM DISC 
SLASH NOP          SLASH OPTION FLAG
SLINE NOP          STARTING INPUT LINE
SPACE ASC 1,       ASCII DOUBLE SPACE 
SSPAC OCT 40       ASCII SINGLE SPACE 
START NOP          FIRST INSERT RECORD NUMBER 
      SPC 1 
TAK   NOP          LS TRACK # 
TBF6D DEF TBUF+5
TBUFD DEF *+1 
TBUF  BSS 80       TEMPORARY BUFFER 
TEMP  NOP          TEMPORARY STORAGE
TTYD  DEF *+1 
TTY   OCT 401      OPERATOR KYBD/OUTPUT LOGICALUNIT 
TYPE  NOP          SCAN ID
      SPC 1 
* WORK FILE LINE BUFFER 
WBF5D DEF WBUF5 
WBUF1 NOP          1ST PART OF LINE NUMBER
WBUF2 NOP          2ND PART OF LINE NUMBER
WBUF3 NOP          PRECEDING LINE RECORD NUMBER 
WBUF4 NOP          NEXT LINE RECORD NUMBER
WBUF5 BSS 40       CHARACTERS IN LINE (MAX 80)
WDCB  DEF *+1 
WDCB1 BSS 144      WORK FILE FMP DCB
WFILE DEF *+1 
      ASC 3,EDITOR WORK FILE FMP NAME 
WLAST NOP          LAST RECORD IN WORK FILE 
      SPC 1 
*                   WORK FILE LINE POINTERS 
* CURRENT REFERENCED LINE 
WLDEF DEF WL11
WL11  NOP          1ST PART OF LINE NUMBER
WL21  NOP          2ND PART OF LINE NUMBER
WL31  NOP          PRECEDING LINE RECORD NUMBER 
WL41  NOP          NEXT LINE RECORD NUMBER
* LINE FOLLOWING CURRENT REFERENCED LINE
WL12  NOP 
WL22  NOP 
WL32  NOP 
WL42  NOP 
* CURRENT INSERT LINE 
WL13  NOP 
WL23  NOP 
WL33  NOP 
WL43  NOP 
* FIRST LINE IN WORK FILE 
WL14  NOP 
WL24  NOP 
WL34  NOP 
WL44  NOP 
* LAST LINE IN WORK FILE
WL15  NOP 
WL25  NOP 
WL35  NOP 
WL45  NOP 
      SPC 1 
YES   ASC 1,YE
      SPC 1 
      END EDIT
                                                                                                                                                                               