
ASMB,R,B,L,C
      NAM D.43
      ENT D.43,I.43
      EXT T.50
*
*   TIME BASE GENERATOR DRIVER - INITIATOR SECTION
*
D.43  NOP           ENTRY POINT.
      STA EQTA      SAVE EQT ENTRY ADDRESS
      STB FUNA      SAVE REQUEST CODE ADDRESS
      LDA B,I       GET WORD #2 OF REQUEST
      AND =B177700  ISOLATE REQUEST CODE
      SZA           CODE = 0?
      JMP DCODE     NO.  DECODE REQUEST
*
*   "CLEAR" REQUEST SECTION
*
CLR   LDA EQTA,I    YES. CLEAR. GET EQT WORD #1
      AND =B77      ISOLATE DEVICE I/O ADDRESS
      IOR =B106700  FORM CLC INSTRUCTION
      STA I.1       SET INSTRUCTION
I.1   CLC 0         PERFORM CLEAR
      CLA
      STA FLAG      CLEAR DRIVER FLAG
*
*   DRIVER EXIT SECTION
*
EXIT  LDA =B100000  EXIT. RELEASE BUF IOC STACK
      RSS           SKIP REQUEST CODE ERROR SECTION
RCER  CLA,INA       REQUEST CODE ERROR EXIT (A)=1
      CLB                                   (B)=0
      JMP D.43,I    RETURN TO IOC
REJB  LDB =B100000  SET (B #15)=1 (BUSY)
      CLA,INA       SET (A)=1 (REJECT)
      JMP D.43,I    REJECT-RETURN TO IOC
*
*  REQUEST DECODING SECTION
*
DCODE CPA =B20100   WRITE BINARY REQUEST?
      JMP WFLG      YES. SET READ/WRITE FLAG
      CPA =B10100   NO. CHECK FOR READ BINARY
      JMP RFLG      READ REQUEST. CLEAR RWFLG
      JMP RCER      NO COMPARISONS. ERROR EXIT
*
*   DRIVER & READ/WRITE FLAGS SECTION
*
WFLG  LDA FLAG      TEST DRIVER FLAG.
      SZA           FLAG SET?
      JMP REJB      YES. REJECT: BUSY
      CLA,INA       SET (A)=1 (WRITE)
      STA FLAG      SET DRIVER FLAG = BUSY
      RSS           SKIP NEXT INSTRUCTION
RFLG  CLA           SET (A)=0 (READ)
      STA RWFLG     SET READ/WRITE FLAG
*%
*   I/O INSTRUCTION INITIALIZATION
*
INIT  LDA EQTA,I    GET EQT WORD #1
      AND =B77      ISOLATE DEVICE I/O ADDRESS
      STA B         SET (B)= DEVICE I/O ADDRESS
      STA SELCD     SAVE FOR T.50 ENTRY.
      LDA =B103600  (A)= OTA
      IOR B         FORM CONFIGURED INSTRUCTION
      STA I.2       SET INSTRUCTION
      LDA =B103700  (A)= STC,C
      IOR B
      STA I.3
      STA I.5       (A)= STC,C
      LDA =B106500  (A)= LIB
      IOR B
      STA I.4
      LDA RWFLG     SET A= READ/WRITE FLAG
      SZA,RSS       (A)= 1?
      JMP RDCLK     NO. GO TO CLOCK READ SECTION
*
*   CLOCK SETTING SECTION - INITIALIZES THE TIME BASE GENERATOR
*   TO INTERRUPT AT THE INTERVAL SPECIFIED BY BINARY DATA
*   WORD #1 IN CALL TO THE DRIVER.  (SEE BEGINNING OF LISTING)
*
      LDB FUNA      GET REQUEST ADDRESS
      ADB =B2       GET REQUEST WORD #4
      LDB B,I       FIND DATA BUFFER ADDRESS
      LDA B,I       GET DATA (INTERRUPT INTERVAL)
      AND =B177770  MASK INTERVAL WORD
      SZA           INTERVAL  7?
      JMP RCER      YES. ERROR REJECT
      LDA B,I       GET INTERVAL WORD AGAIN
      INB           GET DATA WORD #2 ADDRESS
      LDB B,I       (B)= INTERVAL MULTIPLIER
      SZB,RSS       CHECK FOR ZERO DATA
      JMP RCER      ZERO. ERROR REJECT
      CMB,INB       2'S COMPLEMENT OF MULTIPLIER
      STB CNTR      SAVE WORKING COUNTER CONSTANT
      STB WCNT      INITIALIZE WORKING COUNTER
I.2   OTA 0         INITIALIZE TBG INTERRUPT RATE
I.3   STC 0,C       START TIME INTERVAL
      CLA           (A)= 0
      STA MULTL     INITIALIZE MULTIPLE COUNTER
      STA MULTH
      STA ERROR     INITIALIZE ERROR COUNTER
      JMP EXIT
*
*  CLOCK READ SECTION - RETURNS TWO DATA WORDS
*   WORD #1 - MULTIPLE COUNTER (INTERRUPTS/MULTIPLE) LOW COUNTS
*   WORD #1 -                                        HIGH COUNTS
*
RDCLK LDB FUNA      GET REQUEST ADDRESS
      ADB =B2       GET REQUEST WORD #4
      LDB B,I       FIND DATA BUFFER ADDRESS
      LDA MULTL     SET (A)= MULTL (LOW COUNTS)
      STA B,I       STORE LOW COUNTS WRD#1 DATA BUFR
      INB           SET (B) = DATA WRD #2 ADDRESS
      LDA MULTH     SET (A)= MULTH (HIGH COUNTS)
      STA B,I       STORE HIGH COUNTS WRD#2 DATA BUFR
      INB           SET (B)= DATA WRD #3 ADDRESS
      LDA ERROR     GET ERROR COUNT
      STA B,I       STORE ERROR COUNT WRD #3 DATA BUFR
      JMP EXIT      RETURN.
*
*   TIME BASE GINERATOR DRIVER - INTERRUPT PROCESSING SECTION
*
*          - CONTINUATOR -
*
I.43  NOP           ENTRY POINT.
      CLF 0
      STA SAVA      SAVE CONTENTS OF (A) REGISTER
      STB SAVB                       (B)
      ERA,ALS
      SOC
      INA
      STA SAVEO                     (E&O)
*
*   THIS SECTION CAUSES ENTRY TO D.50'S TIME ENTRY POINT (T.50).
*
      LDB SELCD     GET TBG'S SELECT CODE IN B-REG.
      JSB T.50      ENTER D.50.
*
*   INTERRUPT COUNTER SECTION
*
I.4   LIB 0         GET STATUS INFO FROM TBG
      SZB           BIT #4 SET?
      ISZ ERROR     YES. (TIMING ERROR) INCREMENT CNTR
      ISZ WCNT      INCREMENT WORKING COUNTER; =0?
      JMP RSTOR     NO. RESTORE REGISTERS
      ISZ MULTL     YES. INCREMENT MULTIPLE CNTR;=0?
      JMP RESET     NO. RESET WORKING COUNTER
      ISZ MULTH     YES. INCREMENT HIGH COUNTER
      NOP
RESET LDA CNTR      GET WORKING COUNTER VALUE
      STA WCNT      RESET WORKING COUNTER
      CLA           SET (A)= 0
      STA FLAG      CLEAR DRIVER FLAG
*
*   REGISTER RESTORATION SECTION
*
RSTOR LDA SAVEO
      CLO
      SLA,ELA       RESTORE (E)
      STF 1                 (O)
      LDA SAVA              (A)
      LDB SAVB              (B)
I.5   STC 0,C       CLR TBG FOR NEXT INTERRUPT
      STF 0
      JMP I.43,I    RETURN TO INTERRUPTED SEQUENCE
*
*  CONSTANT AND STORAGE SECTION
*
SELCD BSS 1         TIME BASE GEN'S SELECT CODE.
EQTA  NOP           EQT WORD #1 ADDRESS
FUNA  NOP           REQUEST CODE ADDRESS
FLAG  NOP           DRIVER FLAG
RWFLG NOP           READ/WRITE FLAG
CNTR   NOP          WORKING COUNTER VALUE
WCNT  NOP           WORKING COUNTER
MULTL NOP           LOW COUNTS
MULTH NOP           HIGH COUNTS
ERROR NOP           ERROR COUNTER
SAVA  NOP           (A) REGISTER STORAGE
SAVB   NOP          (B) REGISTER STORAGE
SAVEO  NOP          (E&O) REGISTERS STORAGE
A     EQU 0
B     EQU 1
*
*
      END
                                                                                                                                                                 24380-18019 1402                                                                               