ASMB,A,L,C,B
      HED PAPER TAPE DUPLICATOR (CHERNACK DUPLICATOR IA)
*               4 JAN 1972
* 
*     **************
*     CONFIGURATION:
*     **************
* 
*     1. LOAD ADDRESS 3, PUSH RUN 
* 
*        THE COMPUTER WILL HALT WITH T-REGISTER = 102000B 
* 
*        SET THE SWITCH REGISTER TO THE PHOTOREADER (OR BUFFERED
*        TTY SELECT CODE), AND PUSH RUN.
* 
*     2. THE COMPUTER WILL HALT WITH THE T-REGISTER = 102001B 
* 
*        SET THE SWITCH REGISTER TO THE PUNCH (OR BUFFERED TTY) 
*        SELECT CODE, AND PUSH RUN
* 
* 
*        HLT 77B    CONFIGURATION COMPLETE
* 
* 
*     ******************************************
*     HOW TO ENTER A PAPER TAPE FOR DUPLICATION:
*     ******************************************
* 
*     1. LOAD ADDRESS 100B
*     2. TURN ON SWITCH 9 IF THE TAPE IS RELOCATABLE BINARY 
*     3. TURN ON SWITCH 10 IF THE TAPE IS ABSOLUTE BINARY 
* 
*     4. PUT TAPE IN PHOTOREADER AND PUSH RUN 
* 
*        HLT 11B   OUT OF MEMORY -- THIS TAPE IS TO BIG TO STORE
*        HLT 13B   CHECKSUM ERROR -- GO TO "1" ABOVE
*        HLT 77B   END OF TAPE DETECTED, GO TO STEP # 5 
* 
*     5.           IF THIS IS TRULY EOT, CLEAR SW REG AND PUSH RUN
* 
*                   IF THIS IS NOT EOT, MAKE SURE TAPE IS IN
*                   PHOTOREADER AND SET SWITCH REGISTER AS
*                   FOLLOWS:
* 
*                       1. SW 15 ON TO COMBINE TAPES WITH FOUR
*                          FEED HOLE SEPARATION (MAKES LIBRARY
*                          TAPES OR COMBINES BINARY TAPES). 
* 
*                       2. SW 15 OFF, ANY OTHER SWITCH ON, TO 
*                          CONTINUE READ WITHOUT COMPRESSING
*                          FEED HOLES.
* 
*                   GO TO STEP #4, OR RECOVER AT ADDRESS 2
* 
*     NOTE:  AFTER TAPE IS ENTERED, IT IS A GOOD PRACTICE TO
*            VERIFY THE MASTER TAPE AGAINST CORE, UNLESS
*            THE CHECKSUM VERIFICATION OPTION IS USED.
*     ***************** 
*     TO VERIFY A TAPE: 
*     ***************** 
* 
*     1. IF THE T-REGISTER IS 102002, GO TO STEP 3
*     2. LOAD ADDRESS 2, PUSH "RUN" 
*     3. CLEAR SWITCH REGISTER
*     4. PUT TAPE IN PHOTOREADER, PUSH RUN
* 
*        IF THE COMPUTER READS THE ENTIRE TAPE, THERE ARE NO ERRORS.
*        THE COMPUTER WILL HALT WHENEVER AN ERROR IS DETECTED.
* 
*        ABORT/RESTART AT ADDRESS 2 
* 
*     ****************
*     TO PUNCH A TAPE:
*     ****************
* 
*     1. IF THE T-REGISTER IS 102002, THEN GO TO STEP 3 
*     2. LOAD ADDRESS 2, PUSH "RUN" 
*     3. TURN ON SWITCH 0, PUSH "RUN" 
* 
*        HLT 66B    LOW TAPE IN PUNCH, PUSH RUN OR RESTART AT 2 
* 
*                   EVERY TIME 'RUN' IS PUSHED, 10' OF TAPE WILL
*                   UNTIL THE ENTIRE RECORD IS PUNCHED. 
* 
*     *************************** 
*     TO DUMP AN ABSOLUTE LOADER: 
*     *************************** 
* 
*     1. CONFIGURE THE SYSTEM TO USE THE TTY AS THE PUNCH 
*        OUTPUT DEVICE. 
*     2. PULL THE TAPE THRU THE TTY PUNCH TO GET 12 INCHES
*        OF LEADER WITHOUT FEEDHOLES. 
*     3. ENABLE THE LOADER, LOAD ADDRESS 5
*     4. CLEAR SWITCH REGISTER, PUSH "RUN"
* 
*        HLT 2B     IF A-B REGISTERS (OR 2114 SW REG) ARE 
*                   ZERO, THE TAPE IS OK. 
*        HLT 17B    LOADER NOT ENABLED, ENABLE AND PUSH RUN.
* 
*     TO VERIFY THE TAPE JUST GENERATED:
* 
*     1. PUT THE TAPE IN THE READER.
*     2. ENABLE THE LOADER. 
*     3. LOAD ADDRESS 5.
*     4. TURN ON SWITCH 0.
*     5. ENABLE THE LOADER AND PRESS "RUN". 
* 
*        HLT 2B     IF A-B REGISTERS (OR 2114 SW REG) ARE 
*                   ZERO, THE TAPE IS OK. 
*        HLT 17B    LOADER NOT ENABLED, ENABLE AND PUSH RUN 
* 
*     6. PROTECT LOADER.
* 
* 
*     ********************************
*     TO DUMP A CONFIGURED DUPLICATOR:
*     ********************************
* 
*     1. LOAD THE BINARY TAPE FOR THE DUPLICATOR. 
*        THE RAW BINARY TAPE MUST BE LOADED, SINCE THE
*        PUNCH ROUTINES ARE WITHIN THE DUPLICATOR BUFFER, 
*        AND ARE DESTROYED WHENEVER THE DUPLICATOR IS USED. 
* 
*     2. CONFIGURE AS IN "CONFIGURATION"
* 
*     3. LOAD ADDRESS 6, PUSH RUN.
* 
*        HLT 6B    PUNCH ROUTINES ARE GONE, GO TO STEP #1.
*        HLT 66B   LOW TAPE ON PUNCH, PUSH RUN OR RESTART 
*        HLT 77B   NORMAL COMPLETION
* 
*        THE BINARY TAPE THUS GENERATED IS IDENTICAL TO THE 
*        MASTER TAPE, EXCEPT THAT IT IS CONFIGURED. 
* 
* 
*     **************
*     PROGRAM HALTS:
*     **************
* 
*     HLT 0B        HALT WITHIN CONFIGURATION SECTION 
*     HLT 1B        HALT WITHIN CONFIGURATION SECTION 
*     HLT 2B        NORMAL HALT INDICATING TAPE IN CORE - READY TO GO 
*     HLT 6B        PUNCH ROUTINES ARE GONE DURING DUMP ATTEMPT 
*     HLT 11B       OUT OF CORE DURING PAPER TAPE ENTRY - ABORT 
*     HLT 13B       CHECKSUM/PARITY ERROR ON PAPER TAPE - RESTART 
*     HLT 17B       LOADER NOT ENABLED DURING BOOTSTRAP DUMP
*     HLT 30B       DEFECTIVE CORE LOCATION IN BUFFER AREA
*     HLT 66B       LOW TAPE ON PUNCH - PUSH RUN FOR 10' MORE 
*     HLT 77B       NORMAL COMPLETION FOR MOST OPERATIONS 
* 
* 
* 
      ORG 2 
PR    EQU 10B 
PUN   EQU 11B 
      JMP RESTR    RESTART PUNCH/VERIFY 
      JMP COFIG    CONFIGURATION ROUTINE
      HLT 4,C      POWER FAIL 
      JMP PLDR     PUNCH LAST 64-WDS CORE 
TAPR  JMP *+3      IF (WORKING BUFFER HAS BEEN USED)
      HLT 6 
      JMP *-1        THEN DISABLE PUNCH 
      LDA D2       DEF FWA CD-IA
      LDB DEND     DEF LWA CD-IA
      JMP PBUFF    CALL BINARY PUNCH ROUTINE
      HED CONSTANTS, ETC. 
ADD#  NOP 
ANYCT NOP 
BPNTR NOP 
C.CNT NOP 
CHAR  NOP 
CHK   NOP 
CHKSM NOP 
CHKSU BSS 1 
CPBD6 CPB D6
CPBX2 CPB X2WDC 
CTR   NOP 
D2    DEC 2 
D3    DEC 3 
D6    DEC 6 
DANYC DEF ANYCH 
DABST DEF ABST
DBUFF DEF FIND
DISPL NOP 
DM1   DEC -1
DM3   DEC -3
DM7   DEC -7
DM10  DEC -10 
DM90  DEC -90 
ECTR  NOP 
FINAL DEC 1 
LEFT  NOP 
LEN   ABS 17677B-FIND 
LWA   OCT 17677 
M77   OCT 77
M100  OCT 100 
M200  OCT 200 
M377  OCT 377 
M777  OCT 777 
M1100 OCT 1100
M2000 OCT 2000
M3000 OCT 3000
M11K  OCT 110000
M14K  OCT 140000
PTEMP NOP 
SFS0  SFS 0 
TEMPV NOP 
X2WDC NOP 
      HED PAPER TAPE INPUT ROUTINES 
* 
      ORG 77B 
      HLT 77B 
INPUT JSB FIND     CALCULATE LWA MEM (SET TO CLC 0,C) 
      LDB DANYC    ASSUME NO PARITY CHECK ON INPUT
      LIA 1 
      AND M3000    CHECK FOR SW 9 OR 10 
      SZA          NOT ABSOLUTE OR RELOCATABLE
      LDB DABST    ABSOLUTE/RELOCATABLE CHECKSUM
      STB CHK      DEFINE CHECK TYPE
      JSB CONFB    ASSUME RELOCATABLE 
      LIA 1        CHECK FOR BIT 10 
      AND M2000 
      CPA M2000 
      JSB CONFA    ABSOLUTE IF SW 10
* 
      LDA DBUFF 
      STA BPNTR    BPNTR _ FWA BUFFER 
      CLA 
      STA LEFT
      LDA LEN      MAXIMUM BUFFER LENGTH
      STA DISPL    B-REGISTER DISPLAY 
      JSB CINIT    INITIALIZE CHECKSUM/EOT ROUTINES 
INGO  JSB GETCH    GET A CHARACTER
      SZA,RSS      IF (LEADER)
      JMP *-2        THEN IGNORE
      RSS          FIRST CHARACTER - GO TO PUTIT
      JSB GETCH    CHARACTERS 2-N, GET CHARACTER
PUTIT JSB STOCH    STORE CHARACTER
      JSB CHK,I    CHECKSUM 
      JMP *-3      (P+1) OK 
*                                  (P+2) EOF MAYBE
      LDA DM10     COUNT 10 FEED HOLES TO EOF 
      STA ECTR     END COUNTER
      JSB GETCH    GET A CHARACTER
      SZA          FEED HOLE? 
      JMP PUTIT    NO, CONTINUE 
      JSB STOCH    STOW IT
      ISZ ECTR     10 FEED HOLES YET? 
      JMP *-5      NO 
      JSB CINIT    RE-INITIALIZE CHECKSUM/EOT ROUTINES
      LDB DISPL    WORDS LEFT IN BUFFER 
      CMB,INB 
      ADB LEN      MAX BUFFER LENGTH
      STB FINAL    ACTUAL BUFFER LENGTH 
      CLA 
      CLB 
      OTB 1        FOR HP-2100 DISPLAY
      HLT 77B      SUSPECTED END OF TAPE
      LIB 1        CHECK SWITCH REGISTER
      SZB,RSS 
      JMP RESTR    DONE IF SWITCHES ALL ZERO
      SSB,RSS 
      JMP PUTIT-1  CONTINUE IF SWITCH 15 OFF, OTHERS ON 
      SKP 
BAKUP LDA BPNTR    CURRENT BUFFER POINTER (LIB OPTION)
      ADA DM3      SHORTENED BUFFER 
      STA BPNTR 
      LDB DISPL    CURRENT BUFFER AVAILABLE 
      ADB D3       RESTORE 3 WORDS
      STB DISPL 
      JMP INGO     SCAN FOR VALID DATA
* 
* 
GETCH NOP 
      LDB DISPL    RESTORE B-REGISTER DISPLAY 
      LDA M14K     FOR TTY AS INPUT DEVICE
PR1   OTA PR       OUTPUT 140000B 
PR2   STC PR,C
PR3   SFS PR
      JMP *-1 
PR4   LIA PR
      JMP GETCH,I 
* 
* 
STOCH NOP 
      LDB LEFT     IF (LEFT = 0)
      SZB 
      JMP SAVE       THEN STORE INTO RIGHT BYTE 
      ALF,ALF      LEFT POSITION
      STA BPNTR,I  STORE LEFT BYTE, RIGHT _ 0 
      ISZ LEFT     LEFT _ 1 
      ALF,ALF      RESTORE BYTE 
      JMP STOCH,I  RETURN 
SAVE  IOR BPNTR,I  IOR RIGHT BYTE INTO WORD 
      STA BPNTR,I  RESTORE IN BUFFER
      AND M377     RESTORE BYTE 
      CLB 
      STB LEFT     LEFT _ 0 
      JSB UPIT     UP BUFFER POINTER
      JMP STOCH,I  (P+1) RETURN 
      LDA M100     (P+2) OUT OF CORE
      OTA 1        SET S.A. FOR 2114
      HLT 11B      OUT OF CORE
      JMP *-1      IRRECOVERABLE
* 
* 
UPIT  NOP 
      ISZ BPNTR    UP BUFFER POINTER
      LDB DISPL 
      ADB DM1 
      STB DISPL    UP COUNT-DOWN DISPLAY
      OTB 1 
      SZB,RSS      IF (OUT OF BUFFER) 
      ISZ UPIT       THEN (P+2) RETURN
      JMP UPIT,I
      HED CHARACTER VERIFICATION/CHECKSUM ROUTINES
* 
ANYCH NOP 
      SZA,RSS 
      JMP *+3 
      JSB CINIT    RE-INITIALIZE ANYCH
      JMP ANYCH,I 
      ISZ ANYCT    COUNT FEED-HOLES 
      JMP ANYCH,I  (P+1) RETURN 
      ISZ ANYCH    EOT
      JMP ANYCH,I  EOT RETURN (P+2) 
* 
* 
CINIT NOP 
      CLB 
      STB C.CNT    C.CNT _ 0 (FOR ABST) 
      LDB DM10
      STB ANYCT    ANYCT _ -10 (FOR ANYCH)
      LDB DISPL 
      JMP CINIT,I 
* 
* 
CONFA NOP          SET CHECKSUM TO ABSOLUTE TEST
      LDB CPBX2 
      STB INST1    INST1 _ CPB X2WDC
      LDB D3
      STB ADD#     ADD# _ 3 
      JMP CONFA,I 
* 
* 
CONFB NOP          SET CHECKSUM TO RELOCATABLE TEST 
      LDB CPBD6 
      STB INST1    INST1 _ CPB D6 
      CLB 
      STB ADD#     ADD# _ 0 
      JMP CONFB,I 
* 
      HED ABSOLUTE/RELOCATABLE CHECKSUM VERIFICATION
* 
ABST  NOP         ENTRY/EXIT
      LDB C.CNT   GET CHARACTER COUNT 
      SZB         IS CHAR COUNT = 0 
      JMP NEINT   NO, CONTINUE
      SZA         YES, IS IT RECORD LENGTH WORD?
      JMP WORDC   YES, JUMP TO WORD COUNT SAVE SEC. 
* 
INIT  ISZ ABST    PREPARE E.O.R. RETURN (P+2) 
      CLA           (END OF RECORD) 
      STA C.CNT   INITALIZE CHAR COUNT
      JMP ABST,I   RETURN 
* 
WORDC ISZ C.CNT   MAKE CHAR COUNT = 1 
      ADA ADD#    ADJUST FOR ABS OR RELOCATABLE 
      RAL         DOUBLE WORD COUNT 
      STA X2WDC   STORE IT AS TRUE CHAR COUNT 
      STB CHKSU   CLEAR CHECKSUM WORD FOR NEW RECORD
SAVA  ALF,ALF      ROTATE CHARACTER 
      STA CHAR     SAVE IT FOR NEXT PASS
      JMP ABST,I   RETURN 
* 
NEINT INB         INCREMENT CHAR COUNT
      STB C.CNT   SAVE IT 
      CPB D2      IS IT SECOND CHARACTOR? 
      JMP ABST,I   YES, FORGET IT 
      SLB         NO, IS IT COMPLETE WORD?
      JMP SAVA    NO, IT IS FIRST HALF
      IOR CHAR    YES, MAKE FULL WORD 
INST1 CPB D6      (D6 OR X2WDC) IS IT A CHKSUM WORD?
      JMP CHKST   YES 
      ADA CHKSU   NO, ACCUMULATE SUM
      STA CHKSU   SAVE IT!! 
      RSS          END OF RECORD
* 
CHKST STA CHKSM   SAVE CHKSUM FROM TAPE 
      CPB X2WDC    IS IT END OF RECORD? 
      RSS          YES, CHECK THAT IT IS CORRECT
      JMP ABST,I   NO, NORMAL RETURN
* 
      LDA CHKSM    GET CHKSUM OF TAPE 
      CPA CHKSU   DOES IT COMPARE?
      JMP INIT    YES, END OF RECORD RETURN 
      LDA M100
      OTA 1 
      HLT 13B      NO, ERROR
      JMP *-1     NOT RECOVERABLE 
      HED PUNCH/VERIFY SECTION
RESTR CLA          RESTART/FINISH 
      CLB 
      OTB 1 
      HLT 2        READY TO PUNCH/VERIFY
CLCI  CLC 0,C      TURN OFF EVERYTHING
      LIA 1        CHECK SWITCH REGISTER
      LDB DBUFF    BUFFER ADDRESS 
      STB BPNTR    BUFFER POINTER 
      LDB FINAL    ACTUAL BUFFER LENGTH 
      STB DISPL    COUNT-DOWN DISPLAY 
      SLA,RSS 
      JMP VERIF    VERIFY IT
* 
PUNIT JSB LEADR    GENERATE LEADER
PUNT  LDA BPNTR,I 
      JSB PWORD    PUNCH WORD 
      JSB UPIT     UP-THINGS SUBROUTINE 
      JMP PUNT     (P+1) RETURN, CONTINUE 
PDONE CLA,INA      (P+2) RETURN, DONE 
      STA DISPL    DISABLE LOW TAPE HALT (TRAILER)
      JSB LEADR    GENERATE TRAILER 
      JMP RESTR    RESTART
* 
VERIF JSB GETCH 
      SZA,RSS      IF (LEADER)
      JMP *-2        THEN GET MORE
      RSS          SKIP GETCH FOR FIRST CHAR
VAGAN JSB GETCH    GET CHARS 3,5,7,...N-1 
      ALF,ALF 
      STA TEMPV    SAVE LEFT BYTE 
      JSB GETCH    GET CHARS 2,4,6,... N
      IOR TEMPV    MAKE WORD
      CPA BPNTR,I  COMPARE WITH BUFFER
      JMP VOK      OK 
      CCA          FAIL, A_177777 
      CCB          B_177777 
      JMP RESTR+2  DO NOT CLEAR REGISTERS 
* 
VOK   JSB UPIT     UPIT SUBROUTINE
      JMP VAGAN    (P+1) RETURN, CONTINUE 
      JMP RESTR    (P+2) RETURN, DONE 
      HED PUNCH SUBROUTINES 
* 
LEADR NOP 
      LDB DM90     18" LEADER/TRAILER 
      CLA 
      JSB PWORD 
      INB,SZB 
      JMP *-2 
      JMP LEADR,I 
* 
* 
PWORD NOP 
      STA PTEMP 
      LDA DISPL 
      AND M777     EVERY 2000B CHARACTERS 
      SZA 
      JMP *+6 
PU1   LIA PUN 
      CPA M377     BUFFERED TTY 
      JMP *+3 
      SZA 
      HLT 66B      LOW TAPE 
      LDA M11K     PUNCH COMMAND, 110000
PU2   OTA PUN      IF TTY IS PUNCH, SET PUNCH MODE
      LDA PTEMP 
      ALF,ALF 
      JSB PUNCH    LEFT BYTE
      LDA PTEMP 
      JSB PUNCH    RIGHT BYTE 
      LDA PTEMP    RESTORE WORD 
      JMP PWORD,I 
* 
PUNCH NOP 
      AND M377
PU3   OTA PUN 
PU4   STC PUN,C 
PU5   SFS PUN 
      JMP *-1 
      JMP PUNCH,I 
* 
*     SUBROUTINE TO DUMP BOOTSTRAP LOADER 
* 
      HLT 17B      LOADER NOT ENABLED 
PLDR  JSB FIND     SET TO CLC 0,C BY FIND 
      CLA,INA 
      ADA LWA 
      STA BPNTR 
      LDB M100     BUFFER LENGTH
      STB DISPL 
      LDA 0,I 
      SZA,RSS 
      JMP PLDR-1   LOADER NOT ENABLED 
      LIA 1 
      SLA 
      JMP VERIF    SW 0 ON, VERIFY BBL
      JMP PUNT     SW 0 OFF, PUNCH BBL
      HED CONFIGURATION ROUTINE 
* 
COFIG CLB 
      LDA PR1      PRESENT PHOTOREADER SELECT CODE
      AND M77      ISOLATE SELECT CODE
      OTA 1        PUT IN SWITCH REGISTER 
      HLT 0        GET PR SELECT CODE FROM SWITCH REG 
      LIA 1        PICK UP NEW SELECT CODE
      AND M77      BE SAFE
      STA TEMPV 
      ADA SFS0
      STA PR3      SFS PR 
      ADA M200
      STA PR4      LIA PR 
      ADA M100
      STA PR1      OTA PR 
      ADA M1100 
      STA PR2      STC PR,C 
* 
      LDA PU1      DISPLAY PUNCH SC 
      AND M77 
      OTA 1 
      HLT 1 
      LIA 1        PICK UP (NEW) PUNCH SC 
      AND M77      BE SAFE
      STA 1        DISPLAY FOR NEXT HALT
      ADA SFS0
      STA PU5      SFS PUN
      ADA M200
      STA PU1      LIA PUN
      ADA M100
      STA PU2      OTA PUN
      STA PU3 
      ADA M1100 
      STA PU4      STC PUN,C
* 
      LDA TEMPV 
      JMP 77B 
      HED CONSTANTS 
      HED SUBROUTINE TO CALCULATE LWA MEM - SUBROUTINE FIND 
*     THIS ROUTINE CALCULATES THE ADDRESSES OF BBL/BBDL-1, AND
*     STORES IT IN MEMORY LOCATION "LWA". IT THEN OVERLAYS
*     THE "JSB FIND" INSTRUCTION WITH A "CLC 0,C".
* 
*     THIS SUBROUTINE RESIDES IN THE WORKING BUFFER, AND IS 
*     WRITTEN OVER WHEN THE FIRST TAPE IS DUPLICATED. 
* 
*     VARIABLE "LEN" IS SET TO THE LENGTH OF THE AVAILABLE CORE 
*     SEGMENT, AND A QUICK MEMORY TEST DIAGNOSTIC IS RUN ON THE 
*     BUFFER. 
* 
FIND  NOP 
      LDB APPR
      STB APPR,I
RETRY LDA DM10     ANYTHING WILL DO HERE
      ADB M2000 
      STA 1,I 
      LDA 1,I      2100 WILL RETURN 0 
      SZA,RSS 
      JMP *+5 
      LDA APPR,I
      CPA 1,I 
      CLA,RSS 
      JMP RETRY 
      STA TAPR     DISABLE BINARY DUMP
      ADB MIMN
      STB LWA 
* 
      LDB DBUFF 
      CMB,INB 
      ADB LWA 
      STB LEN      ACTUAL AVAILABLE BUFFER LENGTH 
* 
      LDA DBUFF    BASE ADDRESS OF BUFFER 
      CMB,INB      -BUFFER LENGTH 
      ADA OFSET    DON'T WIPE OUT SUBROUTINE FIND YET...
      ADB OFSET 
CLOOK STA 0,I      STORE BUFFER ADDRESS INTO BUFFER 
      CPA 0,I      CHECK TO SEE IF IT'S THERE 
      INA,RSS      NEXT BUFFER ADDRESS
      HLT 30B      BAD MEMORY LOCATION IN BUFFER
      INB,SZB      DONE YET?
      JMP CLOOK    CONTINUE 
* 
      LDB FIND
      ADB DM1 
      LDA CLCI     IF (FIND HAS BEEN CALLED)
      STA PLDR       SET PLDR TO CLC 0,C
      STA 1,I 
      JMP 1,I 
* 
APPR  DEF TAPR
MIMN  ABS -101B-TAPR
OFSET ABS *-FIND+1
      HED BINARY DUMP ROUTINE 
PBUFF STA BUFAD   SAVE BUFFER ADDRESS 
      INB 
      STB BLAST   SAVE BUFFER LAST ADDRESS
* 
      CLB 
      STB DISPL   ENABLE LOW TAPE CHECK 
      JSB LEADR   PUNCH LEADER
      ISZ DISPL   DISABLE LOW TAPE CHECK
* 
NEWRC LDA BUFAD   NO, GET CURRENT BUFFER ADDRESS
      LDB BLAST   GET BUFFER LAST ADDRESS 
      CMA,INA     MAKE S.A. NEGATIVE
      ADA 1       CALCULATE CURRENT BUFFER LENGTH 
      SZA,RSS     IS IT ZERO
      JMP EDUMP   DONE, PUNCH TRAILER 
      LDB M77     YES, GET MAX RECORD LENGTH
      CMB         MAKE NEGATIVE & -1
      ADB 0       ADD CURRENT RECORD LENGTH 
      SSB,RSS     IS CURRENT RECORD TOO LONG? 
      LDA M77     YES, GET MAX RECORD LENGTH
* 
*                 PUNCH RECORD
* 
      STA 1       SAVE RECORD LENGTH IN B-REG 
      JSB PUNCH   PUNCH BUFFER LENGTH CHARACTER 
      CLA 
      JSB PUNCH   PUNCH SECOND CHAR BLANK 
      LDA BUFAD   LOAD A-REG WITH BUFFER ADDRESS
      STA CHKSM   INITIALIZE CHECKSUM WORD
      JSB PWORD   PUNCH ADDRESS WORD
      CMB,INB     MAKE BUFFER LENGTH NEGATIVE 
* 
AGAIN LDA BUFAD,I GET BUFFER CONTENTS 
      JSB PWORD   PUNCH IT
      ADA CHKSM   ADD IT TO CHECKSUM WORD 
      STA CHKSM   SAVE IT FOR NEXT PASS 
      ISZ BUFAD   INCREMENT BUFFER ADDRESS WORD 
      INB,SZB     HAS RECORD BEEN PUNCHED?
      JMP AGAIN   NO, TRY AGAIN 
      JSB PWORD   YES, PUNCH CHECKSUM WORD
      JMP NEWRC   JUMP TO NEW RECORD
* 
EDUMP JSB LEADR   PUNCH TRAILER 
      JMP 77B 
* 
* 
*   CONSTANTS 
* 
BUFAD NOP 
BLAST NOP 
DEND  DEF * 
      END 
                                                                                                                                          