ASMB,A,L,T,C
      HED   ***  SIO VARIAN STATOS 4215 LINE PRINTER DRIVER  ***
*
********************* SYSTEM INPUT / OUTPUT DRIVER ******************
*
*  THIS SIO DRIVER IS FOR THE VARIAN STATOS 42 SERIES
*  PRINTER/PLOTTERS.
*
*  THIS DRIVER PROVIDES FOR ALL LIST OUTPUT FACILITES
*  REQUIRED BY THE ASSEMBLER, SYMBOLIC EDITOR, ALGOL
*  COMPLIER AND THE FORTRAN COMPLIER.
*
*
*  CALLING SEQUENCE:
*
*  A-REGISTER = LENGTH OF DATA BUFFER (CHARACTERS)
*             = ZERO FOR A SKIP A LINE FUNCTION
*             = NEGATIVE FOR A FORM FEED FUNCTION
*
*  B-REGISTER = STARTING ADDRESS OF DATA BUFFER
*                (ONLY USED WHEN A-REGISTER IS POSITIVE)
*
*  (P)        JSB 102B,I     CALL TO SIO DRIVER
*  (P+1)      -RETURN-
*
*
*    THIS SIO DRIVER MUST BE LOADED AFTER THE
*    SIO TELEPRINTER DRIVER (HP-24125).
*
*
********** DRIVER INITIALIZATION SECTION **********
*
*  THE PURPOSE OF THIS SECTION IS TO SET THE I/O
*  INSTRUCTIONS TO REFERANCE A DESIGNATED I/O
*  ADDRESS FOR THE LINE PRINTER.  EXECUTION BEGINS
*  AT LOCATION 2 :   (2) = JMP 160000B
*  THE SWITCH REGISTER IS SET TO CONTAIN THE ADDRESS
*  OF THE PRINTER (SELECT CODE).
*
*  THIS SECTION IS RELEASED AFTER THE
*  INITIALIZATION IS COMPLETED.
*
*
      ORG 2B
      JMP 03B,I           GOTO INITIALIZATION
      DEF ISECT
*
      SKP
      ORG 16000B
ISECT EQU *
      LIA 01B       GET AND
      AND .77       ISOLATE I/O ADDRESS AND
      STA BREG      SAVE THE SELECT CODE
*
*
      LDA .CLC.
      IOR BREG      CLC LPTR
      STA .CLC
*
*
      LDA .OTA.
      IOR BREG      OTA LPTR
      STA .OTA
*
*
      LDA .LIA.
      IOR BREG       LIA LPTR
      STA .LIA
*
*
      LDA .SFS.
      IOR BREG       SFS LPTR
      STA .SFS
*
*
      LDA ENTRY      GET ENTRY POINT OF SIO DRIVER
      STA 102B       PLACE ENTRY POINT IN EQT
*
*
      HLT 77B        WE ARE DONE..........
      JMP *-1        CAN NOT CONTINUE, GO TO HALT
*
*
.77   OCT 77     I/O ADDRESS MASK
BREG  EQU 1      B-REGISTER
ENTRY DEF LPOUT  POINTER TO SIO DRIVER
.CLC. CLC 00B,C  INSTRUCTION DATA
.LIA. LIA 00B,C
.OTA. OTA 00B,C
.SFS. SFS 00B    END OF INSTURCTION DATA
      SKP
**********   SIO DRIVER SECTION   *********
*
*
      ORG 17567B
LPOUT EQU *          ** OUTPUT LIST ENTRY **
      NOP            POINTER TO CALLING ROUTINE
       STA TEMP      SAVE CHARACTER COUNT
.LIA  EQU *         LABEL FOR SELECT CODE ADDITION
      LIA 00B,C     GETSTATUS FROM PRINTER
      SLA           BOTTOM OF FORM?
      JSB BOF       FORM FEED PLEASE...
      LDA TEMP      RESTORE CHARACTER COUNT
      SZA,RSS        LINE FEED FUNCTION?
      JMP LFEED      YES, OUTPUT L.F.
      SSA            FORM FEED FUNCTION?
      JMP FFEED      YES, OUTPUT F.F.
      STB ADDR       SAVE BUFFER POINTER
      CLB            SET FLAG TO ZERO
       SLA             FOR EVEN NUMBER OF CHAR.
      INB              OR SET TO ONE 
      STB FLAG          FOR ODD NUMBER OF CHAR.
      ARS            GENERATE WORD COUNT
      CMA,INA         FROM THE BUFFER SIZE
      STA CNT          AND SET COUNTER
      LDB ADDR       SET UP ADDRESSING OF BUFFER
.CLC  EQU *          LABEL FOR SELECT CODE ADDITION
      CLC 00B,C      SET PRINTER TO DATA MODE
*
GWORD EQU *          OUTPUT CHARACTERS
      LDA BREG,I     GET TWO CHARACTERS FROM BUFFER
      JSB OUT        PRINT THE CHARACTERS
      INB            FIND NEXT CHARACTERS TO BE PRINTED
      ISZ CNT        DONE WITH CHARACTERS IN BUFFER?
      JMP GWORD      NO, CONTINUE
      LDA FLAG       IF ODD NUMBER OF CHARACTERS
      SZA,RSS         ONE MORE CHARACTER LEFT?
      JMP LFEED      NO MORE LEFT
      LDA BREG,I     GET LAST CHARACTER
      AND MASK       ISOLATE CHARACTER
      JSB OUT        PRINT CHARACTER
      SKP
LFEED EQU *          LINE FEED ROUTINE
      LDA LF         GET LINE FEED CODE
      JSB OUT        PRINT IT
      JMP LPOUT,I    RETURN TO CALLING ROUTINE
*
*
*
FFEED EQU *          FORM FEED ROUTINE
      LDA FF         GET FORM FEED CODE
      JSB OUT        PRINT IT
      JMP LPOUT,I    RETURN TO CALLING ROUTINE
*
*
OUT   EQU *          OUTPUT ROUTINE
      NOP            POINTER TO CALLING ROUTINE
.OTA  EQU *          LABEL FOR SELECT CODE ADDITION
      OTA 00B,C      OUTPUT DATA
.SFS  EQU *          LABEL FOR SELECT CODE ADDITION
      SFS 00B        IS PRINT DONE?
      JMP *-1        NO, WAIT
      JMP OUT,I      YES, RETURN TO CALLING ROUTINE
*
*
BOF   EQU *          BOTTOM OF FORM ROUTINE
      NOP            POINTER TO CALLING ROUTINE
      LDA FF         ASCII CODE FOR FORM FEED
      JSB OUT
      JMP BOF,I       RETURN TO CALLING ROUTINE
*
*
TEMP  EQU *           STORAGE (TEMPORAY)
ADDR  NOP            BUFFER POINTER
FLAG  NOP            EVEN/ODD FLAG
CNT   NOP            WORD COUNTER
LF    OCT 12         ASCII CODE FOR LINE FEED
FF    OCT 14         ASCII CODE FOR FORM FEED
MASK  OCT 177400     UPPER CHARACTER MASK
*
*                 PROGRAM BY: JOSE J. PICAZO
*                             JAN. 12, 1976
      END
