
ASMB,R,B,L,X,C
      HED  BINARY SYN TELECOMMUNICATIONS DRIVER  12 MAY 1971
* 
*  *****************************************************
*  *                                                   *
*  *  BASIC CONTROL SYSTEM TELECOMMUNICATIONS DRIVER.  *
*  *                                                   *
*  *****************************************************
* 
*     AUTHORS:
*     RICH NIELSEN - BAEDP, PALO ALTO, CALIF.
* 
*       DATE WRITTEN-24 JUNE 1970
* 
*     *** DATE OF THIS VERSION:  12NOV73
*         (HANDLES BOTH SYNC & ASYN MODEMS)
* 
* 
*     (NOTE!!  DRIVER ASSUMES BUFFERS PASSED FOR SENDING
*     BEGIN ON EVEN BOUNDRIES, I.E. 1ST 2 CHAR = CONTROL CHARS
*     AS "DLE,STX", OR "SYN,STX", AND DATA BEGINS AS
*     THE 3RD CHAR.  DATA RECEIVED AND PASSED TO USER
*     IS POSITIONED IN THE SAVE MANNER.)
* 
* DRIVER FEATURES:
* 
* 1. EMPLOYS IBM'S BINARY SYNCHRONOUS LINE CONTROL.  REFER TO THE
*    IBM MANUAL TITLED "GENERAL INFORMATION - BINARY SYCHNRONOUS
*    COMMUNICATIONS" (FORM A27-3004).
* 
* 2. BASIC ERROR DETECTION AND CORRECTION IS PERFORMED BY THE DRIVER.
* 
* 3. CAN OPERATE EITHER THE ASYNCHRONOUS OR SYNCHRONOUS I/O BOARD
*    (AT PREPARE CONTROL SYSTEM TIME THE USER MUST SPECIFY THAT ALL
*    LOGICAL UNITS USING SYNCHRONOUS I/O BOARDS REQUIRE THE CONTROL-
*    LER "U1", AND THAT ALL ASYNCHRONOUS LOGICAL UNITS DO NOT RE-
*    QUIRE A CONTROLLER.).
* 
* 4. CONTROL CHARACTERS MAY BE EITHER ASCII, EBCDIC, OR TRANSCODE.
* 
* 
* FUNCTIONS AVAILABLE:
* 
*  FUNCT  SUBFUNCT  NAME    DESCRIPTION                REJECT*
*  -----  --------  ----    -------------------------  -------------
* 
*     00        00  CLEAR   CLEARS PRESENT OPERATION   "OFF LINE"
*                           IN PROGRESS.  TERMINAL IS
*                           TAKEN "OFF LINE".
* 
* 
*     01       07   STATUS  READS TRML'S STATUS INTO
*                           USER'S BUFFER.
* 
*     01  OPTIONAL  READ    READS A BLOCK OF DATA      1. "OFF LINE"
*                           FROM REMOTE.  PERFORMS     2. SEND STATE
*                           ERROR DETECTION & CORREC-  3. DRIVER
*                           TION ON BLOCK (UNLESS IN      BUSY
*                           "CONVERSATIONAL" MODE).
* 
*     02  OPTIONAL  WRITE   SENDS A BLOCK OF DATA TO   1. "OFF LINE"
*                           THE REMOTE.  PERFORMS      2. RECEIVE
*                           ERROR CORRECTION (UNLESS      STATE
*                           IN "CONVERSATIONAL" MDE)   3. DRIVER BSY
* 
* 
*     03       01   SHUT    TURNS OFF I/O BOARD,       NEVER
*                   DOWN    FREES DRIVER TO PROCESS    REJECTED
*                           REQUESTS ON OTHER LOGI-
*                           CAL UNITS.
* 
*     03       02   RECEIVE CAUSES LOGICAL UNIT TO     1. "OFF LINE"
*                   TO      BECOME A SENDER AND        2. SEND STATE
*                   SEND    REMOTE TO BECOME A RE-     3. DRVR BUSY
*                           CEIVER.
* 
*     03       03   HAND-   HANDSHAKE ROUTINE FOR      1. DRVR BUSY
*                   SHAKE,  CALLING TERMINAL.  TRML
*                   EBCDIC  BECOMES A SENDER.
* 
*     03       04   HAND-   HANDSHAKE ROUTINE FOR      1. DRVR BUSY
*                   SHAKE,  CALLING TRML.  TRML BE-
*                   ASCII   COMES A SENDER.
* 
*     03       05   HAND-   HANDSHAKE ROUTINE FOR      1. DRVR BUSY
*                   SHAKE,  CALLING TRML.  TRML BE-
*                   6 BIT   COMES A SENDER.
*                   TRANSCODE.
* 
*     03       06   AUTO    HANDSHAKE ROUTINE FOR      1. DRVR BUSY
*                   ANSWER, CALLED TRML.  TRML BE-
*                   EBCDIC  COMES A RECEIVER.
* 
*     03       07   AUTO    HANDSHAKE ROUTINE FOR      1. DRVR BUSY
*                   ANSWER, CALLED TRML.  TRML BE-
*                   ASCII   COMES A RECEIVER.
* 
*     03       10   AUTO    HANDSHAKE ROUTINE FOR      1. DRVR BUSY
*                   ANSWER, CALLED TRML.  TRML BE-
*                   6 BIT   COMES A RECEIVER.
*                   TRANSCODE.
* 
*     03       11   END OF  SEND END OF TAPE CODE.     1. "OFF LINE"
*                   FILE                               2. DRVR BUSY
*                                                      3. RECEIVE
*                                                         STATE
* 
* * ALL REQUESTS FOR A LOGICAL UNIT ARE REJECTED IF ANOTHER TRML IS
*   "ON LINE".
* 
* NOTE: FOR DETAILED DESCRIPTION OF FUNCTIONS, REFER
*       TO THE PARTICULAR FUNCTION'S PROCESSOR.
* 
* 
* EQUIPMENT TABLE STATUS:
* 
*BIT           MEANING
*     RESET              SET
*---  -----------------  ----------------
* 
*  0  NO CARRIER SENSED  CARRIER SENSED
*     ON LINE.           (FROM EITHER
*                         LOCAL OR REMOTE)
* 
*  1                     BUFFER OVERFLOW
* 
*  2                     REMOTE REQUEST
*                        TO SEND.
* 
*  3  LOCAL DATA SET     LOCAL DATA SET
*     NOT READY.         READY.
* 
*  4  RECEIVE STATE      SEND STATE
* 
*  5
* 
*  6  TRML OFF LINE      TRML ON LINE
* 
*  7  LAST RECORD SENT   LAST RECORD SENT
*     OR RECEIVED WAS    OR RECEIVED WAS AN
*     NOT AN END OF      END OF FILE.
*     FILE.
* 
* 
      NAM D.50C    "C" VERSION OF PROGRAM
      SUP
* 
      ENT D.50,I.50,T.50
      EXT .BUFR
* 
A     EQU 0
B     EQU 1
      HED INITIATOR SECTION
* THIS SECTION DETERMINES IF A PROCESSOR SHOULD BE CALLED.
* 
* CALLED PROCESSOR MAY USE THE FOLLOWING WORDS:
*        TEMP5      EQT ENTRY ADDRESS.
*        TEMP6      USER WORD 2 ADDRESS.
*        FUNCT      FUNCTION AND SUBFUNCTION CODE.
* THE VALUE OF THESE WORDS IS NOT SAVED BY THE INITIATOR.
* 
*           *** SAVE ENTRY PARAMETERS. ***
* 
D.50  NOP
      STA TEMP5     SAVE EQT ENTRY ADDRESS.
      STB TEMP6     SAVE REQUEST (WORD 2) ADDRESS.
* 
      LDA B,I       ISOLATE
      ALF,ALF       AND SAVE
      RAL,RAL       FUNCTION
      AND =B1777    AND SUBFUNCTION
      STA FUNCT     FIELDS.
* 
*           *** CHECK FOR CLEAR REQUEST. ***
* 
      CPA =B000     CLEAR REQUEST?
      JMP CLEAR     YES, GO PROCESS IT.
* 
*           *** IF DRIVER IS "ON LINE" WITH A TERMINAL THEN THE
*               LOGICAL UNIT OF THE REQUEST MUST BE THE SAME AS
*               THE LOGICAL UNIT FOR THE TERMINAL THAT IS ON
*               LINE. ***
* 
      LDB LOGUT     IS DRIVER
      SZB,RSS       "ON LINE"?
      JMP TCLR      NO, CHECK IF REQUEST IS O.K..
* 
      LDA TEMP6,I   GET REQUEST'S
      AND =B77      LOGICAL UNIT.
      CPA B         REQ. L.U. = ON LINE L.U.?
      JMP TCLR      YES, CHECK IF REQUEST IS LEGAL.
      LDB =B100000  NO, PUT "DRIVER BUSY" REJ CODE
      JMP REJEC     IN B-REG, AND REJECT THE REQ.
* 
*           *** TEST FOR STATUS READ REQUEST. ***
* 
* 
TCLR  LDA FUNCT
      CPA =B107
      JMP STATS     YES, GO PROCESS IT.
* 
*           *** IF DRIVER IS BUSY, THEN REJECT REQUEST. ***
* 
      LDB =B100000  PRIME B FOR "DRVR BUSY" REJ CODE
      LDA BUSY      IS
      SZA,RSS       DRIVER BUSY?
      JMP CHCKA     NO, VALIDATE REQUEST
REJEC CLA,INA       PUT "REJECT CODE" IN A-REG.
      JMP D.50,I    RETURN TO .IOC..
* 
*           *** IF IN CRITICAL PORTION OF EITHER THE "WABT" OR THE
*               "TTD" GENERATOR, THEN REJECT WITH B-REG SET TO 3 ***
* 
CHCKA JSB SGEN      GET GENERATOR STATUS.
      LDB =B3       PUT "TEMPORARILY BUSY" CODE IN B
      SZA           IN CRITICAL PART OF GENERATOR?
      JMP REJEC     YES, REJECT THE REQUEST.
* 
*           *** IF REQUEST IS INVALID THEN REJECT REQUEST. ***
* 
VCHCK LDA FUNCT     GET FUNCTION/SUBFUNCTION CODE.
      CLB           PUT "INVALID REQ CODE" CODE IN B
      ADA =B-312    IS
      SSA,RSS       CODE > 311?
      JMP REJEC     YES, REJECT REQUEST.
      ADA =B212     IS
      SSA           CODE < 100?
      JMP REJEC     YES, REJECT.
* 
*           *** SAVE EQT TABLE, REQ ADRRESSES. ***
* 
      LDB TEMP5     SAVE
      STB EQT1A     WORD #1 ADDRESS
      INB           AND WORD #2 ADDRESS
      STB EQT2A     OF EQUIPTMENT TABLE.
      LDB TEMP6     SAVE WORD #2 ADDRESS
      STB USER2     OF USER REQUEST.
* 
*           *** CONFIGURE I/O INSTRUCTIONS. ***
* 
      LDA LINE      IF
      SZA           ALREADY "ON LINE"
      JMP *+2       THEN DO NOT CONFIGURE.
      JSB .IOI.     CONFIGURE I/O BOARD.
* 
*           *** FIND PROPER PROCESSOR. ***
* 
      LDA FUNCT     GET FUNCTION
      AND =B1700    CODE IN A-REG.
      CPA =B100     READ REQUEST?
      JMP READ      YES, CALL READ PROCESSOR.
      CPA =B200     WRITE REQUEST
      JMP SEND      YES, CALL WRITE PROCESSOR.
      LDA FUNCT     GET SUBFUNCTION CODE
      AND =B77      IN A-REG.
      ADA CNTR      FORM PROPER PROCESSOR ADRS
      JMP A,I       CALL THE PROCESSOR.
      SPC 3
* 
*           *** DATA ***
* 
BCONT BSS 1         IF ODD EXPECT (OR SEND) ACK1.
BUSY  OCT 0         IF DRIVER BUSY, THEN SET TO 1.
LINE  OCT 0         IF = 1, THEN TRML IS ON LINE.
LOGUT OCT 0         LOGICAL UNIT FOR ON-LINE TRML.
CNTR  DEF CNTR,I    PROCESSOR LOOK UP TABLE.
      DEF OFF
      DEF RC2SD
      DEF HNDSK
      DEF HNDSK
      DEF HNDSK
      DEF ANSWR
      DEF ANSWR
      DEF ANSWR
      DEF SEOF
EQT1A BSS 1         POINTS TO WRD #1 OF EQT TABLE.
EQT2A BSS 1         POINTS TO WORD #2 OF EQT TABLE.
FUNCT BSS 1         FUNCTION & SUBFUNCTION FIELDS.
TEMP5 BSS 1         TEMPORARY STORAGE.
TEMP6 BSS 1         TEMPORARY STORAGE.
USER2 BSS 1         WORD #2 ADRS OF USER REQUEST.
      HED TIMER SUBROUTINE.
* 
*           *** TIMER SUBROUTINE ***
* 
*     THIS SUBROUTINE CAUSES AN "INTERRUPT" (AFTER A SELECTABLE TIME
*     INTERVAL HAS PASSED) TO A DESIRED ENTRY POINT.
* 
*     TO ACTIVATE TIMER:
* 
*     JSB TACTV
*     A-REG CONTAINS TIME INTERVAL (IN TENS OF MILLISECONDS).
*     B-REG CONTAINS INTERRUPT ENTRY POINT.
      SPC 3
* 
*           *** ACTIVATION/DEACTIVATION SEGMENT. ***
* 
TACTV NOP           ENTRY POINT.
* 
      STA ASV       SAVE
      STB BSV       REGISTERS
      LDA TACTV     NOTE CALL
      LDB =B3       IN TRACE
      JSB TRACE
      LDA ASV       RESTORE
      LDB BSV       REGISTERS
* 
      SZA           DE-ACTIVATE TIMER?
      JMP ACTER     NO, ACTIVATE TIMER.
      STA TACT      YES, CLEAR ACTIVE BIT.
      JMP TACTV,I   RETURN.
* 
ACTER CMA,INA       STORE
      STA TINT      NEGATIVE
      STA TEMP2     INTERRUPT TIME.
      STB TADRS     STORE INTERRUPT ENTRY POINT.
      CLA,INA       ACTIVATE
      STA TACT      TIMER.
      JMP TACTV,I   RETURN.
      SPC 3
* 
*           *** TIMER SECTION. ***
* 
T.50  NOP           ENTRY POINT FROM TBG DRVR (D.43)
* 
      LDA TACT      TIMER
      SZA,RSS       ACTIVATED?
      JMP T.50,I    NO, GIVE CONTROL TO TBG DRIVER.
* 
      STB TBGSC     SAVE TBG'S SELECT CODE.
      ISZ TEMP2     TIME TO INTERRUPT?
      JMP T.50,I    NO, RETURN TO TBG DRIVER.
* 
      ISZ WHICH     YES, SET "WHICH" TO 1.
      JMP TADRS,I   EXECUTE INTERRUPT ROUTINE.
      SPC 3
* 
* TIMER INTERRUPT EXIT ROUTINE.
* 
TEXIT LDA TINT      RESET
      STA TEMP2     TIMER.
      CLA           ZERO
      STA WHICH     WHICH.
      LDB SETCN     SET CONTROL, CLEAR FLAG
      STA SETCN     ON I/O BOARD?
      CPB =B-1
STC1  STC 0,C       YES.
* 
      JMP T.50,I    GIVE CONTROL BACK TO TBG DRIVER.
      SPC 3
* 
*           *** DATA ***
* 
TACT  OCT 0         IF = 1, THEN TIMER IS ACTIVE.
TADRS BSS 1         TIMER INTERRUPT ENTRY POINT.
TBGSC BSS 1         TIME BASE GEN'S SELECT CODE.
TEMP2 BSS 1         TEMPORARY STORAGE
TINT  BSS 1         TIMER INTERVAL.
      HED INTERRUPT CONTROL SUBROUTINE.
* 
*           *** INTERRUPT CONTROL SUBROUTINE. ***
* 
* 
*     AN INTERRUPT FROM THE I/O BOARD CAUSES EXECUTION OF THIS
*     MODULE.
* 
* 
*     EXECUTION SEQUENCE:
* 
*     1. SAVE REGISTERS IN SAVE AREA.
*     2. TRANSFER CONTROL TO THE PROPER INTERRUPT PROCESSOR.
* 
      SPC 3
* 
*           *** SEGMENT ONE ***
* 
I.50  NOP           ENTRY POINT.
* 
* SAVE REGISTERS IN SAVE AREA.
* 
      CLF 0         DISABLE INTERRUPT SYSTEM.
      STA ASAVE     SAVE A-REGISTER.
      STB BSAVE     SAVE B-REGISTER.
      ERA,CLE,ALS   SAVE
      SOC           E
      INA           AND O
      STA EOSVE     REGISTERS.
* 
* IF EXECUTING TIME INTERRUPT SET "WHICH" TO 2.
* 
      CLB,INB       IF "WHICH" = 1,
      LDA =B2       THEN EXECUTING
      CPB WHICH     TIME INTERRUPT,
      STA WHICH     SO SET WHICH TO 2.
* 
* TRANSFER CONTROL TO PROPER INTERRUPT PROCESSOR.
* 
      JMP INTAD,I   JUMP TO PROCESSOR.
      SPC 3
* 
*           *** SEGMENT TWO ***
* 
* SET-UP FOR PROPER INTERRUPT PROCESSOR TRANSFER ADDRESS.
* 
PADRS NOP           ENTRY POINT.
      STA INTAD     SAVE INTERRUPT ADRS.
      STB BSV       SAVE B
      LDA PADRS     REGISTER
      LDB =B4       NOTE CALL
      JSB TRACE     IN TRACE
      LDA INTAD     RESTORE
      LDB BSV       REGISTERS
* 
      JMP PADRS,I   RETURN.
      SPC 5
* 
*           *** EXIT SUBROUTINE ***
* 
EXIT  LDB WHICH     IF WHICH = 1,
      SLB           THEN
      JMP TEXIT     TIME INTERRUPT EXIT.
* 
      CPB =B2       IF "WHICH" =2
      JMP DINT      THEN BOTH I/O BRD AND TBG INTRPT
IOXT  LDB EOSVE     RESTORE
      ELB,BRS       E
      CLO           AND
      SLB           O
      STO           REGISTER
      LDB BSAVE     RESTORE B-REGISTER.
      LDA ASAVE     RESTORE A-REGISTER.
* 
      ISZ SETCN     SET CONTROL, CLEAR FLAG?
      RSS           NO, SKIP NEXT INSTRUCTION.
STC2  STC 0,C       CONFIGURED SET CONTROL, CLR FLAG
* 
      STF 0         ENABLE INTERRUPT SYSTEM.
      JMP I.50,I    RETURN TO INTERRUPTED LOCATION.
      SPC 3
* 
*           *** BOTH TBG AND I/O BOARD INTERRUPTED. RETURN TO PROPER
*               ONE. ***
* 
DINT  CLB,INB       SET INTERRUPT LEVEL
      STB WHICH     BACK TO ONE LEVEL.
* 
      LDA EQT1A,I   GET
      AND =B77      I/O BOARD'S SELECT CODE.
      CMA,INA       MAKE NEGATIVE.
      ADA TBGSC     FORM(TBG'S S.C.-I/O BRD'S S.C.)
      SSA,RSS       IF POSITIVE
      JMP IOXT      THEN I/O BOARD HIGHER PRIORITY,
      JMP TEXIT     ELSE TIME BASE GEN HI PRIORITY.
      SPC 3
* 
*           *** DATA ***
* 
ASAVE BSS 1         CONTENTS OF A-REGISTER.
BSAVE BSS 1         CONTENTS OF B-REGISTER.
EOSVE BSS 1         CONTENTS OF E & 0 REGISTERS.
* 
INTAD BSS 1         S.A. OF INTERRUPT PROCESSOR.
WHICH OCT 0         IF = 1, THEN EXECUTING TIME INT.
      HED COMMON SUBROUTINES - UTILITY
* 
*           *** SET EQUIPMENT TABLE ENTRY TO "BUSY". ***
* 
EBUSY NOP           ENTRY POINT.
* 
      LDA =B100000  SET BIT 15
      IOR EQT2A,I   AND CLEAR BIT 14
      AND =B137777  OF WORD #2
      STA EQT2A,I   OF DEVICES EQUIPMENT TABLE ENTRY
* 
      STA BUSY      SET DRIVER BUSY.
* 
      JMP EBUSY,I   RETURN TO CALLING PROCESSOR.
      SPC 5
* 
*           *** BRING UP CARRIER ON I/O BOARD. ***
* 
UPCAR NOP           ENTRY POINT.
* 
      STA TEMP1     SAVE A-REGISTER CONTENTS.
      STB TEMP3     SAVE B-REGISTER CONTENTS.
* 
      LDA UPCAR     NOTE CALL IN TRACE.
      LDB =B5
      JSB TRACE
* 
      JSB .IO.      DISABLE
      OCT 100011
* 
      JSB .IO.      WAIT
      OCT 100003
      RAL,RAL       I/O BOARD'S
      SSA           BUSY FLAG (BIT 13 OF I/O STATUS)
      JMP *-4       GOES OFF.
* 
      JSB .IO.      BRING UP CARRIER
      OCT 5         ON SEND BOARD.
      LDA =D2       SET UP 10-20 M.S. TEIMOUT
      LDB UPCAD     CHECK FOR CLEAR TO SEND.
      JSB TACTV
* 
* 
* SEGMENT TWO: WAIT FOR CARRIER.
* 
UPCA1 JSB .IO.      GET STATUS
      OCT 3         FROM I/O BOARD.
      ALF
      SSA      CLEAR TO SEND ?
      JMP UPCA2  YES,RETURN TO CALL
      SLA       NO,DATA SET READY ?
      JMP EXIT      YES, WAIT FOR CLEAR TO SEND.
      JMP CLOSE      NO,STOP OPERATION
* 
UPCA2 CLA           DEACTIVATE
      JSB TACTV     TIMER.
      CLB      SEND A BURST OF SYNCS
      JSB SYNRZ      IF IN SYNC MODE
      LDA TEMP1     RESTORE A-REGISTER CONTENTS.
      LDB TEMP3     RESTORE B-REGISTER CONTENTS.
      JMP UPCAR,I   RETURN TO CALL.
      SPC 5
* 
*           *** SET TERMINAL "ON LINE" AND SAVE ITS LOGICAL UNIT ***
* 
OLNE  NOP           ENTRY POINT.
* 
      CLA,INA       SET
      STA LINE      "ON LINE".
* 
      LDA USER2,I   GET
      AND =B77      LOGICAL UNIT
      STA LOGUT     AND SAVE.
      JMP OLNE,I    RETURN.
      SPC 5
* 
*           *** SET TERMINAL "OFF LINE". ***
* 
OFLNE NOP           ENTRY POINT.
* 
      CLA           CLEAR
      STA LINE      "ON LINE".
      STA LOGUT     AND "LOGICAL UNIT".
      STA WACT
      STA DACT
      JSB TACTV     CLEAR TIMER,
* 
* 
      JMP OFLNE,I   RETURN.
      SPC 5
* 
*           *** CONTROL CHARACTER INITIALIZER. ***
* 
* UPON ENTRY:
*           IF A-REG = 0, THEN CONTROL CHARACTERS WILL BE EBCDIC.
*                    = 1, THEN CONTROL CHAR'S WILL BE ASCII.
*                    = 2, THEN CONTROL CHAR'S WILL BE 6 BIT TRANSCODE
* 
CCAR  NOP           ENTRY POINT.
* 
      LDB =D-24
      STB TEMP8      24 WORD TRANSFER
      LDB CCADR     SET UP
      STB TEMP7     TRANSFER ADDRESS.
      ADA CDESA     FORM
      LDA A,I       PROPER TRANSMISSION CODE.
* 
LOOP2 LDB A,I       TRANSFER
      STB TEMP7,I   A WORD.
      INA           INCREMENT
      ISZ TEMP7     ADDRESS POINTERS.
      ISZ TEMP8     FINISHED TRANSFER?
      JMP LOOP2     NO, TRANSFER ANOTHER WORD.
* 
      JMP CCAR,I    YES, RETURN TO CALL.
      SPC 3
* 
*           *** STATUS CHECK. ***
* 
* THIS SUBROUTINE CHECKS THAT BOTH CARRIER AND DATA ARE ON.  IF
* EITHER ARE OFF, THE I/O BOARD IS TURNED OFF AND THE OPERATION IS
* ENDED WITH THE STATUS SHOWING "TRANSMISSION ERROR".
* 
LCHCK NOP           ENTRY POINT.
* 
      JSB .IO.      GET STATUS
      OCT 3         FROM I/O BOARD.
* 
      ALF,SLA       DATA SET READY?
      JMP LCHCK,I   YES, RETURN TO CALL.
      JMP CLOSE     NO, END OPERATION.
      SPC 5
* 
*           *** "ENQ" PROCESSOR. ***
* 
* 
* THIS SUBROUTINE SENDS AN "ENQ" TO THE TERMINAL AND EXPECTS TO
* RECEIVE AN "ACK0".  IF SOME OTHER CHARACTER IS RECEIVED, "ENQ"
* WILL BE RESENT UP TO 8 TIMES.  IF "ACK0" IS STILL NOT RECEIVED
* THEN "DLE EOT" WILL BE SENT AND THE LINE DROPPED.  SUCCESSFUL
* EXECUTION ENABLES THE "TTD" MODULE.  CONTROL IS THEN PASSED TO THE
* COMPLETOR.
* 
* THIS MODULE IS USED BY "HANDSHAKE" AND "RECEIVE TO SEND".
* 
SENQ  LDA =D-8      PRIME COUNTER
      STA DD2       TO -8.
* 
* SEND "ENQ" CHARACTER TO THE REMOTE.
* 
DD3   CLB      SEND A BURST OF SYNCS
      JSB SYNRZ      IF IN SYNC MODE
      LDA PAD
                                                                                                                                                                 24380-18028 1409                                                                                           