
ASMB,R,B,L,X,C
      HED ASCII TO EBCDIC & EBCDIC TO ASCII TRANSLATER.   25MAR0
*
*
*               THIS PROGRAM WILL CONVERT AN ASCII CHARACTER STRING
*
*               OR EBCDIC CHARACTER STRING INTO EBCDIC OR ASCII,
*
*               RESPECTIVELY.
*
*
*
*               THERE ARE TWO ENTRY POINTS:
*
*
*                 1. EB2AS - CONVERTS A  PACKED EBCDIC CHARACTER
*                            STRING INTO PACKED ASCII.  CALLING
*                            PROGRAM SHOULD PRIME THE A-REG TO THE
*                            STARTING ADDRESS OF THE CHARACTER
*                            STRING AND THE B-REG TO THE LENGTH (IN
*                            WORDS) OF THE CHARACTER STRING.
*
*
*                 2. AS2EB - CONVERTS A PACKED ASCII CHARACTER
*                            STRING INTO PACKED EBCDIC.  CALLING
*                            PROGRAM SHOULD PRIME THE A-REG TO THE
*                            STARTING ADDRESS OF THE CHARACTER
*                            STRING, AND THE B-REG TO THE LENGTH (IN
*                            WORDS) OF THE CHARACTER STRING.
*
*
*
      NAM CNVT1,7
      SKP
*           *** CONVERT AN ASCII CHARACTER STRING INTO EBCDIC. ***
*
*
      SPC 2
AS2EB NOP           ENTRY POINT.
      STA BUFAD     STORE STRING STARTING ADDRESS.
      CMB,INB       B-REG CONTAINS NEG STRING LENGTH
*
LOOP1 LDA BUFAD,I   CONVERT
      ALF,ALF       LEFT
      AND =B377     HAND
      ADA TABAD     CHARACTER
      LDA A,I       INTO EBCDIC.
      AND =B177400  TEMPORARILY STORE
      STA TEMP      THE CHARACTER.
      LDA BUFAD,I   CONVERT
      AND =B377     RIGHT
      ADA TABAD     HAND
      LDA A,I       CHARACTER
      ALF,ALF       INTO
      AND =B377     EBCDIC.
      IOR TEMP      FORM CONVERTED WORD,
      STA BUFAD,I   AND PUT INTO CHARACTER STRING.
      ISZ BUFAD     INCREMENT CHAR STRING ADRS.
      INB,SZB       FINISHED CONVERSION?
      JMP LOOP1     NO, CONVERT ANOTHER WORD.
      JMP AS2EB,I   YES, RETURN TO CALLING PROGRAM.
      SPC 3
*
*           *** CONVERT AN ASCII CHARACTER STRING INTO EBCDIC. ***
*
EB2AS NOP           ENTRY POINT.
      SPC 2
      STA BUFAD     STORE STRING STARTING ADDRESS.
      CLA           IF BIT 15 IS SET, THEN SET
      LDA =B200     BIT 8 OF ASCII CHARACTER;
      IOR =B177     OTHERWISE,
      STA MASK      MASK BIT 8.
      CMB,INB       MAKE WORD COUNT NEGATIVE.
*
LOOP2 LDA BUFAD,I   CONVERT
      ALF,ALF       LEFT
      AND =B377     HAND
      ADA TABAD     CHARARACTER
      LDA A,I       INTO
      AND MASK      ASCII.
      ALF,ALF       STORE
      STA TEMP      TEMPORARILY.
*
      LDA BUFAD,I   CONVERT
      AND =B377     RIGHT
      ADA TABAD     HAND
      LDA A,I       CHARACTER
      AND MASK      INTO EBCDIC.
      IOR TEMP      FORM CONVERTED WORD
      STA BUFAD,I   AND STORE IN CHARACTER STRING.
*
      ISZ BUFAD     INCREMENT CHARACTER STRING ADRS.
      INB,SZB       FINISHED CONVERSION?
      JMP LOOP2     NO, CONVERT ANOTHER WORD.
      JMP EB2AS,I   YES, RETURN.
      SKP
*
*           *** DATA ***
*
      SUP
      ENT AS2EB,EB2AS
A     EQU 0
B     EQU 1
BUFAD BSS 1
MASK  BSS 1
TEMP  BSS 1
TABAD DEF TABLE
      SPC 3
*
*           *** TRANSLATION TABLE ***
*
*                1. EBCDIC EQUIVALENTS OF ASCII CODES ARE IN UPPER
*                   PART OF WORDS.
*
*                2. ASCII EQUIVALENTS OF EBCDIC CODES ARE IN LOWER
*                   PART OF WORDS.
*
*                3. TABLE CONFORMS TO CORPORATE MARKETING'S "ASCII-
*                   EBCDIC CONVERSION IN EBCDIC ORDER".
      SPC 2
TABLE OCT 000000  - 000
      OCT 000401
      OCT 001002
      OCT 001403
      OCT 033600
      OCT 026411
      OCT 027201
      OCT 027577
      OCT 013202  010
      OCT 002603
      OCT 022604
      OCT 005413
      OCT 006014
      OCT 006415
      OCT 007016
      OCT 007417
      OCT 010020  - 020
      OCT 010421
      OCT 011022
      OCT 011423
      OCT 036205
      OCT 036606
      OCT 031010
      OCT 023207
      OCT 014030  - 030
      OCT 014431
      OCT 037610
      OCT 023611
      OCT 016034
      OCT 016435
      OCT 017036
      OCT 017437
      OCT 040212  - 040
      OCT 047613
      OCT 077614
      OCT 075615
      OCT 055616
      OCT 066012
      OCT 050027
      OCT 076433
      OCT 046617  - 050
      OCT 056620
      OCT 056221
      OCT 047222
      OCT 065623
      OCT 060005
      OCT 045406
      OCT 060407
      OCT 170224  - 060
      OCT 170625
      OCT 171026
      OCT 171626
      OCT 172227
      OCT 172630
      OCT 173231
      OCT 173404
      OCT 174232  - 070
      OCT 174633
      OCT 075234
      OCT 057235
      OCT 046024
      OCT 077025
      OCT 067236
      OCT 067432
      OCT 076040  - 100
      OCT 140637
      OCT 141240
      OCT 141641
      OCT 142242
      OCT 142643
      OCT 143244
      OCT 143645
      OCT 144246  - 110
      OCT 144647
      OCT 150533
      OCT 151056
      OCT 151474
      OCT 152050
      OCT 152453
      OCT 153041
      OCT 153446  - 120
      OCT 154250
      OCT 154651
      OCT 161252
      OCT 161653
      OCT 162254
      OCT 162655
      OCT 163256
      OCT 163657  - 130
      OCT 164260
      OCT 164535
      OCT 045044
      OCT 160052
      OCT 055051
      OCT 057473
      OCT 066536
      OCT 074455  - 140
      OCT 100457
      OCT 101261
      OCT 101662
      OCT 102263
      OCT 102664
      OCT 103265
      OCT 103666
      OCT 104267  - 150
      OCT 104670
      OCT 110574
      OCT 111054
      OCT 111445
      OCT 112137
      OCT 112476
      OCT 113077
      OCT 113671  - 160
      OCT 114272
      OCT 114673
      OCT 121274
      OCT 121675
      OCT 122276
      OCT 122677
      OCT 123300
      OCT 123701  - 170
      OCT 124140
      OCT 124472
      OCT 140043
      OCT 065100
      OCT 150047
      OCT 120475
      OCT 003442
      OCT 002302  - 200
      OCT 003141
      OCT 004142
      OCT 004543
      OCT 005144
      OCT 012145
      OCT 012546
      OCT 013547
      OCT 015150  - 210
      OCT 015551
      OCT 020303
      OCT 020704
      OCT 021305
      OCT 021706
      OCT 022307
      OCT 024310
      OCT 024773  - 220
      OCT 025152
      OCT 025553
      OCT 026154
      OCT 030155
      OCT 030556
      OCT 031557
      OCT 032160
      OCT 032561  - 230
      OCT 033162
      OCT 034311
      OCT 034712
      OCT 035313
      OCT 035714
      OCT 037315
      OCT 040716
      OCT 041317  - 240
      OCT 041576
      OCT 042163
      OCT 042564
      OCT 043165
      OCT 043566
      OCT 044167
      OCT 044570
      OCT 050571  - 250
      OCT 051172
      OCT 051720
      OCT 052321
      OCT 052722
      OCT 053323
      OCT 053724
      OCT 054325
      OCT 054726  - 260
      OCT 061327
      OCT 061730
      OCT 062331
      OCT 062732
      OCT 063333
      OCT 063734
      OCT 064335
      OCT 064736  - 270
      OCT 070337
      OCT 070740
      OCT 071341
      OCT 071742
      OCT 072343
      OCT 072744
      OCT 073345
      OCT 073573  - 300
      OCT 074101
      OCT 100102
      OCT 105103
      OCT 105504
      OCT 106105
      OCT 106506
      OCT 107107
      OCT 107510  - 310
      OCT 115111
      OCT 115746
      OCT 116347
      OCT 116750
      OCT 117351  -
      OCT 117752
      OCT 120353
      OCT 125175  - 320
      OCT 125512
      OCT 126113
      OCT 126514
      OCT 127115
      OCT 127516
      OCT 130117
      OCT 130520
      OCT 131121  - 330
      OCT 131522
      OCT 132360
      OCT 132761
      OCT 133362
      OCT 133763
      OCT 134364
      OCT 134765
      OCT 135134  - 340
      OCT 135766        -
      OCT 136123
      OCT 136524
      OCT 137125
      OCT 137526
      OCT 145127
      OCT 145530
      OCT 146131  - 350
      OCT 146532
      OCT 147367
      OCT 147770
      OCT 166354
      OCT 166754
      OCT 167354
      OCT 167754
      OCT 155060  - 360
      OCT 155461
      OCT 156062
      OCT 156463
      OCT 157064
      OCT 157465
      OCT 160466
      OCT 165067
      OCT 165470  - 370
      OCT 175071
      OCT 175771
      OCT 110372
      OCT 176354
      OCT 176754
      OCT 177354
      OCT 177754
       END
                                                                                                                                                                 24380-18020 1402                                                                                          