
*
*     *** PUT CHARACTER IN OUTPUT BUFFER. ***
*
PUT   NOP
      STA TEMP
      LDB FLOP      DECIDE WHICH POSITION
      CMB,SZB       TO PUT CHAR IN.
      ALF,ALF
      STB FLOP
      SZB,RSS
      IOR S.A.,I    MERGE WITH PREV CHAR.
      STA S.A.,I    PUT IN BUFFER.
      SZB,RSS       INCREMENT ADDRESS
      ISZ S.A.      EVERY OTHER TIME.
      ISZ CNTR2     (COUNTER USED BY BLOCKING
      NOP           ROUTINE ONLY).
      LDA TEMP
      JMP PUT,I     RETURN.
      SKP
*
*     *** ROUTINE TO STRIP TRAILING BLANKS
*         AND BLOCK UP INPUT DATA. ***
*
*
*     DATA FORMATTED AS FOLLOWS:
*
*     (SYN)(STX)(BLOCK 1)(EM)(IUS)(BCC)(BCC)
*     (BLOCK 2)(EM)(IUS)(BCC)(BCC)...(BLOCK N)(ETX)
*
BLKUP NOP
      STA S.A.      SAVE BUFFER POINTER.
      LDA =D398     SET UP
      STA MAX       MAXIMUM BLOCK SIZE.
      CLA
      STA FLOP      INITIALIZE
      STA CNTR2     CONTROL FLAGS.
      STA FEND
*
      LDA SYN       BUFFER 'SYN','STX'
      JSB PUT       AT THE BEGINNING OF THE BLOCK.
      LDA STX
      JSB PUT
*
      LDA EXTRA     IS THERE A CARD IMAGE
      SZA           REMAINING FROM LAST BLOCK?
      JMP NOINP     YES.
*
LOOP8 JSB INPUT     NO, READ NEXT CARD IMAGE.
      ALF,ALF
      SSA           END OF FILE?
      JMP INEOF     YES.
      ISZ REC       NO, INCREMENT COUNTER.
      LDA CODE
      SLA,RSS
      JMP NOINP     NO CODE CONVERSION REQUESTED.
      LDA DEFIN     CONVERT DATA TO
      LDB =D40      EBCDIC.
      JSB AS2EB
*
NOINP LDA =D-80     SET UP 80
      STA CNTR1     CHAR COUNT.
      LDB DEFIN
      ADB =D39
LOOP6 LDA B,I       SCAN FROM REVERSE
      CPA =B40100   FOR NON-BLANK
      IFN
      NOP
      XIF
      IFZ
      RSS           CHARACTERS.
      XIF
      JMP EOD
      ADB =D-1
      ISZ CNTR1
      ISZ CNTR1
      JMP LOOP6
      LDB =D-2      CARD WAS BLANK.
      STB CNTR1     SEND 1ST 2 CHARS ONLY.
      JMP NOBNK
*
EOD   AND =B377     CHECK FOR RIGHT
      CPA =B100     BYTE BLANK CHAR.
      IFN
      NOP
      XIF
      IFZ
      RSS
      XIF
      JMP NOBNK
      ISZ CNTR1
*
NOBNK LDA MAX       CHECK IF THERE
      ADA CNTR1     IS ROOM
      ADA =D-4      IN OUTPUT
      SSA           BUFFER FOR THIS DATA.
      JMP NOFIT     NO, LEAVE AS IS.
      STA MAX       YES, RESET COUNT OF SPACE ABAIL.
*
      CLA           SET UP
      STA FFLOP     FOR MOVING
      STA BCCCH     IMAGE TO OUTPUT
      LDA DEFIN     BUFFER.
      STA SA1
      CCB
      LDA CNTR1     IF FULL
      CPA =D-80     CARD SET
      CMB,INB       FLAG FOR
      STB GLEN      NO EM
      RSS
GLEN  NOP
*
LOOP7 LDA SA1,I     GET CHARACTER
      LDB FFLOP
      CMB,SZB
      ALF,ALF
      AND =B377
      STB FFLOP
      SZB,RSS
      ISZ SA1
*
      JSB BCC       CALCULATE CRC-16 ON IT.
*
      JSB PUT       PUT IN OUTPUT BUFFER.
      ISZ CNTR1
      JMP LOOP7
*
      IFZ
      ISZ GLEN      IF 80 CHARS
      JMP *+4       NO EM
      LDA EM        GET 'END OF MEDIUM' CHAR.
      JSB BCC       CALCULATE CRC-16
      JSB PUT       PUT IN OUTPUT BUFFER.
      XIF
      LDA IUS       GET 'INFORMATION UNIT SEPERATOR'
      JSB BCC       INCLUDE IN CRC-16.
      JSB PUT       PUT IN OUTPUT BUFFER.
      LDA BCCCH     GET 1ST CRC-16
      AND =B377
      JSB PUT       MOVE TO OUTPUT BUFFER.
      LDA BCCCH     GET 2ND CRC16 CHAR.
      ALF,ALF
      AND =B377
      JSB PUT       MOVE TO OUTPUT BUFF.
      JMP LOOP8     GO READ NEXT CHARD IMAGE.
*
NOFIT LDA S.A.      BLOCK IS FULL, REPLACE
      LDB FLOP      LAST 'IUS',BCC,BCC
      CMB,SZB       WITH 'ETX' CHAR.
      ADA =D-1
      ADA =D-1
      STA S.A.
      STB FLOP
      LDA S.A.,I    MASK RIGHT CHAR
      SZB           WHEN NECESSARY.
      AND =B177400
      STA S.A.,I
      CCA           SET LOGIC FOR
      STA EXTRA     AN EXTRA CARD IMAGE.
*
      LDA ETX
      JSB PUT
      LDB CNTR2
      ADB =D-3
      JMP BLKUP,I   RETURN WITH BLOCK LENGTH.
*
INEOF CMA           END OF FILE, SET FLAGS AND
      STA FEND      RETURN.
      LDB CNTR2
      SZB,RSS
      JMP BLKUP,I
      JMP NOFIT
      SKP
*
*     *** SECTION TO ADVANCE TAPE DRIVE. ***
*
ADVN  LDA DEFRP     INITIALIZE PARAMETERS.
      STA HOLD
      CLA
      STA FFLOP
*
*
*     *** ASK OPERATOR FOR FILE & RECORD COUNTS. ***
*
      LDB =D12      ASK FOR FILE
      JSB CNSL      AND RECORD COUNTS.
      JSB RESP
*
      ELB,CLE,ERB   REMOVE MODE BIT.
      BLS           CONVERT COUNT TO CHARACTERS.
      CMB,INB       SET UP CHARACTER INPUT
      STB BSAVE     LOOP FOR SCAN ROUTINE.
*
      JSB SCAN      SCAN FOR 1'ST BLANK OR ",".
      JSB AS2BI     CONVERT TO BINARY.
      CMA,INA       SET UP FILE
      STA FILES     LOOP.
*
      JSB SCAN      SCAN FOR 2ND BLANK.
      JSB AS2BI     CONVERT TO BINARY.
      CMA,INA       SET UP
      STA REC       RECORD LOOP.
*
*     *** ADVANCE TAPE DRIVE GIVEN # OF FILES, RECS. ***
*
ADVAN JSB .IOC.     CALL DRIVER TO
      ABS 30300B+MAG
      JMP *-2       ONE RECORD.
*
      JSB MAGST
*
      ALF,ALF       POSITION BIT "7".
      SSA,RSS       SET?
      JMP CKREC     NO, RECORD NOT AN EOF.
*
      LDA FILES     FILE COUNT ALREADY
      SZA,RSS       SATISFIED?
      JMP FRMAT     YES, FORMAT ERROR.
      ISZ FILES     NO, INCREMENT COUNT.
      JMP ADVAN     LOOP.
      LDA REC       "FILES" = 0.  CHECK OF
      SZA           "REC" = 0 ALSO.
      JMP ADVAN     NO, CONTINUE ADVANCE.
      JMP MTS       GET NEXT FUNCTION
*
*
CKREC LDA FILES     FILE COUNT SATISFIED?
      SZA
      JMP ADVAN     NO, CONTINUE.
*
      ISZ REC       YES, INCREMENT RECORD COUNT.
      JMP ADVAN     CONTINUE.
      JMP MTS       GET NEXT FUNCTION
      SPC 4
*
*     *** ABORT - TAPE MARK ENCOUNTERED BEFORE
*         RECORD COUNT SATISFIED. ***
*
FRMAT LDB =D17      INFORM OPERATOR
      JSB CNSL      OF FORMAT ERROR.
      JMP MTS
      SPC 4
*
*     *** ROUTINE TO SCAN "REPLY" BUFFER FOR EITHER
*         A "," OR "BLANK".  UPON RETURN, A-REG = STRING
*         STARTING ADDRESS, B-REG = STRING LENGTH:
*         POSITIVE IF LEFT JUSTIFIED, NEG IF RIGHT.
*         (COMPATABLE TO "AS2BI" ROUTINE). ***
*
SCAN  NOP
      CLA           SET COUNT TO
      STA CCNTR     ZERO INITIALLY.
      LDA HOLD      SAVE CURRENT STRING
      STA ASAVE     POINTER.
      LDA BSAVE     STRING INPUT COUNT
      SZA,RSS       ALREADY SATISFIED?
      JMP GOTIT     YES, DEFAULT COUNT TO 0.
*
NEXTR LDA HOLD,I    GET 2 CHARS FROM STRING.
      LDB FFLOP     GET POSITION FLIP-FLOP.
      CMB,SZB       NEXT CHAR IN LEFT SIDE OF WORD?
      ALF,ALF       YES, POSITION TO RIGHT
      STB FFLOP     RESET FLAG.
      SZB,RSS       INCREMENT POINTER
      ISZ HOLD      EVERY OTHER TIME.
      AND =B377     MASK PERTINENT CHARACTER.
      CPA =B54      IS IT A COMMA?
      JMP FOUND     YES.
      CPA =B40      IS IT A BLANK?
      JMP FOUND     YES.
      ISZ CCNTR     INCREMENT STRING CHAR COUNT.
      ISZ BSAVE     END OF INPUT?
      JMP NEXTR     LOOP.
*
*
      CMB           ADJUST B-REG.
GOTIT LDA CCNTR     GET CHAR COUNT IN A-REG.
      RAR           MOVE BIT "0" TO "15" POSITION.
      XOR B         EXCLUSIVE OR WITH FLIPF (IN B-REG).
      LDB CCNTR     GET CHAR COUNT IN B-REG.
      SSA,RSS       NEED TO MAKE NEGATIVE?
      CMB,INB       YES, STRING STARTED ON ODD BNDRY
      LDA ASAVE     GET STRING S.A. IN A-REG.
      JMP SCAN,I    RETURN.
*
FOUND ISZ BSAVE     INCREMENT STRING CHAR COUNT.
      NOP
      JMP GOTIT     RETURN
      SKP
*
*     *** ROUTINE TO READ CARDS AND WRITE TO TAPE. ***
*
CD2TP CLA           ZERO RECORD
      STA REC       COUNT.
*
LOOPC JSB READC     READ A CARD IMAGE
      ALF,ALF
      SSA           END OF FILE CARD?
      JMP BCARD     YES.
*
      JSB .IOC.     WRITE CARD IMAGE
      ABS 20000B+MAG  TO MAG TAPE.
      JMP *-2
      DEF IMAGE
      DEC 40
      JSB MAGST
      SLA           IN LOCAL?
      JMP LOOPC+1   YES, LOOP UNTIL NOT.
      ISZ REC       INCREMENT RECORD COUNT.
      JMP LOOPC
      SPC 4
BCARD JSB .IOC.     END OF DECK ENCOUNTERED.
      ABS 30100B+MAG  WRITE 2
      JMP *-2       END OF FILES.
      JSB .IOC.
      ABS 30100B+MAG
      JMP *-2
      JSB .IOC.     REWIND TAPE.
      ABS 30400B+MAG
      JMP *-2
*
      LDA REC       CONVERT RECORD
      CLB           COUNTER TO ASCII.
      JSB B2ASC
      DEF MSG18+14
      DEC 3
      LDB =D18      GO PRINT COMPLETION MESSAGE.
      JSB CNSL
      JMP MTS
*
      SKP
*
*     *** ROUTINE TO PRINT A RECEIVED FILE. ***
*
PRINT CLA           INITIATE RECORD
      STA REC       COUNT TO ZERO.
                                                                                                                                                                  24380-18016 1402                                                                                           