ASMB,R,L,B,T,C
      HED A-05470-94019-1  REV B NAM MULT.  ERS & LISTING 
      NAM MULT. 
* 
****
* 
* 5451 - 5470 
* 
* REVISED AUG 27, 1974
*  FIX BUG THAT INCORRECTLY SET OVERFLOW STATUS WHEN MULTIPLYING
*  A DOUBLE PRECISION BLOCK IN BLOCK 0 BY A COMPLEX NUMBER. 
*  SEE LABEL REVB.
* 
****
* PURPOSE:           EXECUTES MULTIPLY COMMANDS IN THE
*                    5451-5470 FOURIER SYSTEM 
* 
* SIZE:              222 WORDS (336 OCTAL)
* 
* ENTRY POINTS:      MULO, MULI, MULX, Y3011
* 
*   1. MULO 
* 
*     CALLING SEQUENCE: 
*                    INS1 _ N1
*                    INS2 _ N2 (FOR INTEGER MULTIPLY) 
*                    INS3 _ N3 ( FOR COMPLEX INTEGER MULTIPLY)
*                    INSMX _ 1 IF N1 ONLY GIVEN 
*                          _ 2 IF N1, N2 GIVEN
*                          _ 3 IF N1, N2, N3 GIVEN
*                    JSB MULO 
* 
*     PARAMETERS USED:
*                    IMAK 
*                    REAK0
*                    IMAK0
*                    PRNUM
*                    SCALN
*                    CALBN
*                    SCAL0
*                    CALB0
*                    TIME0
*                    TIMEN
*                    PREN7
*                    PRE07
*                    FLG1 
* 
*     CONSTANTS USED: 
*                    P8 
*                    P.1
*                    P100 
* 
*     SUBROUTINES CALLED: 
*                    CHKN 
*                    MAXIM
*                    ADSCL
*                    .MPY.
*                    CPLXM
*                    INTEG
*                    DPREC
*                    RAXOV
*                    OFF0 
*                    OTAS 
*                    INAS 
*                    SALOK
*                    INKEG
*                    MULAS
*                    MAXC 
*                    RUN7 
*                    PGM10
*                    PGM11
*                    PGM28
*                    PGM12
*                    PGM13
*                    PGM14
*                    PGM15
*                    PGM35
*                    PGM37
*                    PGM38
*                    PGM34
*                    SAS7S
*                    GOV7 
*                    IXE0 
* 
*     OPERATION:     SETS FLG1  _ 0 
*                    EXECUTES "MULT" : * N1 (N2) (N3) COMMAND 
*                    IF ONLY N1 GIVEN, THEN BLOCK MULTIPLY: 
*                        BLOCK 0 MULTIPLIED BY BLOCK N1, RESULT 
*                        GOES TO BLOCK 0. 
*                        SETS TIMEN _ TIME0.  THE DOMAIN OF 
*                        BLOCK 0 DETERMINES THE TYPE OF POINT BY
*                        POINT MULTIPLICATION.  THE RESULT WILL 
*                        BE IN THE SAME DOMAIN AS WAS BLOCK 0.
*                    IF N2 (N3) GIVEN, THEN BLOCK N1 IS 
*                       MULTIPLIED BY INTEGER CONSTANT N2 (OR 
*                       COMPLEX NUMBER N2 + IN3).  IF BLOCK N1
*                       IS IN THE TIME DOMAIN, N3 IS DISREGARDED. 
*                    IF ONLY N1 & N2 GIVEN, WITH N2 =0 THEN BLOCK 
*                        N1 WILL BE MULTIPLIED BY THE LOOP
*                        COUNTER.  THIS OPERATION WILL ONLY BE
*                        EXECUTED WHILE INSIDE A PROGRAM LOOP.
* 
*     NORMAL RETURN: IS MADE WHEN OPERATION IS COMPLETED. 
* 
*     ERROR CONDITIONS: 
*                    IF BLOCK N1 IS NON-EXISTENT, A "WHAT"
*                    MESSAGE RESULTS. 
*                    IF N2 =0 (N3 NOT GIVEN) AND NOT IN 
*                    PROGRAMMING MODE (XEQ =0), OR A LOOP 
*                    COUNTER IS NOT PRESENT IN THE PROGRAM STACK, 
*                    THEN A "WHAT" MESSAGE WILL RESULT. 
*                    RETURN IS TO CNTRL TO RESTART FOURIER
*                    PROGRAM. 
* 
*   2. MULI 
* 
*     CALLING SEQUENCE: 
*                    INS1 _ N1
*                    INS2 _ 0 (FOR CONJUGATION) 
*                    INSMX _ 1 IF N1 ONLY GIVEN 
*                          _ 2 IF N1, N2 GIVEN
*                    JSB MULI 
* 
*     PARAMETERS USED:
*                    SAME AS MULO 
* 
*     CONSTANTS USED: 
*                    SAME AS MULO 
* 
*     SUBROUTINES CALLED: 
*                    SAME AS MULO 
* 
*     OPERATION:     SETS FLG1 _ 1
*                    EXECUTES "* MULT" : *- N1 (N2) COMMAND 
*                    IF N2 NOT GIVEN THEN BLOCK MULTIPLY: 
*                       MULTIPLIES BLOCK 0 BY THE CONJUGATE OF
*                       BLOCK N1, RESULT RETURNED INTO BLOCK 0. 
*                    SETS TIMEN _ TIME0.  THE DOMAIN OF BLOCK 0 
*                        DETERMINES THE TYPE OF POINT BY POINT
*                        MULTIPLICATION.  THE RESULT WILL ALSO
*                        BE IN THE SAME DOMAIN AS WAS BLOCK 0.
*                       IF BLOCK 0 IS TIME DOMAIN OR DOUBLE PRE-
*                       CISION THEN NON-CONJUGATE MULTIPLY IS 
*                       PERFORMED.
*                       IF N1 = 0 THEN THE RESULT IS DOUBLE PRE-
*                       CISION UNLESS DISABLED BY Y3011.
*                    IF N2 = 0, THEN BLOCK N1 WILL BE CONJUGATED
*                        (SIGN OF THE IMAGINARY PART OF EACH
*                        HARMOMIC IS CHANGED) UNLESS BLOCK N1 IS
*                        IN THE TIME DOMAIN OR DOUBLE PRECISION.
* 
*     NORMAL RETURN: SAME AS MULO 
* 
*     ERROR CONDITIONS: 
*                    IF BLOCK N1 DOES NOT EXIST, A "WHAT" 
*                    MESSAGE WILL RESULT AND RETURN IS TO 
*                    CNTRL TO RESTART FOURIER PROGRAM.
* 
*   3. MULX 
* 
*     CALLING SEQUENCE: 
*                    INS1 _ N1 (N1 >0)
*                    INSMX _ 1
*                    JSB MULX 
* 
*     PARAMETERS USED:
*                    SAME AS MULO 
* 
*     CONSTANTS USED: 
*                    SAME AS MULO 
* 
*     SUBROUTINES CALLED: 
*                    SAME AS MULO 
* 
*     OPERATION:     SETS FLG1 _ -1 
*                    MULTIPLIES BLOCK 0 BY THE CONJUGATE OF BLOCK 
*                    N1 AND STORES THE DOUBLE PRECISION REAL PART 
*                    OF THE PRODUCT IN BLOCK 0.  THE IMAGINARY
*                    PART OF THE PRODUCT IS DISCARDED.
*                    THIS OPERATION MAY RESULT IN NONSENSE IF 
*                    N1 = 0 OR IF EITHER OF THE DATA BLOCKS 
*                    ARE IN THE TIME DOMAIN OR DOUBLE PRECI-
*                    SION.
* 
*     NORMAL RETURN: SAME AS MULO 
* 
*     ERROR CONDITIONS: 
*                    SAME AS MULI.
* 
*   4. Y3011
* 
*     CALLING SEQUENCE: 
*                    INSMX _ 0 FOR ENABLING DOUBLE PRECISION
*                    INSMX _ 1 FOR DISABLING DOUBLE PRECISION 
*                    JSB Y3011
*                    DEF *+1
* 
*     PARAMETERS USED:
*                    INSMX
* 
*     OPERATION:
*                    IF INSMX = 0 THEN ENABLES DOUBLE PRECISION 
*                    RESULT FOR SELF CONJUGATE MULTIPLY, ELSE 
*                    DISABLES IT. 
* 
*     NORMAL RETURN: AFTER OPERATION COMPLETED
* 
      SKP 
*                     NAM MULT. 
      ENT MULO,MULI 
      ENT Y3011 
      ENT MULX
      EXT MAXC
      EXT CHKN
      EXT FLG1
      EXT PRNUM 
      EXT MAXIM 
      EXT SCALN 
      EXT ADSCL 
      EXT CALB0 
      EXT CALBN 
      EXT .MPY. 
      EXT CPLXM 
      EXT INTEG 
      EXT DPREC 
      EXT P8
      EXT SCAL0 
      EXT INS1
      EXT INSMX 
      EXT TIME0 
      EXT TIMEN 
      EXT RAXOV 
      EXT IMAK
      EXT IMAK0 
      EXT REAK0 
      EXT SALOK 
      EXT INKEG 
      EXT PREN7 
      EXT PRE07 
      EXT INS2
      EXT INS3
      EXT P.1 
      EXT P100
      EXT OTAS
      EXT INAS
      EXT PGM10 
      EXT PGM11 
      EXT PGM28 
      EXT PGM12 
      EXT PGM13 
      EXT PGM14 
      EXT PGM15 
      EXT PGM35 
      EXT PGM37 
      EXT PGM38 
      EXT PGM34 
      EXT IXE0
      EXT SAS7S 
      EXT GOV7
      EXT OFF0
      EXT RUN7
      EXT MULAS 
* 
* 
MULO  NOP     MULTIPLY
      CLA 
      JSB MULT
      JMP MULO,I
* 
* 
MULI  NOP      CONJUGATE MULTIPLY 
      CLA,INA 
      JSB MULT
      JMP MULI,I
* 
MULX  NOP 
      CCA 
      JSB MULT
      JMP MULX,I
* 
MULT  NOP 
OUT   STA FLG1    =0 MULT., =1 CONJUGATE MULT.
      JSB CHKN
      LDB PRNUM 
      SZB 
      JMP INTM
      LDB PREN7 
      SZB,RSS 
      JSB DPREC 
      LDA PREN7 
      LDB PRE07 
      SZB,RSS 
      CMA,INA 
      STA DPF 
* 
* 
MULT1 JSB OFF0
      LDA INS1
      LDB TIME0 
      SZB,RSS 
      JMP MULT3 
      SZA 
      JMP MULT2 
      JSB RUN7
      DEF PGM10 
      JMP ENDE
MULT2 JSB RUN7      TIME CROSS
      DEF PGM13 
      JMP ENDE
MULT3 LDB DPF 
      SZA 
      JMP MULT6 
      SZB,RSS 
      JMP *+4 
      JSB RUN7
      DEF PGM35     SELF DP DP
      JMP ENDE
      LDB FLG1
      SZB 
      JMP MULT4 
      JSB RUN7     SELF CMPLX 
      DEF PGM11 
      JMP ENDE
MULT4 RSS         NOP IF NO DP
      JMP MULT5 
      LDA SCAL0 
      IOR P8      SET DP BIT
      STA SCAL0 
      JSB RUN7     SELF CONJ DP 
      DEF PGM28 
      JMP ENDE
MULT5 JSB RUN7   SELF CONJ SP 
      DEF PGM12 
      JMP ENDE
MULT6 SZB,RSS 
      JMP *+9 
      SSB 
      JMP *+4 
      JSB RUN7
      DEF PGM37     X DP DP 
      JMP ENDE
      JSB RUN7
      DEF PGM38     X SP DP 
      JMP ENDE
      LDB FLG1
      SZB 
      JMP MULT7 
      JSB RUN7
      DEF PGM14     CROSS COMPLX
      JMP ENDE
MULT7 SSB 
      JMP *+4 
      JSB RUN7
      DEF PGM15 
      JMP ENDE
      LDA SCAL0 
      IOR P8
      STA SCAL0 
      JSB RUN7
      DEF PGM34 
ENDE  CLB 
      JSB ADSCL 
      LDA CALB0 
      LDB CALBN 
      JSB .MPY. 
      JSB MAXC
      OCT 0 
      JSB IXE0
      JMP MULT,I
* 
* 
* 
Y3011 NOP 
      LDA RSSC
      LDB INSMX 
      SZB 
      CLA 
      STA MULT4 
      LDA Y3011,I 
      JMP A,I 
* 
* 
INTM  JSB SAS7S 
      JSB MAXIM 
      CLA 
      LDB PRNUM 
      STA TN2 
      STA I0
      LDA FLG1
      SZA 
      JMP INT1      CONJUGATE MULT
      SSB 
      JMP N2GER 
      JSB INTEG     N3 NOT GIVEN
      JMP *+6 
N2GER LDA INS2
      CLB 
      SZA,RSS 
      JMP *+2 
      JSB INKEG 
      STB R0
      STA TN2 
* 
INT1  LDB FLG1
      SZB,RSS 
      JMP INT7
      LDA INS2
      SZA 
      JMP MULT,I    CONJUGATE=N2 NOT 0
      LDA TIMEN 
      IOR PREN7 
      SZB,RSS 
      JMP *+4 
      SZA 
      JMP MULT,I    TIME OR DRED 6 CONJUGATE
      JMP INT2
INT7  LDA TIMEN 
      SZA 
      JMP INT2
      LDB PRNUM 
      SSB,RSS 
      JMP INT2
* 
      JSB DPREC 
REVB  LDA INS1      SET PREN0=0 IF BLOCK 0 TO 
      SZA,RSS       COMPUTE THE PROPER OVERFLOW 
      STA PRE07     STATUS FOR BLOCK 0
* 
* 
      LDA INS3      N3 GIVEN,FRSA 
      CLB           NON DPREC 
      SZA,RSS 
      JMP *+2 
      JSB INKEG 
      STB I0
      STA TN3       AND ITS SCHLOR
INT3  LDA TN3 
      CMA,INA 
      ADA TN2       TN2-TN3 
      SZA,RSS 
      JMP INT2      TN2=TN3 
      SSA 
      JMP INT4
      LDA TN3       TNZ>TN3 
      ADA P100
      STA TN3 
      LDB I0
      LDA P.1 
      JSB .MPY. 
      STB I0
      JMP INT3
INT4  LDA TN2       TN2<TN3 
      ADA P100
      STA TN2 
      LDB R0
      LDA P.1 
      JSB .MPY. 
      STB R0
      JMP INT3
INT2  JSB RAXOV 
      JSB OTAS
      LDA R0
      LDB PREN7 
      SZB 
      JMP INT6      DPREC 
      LDB I0
      STA REAK0 
      STB IMAK0 
      LDA FLG1
      SZA 
      JMP INT5      CONT. 
      JSB CPLXM 
      JMP INT8
      JSB SALOK 
      JMP INT2+1
INT8  JSB INAS
      JMP INT2+1
      LDA TN2       END 
      ADA SCALN 
      STA TN2 
      LDB CALBN 
      CLA 
      JSB MAXC
      DEF TN2 
      STB CALBN 
      LDA TN2 
      STA SCALN 
      JSB GOV7
      JMP MULT,I
INT5  LDB IMAK      CONJUGATE 
      CMB,INB 
      STB IMAK
      JMP INT8
INT6  JSB MULAS     DPREC 
      JMP INT8
* 
* 
* 
TN2   BSS 1 
TN3   BSS 1 
R0    BSS 1 
I0    BSS 1 
RSSC  RSS 
DPF   NOP 
* 
* 
A     EQU 0 
B     EQU 1 
* 
      END 
                                                                                                                                 