ASMB,R,L,B,T,C
      HED A-05470-94016-1  NAM LOCAT  ERS & LISTING 
      NAM LOCAT 
* 
****
* 
* 5451 - 5470 
* 
****
* PURPOSE:           TO SET UP DATA BLOCK ADDRESS AND QUALIFIERS
* 
* SIZE:              70 WORDS (106 OCTAL) 
* 
* ENTRY POINTS:      LOCAT, LOCIT, BLNMR, OFFS
*                    OFF0 
* 
*   1. LOCAT
* 
*     CALLING SEQUENCE: 
*                    REG. A _ BLOCK NUMBER
*                    JSB LOCAT
* 
*     PARAMETERS USED:
*                    NMAX 
*                    BLNMR
*                    NMAX0
*                    SCALN
*                    CALBN
*                    FREQN
*                    SIZE 
*                    NA 
*                    NB 
*                    NA#
*                    SCALA
*                    CALBA
*                    FREQA
*                    DRE. 
* 
*     SUBROUTINES CALLED: 
*                    OFFS 
*                    WHAT 
* 
*     OPERATION:
*                    CHECKS THE LEGALITY OF THE BLOCK NUMBER IN 
*                    REGISTER A.  IF ILLEGAL , THEN CALLS ON
*                    NAM WHAT TO SEND "WHAT" MESSAGE AND RESTART
*                    FOURIER PROGRAM.  IF BLOCK NUMBER IS VALID,
*                    IT IS SAVED IN PARAMETER BLNMR.
* 
*                    TRANSFERS THE DATA QUALIFIERS OF DATA BLOCK
*                    BLNMR FROM THE DATA QUALIFIER STACK INTO:
*                        SCALN _ SCALE FACTOR WORD OF BLOCK BLNMR 
*                        CALBN _ CALIBRATOR OF BLOCK BLNMR
*                        FREQN _ FREQ.FACTOR OF BLOCK BLNMR 
* 
*                    SETS DRE. _ STARTING ADDRESS OF BLOCK BLNMR
* 
*                    SETS RUN7 PARAMETERS NA,NA#,NB,SCALA,CALBA 
*                    FREQA FOR BLOCK N1 
* 
*     NORMAL RETURN: WHEN OPERATION COMPLETED 
* 
*     ERROR CONDITIONS: 
*                    IF BLOCK NUMBER IS ILLEGAL, THEN "WHAT"
*                    MESSAGE RESULTS AND RETURN IS TO CNTRL 
*                    TO RESTART FOURIER PROGRAM.
* 
*   2. LOCIT
* 
*     CALLING SEQUENCE: 
*                    BLNMR _ LEGAL BLOCK NUMBER 
*                    JSB LOCIT
* 
*     PARAMETERS USED:
*                    NMAX0
*                    SCALN
*                    CALBN
*                    FREQN
* 
*     SUBROUTINES CALLED: 
*                    OFFS 
* 
*     OPERATION:
*                    TRANSFERS SCALN, CALBN, FREQN INTO THE 
*                    DATA QUALIFIERS STACK AS THE SCALE FACTOR
*                    WORD, CALIBRATOR AND FREQ. FACTOR OF 
*                    BLOCK BLNMR, RESPECTIVELY. 
* 
*     NORMAL RETURN: WHEN OPERATION COMPLETED 
* 
*   3. BLNMR         CONTAINS DATA BLOCK NUMBER CHECKED BY LOCAT
*                    AND FOUND LEGAL. 
* 
*   4. OFFS 
* 
*     CALLING SEQUENCE: 
*                    BLNMR _ LEGAL BLOCK NUMBER 
*                    JSB OFFS 
* 
*     PARAMETERS USED:
*                    ZIFPW
*                    SCAL 
* 
*     OPERATION:     RETURNS IN REGISTER A THE ADDRESS IN THE 
*                    DATA QUALIFIER STACK OF THE SCALE FACTOR 
*                    WORD OF BLOCK BLNMR
* 
*     NORMAL RETURN: WHEN OPERATION COMPLETED 
* 
* 
*   5. OFF0 
* 
*     CALLING SEQUENCE: 
*                    SCAL _ ADDRESS OF DATA QUALIFIERS STACK
*                    NMAX0 _ LARGEST NUMBER OF DATA BLOCKS
*                    JSB OFF0 
* 
*     PARAMETERS USED:
*                    SCALA
*                    CALBA
*                    FREQA
*                    NA 
*                    NA#
* 
*     OPERATION:     SETS RUN7 PARAMETERS  NA, NA#, SCALA,
*                    CALBA, FREQA FOR BLOCK 0 
* 
*     NORMAL RETURN: WHEN OPERATION COMPLETED 
      SKP 
*                     NAM LOCAT 
      ENT LOCAT 
      ENT LOCIT 
      ENT BLNMR 
      ENT OFFS
      ENT OFF0
* 
      EXT SCAL,NMAX0
      EXT SIZE
      EXT WHAT,NMAX 
      EXT SCALN,CALBN,FREQN,DRE.
      EXT ZIFPW 
      EXT SCALA 
      EXT CALBA 
      EXT FREQA 
      EXT NA
      EXT NB
      EXT NA# 
****
LOCAT NOP 
      SSA 
      CMA,INA 
      LDB 0 
      CMB 
      ADB NMAX
      SSB 
      JSB WHAT     BLOCK# >NMAX 
      STA BLNMR 
      STA NA# 
      JSB OFFS
      STA SCALA 
      LDB A,I 
      STB SCALN    SET UP SCALN 
      ADA NMAX0 
      STA CALBA 
      LDB A,I 
      STB CALBN    SET UP CALBN 
      ADA NMAX0 
      STA FREQA 
      CLF 0 
      LDB A,I 
      STB FREQN    SET UP FREQN 
      STF 0 
      LDA BLNMR 
      LDB SIZE
L3    SLB 
      JMP L2
      RAL          CALCULATE STARTING 
      RBR            ADDRESS OF 
      JMP L3          BLOCK N 
L2    STA NA
      STA NB
      STA DRE.
      JMP LOCAT,I 
* 
*  LOCIT TRANSFERS SCALN,CALBN, AND FREQN 
*  BACK INTO THE STACK. 
*  LOCIT IS CALLED BY SUBROUTINES WHICH MAY ALTER 
*  THE CONTENTS OF SCALN,CALBN OR FREQN.
****
LOCIT NOP 
      JSB OFFS
      LDB SCALN 
      STB A,I 
      ADA NMAX0 
      LDB CALBN 
      STB A,I 
      ADA NMAX0 
      CLF 0 
      LDB FREQN 
      STB A,I 
      STF 0 
      JMP LOCIT,I 
* 
* 
OFFS  NOP 
      LDA BLNMR 
      LDB ZIFPW 
      BRS 
      SZB,RSS 
      JMP *+3 
      ALS 
      JMP *-4 
      ADA SCAL
      JMP OFFS,I
* 
* 
OFF0  NOP 
      LDA SCAL
      STA SCALA 
      ADA NMAX0 
      STA CALBA 
      ADA NMAX0 
      STA FREQA 
      CLA 
      STA NA
      STA NA# 
      JMP OFF0,I
* 
* 
BLNMR NOP 
A     EQU 0 
B     EQU 1 
      END 
                                                                                                                       