ASMB,R,L,B,T,C
      HED A-05470-94013-1  NAM IF.  ERS & LISTING 
      NAM IF. 
* 
****
* 
* 5451 - 5470 
* 
****
* PURPOSE:           TO PROVIDE CONDITIONAL BRANCHING FOR 
*                    THE 5451-5470 FOURIER SYSTEM KEYBOARD
*                    PROGRAMS 
* 
* SIZE:              31 WORDS (37 OCTAL)
* 
* ENTRY POINTS:      IF.
* 
*   1. IF.
* 
*     CALLING SEQUENCE: 
*                    INS1 _ N1
*                    INS2 _ N2 (OPTIONAL) 
*                    INS3 _ N3 (OPTIONAL) 
*                    INSMX _ 1 IF N1 ONLY GIVEN 
*                          _ 2 IF N1, N2 GIVEN
*                          _ 3 IF N1, N2, N3 GIVEN
*                    JSB IF.
* 
*     PARAMETERS USED:
*                    POINT
*                    SCALN
*                    REAK 
*                    IMAK 
*                    NA 
* 
*     CONSTANTS USED: 
*                    P9 
* 
*     SUBROUTINES CALLED: 
*                    UPL
*                    CHKN 
*                    RATOV
*                    INAS 
*                    OTAS 
*                    SFS7U
*                    NPROG
* 
* 
*     OPERATION:     EXECUTES "SKIP" : IF N1 (N2) (N3) COMMAND. 
*                    EXAMINES THE DATA VALUES OF BLOCK N1 (FROM 
*                    POINT OR HARMONIC N2 TO POINT OR HARMONIC
*                    N3) AND IF AT LEAST ONE DATA IS NEGATIVE,
*                    INCREMENTS THE PROGRAM STACK POINTER (POINT) 
*                    TO SKIP THE NEXT INSTRUCTION.
*                    IF BLOCK N1 IS IN POLAR COORDINATES, EXAMINES
*                    MAGNITUDE ONLY.
* 
*     NORMAL RETURN: IF IN THE PROGRAM STACK (XEQFG = 1)
*                    THEN RETURNS IF A NEGATIVE NUMBER HAS BEEN 
*                    ENCOUNTERED IN THE GIVEN RANGE, OR WHEN THE
*                    GIVEN RANGE OF POINTS HAVE BEEN TESTED.
* 
*     ERROR CONDITIONS: 
*                    IF NOT IN THE PROGRAM STACK (XEQFG = 0)
*                    THEN "WHAT" MESSAGE RESULTS. 
*                    IF BLOCK N1 OR RANGE SPECIFIED BY N2 & N3 IS 
*                    INVALID, THEN "WHAT" MESSAGE RESULTS.
*                    RETURN IS TO CNTRL TO RESTART FOURIER
*                    PROGRAM. 
* 
      SKP 
*                     NAM IF. 
      ENT IF. 
      EXT UPL 
      EXT CHKN
      EXT RATOV 
      EXT POINT 
      EXT SCALN 
      EXT P9
      EXT INAS
      EXT REAK
      EXT IMAK
      EXT OTAS
      EXT NA
      EXT SFS7U 
      EXT NPROG 
* 
* 
* 
IF.   NOP 
      JSB CHKN
      JSB NPROG 
      LDA NA
      JSB SFS7U 
      JMP *-1 
      LDA SCALN 
      AND P9
      STA TEMPA 
      JSB RATOV 
      CLB 
      STB IMAK
LOOP  JSB OTAS
      LDB REAK
      SSB 
      JMP SKIP
      LDB IMAK
      LDA TEMPA 
      SZA 
      CLB           DPREC OR
      SSB           POLAR 
      JMP SKIP
      JSB INAS
      JMP LOOP
      JMP IF.,I 
SKIP  LDA POINT 
      INA 
      JSB UPL 
      STA POINT 
      JMP IF.,I 
* 
TEMPA BSS 1 
A     EQU 0 
B     EQU 1 
      END 
                                                                                                                                       