{$nomain}
{$nowalkback}
{$norangecheck}
{$nohelpfromabove}

{a+,b+}

{SAYERROR       ~descr'
{************************************************************************

        This software is licensed for use only at a single site.  It
        may be copied  with the inclusion of this  copyright notice.
        This software, or any other  copies thereof, may not be made
        available to  or distributed to  any person or  site without
        written approval of an  authorized representative of  Oregon
        Minicomputer Software, Inc.   Ownership of this  software is
        held by Oregon Minicomputer Software, Inc.   The information
        in this software is subject to change without notice. Oregon
        Minicomputer Software assumes no responsibility for  the use
        or reliability of its software if modified without the prior
        written consent of Oregon Minicomputer Software, Inc.

        Copyright (C) 1982 Oregon Minicomputer Software, Inc.
        Oregon Software and OMSI PASCAL are trademarks
        of Oregon Minicomputer Software, Inc.

************************************************************************

 Last modified by [2,44] on 17-Jul-1984 15:22:16
 Purpose:
.if eq 1
UPDATE TO 2.1D
.endc
}

{This routine is called by an RT-11 user to decode and print rt-11
operating system specific errors}


procedure SayError(status_code: integer);
  external;


procedure sayerror;

  const
    Channel_Used = 'Channel in use';
    Past_EOF = 'Past end of file';
    Hardware_Error = 'Hardware error';
    Channel_Not_Open = 'Channel not open';

  type
    error_number_type = (zero, one, two, three, four, five, six, seven);
    rt_function_type = (empty0, lookup, enter, fetch, csispc, rread, rwrite,
                        rclose, dstat, spfun, empty10, empty11, empty12,
                        empty13, empty14, empty15);
    sign_bit_type = (positive, negative);

    coded_word =
      packed record
        error_number: error_number_type;
        rt_function: rt_function_type;
        alignment: 0..377B; {take up 8 bits please}
        sign_bit: sign_bit_type;
      end;

  var
    rt_code:
      record
        case integer of
          1:
            (cw: coded_word);
          2:
            (w: integer);
      end;


  begin
    rt_code.w := status_code;
    with rt_code.cw do {unpack the coded word}
      begin
      if sign_bit = negative then {only negative errors can call sayerr}
        begin
        case rt_function of
          lookup:
            begin
            write('.LOOKUP-');
            case error_number of
              zero:
                write(Channel_used);
              one:
                write('File not found');
              end;
            end;
          enter:
            begin
            write('.ENTER-');
            case error_number of
              zero:
                write(channel_used);
              one:
                write('Not enough room on device');
              two:
                write('File exists and is protected');
              end;
            end;
          fetch:
            begin
            write('.FETCH-');
            case error_number of
              zero:
                write('Device not installed/no handler');
              four:
                write('No heap space for handler');
              end;
            end;
          dstat:
            begin
            write('.DSTAT-');
            case error_number of
              zero:
                write('Device not found in tables');
              end;
            end;
          spfun:
            begin
            write('.SPFUN-');
            case error_number of
              zero:
                write(past_eof, ' or invalid function');
              one:
                write(hardware_error);
              three:
                write(channel_not_open);
              end;
            end;
          csispc:
            begin
            write('.CSISPC-');
            case error_number of
              zero:
                write('Invalid command line');
              one:
                write('Invalid device');
              end;
            end;
          rread:
            begin
            write('.READ-');
            case error_number of
              zero:
                write(Past_EOF);
              one:
                write(hardware_error);
              two:
                write(channel_not_open);
              end;
            end;
          rwrite:
            begin
            write('.WRITE-');
            case error_number of
              zero:
                write(Past_EOF);
              one:
                write(hardware_error);
              two:
                write(channel_not_open);
              end;
            end;
          rclose:
            begin
            write('.CLOSE');
            case error_number of
              zero:
                write(
                   'Protected file on device.  Two files with same name exist'
                      );
              end;
            end;
          otherwise
            writeln('Unknown RT-11 error condition');
          end {case} ;
        writeln;
        end; {if sign_bit}
      end; {with rt_code}
  end; {Say Error}
                                                                                                                                                                                                      