{ NOTICE OF COPYRIGHT AND OWNERSHIP OF SOFTWARE:

  Copyright 1980, 1981, 1982 by Oregon Software, Inc.
  All Rights Reserved.

  Whether this program is copied in whole or in part and whether this
  program is copied in original or in modified form, ALL COPIES OF THIS
  PROGRAM MUST DISPLAY THIS NOTICE OF COPYRIGHT AND OWNERSHIP IN FULL.

  Symbol Table code for PB
  Release version: 2.1A  Level: 2  Date: 10-Jul-1983 20:18:09
  Processor: ALL
  System: ALL
}

{ SYMCOD, Symbol Table Manager (code section); release 1.5 }

  procedure SetNilCookie { (var ptr: MagicCookie) };
  begin
    ptr.num := 0; ptr.idx := 0;
  end;

  function IsNilCookie { (ptr: MagicCookie): boolean };
  begin
    IsNilCookie := (ptr.num = 0) and (ptr.idx = 0);
  end;

  procedure AccNode { (ptr: MagicCookie; how: AccessType) };
  { Set up a node for access (make sure it is in a buffer). }
  var
    p: NodeBufferPointer;
    i: NodeCacheIndex;
    a: BufferAge;
  begin
    if NodeTable[ptr.num] = nil then begin
      if CurNodeCacheIndex < MaxNodeCache then begin
        { allocate a new buffer }
        new(p);
        CurNodeCacheIndex := CurNodeCacheIndex + 1;
        NodeCache[CurNodeCacheIndex] := p;
        end
      else begin
        { steal the oldest buffer }
        a := 0;
        for i := 1 to MaxNodeCache do with NodeCache[i]^ do
          if (CurNodeAge - age) > a then begin
            a := CurNodeAge - age;
            p := NodeCache[i];
            end;
        with p^ do begin
          if dirty then begin
            seek(NodeFile, num); write(NodeFile, blk);
            end;
          NodeTable[num] := nil;
          end;
        end;
      { connect buffer to desired block }
      NodeTable[ptr.num] := p;
      with p^ do begin
        num := ptr.num;
        dirty := false;
        if how < WriteAccess then begin
          seek(NodeFile, num); read(NodeFile, p^.blk);
          end;
        end;
      end;
    with NodeTable[ptr.num]^ do begin
      { update age of buffer }
      age := CurNodeAge;
      CurNodeAge := CurNodeAge + 1;
      { update dirty flag }
      if how > ReadAccess then dirty := true;
      end;
  end;

  procedure AccString { (ptr: MagicCookie; how: AccessType) };
  { Set up a string for access (make sure it is in a buffer). }
  var
    p: StringBufferPointer;
    i: StringCacheIndex;
    a: BufferAge;
  begin
    if StringTable[ptr.num] = nil then begin
      if CurStringCacheIndex < MaxStringCache then begin
        { allocate a new buffer }
        new(p);
        CurStringCacheIndex := CurStringCacheIndex + 1;
        StringCache[CurStringCacheIndex] := p;
        end
      else begin
        { steal the oldest buffer }
        a := 0;
        for i := 1 to MaxStringCache do with StringCache[i]^ do
          if (CurStringAge - age) > a then begin
            a := CurStringAge - age;
            p := StringCache[i];
            end;
        with p^ do begin
          if dirty then begin
            seek(StringFile, num); write(StringFile, blk);
            end;
          StringTable[num] := nil;
          end;
        end;
      { connect buffer to desired block }
      StringTable[ptr.num] := p;
      with p^ do begin
        num := ptr.num;
        dirty := false;
        if how < WriteAccess then begin
          seek(StringFile, num); read(StringFile, p^.blk);
          end;
        end;
      end;
    with StringTable[ptr.num]^ do begin
      { update age of buffer }
      age := CurStringAge;
      CurStringAge := CurStringAge + 1;
      { update dirty flag }
      if how > ReadAccess then dirty := true;
      end;
  end;

  procedure NewNode { (var ptr: MagicCookie) };
  { Allocate a new node in the node file. }
  var how: AccessType;
  begin
    if CurNodeBlockIndex < MaxNodeBlockIndex then begin
      CurNodeBlockIndex := CurNodeBlockIndex + 1;
      how := ReadWriteAccess;
      end
    else begin
      CurNodeBlockNum := CurNodeBlockNum + 1;
      CurNodeBlockIndex := 0;
      NodeTable[CurNodeBlockNum] := nil;
      how := WriteAccess;
      end;
    ptr.idx := CurNodeBlockIndex;
    ptr.num := CurNodeBlockNum;
    AccNode(ptr, how);
    with NodeTable[CurNodeBlockNum]^.blk[CurNodeBlockIndex] do begin
      SetNilCookie(lab);
      SetNilCookie(next);
      key := OtherKey;
      end;
  end;

  procedure NewString { (var str: StringBlock; var ptr: MagicCookie) };
  { Save new string in string file. }
  var
    i, n: StringBlockIndex;
    how: AccessType;
  begin
    n := ord(str[0]);
    if (CurStringBlockIndex + n) < MaxStringBlockIndex then begin
      CurStringBlockIndex := CurStringBlockIndex + 1;
      how := ReadWriteAccess;
      end
    else begin
      CurStringBlockNum := CurStringBlockNum + 1;
      CurStringBlockIndex := 0;
      StringTable[CurStringBlockNum] := nil;
      how := WriteAccess;
      end;
    ptr.idx := CurStringBlockIndex;
    ptr.num := CurStringBlockNum;
    AccString(ptr, how);
    for i := 0 to n do
      StringTable[CurStringBlockNum]^.blk[CurStringBlockIndex + i] := str[i];
    CurStringBlockIndex := CurStringBlockIndex + n;
  end;

  procedure WrtString { (var f: text; ptr: MagicCookie) };
  { Write a string to a file. }
  var i: StringBlockIndex;
  begin
    if IsNilCookie(ptr) then
      write(f, '(nil)')
    else begin
      AccString(ptr, ReadAccess);
      with StringTable[ptr.num]^ do
        for i := ptr.idx + 1 to ptr.idx + ord(blk[ptr.idx]) do
          write(f, blk[i]);
      end;
  end;

  procedure IniSymbol;
  { Initialize Symbol Table. }
  var i: HashIndex;
  begin
    for i := 0 to HashSize - 1 do SetNilCookie(HashTab[i]);

    rewrite(NodeFile, , DirectAccess);
    CurNodeBlockNum := 0;
    CurNodeBlockIndex := MaxNodeBlockIndex;
    CurNodeCacheIndex := 0;
    CurNodeAge := 0;

    rewrite(StringFile, , DirectAccess);
    CurStringBlockNum := 0;
    CurStringBlockIndex := MaxStringBlockIndex;
    CurStringCacheIndex := 0;
    CurStringAge := 0;
  end;

  procedure LocSymbol
  { (var sym: StringBlock; k: KeyType; var ptr: MagicCookie) };
  { Locate (or create if necessary) a node in the symbol table. }
  label 10;
  var
    hash: HashIndex;
    n, i: StringBlockIndex;
    qtr: MagicCookie;
  begin
    { compute initial hash function }
    n := ord(sym[0]); hash := ord(k) + n;
    for i := 1 to n do
      hash := (hash * 2 + ord(sym[i])) mod HashSize;

    ptr := HashTab[hash];
    SetNilCookie(qtr);
    while true do begin
      if IsNilCookie(ptr) then begin
        { add to symbol table }
        NewNode(ptr);
        if IsNilCookie(qtr) then
          HashTab[hash] := ptr
        else begin
          AccNode(qtr, ReadWriteAccess);
          NodeTable[qtr.num]^.blk[qtr.idx].next := ptr;
          end;
        NewString(sym, NodeTable[ptr.num]^.blk[ptr.idx].lab);
        goto 10;
        end;

      { check for match }
      AccNode(ptr, ReadAccess);
      with NodeTable[ptr.num]^.blk[ptr.idx] do begin
        if k = key then begin
          AccString(lab, ReadAccess);
          i := 0;
          with StringTable[lab.num]^ do begin
            while blk[lab.idx + i] = sym[i] do begin
              if i = n then goto 10;
              i := i + 1;
              end;
            end;
          end;
        qtr := ptr;
        ptr := next;
        end;
      end;
    10:;
  end;

  procedure ChkSymbol
  { (var sym: StringBlock; k: KeyType; var ptr: MagicCookie) };
  { Locate a node in the symbol table. }
  label 10;
  var
    hash: HashIndex;
    n, i: StringBlockIndex;
  begin
    { compute initial hash function }
    n := ord(sym[0]); hash := ord(k) + n;
    for i := 1 to n do
      hash := (hash * 2 + ord(sym[i])) mod HashSize;

    ptr := HashTab[hash];
    while not IsNilCookie(ptr) do begin
      { check for match }
      AccNode(ptr, ReadAccess);
      with NodeTable[ptr.num]^.blk[ptr.idx] do begin
        if k = key then begin
          AccString(lab, ReadAccess);
          i := 0;
          with StringTable[lab.num]^ do begin
            while blk[lab.idx + i] = sym[i] do begin
              if i = n then goto 10;
              i := i + 1;
              end;
            end;
          end;
        ptr := next;
        end;
      end;
    10:;
  end;
                                                                                                                                                                                                                               