{ NOTICE OF COPYRIGHT AND OWNERSHIP OF SOFTWARE:

  Copyright 1983 by Oregon Software, Inc.
  All Rights Reserved.

  Whether this program is copied in whole or in part and whether this
  program is copied in original or in modified form, ALL COPIES OF THIS
  PROGRAM MUST DISPLAY THIS NOTICE OF COPYRIGHT AND OWNERSHIP IN FULL.

  Temporary output file management routines
  Release version: 2.0L  Level: 1  Date: 23-Mar-1983 17:52:59
  Processor: PDP11
  System: RSX11,RSTS/E,RT11
}

  procedure FixOutputArg(perm: ArgValue; var temp: ArgValue);

  { Construct a temporary output filename, based on a permanent output
    filename. }

  { On RSX, RSTS, and RT-11 systems the temporary file name consists
    of the output file name with the extension 'tmp' substituted }

  const TmpExt = 'tmp';
  var
    i: iArgValue;

  begin
    CleanupArg(perm);
    temp.len := 0;
    AppendToArg(temp, perm, 1, SkipToDelim(perm, 1, ['.', ';']) - 1);
    temp.len := temp.len + 1;
    temp.txt[temp.len] := '.';
    for i := 1 to 3 do begin
      temp.len := temp.len + 1;
      temp.txt[temp.len] := TmpExt[i];
      end;
    CleanupArg(temp);
  end;


  procedure FixTempOutput
    (temp, perm: ArgValue; succ: boolean; var status: boolean);

  { Turn a temporary output file into a permanent one, return error
    indication if it can't be done. }

  { On RSX, RSTS, and RT-11 systems, fixup consists of renaming the
    temporary file to the permanent file name. }

  var
    inp: packed file of char;
    flg: integer;

   begin
    status := false;
    reset(inp, temp.txt, , flg);{get a file variable}
    if flg <> -1 then begin
      if succ then begin
        rename(inp, perm.txt);
        close(inp);
        end;
      if not succ then delete(inp);
      status := true;
      end;
  end;
                                                                                                                                                                                             