{$nomain} {$nowalkback}
{[a+,b+]}
{$E+ - Pascal 1}
PROGRAM uerror;

{
  This procedure is called by the Pascal support library to process
  run-time errors.

  Now generalized for RSTS/RT/RSX and Pascal-1/Pascal-2

}

  CONST
    DumpMemory = false; { Print a memory map }
    DumpFile = false; { Print detailed file dump }
    PrintErrorText = false; { Print text for I/O errors }

  TYPE

    ErrorNumberandClass = integer; {High byte is error class, with bit 0 of
                                    the high byte indicating either an I/O
                                    error (if set) or a Fatal error (if
                                    zero). Low byte is error number in range
                                    0..255 and can be mapped to support
                                    library error codes in OPCOM.MAC or the
                                    user manual}

    TextPointer = ^text; { Address of a text file }

    ErrorBlock =
      RECORD
        ErrCode: ErrorNumberandClass; {High = class, Low = number}
        Xfile: TextPointer; { Pointer to file causing problem }
        IoStatus: integer; { I/O status if a file }
        UserPc: 0..65535; { Address of error }
      END;


  PROCEDURE sayerr(status: integer); { Print text for I/O error code }
    EXTERNAL;


  PROCEDURE fdump(VAR f: text); { Dump file data structures }
    EXTERNAL;


  PROCEDURE memmap; { Print memory usage map }
    EXTERNAL;


  PROCEDURE p$uerror(VAR err: ErrorBlock); { Called by library by error }

   {** remove the next two lines of code for Pascal-1 systems **}

    EXTERNAL; {remove for Pascal-1}

  PROCEDURE p$uerror; {remove for Pascal-1}

    BEGIN
      with err do
        BEGIN
        IF ErrCode div 256 = 1 THEN {was it an I/O error}
          BEGIN
          IF PrintErrorText THEN sayerr(IoStatus);
          IF DumpFile THEN fdump(Xfile^);
          END;
        IF DumpMemory THEN memmap;
        END;
    END;
                              