/*
 * PTTC/6 to ASCII
 *
 *      lc    uc                      lc     uc
 *
 * 00                            40   -      _
 * 01   1     =                  41   j      J
 * 02   2                        42   k      K
 * 03   3     ;                  43   l      L
 * 04   4     :                  44   m      M
 * 05   5     %                  45   n      N 
 * 06   6     '                  46   o      O
 * 07   7     "                  47   p      P
 * 10   8     *                  50   q      Q
 * 11   9     (                  51   r      R
 * 12   0     )                  52   <       
 * 13   #     +/-                53   $
 * 14   <pn>  <pn>               54   <res>   
 * 15   <rs>  <rs>               55   <nl>
 * 16   <uc>  <uc>               56   <bs>    
 * 17   <eot> <eot>              57   <il>
 * 20   @     <cent>             60   &      O
 * 21   /     ?                  61   a      A
 * 22   s     S                  62   b      B
 * 23   t     T                  63   c      C
 * 24   u     U                  64   d      D
 * 25   v     V                  65   e      E
 * 26   w     W                  66   f      F
 * 27   x     X                  67   g      G
 * 30   y     Z                  70   h      H
 * 31   z     Z                  71   i      I
 * 32   <rm>  <gm>               72   >      <tm>
 * 33   ,     6                  73   .
 * 34   <byp> C                  74   <pf>   V
 * 35   <lf>  <upper score>      75   <ht>
 * 36   <eob>                    76   <lc>
 * 37   <pre>                    77   <del>
 *
 */

#include <stdio.h>

// upper case table
//
char cvt[] = { ' ', '1', '2', '3', '4', '5', '6', '7',     /* 00 - 07 */
               '8', '9', '0', '#', 'I', '/', 'U', '2',     /* 10 - 17 */
                0 , '?', 'S', 'T', 'U', 'V', 'W', 'X',     /* 20 - 27 */
               'Y', 'Z', 'F', '6', 'C',  0 ,  0 ,  0 ,     /* 30 - 37 */
               'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q',     /* 40 - 47 */
               'R',  0 , 'Y',  0 , 'P',  0 , 'Q',  0 ,     /* 50 - 57 */
               'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H',     /* 60 - 67 */
               'I',  0 , 'X',  0 , 'V',  0 , '0',  0       /* 70 - 77 */
        };

// lower case table
//
char cvtl[] ={ ' ', '1', '2', '3', '4', '5', '6', '7',     /* 00 - 07 */
               '8', '9', '0', '4', 'i', '+', 'u', '2',     /* 10 - 17 */
                0 , 's', 't', 'u', 'v', 'w', 'x', 'y',     /* 20 - 27 */
               'z', ',', 'f', '6', 'c',  0 ,  0 ,  0 ,     /* 30 - 37 */
               '-', 'j', 'z','\b', 'l','\t', 'w',  0 ,     /* 40 - 47 */
               'h',  0 , 'y',  0 , 'p',  0 , 'q',  0 ,     /* 50 - 57 */
               '&', 'a', 'b', 'c', 'd', 'e', 'f', 'g',     /* 60 - 67 */
               'h', 'i', 'x',  0 , 'v',  0 , '0',  0       /* 70 - 77 */
        };
main()
{
        char c;
        int state = 0;

        while(!feof(stdin)){
                c = getchar() & 0x3f;
                if (c == 076) {state = 0; continue;}    /* lower case */
                if (c == 006) {state = 1; continue;}    /* upper case */
                
                if(state){
                 if(cvt[c] == 0) { printf(">>%02o<<",c); continue;}
                 putchar(cvt[c]);
                }
                else{
                 if(cvtl[c] == 0) {printf(">>%02o<<",c); continue;}
                 putchar(cvtl[c]);
                }
        }
}
