/*
 * Flexowriter to ASCII
 *
 *      lc    uc                      lc     uc
 *
 * 00                            40   t      T
 * 01                            41  
 * 02   e     E                  42   z      Z
 * 03   8     8                  43   <bs>
 * 04                            44   l      L
 * 05   |     _                  45   <tab>
 * 06   a     A                  46   w      W
 * 07   3     3                  47  
 * 10   <sp>                     50   h      H
 * 11   =     <midDot>           51   <cr>
 * 12   s     S                  52   y      Y
 * 13   4     4                  53  
 * 14   i     I                  54   p      P
 * 15   +     /                  55  
 * 16   u     U                  56   q      Q
 * 17   2     2                  57  
 * 20   <color shift>            60   o      O
 * 21   .     )                  61   <stop>
 * 22   d     D                  62   b      B
 * 23   5     5                  63
 * 24   r     R                  64   g      G
 * 25   1     1                  65
 * 26   j     J                  66   9      9
 * 27   7     7                  67
 * 30   n     N                  70   m      M
 * 31   ,     (                  71   <uc>
 * 32   f     F                  72   x      X
 * 33   6     6                  73
 * 34   c     C                  74   v      V
 * 35   -     <upper score>      75   <lc>
 * 36                            76   0      0   // upper case digits are 'small'
 * 37                            77   <del>
 *
 */

#include <stdio.h>

// upper case table
//
char cvt[] = {  0 ,  0 , 'E', '8',  0 , '_', 'A', '3',     /* 00 - 07 */
               ' ', '.', 'S', '4', 'I', '/', 'U', '2',     /* 10 - 17 */
                0 , ')', 'D', '5', 'R', '1', 'J', '7',     /* 20 - 27 */
               'N', '(', 'F', '6', 'C',  0 ,  0 ,  0 ,     /* 30 - 37 */
               'T',  0 , 'Z','\b', 'L','\t', 'W',  0 ,     /* 40 - 47 */
               'H',  0 , 'Y',  0 , 'P',  0 , 'Q',  0 ,     /* 50 - 57 */
               'O',  0 , 'B',  0 , 'G',  0 , '9',  0 ,     /* 60 - 67 */
               'M',  0 , 'X',  0 , 'V',  0 , '0',  0       /* 70 - 77 */
        };

// lower case table
//
char cvtl[] ={  0 ,  0 , 'e', '8',  0 , '|', 'a', '3',     /* 00 - 07 */
               ' ', '=', 's', '4', 'i', '+', 'u', '2',     /* 10 - 17 */
                0 , '.', 'd', '5', 'r', '1', 'j', '7',     /* 20 - 27 */
               'n', ',', 'f', '6', 'c',  0 ,  0 ,  0 ,     /* 30 - 37 */
               't',  0 , 'z','\b', 'l','\t', 'w',  0 ,     /* 40 - 47 */
               'h',  0 , 'y',  0 , 'p',  0 , 'q',  0 ,     /* 50 - 57 */
               'o',  0 , 'b',  0 , 'g',  0 , '9',  0 ,     /* 60 - 67 */
               'm',  0 , 'x',  0 , 'v',  0 , '0',  0       /* 70 - 77 */
        };
main()
{
        char c;
        int state = 0;

        while(!feof(stdin)){
                c = getchar() & 0x3f;
                if (c == 075) {state = 0; continue;}    /* lower case */
                if (c == 071) {state = 1; continue;}    /* upper case */
                
                if(state){
                 if(cvt[c] == 0) { printf(">>%02o<<",c); continue;}
                 putchar(cvt[c]);
                }
                else{
                 if(cvtl[c] == 0) {printf(">>%02o<<",c); continue;}
                 putchar(cvtl[c]);
                }
        }
}
