
/* readvol.c - Read a UCSD disk image file's volume descriptor */
/* Copyright 1994 Syndesis Corporation */
/* July 12, 1990 */

#include <stdio.h>
#include <string.h>

#include "diskdecl.h"

#include "ucsddecl.h"
#include "ucsdvars.h"


/* Read in a dirRoot struct, the volume info */

USHORT ucsdReadVolInfo( FILE *infp, ucsdDirRoot *root )
{
USHORT lerr;


    /* Sniff endian of disk image */
    if ((lerr=determineEndian( infp )) != TE_NOERROR) {
        puts( "Failed determining endian." );
        goto out;
    }

    /* Read the volume info into dirRoot, from block 2 of the disk */
    fseek( infp, (long) (UCSD_BLK_SIZE * 2), SEEK_SET );

    /* printf( "Volume info at 0x%lx\n", ftell( infp ) ); */

    /* Read each element */
    if ((lerr=getShort( infp, &root->firstBlk )) != TE_NOERROR) {
        goto out;
    }
    if ((lerr=getShort( infp, &root->lastBlk )) != TE_NOERROR) {
        goto out;
    }
    if ((lerr=getShort( infp, &root->fileKind )) != TE_NOERROR) {
        goto out;
    }

    if (fread( &root->volName, (size_t) 8, (size_t) 1, infp ) != 1) {
        lerr = TE_BADREAD;
        goto out;
    }

    unPascalStr( &root->volName[0] );

    if ((lerr=getShort( infp, &root->eovBlk )) != TE_NOERROR) {
        goto out;
    }

    if ((lerr=getShort( infp, &root->numFiles )) != TE_NOERROR) {
        goto out;
    }

    if ((lerr=getShort( infp, &root->loadTime )) != TE_NOERROR) {
        goto out;
    }
    if ((lerr=getShort( infp, &root->lastBoot )) != TE_NOERROR) {
        goto out;
    }

    /* Four bytes left over before first file directory entry */

    lerr = TE_NOERROR;
out:
    return lerr;
} 

