; ------ CORVUS SEMAPHORE TEST PROGRAM ------
;		VERSION 1.3S/TT  
;		  BY BRK
;
;$I CRVSYS.S		; SYSTEM EQUATES
;	----	S100/TRS80 II9 PORT ADDRESSES & MASKS	----
;
STAT	EQU	0DFH	; STATUS I/O PORT
DATA	EQU	0DEH	; DATA I/O PORT
DRDY	EQU	1	; MASK FOR DRIVE READY BIT
DRDYST	EQU	0	; IF BIT 0 = 0 THEN DRIVE READY
DIFAC	EQU	2	; MASK FOR DRIVE ACTIVE BIT
HTD	EQU	2	; IF BIT 1 SET THEN HOST-TO-DRIVE STATUS
DTH	EQU	0	; IF BIT 1 = 0 THEN DRIVE-TO-HOST
;
;
;
;$I SEMA4.BDY
;
;	THIS PROGRAM IS DESIGNED TO ILLUSTRATE THE USE OF THE
;	'SEMAPHORES' ON THE CORVUS DRIVE.  THIS PROGRAM CAN:
;	    1.  TEST AND LOCK (SET) A SPECIFIC SEMAPHORE.
;	    2.  TEST AND UNLOCK (CLEAR) A SPECIFIC SEMAPHORE.
;	    3.  CLEAR THE SEMAPHORE KEY TABLE.
;	THE MAJOR USE OF THIS PROGRAM IS AS AN EXAMPLE OF THE
;	ASSEMBLY LANGUAGE PROTOCOL NEEDED TO CONTROL THE
;	SEMAPHORES.  THIS PROGRAM CAN ONLY LOCK OR UNLOCK
;	SEMAPHORES WITH ALPHA-NUMERIC NAMES.  HOWEVER, THE
;	EIGHT BYTE SEMAPHORE NAME CAN CONSIST OF ANY
;	COMBINATION OF 8 BIT CHARACTERS.
;
;
;
; ---- CP/M EQUATES -----
;
BDOS	EQU	05	; BDOS ENTRY POINT
CHIN	EQU	1	; BDOS COMMAND FOR CONSOLE INPUT
CHOUT	EQU	2	; BDOS COMMAND FOR CONSOLE OUTPUT
LST	EQU	9	; BDOS COMMAND FOR WRITE LIST
RDBUF	EQU	10	; BDOS COMMAND TO READ BUFFER
;
CR	EQU	0DH	; CARRIAGE RETURN
LF	EQU	0AH	; LINE FEED
;
;
; ---- CORVUS DISC EQUATES ----
;
VERCOM	EQU	0	; READ VERSION # AND # OF DRIVES COMMAND
SEMCOM	EQU	0BH	; SEMAPHORE COMMAND
LCOM	EQU	1H	; LOCK SUB-COMMAND
ULCOM	EQU	11H	; UNLOCK SUB-COMMAND
;
;
;
	ORG 100H	; STANDARD CP/M TPA ORIGIN
;
START:	LXI	H,0
	DAD	SP	; GET STACK POINTER IN (H,L)
	SHLD	SBUF	; SAVE IT
;   -- SETUP DIRECT CONSOLE I/O JUMPS ---
	LHLD	1	; GET ADDRESS OF WARM BOOT (BIOS+3)
	LXI	D,3
	DAD	D	; COMPUTE ADDRESS OF CONST
	SHLD	CONST+1	; PATCH IN JUMP
	DAD	D
	SHLD	CONIN+1
	DAD	D
	SHLD	CONOUT+1
	JMP	SIGNON	; SIGN ON AND START PROGRAM
;
CONST:	JMP	0	; JUMP TO BIOS ROUTINES
CONIN:	JMP	0
CONOUT:	JMP	0
;
SIGNON:	LXI	SP,STACK	;SETUP LOCAL STACK
	LXI	D,SMSG		;POINT TO MESSAGE
	CALL	PTMSG		; PRINT SIGN ON MESSAGE
Q1:	LXI	D,MSG2
MN0:	CALL	PTMSG		; LIST TASK MENU
MN1:	LXI	SP,STACK	;RESET STACK
	LXI	D,MSG3
	CALL	PTMSG		; ASK FOR CHOICE
MN2:	CALL	CONNC		; GET THE TASK
	LXI	H,TSKTAB	; POINT TO TASK TABLE
	MVI	B,(TSKTBE-TSKTAB)/3	; # TASKS IN TABLE
	CALL	STAB		;  LOOK FOR COMMAND IN TABLE
	JC	MN2		; DIDN'T FIND IT, SO TRY AGAIN
	PUSH	D		; PUT COMMAND ADDRESS IN STACK
	CALL	COUT		; ECHO COMMAND
	LXI	D,CRLF
	JMP	PTMSG		; CRLF AND VECTOR TO COMMAND
;
; --- TASK TABLE ---
;
TSKTAB:	EQU	$
	DB	'0'		; COMMAND INDENTIFIER
	DW	Q1		; COMMAND ADDRESS
	DB	'H'
	DW	INST
	DB	'L'
	DW	LOCK
	DB	'U'
	DW	UNLOCK
	DB	'C'
	DW	CLEAR
	DB	'Q'
	DW	EXIT
TSKTBE	EQU	$		; END OF TASK TABLE
;
;
; --- LIST INSTRUCTIONS COMMAND ---
;
INST:	LXI	D,MSGI
	JMP	MN0
;
; --- LOCK SEMAPHORE COMMAND ---
;
LOCK:	CALL	INITX		; RE-SYNC CONTROLLER AND CHECK
				; CODE VERSION
	JC	CDERR		; IF WRONG CODE VERSION
	MVI	A,80H
	STA	LSTAT		; NOTE THAT COMMAND WAS 'LOCK'
	CALL	GTNAM		; ASK FOR AND GET SEMAPHORE NAME
	MVI	A,SEMCOM	; GET SEMAPHORE COMMAND
	CALL	WAITO		; SEND IT TO CONTROLLER
	MVI	A,LCOM		; GET LOCK COMMAND
	CALL	WAITO		; SEND IT TO CONTROLLER
	JMP	OUTKEY		; OUTPUT KEY AND LIST STATUS
;
; --- UNLOCK SEMAPHORE COMMAND ---
;
UNLOCK:	CALL	INITX		; RE-SYNC CONTROLLER AND CHECK
				; CODE VERSION
	JC	CDERR		; IF WRONG CODE VERSION
	MVI	A,0
	STA	LSTAT		; NOTE THAT COMMAND WAS 'UNLOCK'
	CALL	GTNAM		; ASK FOR AND GET SEMAPHORE NAME
	MVI	A,SEMCOM	; GET SEMAPHORE COMMAND
	CALL	WAITO		; SEND IT TO CONTROLLER
	MVI	A,ULCOM		; GET UNLOCK COMMAND
	CALL	WAITO		; SEND IT TO CONTROLLER
OUTKEY:	LXI	H,KEY		; POINT TO KEY NAME
	MVI	C,8		; LENGTH OF KEY
OTK1:	MOV	A,M		; GET KEY BYTE
	CALL	WAITO		; SEND KEY BYTE
	INX	H		; POINT TO NEXT BYTE OF KEY
	DCR	C		; COUNT DOWN LENGTH OF KEY
	JNZ	OTK1		; LOOP UNTIL KEY IS SENT
WERR:	CALL	RETX		; PROCESS RETURN BYTES
	CNC	SDSP		; IF NO ERROR, DISPLAY SEMAPHORE STATUS
	JMP	MN1		; BACK TO MENU
;
; --- CLEAR KEY TABLE COMMAND ---
;
CLEAR:	CALL	INITX		; RE-SYNC CONTROLLER AND CHECK
				; CODE VERSION
	JC	CDERR		; IF WRONG CODE VERSION
	LXI	D,MSG5
	CALL	PTMSG		; ASK 'DO YOU REALLY WANT TO DO THIS'
	CALL	YES		; GET RESPONSE
	LXI	D,CRLF
	JNZ	MN0		; IF NOT, BACK TO MENU
;
	LDA	VERNUM		; GET FIRMWARE VERSION # RETURNED
	CPI	8FH		; TEST FOR ILLEGAL COMMAND (' REV B')
	JNZ	CLR1		; IF NOT 'REV B' DRIVE VERSION
;
	MVI	A,SEMCOM+0FH	; GET 'CLEAR' COMMAND ('REV B' DRIVES)
	CALL	WAITO		; SEND IT TO CONTROLLER
	MVI	A,ULCOM-1	; GET CLEAR COMMAND
	CALL	WAITO		; SEND IT TO CONTROLLER
	XRA	A		; GET A ZERO
	CALL	WAITO		; SEND TWO ZEROS
	CALL	WAITO
	CALL	WAITO		; SEND A THIRD ZERO FOR 'REV B'
	JMP	CLR2		; CONTINUE 
;
CLR1:	MVI	A,SEMCOM-1	; GET SEMAPHORE COMMAND (REV A)
	CALL	WAITO		; SEND IT TO CONTROLLER
	MVI	A,ULCOM-1	; GET CLEAR COMMAND
	CALL	WAITO		; SEND IT TO CONTROLLER
	XRA	A		; GET A ZERO
	CALL	WAITO		; SEND TWO ZEROS
	CALL	WAITO
CLR2:	CALL	RETX		; GET RETURN DATA FROM CONTROLLER
	LXI	D,CLMSG		; POINT TO "CLEAR" MESSAGE
	CALL	PTMSG		; SEND IT TO CONSOLE
	JMP	MN1		; BACK TO MENU
;
CDERR:	LXI	D,MSG6	; POINT TO ERROR MESSAGE
	JMP	MN0	; PRINT MESSAGE AND BACK TO MENU
;
; ------ SUBROUTINES & DATA ------
;
; --- READ BACK RETURN DATA FROM DRIVE AND LIST ERROR CODE ---
;
;	THIS ROUTINE WAITS FOR BUSS TURN AROUND AND
;	THEN RECEIVES ALL OF THE BYTES SENT BACK
;	BY THE CONTROLLER.  IT SAVES THESE IN THE
;	BUFFER: RTBUF.  NOTE, THIS ROUTINE USES THE
;	BUSS DIRECTION LINE TO DETERMINE WHEN TO START
;	AND STOP RECEIVING BYTES FROM THE DRIVE.  IN
;	THIS WAY IT IS INDEPENDENT OF THE NUMBER OF BYTES
;	RETURNED (EXCEPT FOR THE AMOUNT OF SPACE RESERVED
;	FOR  'RTBUF' ).  THIS IS NECESSARY BECAUSE SOME
;	TYPES OF DISC ERRORS MAY CHANGE THE NUMBER OF BYTES
;	RETURNED FOR THE 'SEMAPHORE' COMMANDS.
;
RETX:	CALL	TURN	; WAIT FOR BUSS TURN AROUND
	LXI	H,RTBUF	; POINT TO READ BUFFER
	CALL	GTBLK	; 1.3- GET RETURNED BYTES TIL BUS TURNS AROUND
	POP	B	; 1.3- GET RETURN COUNT INTO C
RT2:	LDA	RTBUF	; GET "RETURN CODE"
	MOV	B,A	; SAVE IT
	ANI	80H	; TEST FOR FATAL ERROR
	RZ		; RETURN IF OK
	MOV	A,B	; GET VALUE BACK
	PUSH	PSW	; NO, OTHER ERROR TYPE
	LXI	D,MSGE	; ERROR, SO ISSUE MESSAGE
	CALL	PTMSG
	POP	PSW	; GET ERROR BYTE BACK IN ACC
	CALL	HEXOT	; OUTPUT IN HEX
	LXI	D,MSGE1
RT3:	CALL	PTMSG
;
;
	CALL	INIT	; RE-SYNCHRONIZE CONTROLLER
	STC		; SET CARRY TO INDICATE ERROR
	RET
;
;
INITX:	CALL	INIT	; DO NORMAL INIT
			; THEN DO VCHK
;
; --- TEST CONTROLLER CODE VERSION AND CORRECT R/W COMMAND ---
;
VCHK:	MVI	A,VERCOM ;  GET COMMAND TO READ VERSION # AND # OF DRIVES
	CALL	WAITO	; SEND IT
	CALL	TURN	; WAIT FOR ACCEPTANCE
	CALL	WAITI	; GET ANSWER
	STA	VERNUM	; SAVE "VERSION # BYTE"
	ANI	0F0H	; MASK OUT # OF DRIVES
	CPI	20H	; TEST IF CONT. CODE >=2
	RET
;
;
;
; --- MESSAGE PRINT ROUTINE---
;
PTMSG:	MVI	C,LST	; CP/M WRITE LIST COMMAND
	JMP	BDOS	; EXECUTE BDOS COMMAND
;
; --- PRINT OUT STRING OF SPECIFIED LENGTH ---
;	(D,E) POINT TO STRING
;	 (B)  GIVES LENGTH
;
PRSTR:	LDAX	D	; GET CHAR.
	CALL	PRT	; PRINT IT OUT
	INX	D
	DCR	B
	JNZ	PRSTR	; LOOP UNTIL DONE
	RET
;
; --- OUTPUT BYTE IN ACC IN HEX ---
;
HEXOT:	PUSH	PSW	; SAVE BYTE
	RRC		; SHIFT UPPER NIBBLE DOWN
	RRC
	RRC
	RRC
	CALL	HEXB	; OUTPUT UPPER NIBBLE IN HEX
	POP	PSW	; GET BYTE BACK
HEXB:	ANI	0FH	; MASK OFF UPPER NIBBLE
	ADI	'0'	; ADD ASCII BIAS
	CPI	'9'+1	; TEST IF NUMERIC
	JC	PRT	; YES, SO DO IT
	ADI	7	; NO, SO ADD BIAS FOR A-F
PRT:	MOV	C,A	; SETUP FOR OUTPUT
COUT:	PUSH	PSW
	PUSH	H	; BUFFERED CONSOLE OUTPUT
	PUSH	D
	PUSH	B
	MOV	E,C
	MVI	C,CHOUT	; BDOS CHAR. OUTPUT COMMAND
	CALL	BDOS
	POP	B
	POP	D
	POP	H
	POP	PSW
	RET
;
; -- YES FUNCTION --
;
YES:	CALL	CONNC	; GET CONSOLE CHAR.
	CPI	'Y'	; IS IT A  Y?
	JZ	YES1
	CPI	'N'	; IS IT A  N?
	JNZ	YES	; IF NEITHER, KEEP TRYING
	INR	A	; SET  N  STATUS
YES1:	PUSH	PSW	; SAVE FLAGS
	CALL	CONOUT	; OUTPUT TO CONSOLE
	POP	PSW	; RESTORE FLAGS
	RET
CONNC:	CALL	CONIN	; GET CHAR. FROM CONSOLE
	MOV	C,A	; SAVE FOR ECHO
	CPI	60H	; IS IT LOWER CASE?
	JC	CON1	; NO, SO CONTINUE
	ANI	5FH	; YES, SO MASK TO UPPER CASE
CON1:	CPI	'C'-40H	; IS IT A CONTROL-C?
	RNZ		; NO, SO RETURN
CTC:	LXI	D,CMSG	; POINT TO CONTROL-C MESSAGE
EXMG:	CALL	PTMSG		; ISSUE MESSAGE 
EXIT:	LXI	D,CRLF
	CALL	PTMSG		; ISSUE A CRLF
	LHLD	SBUF		; GET OLD STACK POINTER
	SPHL			; SET STACK
	RET			; BACK TO CP/M
;
; --- SEARCH TABLE FOR MATCH AND GET ASSOC. ADDRESS ---
;	(H,L) POINT TO TABLE TO SEARCH
;	(B)   HAS THE # OF TABLE ELEMENTS
;	(C)   HAS THE BYTE TO MATCH WITH
;
STAB:	MOV	A,M	; GET TABLE VALUE
	INX	H	; POINT TO START OF ADDRESS
	CMP	C	; IS THERE A MATCH?
	JNZ	STB1	; NO, SO CONTINUE
	MOV	E,M	; GET LOWER BYTE OF ADDRESS
	INX	H
	MOV	D,M	; ADDRESS IN (D,E)
	RET
STB1:	INX	H	; SKIP OVER ADDRESS
	INX	H
	DCR	B	; COUNT DOWN COMMANDS
	JNZ	STAB	; LOOP THRU TABLE
	STC		; NO MATCH, SO SET ERROR
	RET
;
; --- GET SEMAPHORE NAME FROM CONSOLE AND SAVE IN KEY BUFFER ---
;
GTNAM:	MVI	C,8	; LENGTH OF KEY
	LXI	H,KEY	; POINT TO KEY BUFFER
GTN1:	MVI	M,' '	; FILL KEY WITH SPACES
	INX	H
	DCR	C
	JNZ	GTN1
;
GTN2:	LXI	D,NMSG
	CALL	PTMSG	; ASK FOR NAME
	LXI	D,TXBUF	; POINT TO INPUT BUFFER
	MVI	C,RDBUF	; GET BUFFER READ COMMAND
	CALL	BDOS	; INPUT TEXT STREAM
	LXI	H,TXBUF+1 ; POINT TO CHAR. COUNTER
	MOV	A,M	; GET IT
	INX	H
	ORA	A	; IS IT ZERO?
	JZ	GTN2	; YES, SO TRY AGAIN
	LXI	D,KEY	; POINT TO KEY BUFFER
	MOV	C,A	; GET LENGTH AS COUNTER
GTN3:	MOV	A,M	; GET CHAR.
	STAX	D	; SAVE IN KEY NAME
	INX	H
	INX	D
	DCR	C
	JNZ	GTN3	; COPY NAME TO KEY BUFFER
	RET
;
; --- DISPLAY KEY STATUS (FOR LOCK AND UNLOCK COMMANDS) ---
;
SDSP:	LDA	RTBUF+1	; GET RETURNED STATUS BYTE
	LXI	D,FLMSG	; POINT TO "TABLE FULL MESSAGE"
	CPI	0FDH	; IS TABLE FULL?
	JZ	PTMSG	; YES, PRINT ERROR MESSAGE AND RETURN
	LXI	D,RWMSG	; POINT TO "READ/WRITE " ERROR MESSAGE
	CPI	0FEH	; WAS THERE A "READ/WRITE" ERROR
	JZ	PTMSG	; YES, PRINT ERROR MESSAGE AND RETURN
	LXI	D,KEYX	; POINT TO KEY STRING
	CALL	PTMSG	; PRINT IT OUT
	LDA	LSTAT	; GET TYPE OF COMMAND USED
	CALL	LDSP	; DISPLAY STATUS
	LXI	D,KMSG1
	CALL	PTMSG	; ' , IT WAS'
	LDA	RTBUF+1	; GET PREVIOUS STATUS
	CALL	LDSP	; SHOW IT
	LXI	D,CRLF
	JMP	PTMSG
;
LDSP:	LXI	D,LKMSG	; POINT TO 'LOCK' MESSAGE
	CPI	80H	; WAS IT LOCKED?
	JZ	PTMSG	; YES, PRINT IT OUT
	LXI	D,ULKMSG ; NO, MUST BE UNLOCKED
	JMP	PTMSG
;
;
;$I GTBLK.IO		; GET A BLOCK OF UNDETERMINED LENGTH
;FILEID: GTBLK.IO
;
; --- GET A BLOCK OF UNDETERMINED LENGTH BACK FROM DISC ---
;
GTBLK:
	LXI	D,0	; INIT COUNT
GTB1:	IN	STAT	; GET STATUS
	MOV	C,A	; SAVE IT
	ANI	DRDY	; TEST READY BIT
	CPI	DRDYST	; IS DRIVE READY
	JNZ	GTB1	; LOOP UNTIL READY
	MOV	A,C
	ANI	DIFAC	; TEST BUSS DIRECTION
	CPI	HTD	; IS IT HOST-TO-DRIVE
	JZ	GTB2	; IF  SO THEN NO MORE BYTES
	CALL	WAITI	; GET DATA BYTE
	MOV	M,A	; SAVE IT
	INX	H
	INX	D
	JMP	GTB1
GTB2:	XCHG		; GET COUNT IN (H,L)
	XTHL            ; SAVE IT
	PCHL            ; RETURN
        
;
;
;$I CRVINIT.IO		; RESYNC CONTROLLER ROUTINE
;FILEID: CRVINIT.IO
;
;
; --- INITIALIZE CONTROLLER ----
;
INIT:	MVI	A,0FFH	; GET AN INVALID COMMAND
	OUT	DATA	; SEND IT TO CONTROLLER
	MVI	B,150	; SET FOR LONG DELAY
	CALL	DELAY
	IN	STAT
	ANI	DRDY OR DIFAC	; LOOK AT DRIVE ACTIVE BIT
	CPI	DRDYST OR DTH	; IS STATUS = READY & DRIVE-TO-HOST
	JNZ	INIT	; LOOP UNTIL DRIVE-TO-HOST
	CALL	WAITI	; GET ERROR CODE
	CPI	8FH	; CHECK RETURN CODE
	JNZ	INIT	; IF NOT RIGHT, TRY AGAIN
	RET
;
;$I CRV.IO		; BASIC CORVUS IO ROUTINES
;FILEID: CRV.IO
;

TURN:				; WAIT FOR DRIVE-TO-HOST STATUS AND
	IN	STAT		; DELAY TILL DATA STABLE
	ANI	DRDY OR DIFAC	; TEST STATUS
	CPI	DRDYST OR DTH	; IS DRIVE READY & DRIVE-TO-HOST
	JNZ	TURN		; IF NOT THEN LOOP
	MVI	B,6		; SET DELAY COUNT
	CALL	DELAY		; GOOD AT 4MHZ ALSO
	RET			;
;
DELAY:	DCR	B
	JNZ	DELAY
	RET
;
WAITI:	IN	STAT	; READ STATUS PORT
	ANI	DRDY OR DIFAC	; LOOK AT STATUS
	CPI	DRDYST OR DTH	; IS DRIVE READY & DRIVE-TO-HOST
	JNZ	WAITI	; LOOP UNTIL READY
	IN	DATA	; READ BYTE FROM DISC
	RET
;
WAITO:	PUSH	PSW	; SAVE COMMAND
	IN	STAT	; READ STATUS PORT
	ANI	DRDY OR DIFAC	; LOOK AT STATUS
	CPI	DRDYST OR HTD	; IS DRIVE READY & HOST-TO-DRIVE
	JNZ	WAITO+1	; LOOP UNTIL READY
	POP	PSW
	OUT	DATA	; WRITE BYTE TO DISC
	RET

;
;
; ---- MESSAGES ----
;
SMSG:	DB CR,LF,' --- CORVUS SEMAPHORE EXAMPLE PROGRAM ---'
	DB CR,LF,'             ( VERSION 1.3S/TT ) ',CR,LF,'$'
;
;$I SEMA4.DAT		; DATA DECLARATIONS 
MSG2:	DB CR,LF,'        --- MENU ---',CR,LF
	DB CR,LF,' 0:  LIST THIS MENU'
	DB CR,LF,' H:  LIST "HELP" INSTRUCTIONS'
	DB CR,LF,' L:  LOCK (SET) SEMAPHORE'
	DB CR,LF,' U:  UNLOCK (CLEAR) SEMAPHORE'
	DB CR,LF,' C:  CLEAR KEY TABLE (CLEAR ALL SEMAPHORES)'
	DB CR,LF,' Q:  QUIT (BACK TO CP/M)'
	DB CR,LF,'$'
;
MSG3:	DB CR,LF,' TASK (0 TO LIST) : $'
;
MSG5:	DB CR,LF,' DO YOU REALLY WANT TO CLEAR ALL OF THE SEMAPHORES'
	DB ' (Y/N) ?$'
;
;
MSG6:	DB CR,LF,07
	DB ' --- THIS VERSION OF THE CONTROLLER CODE DOES NOT ---',CR,LF
	DB'                   SUPPORT SEMAPHORES'
CRLF:	DB CR,LF,'$'
;
FLMSG:	DB CR,LF,CR,LF,07,' ** THE KEY TABLE IS FULL **',CR,LF,'$'
;
RWMSG:	DB CR,LF,CR,LF,07
	DB ' ** DISC READ-WRITE ERROR DURING TABLE UPDATE'
	DB ' **',CR,LF,'$'
;
ULKMSG:	DB 'UNLOCKED$'
LKMSG:	DB ' LOCKED $'
KMSG1:	DB ' , IT WAS $'
;
MSGE:	DB CR,LF,CR,LF,07,' ** DISC R/W ERROR # $'
;
MSGE1:	DB 'H **',CR,LF,'$'
;
CMSG:	DB '^C',CR,LF,'$'
;
CLMSG:	DB CR,LF, ' THE KEY TABLE HAS BEEN CLEARED !!',CR,LF,'$'
;
NMSG:	DB CR,LF,' SEMAPHORE NAME (8 CHAR. MAX) : $'
;
MSGI:	DB CR,LF
	DB CR,LF,' THIS PROGRAM IS DESIGNED TO SERVE AS AN'
	DB CR,LF,' EXAMPLE OF HOW TO ACCESS THE SEMAPHORES'
	DB CR,LF,' SUPPORTED BY THE CORVUS DRIVE.  THESE'
	DB CR,LF,' SEMAPHORES (SOFTWARE SWITCHES) ARE '
	DB CR,LF,' MAINTAINED BY THE CORVUS CONTROLLER AND'
	DB CR,LF,' SAVED ON A HIDDEN AREA OF THE DISC.  THEY'
	DB CR,LF,' ARE DESCRIBED IN THE BACK OF OUR '
	DB CR,LF,' CONSTELLATION MANUAL.  THE CORVUS DRIVE'
	DB CR,LF,' FIRMWARE SUPPORTS  32  BINARY SEMAPHORES'
	DB CR,LF,' - EACH ASSOCIATED WITH A USER SELECTED'
	DB CR,LF,' 8 BYTE NAME (KEY).  THIS FEATURE WAS'
	DB CR,LF,' IMPLEMENTED TO PROVIDE A WAY FOR APPLICATIONS'
	DB CR,LF,' PROGRAMS TO "SAFELY" CONTROL SIMULTANEOUS'
	DB CR,LF,' FILE ACCESS BY TWO OR MORE USERS ON THE'
	DB CR,LF,' CORVUS CONSTELLATION.  HOWEVER, YOU MAY'
	DB CR,LF,' FIND OTHER USES FOR THEM.  FOR INSTANCE,'
	DB CR,LF,' THEY COULD ALSO BE USED FOR PASSWORD'
	DB CR,LF,' ACCESS CONTROL OF VARIOUS USER PROGRAMS.'
	DB CR,LF
	DB CR,LF,' -------------- WARNING ---------------'
	DB CR,LF,' USE THIS PROGRAM WITH CAUTION ON A SYSTEM'
	DB CR,LF,' THAT IS ALREADY USING SEMAPHORES. IF USED'
	DB CR,LF,' INDISCRIMINATELY, YOU MAY SET OR CLEAR'
	DB CR,LF,' SEMAPHORES IN USE BY CURRENTLY RUNNING'
	DB CR,LF,' PROGRAMS.  THIS WOULD CONFUSE THEIR FILE'
	DB CR,LF,' OR RECORD PROTECTION SCHEME AND COULD'
	DB CR,LF,' LEAD TO EITHER LOSS OF DATA OR SYSTEM'
	DB CR,LF,' LOCKUP (OR BOTH).'
	DB CR,LF,CR,LF,'$'
;
; ---- BUFFERS AND DATA ----
;
;
SBUF:	DS	2	; OLD STACK POINTER
VERNUM:	DS	1	; BUFFER FOR 'REV A' VERSION # RTN 
LSTAT:	DS	1	; BUFFER FOR LOCK/UNLOCK STATUS
;
;  CP/M INPUT STRING BUFFER
;
TXBUF:	DB	8	; MAX SIZE OF BUFFER
	DB	0	; BUFFER COUNTER
	DS	12	; BUFFER SPACE
;
KEYX:	DB	CR,LF,' '
KEY:	DS	8	; BUFFER FOR SEMIPHORE NAME (8 CHAR. LONG)
	DB	'   IS $'	; TERMINATION STRING FOR PRINT ROUTINE
;
;
RTBUF:	DS	16	; BUFFER FOR READING RETURN BYTES
	DS	80	; STACK SPACE
STACK	EQU	$
;
;

	END
   	D:SEMA4.S                                                      