;****************************************************************
;*								*
;*								*
;*		CORVUS FLOPPY CP/M LINK PROGRAM 		*
;*			FOR CP/M 2.2				*
;*								*
;*		  VERSION 1.12TT  BY BRK			*
;*		     ( TRS80 II VERSION )			*
;*								*
;*								*
;*  COPYRIGHT 1980 CORVUS.		 ALL RIGHTS RESERVED	*
;*								*
;****************************************************************
;$I CRVDRV.TT			; CORVUS DRIVER EQUATES
;****************************************************************
;								*
; ---- TRS80 CORVUS DRIVER EQUATES (USER SETTABLE) ----		*
;								*
T80	EQU	1		; SET TO 1 FOR TRS80 MODEL 2	*
H89	EQU	0		; SET TO 1 FOR H89 SYSTEM	*
XRX	EQU	0		; SET TO 1 FOR XEROX SYSTEM ONLY*
;
;								*
ABOVE	EQU	1		; SET TO 1 IF LINKAGE CODE IS	*
;				; TO BE PUT 'ABOVE' CP/M AND 0	*
;				; IF IT IS TO BE PUT BELOW CP/M	*
;
MSIZE	EQU	64		; MAX MEMORY SPACE ALLOWED TO CP/M*
;
CLK2SZ	EQU	400H		; MAX ALLOWABLE CLINK2 SIZE	*
;
      IF ABOVE			;
FREE	EQU	(MSIZE*1024)-CLK2SZ ; BEGINNING ADDRESS OF CLINK2 *
      ENDIF
      IF NOT(ABOVE)		;
				; THIS DELTA IS FOR LIFEBOAT CPM*
DELTA	EQU	0E00H		; OFFSET FROM STANDARD CP/M	*
				; TRS80 BIOS SIZE - STANDARD SIZE*
BIAS	EQU	(MSIZE-20)*1024 - DELTA ;
CCP	EQU	3400H + BIAS	; BEGINNING OF CP/M		*
FREE	EQU	CCP-CLK2SZ	; BEGINNING ADDRESS OF CLINK2	*
      ENDIF
;								*
Z80B	EQU	1		;SET TO 1 IF USING Z80 ON REV B	*
;				;DRIVE, 0 OTHERWISE		*
;								*
;$I CRVDRV.EQU			; DRIVE SIZE EQUATES		*
;
FIVEMB	EQU	0		; ONLY 1 OF THESE DRIVE DESIGNATOR
TENMB	EQU	1		; MAY BE SET TO 1.
TWNTYMB	EQU	0		;
;
NPSUDO	EQU	2		; # OF PSEUDO DRIVES TO DIVIDE	* 
;				  DISK INTO (1-7)		*
PIPES	EQU	1		; SET TO 1 IF A PIPES AREA IS RESERVED
;								*
BLKSZ	EQU	8		; ALLOCATION BLOCK SIZE (DEFAULT ?K)
;								*
;****************************************************************
;
;$I CRVSYS.S			; SYSTEM EQUATES
;	----	S100/TRS80 II9 PORT ADDRESSES & MASKS	----
;
STAT	EQU	0DFH	; STATUS I/O PORT
DATA	EQU	0DEH	; DATA I/O PORT
DRDY	EQU	1	; MASK FOR DRIVE READY BIT
DRDYST	EQU	0	; IF BIT 0 = 0 THEN DRIVE READY
DIFAC	EQU	2	; MASK FOR DRIVE ACTIVE BIT
HTD	EQU	2	; IF BIT 1 SET THEN HOST-TO-DRIVE STATUS
DTH	EQU	0	; IF BIT 1 = 0 THEN DRIVE-TO-HOST
;
;
;
;
;$I CLINK2.BDY
;FILEID: CLINK2.BDY
;
;****************************************************************
;
;	THIS PROGRAM IS DESIGNED TO LINK A FLOPPY DISC CP/M V2.X
;	TO THE CORVUS HARD DISC.  IT IS SET UP TO ALLOW 2 FLOPPY
;	DRIVES, AND UPTO 7 PSUEDO DRIVES ON THE CORVUS.  IF YOU
;	CHOOSE TO USE THE CORVUS DISK LAYOUT SCHEME PROVIDED, YOU
;	NEED ONLY SET THE MEMORY SIZE EQUATE (MSIZE), DRIVE DESIG-
;	NATOR EQUATES (FIVEMB, TENMB, TWNTYMB), AND THE NUMBER OF
;	PSUEDO DRIVES EQUATE (NPSUDO).  THIS VERSION ALLOWS THE
;	LINK TO BE PUT ABOVE OR BELOW CP/M.  IN GENERAL IT IS BEST
;	TO PUT THE LINK ABOVE CP/M, BUT THIS IS NOT ALWAYS POSSIBLE.
;	CURRENTLY, THE XEROX AND THE SUPERBRAIN INTERFACES HAVE TO
;	BE PUT BELOW CP/M.  IF YOU PUT IT BELOW CP/M YOU MUST BE
;	SURE THAT IT SITS FULLY BELOW THE CCP OF THE CP/M IT IS TO
;	BE USED WITH (SEE THE "FREE" EQUATE ABOVE).
;	
;	THIS PROGRAM LOADS AT THE CP/M TPA (100H) AND MOVES A
;	PART OF ITSELF UP TO  LOCATION:FREE  AND THEN PATCHES
;	THE CODE IN   THIS AREA TO LINK TO THE CURRENTLY RUNNING
;	FLOPPY CP/M 2.X.  THIS INVOLVES COPYING SOME TABLES
;	FROM THE CP/M UP INTO THE LINK CODE AND RE-DIRECTING SOME
;	JUMPS IN THE BIOS JUMP TABLE UP TO THE LINK CODE.  THIS
;	LINK WILL NOT BE BROKEN BY A WARM BOOT BUT A COLD BOOT
;	WILL BRING IN A NEW COPY OF CP/M THAT IS NOT LINKED.
;	THIS PROGRAM MUST NOT BE RUN MORE THAN ONCE AFTER EACH
;	COLD START SINCE IT WOULD TRY TO SORT OF LINK TO ITSELF
;	IF RUN AGAIN (NOTE: THERE IS A BUILT IN CHECKING ROUTINE
;	TO PREVENT THIS LINK FROM BEING ENABLED TWICE- TO AVOID
;	THIS PROBLEM).  THIS PROGRAM IS AN IDEAL CANDIDATE FOR 
;	USING THE PROGRAM AUTO LOAD FEATURE BUILT INTO THE CCP OF
;	CP/M 2.0.  THIS FEATURE ALLOWS CP/M TO AUTOMATICALLY
;	EXECUTE A PRE-SELECTED COMMAND (SUCH AS LOADING BASIC
;	OR DOING A DIRECTORY LISTING) ON EACH WARM OR COLD BOOT.
;	THIS FEATURE CAN BE MADE SELECTIVE TO ONLY COLD BOOTS
;	BY A MODIFICATION OF THE USER BIOS.
;		IN ANY CASE, YOU CAN ALWAYS DO THE LINK MANUALLY
;	BY LOADING CLINK AFTER YOU FIRST BOOT UP.  NOTE, A CLEANER
;	SOLUTION IS TO CONFIGURE THESE DRIVERS DIRECTLY INTO YOUR
;	CP/M (AS CAN BE DONE WITH THE FILE BIOSC.ASM)  HOWEVER
;	IF YOU DO NOT HAVE THE SOURCE FOR YOUR DRIVERS, THIS
;	MAY NOT BE POSSIBLE.
;
;
;****************************************************************
;
;
; ---- CP/M EQUATES ----
;
CDISC	EQU	04		; BUFFER LOCATION FOR CURRENT DISC #
IOBYTE	EQU	03		; LOCATION OF INTEL IOBYTE
BDOS	EQU	05		; LOCATION OF BDOS JUMP
;
RSET	EQU	13		; BDOS RESET COMMAND
LST	EQU	 9		; LIST STRING COMMAND
;
CONOUT	EQU	4A0CH		; LOCATION OF CONOUT JUMP IN 20K
;				; CP/M 2.X BIOS (DO NOT CHANGE)
;
; ---- CORVUS DISK EQUATES ----
;
RDCOM	EQU	12H		; READ COMMAND (VERS. 1 CCODE)
WRCOM	EQU	13H		; WRITE COMMAND (VERS. 1 CCODE)
SSIZE	EQU	128		; SECTOR SIZE (IN BYTES)
FMAX	EQU	2		; ALLOW FOR 2 FLOPPY DRIVES
DMAX	EQU	NPSUDO+FMAX	; TOTAL # DRIVES
;
;
;
	ORG	100H	;START AT CP/M TPA
				; 1.09 -
	POP	H		; GET RETURN ADDRESS FROM CPM STACK
	LXI	SP,STACK	; SET STACK POINTER TO LOCAL STACK
	PUSH	H		; SET OLD RETURN ADDRESS BACK
;
; --- COMPUTE ADDRESS OF BIOS FOR THE LOADED CP/M ---
;
	LHLD	1	; GET ADDRESS OF JUMP TO WBOOT
	DCX	H
	DCX	H
	DCX	H
	SHLD	LDBIOS	; SAVE IT FOR LATER USE
;
; --- COMPUTE CP/M OFFSET BIAS FROM 20K SYSTEM ----
;
	MOV	A,H
	SUI	04AH
	MOV	H,A
	SHLD	CBIAS	; SAVE IT
;
; --- DETERMINE IF LINK IS ALREADY INSTALLED ---
;
	LXI	D,CONOUT+13	; POINT TO 20K HOME ADDRESS
	DAD	D		; ADJUST FOR CP/M SIZE
	LXI	D,SHOME		; GET ADDRESS OF NEW VALUE
	MOV	A,M		; GET LOW ADDRESS BYTE
	CMP	E		; IS THERE A MATCH?
	JNZ	OK		; NO, SO LINK IS NOT INSTALLED
	INX	H		; POINT TO HIGH ADDRESS BYTE
	MOV	A,M		; GET IT
	CMP	D		; IS THERE A MATCH?
	JNZ	OK		; NO, SO LINK IS NOT INSTALLED
;
	LXI	D,LMSG		; POINT TO ERROR MESSAGE
	MVI	C,LST		; SET FOR LIST FUNCTION
	JMP	BDOS		; LIST AND EXIT BACK TO CP/M
;
; --- 1.09 - TEST IF LINK OK ---
;
OK:	LXI	H, CLK2SZ		; GET ALLOCATED SPACE
	LXI	D, LENC			; GET SIZE OF CODE
	CALL	CMPDE			; IS CODE TOO BIG
	LXI	D, CLK2BG		; SET MESSAGE POINTER
	JC	LNRCPM			; IF YES THEN REPORT
      IF NOT(ABOVE)			; IF CLINK2 BELOW CP/M
	LHLD	LDBIOS			; GET BIOS ADDRESS
	LXI	D, FREE+LENC+1600H	; SHOULD BE <= BIOS ADDR
	CALL	CMPDE			; TEST IF DE > HL
	LXI	D, CLK2HI		; SET MESSAGE POINTER
	JC	LNRCPM			; IF C THEN LIST & RETURN CP/M
      ENDIF				;
;			OK TO MOVE CODE
	LXI	H,START	;SOURCE OF CODE
	LXI	D,FREE	;DESTINATION OF CODE
	LXI	B,LENC+2;LENGTH OF CODE
;
SZOK:	CALL	MOVE			; 1.09- ADDED LABEL
;
; --- COPY PART OF OLD BIOS JUMP TABLE UP TO LINK PGM ---
;
	LHLD	CBIAS	; GET OFFSET
	LXI	D,4A18H	; 20K ADDRESS OF PART OF BIOS TABLE
	DAD	D	; ADJUST FOR CURRENT CP/M SIZE
	PUSH	H	; SAVE IT
	LXI	D,FHOME	; DESTINATION
	LXI	B,27
	CALL	MOVE
	POP	D
;
; --- COPY NEW LINK TABLE INTO BIOS JUMP TABLE ---
;
	LXI	H,NTAB	; NEW TABLE
	LXI	B,27	; SET TABLE LENGTH
	CALL	MOVE
;
; --- PATCH IN LINK TO CONOUT ROUTINE ---
;
	LHLD	CBIAS
	LXI	D,CONOUT ;LOCATION OF CONOUT JUMP
	DAD	D	;CORRECT FOR CP/M SIZE
	SHLD	PTX0+1	;PATCH REFERENCES
	SHLD	PTX1+1
;
; --- 1.07 - PATCH IN REFERENCE TO DIRECTORY BUFFER ---
;
	LDA	CDISC	; GET CURRENT DRIVE #
	ANI	0FH	; MASK OUT POSSIBLE USER #
	MOV	C,A
	CALL	FSELEC	; CALL FLOPPY SELECT TO FIND LOCATION
			; OF DISC PARAM. HEADER
	LXI	D,8
	DAD	D	; OFFSET TO DIRECTORY BUFFER POINTER
	MOV	E,M	; GET IT INTO (D,E)
	INX	H
	MOV	D,M
;
	LXI	H,DPBASE+8 ; POINT TO LOCATION IN CORVUS PARAMETER
			   ; HEADERS
	MVI	A,(DMAX-FMAX) ; SET # OF HEADERS TO PATCH
	LXI	B,15	; OFFSET BETWEEN PATCHES
LP1:	MOV	M,E	; INSERT POINTER IN PARAMETER HEADER
	INX	H
	MOV	M,D
	DAD	B	; POINT TO NEXT HEADER
	DCR	A	; COUNT DOWN NUMBER
	JNZ	LP1	; CONTINUE UNTIL DONE
;
	IF NOT ABOVE
; --- TRANSFER BDOS JUMP TO START OF CLINK ---
;
        LHLD    BDOS+1  ; GET BDOS JUMP ADDRESS
        SHLD    BDJ+1   ; SAVE IT IN CLINK
        LXI     H,BDJ   ; GET ADDRESS OF TRANSFER
        SHLD    BDOS+1  ; SAVE IT BACK IN BDOS JUMP
;
; --- DISABLE USUAL WARM BOOT SEQUENCE ---
;
        LHLD    1       ; GET ADDRESS OF WARM BOOT JUMP
        SHLD    PTXWB+1 ; PATCH IN ADDRESS
        INX     H       ; POINT TO ACTUAL ADDRESS PART
        LXI     D,WBOOT ; GET NEW ADDRESS
        MOV     M,E     ; SAVE IT IN JUMP ADDRESS
        INX     H
        MOV     M,D
;
        LXI     D,-1602H ; 1.09 - OFFSET TO START OF CCP+3
        DAD     D
        SHLD    PTXCP+1 ; PATCH IN JUMP ADDRESS
	ENDIF
;
; --- NOTIFY OF CORVUS LINK ---
;
	LXI	D,BMSG
LNRCPM:	MVI	C,LST		; 1.09 - ADD LABEL: LIST & RET CP/M
	CALL	BDOS		;
;
;
;   DO A SYSTEM RESET
;
	MVI	C,RSET
	JMP	BDOS	;DO A RESET AND RE-ENTER CP/M (LINK IS DONE)
;
MOVE:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	MOVE
	RET
;
; --- 1.09 - COMPARE HL TO DE REGISTER AND SET CARRY IF DE > HL
;
CMPDE:	MOV	A, L		; GET LOWER BYTE OF HL
	SUB	E		; SUB LOWER BYTE OF DE
	MOV	A, H		; GET UPPER BYTE HL
	SBB	D		; SUB WITH CARRY LOWER BYTE DE
	RET				;
;
; --- NEW JUMP TABLE TO BE COPIED INTO THE BIOS ---
;
NTAB:	JMP	SHOME	;JUMP TO SWITCH TABLE
	JMP	SELDSK
	JMP	SETTRK
	JMP	SETSEC
	JMP	SETDMA
	JMP	SREAD
	JMP	SWRITE
	JMP	FLISTST
	JMP	SSCTRAN
;
BMSG:	DB 0DH,0AH,' --- CORVUS LINK INSTALLED ---',0DH,0AH,'$'
LMSG:	DB 0DH,0AH,07,' ** CORVUS LINK ALREADY INSTALLED **',0DH,0AH,'$'
;			1.09 - ADD CLK2BG  AND CLK2HI MESSAGE
CLK2BG:	DB 0DH,0AH,07,' ** CORVUS LINK TOO BIG ** ',0DH,0AH,'$';
CLK2HI:	DB 0DH,0AH,07,' ** CP/M MEMORY SIZE MISMATCH ** ',0DH,0AH,'$';
LDBIOS	DS	2	;BUFFER FOR BIOS LOCATION
CBIAS	DS	2	;BUFFER FOR CP/M BIAS
;
;
START	EQU  $	;START OF CODE TO BE MOVED UP
;
SHIFT	EQU	FREE-START	;OFFSET OF CODE TO MOVE UP LOCATION
;	NOTE: ALL LABELS IN THE CODE TO FOLLOW MUST BE
;	      OF THE FORM    LABEL  EQU  $+SHIFT
;             TO MAKE THE CODE CORRECTLY BE ASSEMBLED
;             FOR THE SHIFTED ORIGIN (AT 'FREE').
;
	IF NOT ABOVE
; --- FAKE START TO LOOK LIKE BDOS ---
;
        DS      6       ; SPACE 
BDJ     EQU     $+SHIFT
        JMP     0       ; GETS PATCHED TO JUMP TO BDOS ENTRY IN BDOS
;
; --- FAKE WARM BOOT ENTRY ---
;
WBOOT   EQU     $+SHIFT
        MVI     A,0C3H  ; GET JUMP OPCODE
        STA     0       ; SETUP FOR WARM BOOT
PTXWB   EQU     $+SHIFT ; SETUP PATCH LOCATION
        LXI     H,0     ; GET WARM BOOT ADDRESS
        SHLD    1       ; SET ADDRESS
        STA     5       ; SETUP BDOS ENTRY JUMP
        LXI     H,BDJ   ; GET NEW BDOS JUMP TRANSFER ADDRESS
        SHLD    6       ; SET ADDRESS
        LXI     B,80H   ; GET DEFAULT DMA ADDRESS
        CALL    SETDMA  ; SET DMA ADDRESS
        LDA     CDISC   ; GET CURRENT DRIVE #
        MOV     C,A     ; SAVE FOR CCP FUNCTION
PTXCP   EQU     $+SHIFT ; SETUP PATCH LOCATION
        JMP     0       ; ENTER CP/M
	ENDIF
;
; --- COPY OF ORIGINAL BIOS SELECT,SETTRK,SETSEC,AND SETDMA
;
FHOME	EQU	$+SHIFT
	JMP	0
FSELEC	EQU	$+SHIFT
	JMP	0	;THIS GETS PATCHED ON STARTUP
FSTTRK	EQU	$+SHIFT
	JMP	0
FSTSEC	EQU	$+SHIFT
	JMP	0
FSTDMA	EQU	$+SHIFT
	JMP	0
FREAD	EQU	$+SHIFT
	JMP	0
FWRITE	EQU	$+SHIFT
	JMP	0
FLISTST	EQU	$+SHIFT
	JMP	0
FSCTRAN	EQU	$+SHIFT
	JMP	0
;
	DS	2	;EXTRA ROOM
;
; --- THIS JUMP TABLE IS USED AS A SWITCH TO DIRECT THE BIOS
;     DISC INTERFACE CALLS TO THE FLOPPY OR HARD DISC ROUTINES.
;
SHOME	EQU	$+SHIFT
	JMP	FXHOME	; SET TO FLOPPY ROUTINES AT FIRST
SREAD	EQU	$+SHIFT
	JMP	FXREAD
SWRITE	EQU	$+SHIFT
	JMP	FXWRITE
SSCTRAN	EQU	$+SHIFT
	JMP	FSCTRAN
;
	DS	2	; EXTRA ROOM
;
; --- THIS JUMP TABLE IS USED TO COPY INTO THE SWITCHING
;     JUMP TABLE TO LINK TO THE FLOPPY DISC (WITH THE 
;     SELECT ROUTINE).
;
FTAB	EQU	$+SHIFT
	JMP	FXHOME
	JMP	FXREAD
	JMP	FXWRITE
	JMP	FSCTRAN
;
; --- THIS JUMP TABLE IS USED TO COPY INTO THE SWITCHING
;     JUMP TABLE TO LINK TO THE HARD DISC (WITH THE 
;     SELECT ROUTINE).
;
HTAB	EQU	$+SHIFT
	JMP	HHOME
	JMP	HREAD
	JMP	HWRITE
	JMP	HSCTRAN
;
	DS	2	;EXTRA ROOM
;
; --- FLOPPY CALLS WITH TRACK SETUP ---
;
FXHOME	EQU	$+SHIFT
	LXI	H,0
	SHLD	TRACK	; SET LOCAL BUFFER
	JMP	FHOME

;			  1.08 - CANT USE STACK SPACE, CAUSES ERROR
;			  1.09 - SAVE BC REG FOR CALL TO READ
FXREAD	EQU	$+SHIFT
	IF XRX
	POP	H	; GET RETURN ADDRESS FROM STACK
	SHLD	RTSAV	; SAVE IT IN BUFFER
			;   THIS STEP IS DONE TO AVOID INCREASING
			;   THE STACK SPACE USED BY THE FLOPPY
			;   ROUTINES
	MOV	L,C	; SAVE BC REG
	MOV	H,B	;
	SHLD	BCSAV	;
	LHLD	TRACK	; GET TRACK #
	MOV	C,L	; GET INTO (B,C)
	MOV	B,H
	CALL	FSTTRK	; SEND IT TO FLOPPY ROUTINES
	LHLD	RTSAV	; GET BACK RETURN ADDRESS
	PUSH	H	; PUT BACK ON STACK
	LHLD	BCSAV	; RESTORE BC REG FOR FLOPPY READ CALL
	MOV	C,L	;
	MOV	B,H	;
	ENDIF
	JMP	FREAD	; DO FLOPPY READ
;
FXWRITE	EQU	$+SHIFT
	IF XRX
	XCHG		; GET POSSIBLE LOGON FLAG IN (H,L)
	SHLD	DESAV	; SAVE LOCALLY
	POP	H	; GET RETURN ADDRESS FROM STACK
	SHLD	RTSAV	; SAVE IT IN BUFFER
			;   THIS STEP IS DONE TO AVOID INCREASING
			;   THE STACK SPACE USED BY THE FLOPPY
			;   ROUTINES
	LHLD	TRACK	; GET TRACK #
	MOV	C,L	; GET INTO (B,C)
	MOV	B,H
	CALL	FSTTRK	; SEND IT TO FLOPPY ROUTINES
	LHLD	RTSAV	; GET BACK RETURN ADDRESS
	PUSH	H	; PUT BACK ON STACK
	LHLD	DESAV	; GET LOGON FLAG
	XCHG		;  BACK INTO (D,E)
	ENDIF
	JMP	FWRITE
;
;
;
;
; ---- SECTOR TRANSLATION ROUTINE ----
;
HSCTRAN	EQU	$+SHIFT
	MOV	A,D	; TEST IF TABLE TRANSLATION IS REQUESTED
	ORA	E
	JNZ	STR1	; YES, SO DO IT
	MOV	L,C	; NO, SO JUST TRANSFER TO (H,L)
	MOV	H,B
	RET
STR1	EQU	$+SHIFT
	XCHG		; GET TABLE ADDRESS IN (H,L)
	DAD	B	; INDEX INTO TABLE
	MOV	L,M	; GET BYTE IN (H,L)
	MVI	H,0
	RET
;
;  --- MESSAGE PRINTOUT ROUTINE ----
;
PTMSG	EQU	$+SHIFT
	MOV	A,M	; GET MESSAGE BYTE
	CPI	'$'	; IS IT THE TERMINAL CHARACTER
	RZ		; YES, SO RETURN
	MOV	C,A	; SAVE FOR CONSOLE OUTPUT
	PUSH	H
PTX0	EQU	$+SHIFT	;SETUP LOCATION FOR PATCH
	CALL	CONOUT
	POP	H
	INX	H
	JMP	PTMSG
;
; --- OUTPUT ACC IN HEX ---
;
HEXOT	EQU	$+SHIFT
	PUSH	PSW	; SAVE BYTE
	RRC		; SHIFT UPPER NIBBLE DOWN 4 BITS
	RRC
	RRC
	RRC
	CALL	HEXB	; OUTPUT UPPER NIBBLE IN HEX
	POP	PSW	; RESTORE BYTE
HEXB	EQU	$+SHIFT
	ANI	0FH	; MASK OUT UPPER NIBBLE
	ADI	'0'	; ADD ASCII BIAS
	CPI	'9'+1	; IS IT NUMERIC?
	JC	PRT	; YES, SO SEND IT OUT
	ADI	7	; NO, SO ADJUST FOR A-F
PRT	EQU	$+SHIFT
	MOV	C,A	; SAVE FOR OUTPUT
PTX1	EQU	$+SHIFT	; SETUP LOCATION FOR PATCH
	JMP	CONOUT	; OUTPUT TO CONSOLE
;
; --- COMPUTE CORVUS DISC ADDRESS AND SEND TO CONTROLLER ---
;
SETUP	EQU	$+SHIFT
	CALL	WAITO	; ISSUE DISC R/W  COMMAND
	LHLD	TRACK	; GET TRACK # FROM BUFFER
	XCHG		; PUT IN (D,E)
	LXI	H,0	; CLEAR CONVERSION BUFFER
	LDA	NSPTRK	; GET # SECTORS/TRACK  (ASSUMED <255)
	MVI	B,8	; SET TO MULTIPLY 8 BITS
;           MULTIPLY :(H,L)=TRACK*(# SECTORS/TRACK)
MULT	EQU	$+SHIFT
	DAD	H	; SHIFT BUFFER OVER 1 POSITION
	RAL		; TEST NEXT BIT OF (#SECTORS/TRACK)
	JNC	ML1	; IF NOT A 1, DON'T ADD IN
	DAD	D	; IF A 1, ADD IN  TRACK #
ML1	EQU	$+SHIFT
	DCR	B	; COUNT DOWN # BITS
	JNZ	MULT	; LOOP UNTIL DONE
	XCHG		; PUT RESULT IN (D,E)
	LHLD	SECTOR	; GET SECTOR #
	DAD	D	; (H,L)=SECTOR+TRACK*(#SECTORS/TRACK)
;
	XCHG		; PUT RESULT IN (D,E)
	LHLD	ADDOF	; GET POINTER TO DISC ADDRESS OFFSET
;	    ADD IN DISC ADDRESS OFFSET
	MOV	A,E	; GET LOWER BYTE OF RELATIVE DISC ADDRESS
	ADD	M	; ADD IN LOWER BYTE OF ABSOLUTE DISC OFFSET
	MOV	E,A	; SAVE RESULT
	INX	H	; POINT TO NEXT BYTE OF OFFSET
	MOV	A,D	; DO ADDITION AGAIN
	ADC	M
	MOV	D,A	; SAVE IT
	INX	H	; POINT TO LAST BYTE OF OFFSET
	MVI	A,0	; CLEAR ACC WITHOUT CLEARING CARRY BIT
	ADC	M	; GET UPPER BYTE OF DISC ADDRESS
	RLC		; SHIFT OVER 4 PLACES
	RLC
	RLC
	RLC
	MOV	C,A	; SAVE IT
	LDA	CDRIVE	; GET CORVUS DRIVE # (1-4)
	ADD	C	; MERGE IN EXTENDED DISC ADDRESS BITS
;
;	   WE NOW HAVE  (D,E)=LOWER TWO BYTES OF DISC ADDRESS
;	                ACC  =EXTENDED DISC ADDRESS+DRIVE #
;
SET1	EQU	$+SHIFT
	CALL	WAITO	; SEND DRIVE # TO CONTROLLER
	MOV	A,E
	CALL	WAITO	; SEND LOWER DISC ADDRESS TO CONTROLLER
	MOV	A,D
	JMP	WAITO
;
; --- HOME CORVUS DRIVE ----
;
HHOME	EQU	$+SHIFT
	LXI	H,0	; GET TRACK 0
	SHLD	TRACK
	RET
;
; ---- SELECT DISC ROUTINE ----
;  NOTE, THIS ROUTINE DOES A LOT OF EXTRA WORK SO
;  THAT SOME OF IT NEED NOT BE DONE FOR EACH DISC
;  READ/WRITE OPERATION.  THE METHOD USED TO SWITCH
;  BETWEEN CORVUS AND FLOPPY DRIVES (PATCHING A JUMP
;  TABLE) IS MAINLY USED BECAUSE IT CONCENTRATES THE
;  SELECT FUNCTIONS ALL WITHIN THE SELDSK ROUTINE.
;
SELDSK	EQU	$+SHIFT
	MOV	A,C	; GET CP/M DRIVE #
	CPI	DMAX	; NO, SO SEE IF # IS TOO BIG
	JNC	SLDERR	; ERROR, SO GIVE NOTICE
	CPI	FMAX	; IS IT A FLOPPY?
	JC	SLD1	; YES, SO PROCESS SELECT
;  COPY HARD DISC LINKS INTO SWITCH TABLE
;
	LXI	H,HTAB	; POINT TO HARD DISC TABLE
	CALL	COPYS	; DO IT
;
	MOV	A,C
	SUI	FMAX	; REMOVE FLOPPY OFFSET
	MOV	C,A
	MOV	L,C	; GET CP/M DRIVE # IN (H,L)
	MVI	H,0
	DAD	H	; MULTIPLY BY 4
	DAD	H
	LXI	D,OFSBAS ; POINT TO BASE OF OFFSET TABLE
	DAD	D	; SELECT THE RIGHT ONE
	SHLD	ADDOF	; SAVE POINTER FOR LATER USE
	INX	H
	INX	H
	INX	H
	MOV	A,M	; GET ACTUAL CORVUS DRIVE #
	STA	CDRIVE	; SAVE IT
SLD2	EQU	$+SHIFT
	MOV	L,C	; GET CP/M DRIVE # IN (H,L)
	MVI	H,0
	DAD	H	; MULTIPLY BY 16
	DAD	H
	DAD	H
	DAD	H
	LXI	D,DPBASE ; GET START OF PARAM. BLOCK
	DAD	D	; SELECT THE RIGHT BLOCK
	SHLD	PPOINT	; SAVE POINTER
	LXI	D,10
	DAD	D	; POINT TO ADDRESS OF DISC BLOCK
	MOV	E,M	; GET ADDRESS IN FROM TABLE INTO (D,E)
	INX	H
	MOV	D,M
	XCHG		; PUT IN (H,L)
	MOV	E,M	; GET # SECTORS/TRACK INTO (D,E)
	INX	H
	MOV	D,M
	XCHG
	SHLD	NSPTRK	; SAVE IT IN BUFFER
SLD3	EQU	$+SHIFT
	LHLD	PPOINT	; GET PARAM. POINTER
	RET
;   COPY FLOPPY JUMP TABLE INTO SWITCH TABLE
SLD1	EQU	$+SHIFT
	LXI	H,FTAB	; POINT TO FLOPPY JUMP TABLE
	PUSH	D	; SAVE POSSIBLE LOGON FLAG
	CALL	COPYS	; DO COPY
	POP	D	; RESTORE FLAG
	JMP	FSELEC	; FINISH THRU FLOPPY SELECT ROUTINE
;
SLDERR	EQU	$+SHIFT
	LXI	H,0	; IF SELECT ERROR, GET 0 IN (H,L)
	LDA	CDISC
	ANI	0F0H
	STA	CDISC	; SET TO REBOOT ON DRIVE  A
	RET
;
COPYS	EQU	$+SHIFT
	LXI	D,SHOME	; SET DESTINATION OF COPY (SWITCH TABLE)
	MVI	B,12	; SET SIZE OF TABLE
COPY	EQU	$+SHIFT
	MOV	A,M	; GET BYTE FROM SOURCE
	STAX	D	; SAVE AT DESTINATION
	INX	H
	INX	D
	DCR	B
	JNZ	COPY
	RET
;
SETTRK	EQU	$+SHIFT
	MOV	L,C	; GET TRACK # INTO (H,L)
	MOV	H,B
	SHLD	TRACK	; SAVE LOCALLY
	   IF	XRX
	RET		; RETURN, PASS # TO FLOPPY ON R/W ONLY
	   ENDIF
	   IF	T80	; IF TRS80/2
	MOV	A,C	; * ITS ONLY NECESSARY TO CHECK LOWER BYTE
	CPI	77	; * IF TRACK IS BIGGER THAN 77 THEN DONT
	RNC		; * PASS TO FLOPPY ROUTINES
	   ENDIF	;
	   IF NOT XRX
	JMP	FSTTRK	; DO FLOPPY ONE ALSO
	   ENDIF
;
SETSEC	EQU	$+SHIFT
	MOV	L,C	; SAVE CP/M SECTOR #
	MOV	H,B
	SHLD	SECTOR
	JMP	FSTSEC	; DO FLOPPY ONE ALSO
;
SETDMA	EQU	$+SHIFT
	MOV	L,C	; SAVE DMA ADDRESS
	MOV	H,B
	SHLD	DMAAD
	JMP	FSTDMA	; DO FLOPPY ONE ALSO

;
; ---- CORVUS DISC READ ROUTINE ----
;
HREAD	EQU	$+SHIFT
	MVI	A,RDCOM	; GET READ COMMAND
	CALL	SETUP	; COMPUTE DISC ADDRESS AND ISSUE COMMANDS
RDC1	EQU	$+SHIFT
	CALL	TURN	; WAIT FOR ACCEPTANCE OF COMMAND
	JNZ	ERRCD	; IF ERROR
	LHLD	DMAAD	; GET DMA ADDRESS
	MVI	B,SSIZE	; GET SECTOR SIZE
	CALL	RDBLK	; GET BLOCK
RTN	EQU	$+SHIFT
	XRA	A	; CLEAR ERROR INDICATOR
	RET
;
; ---- CORVUS DISC WRITE ROUTINE ----
;
HWRITE	EQU	$+SHIFT
	MVI	A,WRCOM	; GET WRITE COMMAND
	CALL	SETUP	; COMPUTE ADDRESS AND ISSUE COMMANDS
	MVI	B,SSIZE	; GET SECTOR SIZE
	LHLD	DMAAD	; SET BUFFER ADDRESS
	CALL	WTBLK	; WRITE OUT BLOCK
	CALL	TURN	; WAIT FOR BUSS TURN AROUND AND READ ERROR #
	JZ	RTN	; RETURN IF OK
ERRCD	EQU	$+SHIFT
	PUSH	B	; IF ERROR, ISSUE ERROR MESSAGE
	LXI	H,ERMSG
	CALL	PTMSG
	POP	PSW	; GET ERROR # BACK IN ACC
	CALL	HEXOT	; PRINT IT OUT IN HEX
	LXI	H,ERMSG1
	CALL	PTMSG	; PRINT REMAINDER OF MESSAGE
	MVI	A,1	; SET ERROR INDICATOR
	RET
;
;
;$I CLINK2.IO
;FILEID: CLINK2.IO

;
;
RDBLK	EQU	$+SHIFT	;
	IF	Z80B
	MVI	C,DATA	; SET DATA PORT FOR  INIR
	ENDIF
;
RLP	EQU	$+SHIFT
	IN	STAT	; GET DRIVE STATUS
	ANI	DRDY	; LOOK AT READY BIT
	JNZ	RLP	; LOOP UNTIL BYTE IS AVAILABLE
;
	IF	NOT Z80B 
	IN	DATA	; READ BYTE FROM CONTROLLER
	MOV	M,A	; SAVE IT IN MEMORY
	INX	H
	DCR	B	; COUNT DOWN BYTES
	JNZ	RLP	; LOOP UNTIL DONE
	ENDIF
;
	IF	Z80B
	DB	0EDH,0B2H	; --- FAKE INIR
	ENDIF
;
	RET		; END RDBLK
;
;
WTBLK	EQU	$+SHIFT	;
	IF	Z80B
	MVI	C,DATA	; SET DATA PORT FOR  OUTIR
	ENDIF
;
WLP	EQU	$+SHIFT
	IN	STAT	; GET DRIVE STATUS
	ANI	DRDY	; LOOK AT READY BIT
	JNZ	WLP	; LOOP UNTIL BYTE ISS AVAILABLE
;
	IF	NOT  Z80B
	MOV	A,M	; GET BYTE FROM MEMORY
	OUT	DATA	; SEND IT TO CONTROLLER
	INX	H
	DCR	B	; COUNT DOWN # OF BYTES
	JNZ	WLP	; LOOP UNTIL DONE
	ENDIF
;
	IF	Z80B
	DB	0EDH,0B3H	; --- FAKE OUTIR
	ENDIF
;
	RET
;
;
; --- TURN -	WAIT FOR BUS TO TURN AROUND AND TEST RETURN CODE
;
TURN	EQU	$+SHIFT
	IN	STAT	; READ STATUS BYTE
	ANI	DRDY OR DIFAC	; CHECK  READY BIT
	CPI	DRDYST OR DTH	; IS STATUS = DRIVE READY
	JNZ	TURN	; IF  NOT READY, THEN WAIT
	CALL	DELAY1	; WAIT FOR OVER 20USEC
	CALL	WAITI	; READ ERROR BYTE
	MOV	B,A	; SAVE IT
	ANI	80H	; LOOK AT FATAL ERROR BIT
	RET
;
DELAY1	EQU	$+SHIFT
	MVI	B,6	; DELAY MORE THAN 20USEC
DELAY	EQU	$+SHIFT
	DCR	B	; COUNT DOWN
	JNZ	DELAY
	RET
;
WAITI	EQU	$+SHIFT
	IN	STAT	; GET STATUS BYTE
	ANI	DRDY OR DIFAC	; LOOK AT READY BIT
	CPI	DRDYST OR DTH	; IS STATUS = DRIVE READY
	JNZ	WAITI
	IN	DATA	; GET DATA FROM CONTROLLER
	RET
;
WAITO	EQU	$+SHIFT
	MOV	B,A	; SAVE COMMAND
	IN	STAT	; READ STATUS BYTE
	ANI	DRDY OR DIFAC	; LOOK AT READY BIT
	CPI	DRDYST OR HTD	; IS STATUS = DRIVE READY
	JNZ	WAITO+1
	MOV	A,B	; GET COMMAND
	OUT	DATA	; SEND IT TO CONTROLLER
	RET

;
;$I CLINK2.DPB
;FILE ID: CLINK2.DPB
;
;	  THE FOLLOWING CODE SETS UP THE LAYOUT OF THE PSUEDO DRIVES
;	ON THE CORVUS DRIVE.  IT USES 6 EQUATES (FIVEMB, TENMB,
;	TWNTYMB, NPSUDO, BLKSZ, & PIPES) THAT SHOULD BE SET BY THE
;	USER TO DO THE SET UP.  THE BASIC IDEA IS THAT THE DRIVE IS 
;	SPLIT UP INTO BETWEEN 1 & 7 EQUALLY SIZED DRIVES BASED ON THE 
;	PREVIOUSLY MENTIONED USER SETTABLE EQUATES AND THE EQUATES
;	THAT FOLLOW WHICH ARE NOT INTENDED FOR THE USER TO CHANGE.
;	IF THE LAYOUT SCHEME IS NOT SATISFACTORY, THEN THIS CODE
;	SHOULD SERVE AS A GUIDE ON HOW TO SET UP THE CP/M DISK 
;	PARAMETER BLOCK STRUCTURE AND THE CORVUS PSEUDO DRIVE OFFSET
;	TABLE.
;	  ALL ADDRESS & DRIVE SIZE CALCULATIONS ARE DONE IN UNITS OF
;	512 BYTE BLOCKS.  THEY ARE CONVERTED TO UNITS OF 128 BYTE
;	SECTORS WHEN NECESSARY.  THIS WAS DONE TO BE COMPATIBLE WITH
;	THE CORVUS MIRROR WHICH NEEDS ALL VOLUMES TO START ON A 512
;	BYTE BOUNDARY.
;
;
;
;$I DPB.SET			; SET UP CORVUS DISK PARAMETER BLOCK
;FILE ID: DPB.SET
;
				; SPT MUST BE A MULTIPLE OF 4
	IF FIVEMB
DRVSZ	EQU	11220		; 5.61MB USER AREA
SPT	EQU	64		; 64 SECTORS/TRACK ON 5MB
      ENDIF
      IF TENMB
DRVSZ	EQU	21220		; 10.61MB USER AREA
SPT	EQU	60		; 60 SECTORS/TRACK ON 10
      ENDIF
      IF TWNTYMB
DRVSZ	EQU	38460		; 19.23MB USER AREA
SPT	EQU	64		; 64 SECTORS/TRACK ON 20
      ENDIF

      IF PIPES			; 500 BLOCKS FOR PIPES AREA
RESERVE	EQU	564		; # OF 512 BYTE BLOCKS RESERVED 
      ENDIF			; IF A PIPES AREA TO EXIST
      IF NOT PIPES		; 64 BLOCKS FOR CORVUS USE
RESERVE	EQU	64		; # OF 512 BYTE BLOCKS IF NO PIPES
      ENDIF

				; DRM+1 MUST BE A MULTIPLE OF BLKSZ*32 
				; FOR ALOCMSK TO BE SET UP RIGHT
DRM	EQU	255		; # DIRECTORY ENTRIES - 1

				; NUMBER OF DIRECTORY BLOCKS TO ALLOCATE
				; (((DRM+1)*32)/(BLKSZ*1024))
NDB	EQU	((DRM+1)/(BLKSZ*32))
;

SHFTCNT	EQU	16-NDB		; SHIFT LEFT COUNT
				; BIT MAP FOR RESERVED DIRECTORY BLOCKS
ALOCMSK	EQU	(0FFFFH SHL SHFTCNT)
				; UPPER BYTE OF DIRECTORY BIT MAP
AL0	EQU	(ALOCMSK SHR 8) AND 00FFH
				; LOWER BYTER OF DIRECTORY BIT MAP
AL1	EQU	ALOCMSK AND 00FFH
;
OFF	EQU	1		; RESERVED TRACKS/PSEUDO DRIVE
BLM	EQU	(BLKSZ*8)-1	; BLOCK MASK (USED INTERNALLY BY CP/M)

      IF BLKSZ SHR 1		 ;IF ALLOCATION BLOCK SIZE = 2K
BSH	EQU	4		;
      ENDIF
      IF BLKSZ SHR 2		; if allocation size = 4k
BSH	EQU	5		;
      ENDIF
      IF BLKSZ SHR 3		; if allocation size = 8k
BSH	EQU	6		;
      ENDIF
      IF BLKSZ SHR 4		; if allocation size = 16k
BSH	EQU	7		;
      ENDIF


PDRVSZ	EQU	(DRVSZ - RESERVE)/NPSUDO	;
RTOFF	EQU	(SPT * OFF)/4	; # OF 512 BYTE SECTORS RESERVED FOR
				; BOOT TRACK OF EACH PSEUDO DISK

BLKS	EQU	BLKSZ*2		; # OF 512 BYTE BLOCKS IN 1 
				; ALLOCATION BLOCK.
;
DSM	EQU	((PDRVSZ-RTOFF)/BLKS)-1	;
;
;	THE FOLLOWING SET OF EQUATES THAT SET GRTR ARE USED TO 
;	DETERMINE IF THE DSM IS >= 256.  THE EXTENT MASK IS SET 
;	DEPENDING ON GRTR EQUATE.
;
GRTR	SET	0	;
      IF (DSM SHR 8)OR(DSM SHR 9)OR(DSM SHR 10)
GRTR	SET	1	; IF ANY OF THESE BITS SET THEN DSM >= 256
      ENDIF
      IF (DSM SHR 11)OR(DSM SHR 12)OR(DSM SHR 13)
GRTR	SET	1	; IF ANY OF THESE BITS SET, DSM >= 256
      ENDIF
      IF (DSM SHR 14)OR(DSM SHR 15)
GRTR	SET	1	; 
      ENDIF
      IF GRTR
EXM	EQU	(BLKSZ/2)-1	;
      ENDIF
      IF NOT GRTR
EXM	EQU	BLKSZ-1		;
      ENDIF


; --- DISC PARAMETER BLOCK ---
;
;
DPBC	EQU	$+SHIFT
	DW	SPT	; SECTORS/TRACK ON CORVUS PSEUDO DRIVE
	DB	BSH	; BLOCK SHIFT
	DB	BLM	; BLOCK MASK
	DB	EXM	; EXTENT MASK
	DW	DSM	; DISK SIZE-1
	DW	DRM	; DIRECTORY MAX-1
	DB	AL0	; ALLOC0
	DB	AL1	; ALLOC1
	DW	0	; CHECK SIZE
	DW	OFF	; TRACK OFFSET


; ---- DISC PARAMETER BLOCKS AND HEADERS ----
;
;	  THE # OF DPE, PDRV, ALV, & CSV'S ALLOCATED IS BASED ON
;	THE LOWEST 3 BITS OF THE NPSUDO EQUATE.  IF BIT 0 = 1,
;	THEN 1 SET OF THE PREVIOUSLY MENTIONED STRUCTURES ARE 
;	ALLOCATED. IF BIT 1 = 1 THEN 2 MORE; AND IF BIT 2 = 1,
;	THEN 4 MORE SETS ARE ALLOCATED.  THUS IF ALL 3 BITS ARE
;	SET, A MAXIMUM OF 7 PSEUDO DRIVES ARE SET UP.
;	ALL REFERENCES TO THE DPE TABLE AND THE PDRV TABLE ARE
;	MADE VIA THE BASE ADDRESS FOR EACH TABLE.
;
;
;  NOTE: THE REFERENCES TO THE DIRECTORY BUFFER GET
;	 PATCHED TO THAT OF THE RESIDENT CP/M 2.X SYSTEM
;	 WHEN THE LINK IS INSTALLED
;
DPBASE	EQU	$+SHIFT
;
      IF NPSUDO			;
DPE0	EQU	$+SHIFT
	DW	0,0	; CORVUS PSEUDO DRIVE 1
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV0,ALV0	; CHECK, ALLOC MAP
      ENDIF
;
      IF NPSUDO SHR 1		;
DPE1	EQU	$+SHIFT		; CORVUS PSEUDO DRIVE 2
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV1,ALV1	; CHECK, ALLOC MAP
;
DPE2	EQU	$+SHIFT		; CORVUS PSEUDO DRIVE 3
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV2,ALV2	; CHECK, ALLOC MAP
;
      ENDIF
      IF NPSUDO SHR 2		;
DPE3	EQU	$+SHIFT		; CORVUS PSEUDO DRIVE 4
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV3,ALV3	; CHECK, ALLOC MAP
;
DPE4	EQU	$+SHIFT		; CORVUS PSEUDO DRIVE 5
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV4,ALV4	; CHECK, ALLOC MAP
;
DPE5	EQU	$+SHIFT		; CORVUS PSEUDO DRIVE 6
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV5,ALV5	; CHECK, ALLOC MAP
;
DPE6	EQU	$+SHIFT		; CORVUS PSEUDO DRIVE 7
	DW	0,0		;
	DW	0,0
	DW	DIRBUF,DPBC	; DIRECTORY BUFFER, PARAM. BLOCK
	DW	CSV6,ALV6	; CHECK, ALLOC MAP
;
      ENDIF
;
;
; ---- CORVUS DISC OFFSET TABLE ----
;
;  THIS TABLE SPECIFIES WHERE THE PSEUDO DRIVES ARE
;  ON THE CORVUS DRIVE (BY ADDRESS AND DRIVE #).
;  EACH PSEUDO DRIVE ENTRY USES A 3 BYTE SECTOR(128 BYTES) ADDRESS
;  AND 1 BYTE TO REPRESENT THE PHYSICAL DRIVE #.  THE 1ST 2 BYTES
;  OF THE ADDRESS ARE DEFINED AS A WORD( I.E.- HIGH BYTE, LOW BYTE).
;  IT IS AT THIS TIME THAT WE MULTIPY THE ADDRESS BY 4 TO CHANGE
;  THE UNITS FROM 512 BYTE BLOCKS TO 128 BYTE SECTORS.  THE 3RD BYTE
;  IS THE HIGH ORDER BYTE OF A 3 BYTE SECTOR ADDRESS.
;
MAX16	EQU	16384		; MAX # OF 128 BYTE SECTORS ADDRESSIBLE
				; BY 16 BITS (IN UNITS OF 512 BYTE
				; BLOCKS. 16384*4=65536)
;
CUROFF	SET	0		; TO GET AROUND WHAT SEEMS TO BE
				; A BUG IN ASM.
CUROFF	SET	CUROFF + RESERVE		;

OFSBAS	EQU	$+SHIFT

      IF NPSUDO			;
PDRV0OFF EQU	CUROFF		;
CUROFF	SET	PDRV0OFF + PDRVSZ	;

PDRV0	EQU	$+SHIFT
	DW	(PDRV0OFF MOD MAX16)*4	;
	DB	PDRV0OFF/MAX16		;
	DB	1			;
;
      ENDIF
      IF NPSUDO SHR 1		;
PDRV1OFF EQU	CUROFF			;
PDRV2OFF EQU	PDRV1OFF + PDRVSZ	;
CUROFF	 SET	PDRV2OFF + PDRVSZ	;

PDRV1	EQU	$+SHIFT
	DW	(PDRV1OFF MOD MAX16)*4	;
	DB	PDRV1OFF/MAX16		;
	DB	1			;
;
PDRV2	EQU	$+SHIFT
	DW	(PDRV2OFF MOD MAX16)*4	;
	DB	PDRV2OFF/MAX16		;
	DB	1			;
;
      ENDIF
      IF NPSUDO SHR 2		;
PDRV3OFF EQU	CUROFF			;
PDRV4OFF EQU	PDRV3OFF + PDRVSZ	;
PDRV5OFF EQU	PDRV4OFF + PDRVSZ	;
PDRV6OFF EQU	PDRV5OFF + PDRVSZ	;
CUROFF	 SET	PDRV6OFF + PDRVSZ	;

PDRV3	EQU	$+SHIFT
	DW	(PDRV3OFF MOD MAX16)*4	;
	DB	PDRV3OFF/MAX16		;
	DB	1			;
;
PDRV4	EQU	$+SHIFT
	DW	(PDRV4OFF MOD MAX16)*4	;
	DB	PDRV4OFF/MAX16		;
	DB	1			;
;
PDRV5	EQU	$+SHIFT
	DW	(PDRV5OFF MOD MAX16)*4	;
	DB	PDRV5OFF/MAX16		;
	DB	1			;
;
PDRV6	EQU	$+SHIFT
	DW	(PDRV6OFF MOD MAX16)*4	;
	DB	PDRV6OFF/MAX16		;
	DB	1			;
;
      ENDIF
;
;	  THE ALLOCATION VECTOR  IS A BIT MAP OF THE ASSOCIATED
;	VOLUME.  EACH BIT REPRESENTS 1 "LOGICAL BLOCK" OF THE
;	VOLUME.  SO ITS SIZE IS CALCULATED BY DIVIDING THE # OF
;	"LOGICAL BLOCKS" (I.E.- DSM+1) BY THE # OF BITS IN A BYTE
;	AND ADDING 1 IN CASE OF ROUNDING ERROR.
;	  THE CHECKSUM VECTOR IS CURRENTLY NOT USED ON THE CORVUS,
;	BUT MUST EXIST TO DEFINE THE LABELS.
;
ALVSZ	EQU	((DSM+1)/8)+1	;
      IF NPSUDO			;
ALV0	EQU	$+SHIFT		;
	DS	ALVSZ		;
CSV0	EQU	$+SHIFT		;
	DS	0		
      ENDIF
      IF NPSUDO SHR 1		;
ALV1	EQU	$+SHIFT		;
	DS	ALVSZ		;
CSV1	EQU	$+SHIFT		;
	DS	0		
ALV2	EQU	$+SHIFT		;
	DS	ALVSZ		;
CSV2	EQU	$+SHIFT		;
	DS	0		
      ENDIF
      IF NPSUDO SHR 2		;
ALV3	EQU	$+SHIFT		;
	DS	ALVSZ		;
CSV3	EQU	$+SHIFT		;
	DS	0		
ALV4	EQU	$+SHIFT		;
	DS	ALVSZ		;
CSV4	EQU	$+SHIFT		;
	DS	0		
ALV5	EQU	$+SHIFT		;
	DS	ALVSZ		;
CSV5	EQU	$+SHIFT		;
	DS	0		
ALV6	EQU	$+SHIFT		;
	DS	ALVSZ		;
CSV6	EQU	$+SHIFT		;
	DS	0		
      ENDIF

DIRBUF	EQU	$+SHIFT		; DEFINE LABEL
	DS	0		; BUT DONT ALLOCATE SPACE 
;
;$I CLINK2.DAT			; CLINK2 DATA DECLARATIONS
;FILEID: CLINK2.DAT
;
;
; -------- MESSAGES -----------
;
ERMSG	EQU	$+SHIFT
	DB 0DH,0AH,07,' -- DISC R/W ERROR # $'
;
ERMSG1	EQU	$+SHIFT
	DB 'H --',0DH,0AH,'$'
;
; --------- BUFFERS --------------
;
DMAAD	EQU	$+SHIFT
	DS	2	; DMA ADDRESS
TRACK	EQU	$+SHIFT
	DS	2	; TRACK #
SECTOR	EQU	$+SHIFT
	DS	2	; SECTOR #
DSKNO	EQU	$+SHIFT
	DB	0FFH	; CURRENT DISC # (UNDEFINED AT START)
ADDOF	EQU	$+SHIFT
	DS	2	; BUFFER FOR POINTER TO ADDRESS OFFSET
NSPTRK	EQU	$+SHIFT
	DS	2	; BUFFER WITH # SECTORS/TRACK
PPOINT	EQU	$+SHIFT
	DS	2	; POINTER TO CURRENT PARAM. BLOCK
CDRIVE	EQU	$+SHIFT
	DS	1	; BUFFER FOR CORVUS DISC #
;
	IF XRX
RTSAV	EQU	$+SHIFT
	DS	2	; BUFFER FOR SAVING RETURN ADDRESS IN R/W
			;   ROUTINES
DESAV	EQU	$+SHIFT
	DS	2	; BUFFER FOR SAVING (D,E) IN R/W ROUTINES
BCSAV	EQU	$+SHIFT	; BUFFER FOR SAVING BC REGISTER
	DS	2	;
	ENDIF
;
;
;
ENDP	EQU  $
LENC	EQU	ENDP-START	;LENGTH OF CODE TO COPY 

	DS	80		;
STACK	EQU	$		; LOCAL STACK SPACE
	END
