
/* List a directory of a RT-11 volume */
/* Copyright 1994 Syndesis Corporation, by John Foust <jfoust@threedee.com> */
/* July 12, 1990 */

#include <stdio.h>
#include <string.h>

#include "diskdecl.h"

#include "rt11decl.h"
#define PRIMARY
#include "rt11vars.h"


/* Give a directory of an RT-11 disk image file */

int main( int argc, char **argv )
{
USHORT lerr;
int each;
char inname[128];
FILE *infp;
rtDirRoot dirRoot;
rtFileEntry *eachEntry;
char buff[ 16 ];
USHORT block;
char *lineSpec;


    infp = NULL;
    doSwab = FALSE;

    if (argc == 2) {
        strcpy( inname, argv[1] );
    }
    else {
        puts( "Lists directories of RT-11 disk image files" );
        puts( "Usage: tdrt imagefilename" );
        goto out;
    }

    /* Open input file from command line */
    printf( "\nDirectory of RT-11 disk image file '%s'\n\n", inname );
    infp = fopen( inname, "rb" );
    if (infp == NULL) {
        puts("Couldn't open file.");
        goto out;
    }

    /* Read volume info, including 72 file entries */
    if ((lerr=readRT11VolInfo( infp, &dirRoot )) != TE_NOERROR) {
        puts( "Failed on volume info." );
        goto out;
    }

    /* Print volume info header */
    printf( "segs %hu, next %hu, high %hu, filler %hu, begin %hu\n\n",
        dirRoot.segsAvailable, dirRoot.nextSegment, dirRoot.highSegment,
        dirRoot.filler, dirRoot.beginSegment );

    /* Header */
    printf( "              Size  Block   Date\n" );

    /* Format specifier for each line */
    lineSpec = " %-11s  %3hu  %4hu";

    /* Print each entry */
    block = dirRoot.beginSegment;
    eachEntry = &dirRoot.files[0];
    for (each=0; each<RT_NUM_FILES; each++) {

        /* If no more files */
        if (eachEntry->status == RT_ENDMARK) {
            break;
        }
        /* If a temporary file */
        else if (eachEntry->status == RT_TENTATIVE) {
            printf( lineSpec, "<temp>", eachEntry->length, block );
            /* Always have date of 0 */
            printf( "\n" );
        }
        /* If empty space, like at end of list */
        else if (eachEntry->status == RT_EMPTY) {
            printf( lineSpec, "<empty>", eachEntry->length, block );
            /* Always have date of 0 */
            printf( "\n" );
        }
        /* If a permanent file */
        else if (eachEntry->status == RT_PERM) {

            /* Convert RAD-50 filename to ASCII, including extension '.' */
            rad50ToAscii( eachEntry->name[0], &buff[0] );
            rad50ToAscii( eachEntry->name[1], &buff[3] );
            buff[6] = '.';
            rad50ToAscii( eachEntry->name[2], &buff[7] );
            buff[10] = '\0';

            printf( lineSpec, buff, eachEntry->length, block );

            /* Date */
            rtDateStr( eachEntry->date, buff );
            printf( "  %s\n", buff );
        }
        else {
            printf( "Unknown status %hu 0x%04hx\n", eachEntry->status, eachEntry->status );
        }

        /* Keep track of which block we're at */
        block += eachEntry->length;

        eachEntry ++;
    }

out:
    if (infp != NULL) {
        fclose( infp );
        infp = NULL;
    }

    return 0;
}

