
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <io.h>
#include <time.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/utime.h>

#include "diskdecl.h"

#include "ucsddecl.h"
#include "ucsdvars.h"


/* Set the filesystem timestamp to agree with the UCSD data */

void ucsdSetTimeStamp( char *filename, ucsdDirEntry *eachEntry )
{
struct _utimbuf timebuf;
struct tm ucsdTime;
time_t fileTime;
int result;


    /* Safety */
    if (eachEntry->lastAccess == 0) {
        return;
    }

    /* All translated files made at noon */
    ucsdTime.tm_sec = 0;   /* seconds after the minute - [0,59] */
    ucsdTime.tm_min = 0;   /* minutes after the hour - [0,59] */
    ucsdTime.tm_hour = 12; /* hours since midnight - [0,23] */

    /* On the date they were made under UCSD */
    /* day of the month - [1,31] */
    ucsdTime.tm_mday = ucsdDAY(eachEntry->lastAccess);
    
    /* months since January - [0,11] */
    ucsdTime.tm_mon = ucsdMONTH(eachEntry->lastAccess);

    /* Year (current year minus 1900) */
    ucsdTime.tm_year = ucsdYEAR(eachEntry->lastAccess);

    /* Leave these fields zero */
    ucsdTime.tm_wday = 0; /* days since Sunday - [0,6] */
    ucsdTime.tm_yday = 0; /* days since January 1 - [0,365] */

    /* Positive if daylight saving time is in effect; 
    0 if daylight saving time is not in effect; 
    negative if status of daylight saving time is unknown. */
    ucsdTime.tm_isdst = -1;   /* daylight savings time flag */

    /* Debug */
    /* printf( "ucsdTime %s", asctime( &ucsdTime ) ); */

    /* Convert the 'struct tm' to a 'time_t' */
    fileTime = mktime( &ucsdTime );
    if (fileTime == (time_t) -1) {
        printf( "mktime failed\n" ) /* failed */;
    }

    /* Make create and modification dates the same */
    timebuf.actime = fileTime;
    timebuf.modtime = fileTime;

    /* Set the time on the file */
    result = _utime( filename, &timebuf );
    if (result == -1) {
        printf( "_futime '%s' failed, errno %d\n", filename, errno );
    }
}

