                                                          
/* rtdate.c - RT-11 type strings */
/* Copyright 1994 Syndesis Corporation, by John Foust <jfoust@threedee.com> */
/* March 17, 1998 */

#include <stdio.h>
#include <string.h>

#include "diskdecl.h"

#include "rt11decl.h"
#include "rt11vars.h"


/* Convert RT-11 date to ASCII "01-May-79" */

static char *month_str[] = 
    { "???", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

void rtDateStr( USHORT date, char *str )
{
int day;
int month;
int year;


    year  = (date & 0x1F) + 72;
    day   = (date >> 5)  & 0x1F;
    month = (date >> 10) & 0x1F;

    if (month < 1 || month > 12) {
        month = 0;
    }

    sprintf( str, "%02d-%3s-%02d", day, month_str[month], year );
}

