
#include <stdio.h>
#include <string.h>

#include "diskdecl.h"

#include "ucsddecl.h"
#include "ucsdvars.h"


/* Sniff the endian of the disk image file, set global doSwab */

USHORT determineEndian( FILE *infp )
{
USHORT lerr;
short firstBlk;     /* first block of volume */
short lastBlk;
short swapped;


    /* Seek to volume info */
    fseek( infp, (long) (UCSD_BLK_SIZE * 2), SEEK_SET );

    /* Read a few elements */
    if (fread( &firstBlk, sizeof(short), (size_t) 1, infp ) != 1) {
        lerr = TE_BADREAD;
        goto out;
    }

    /* lastBlk */
    if (fread( &lastBlk, sizeof(short), (size_t) 1, infp ) != 1) {
        lerr = TE_BADREAD;
        goto out;
    }
    
    /* printf( "lastBlk %hx %hd, ", lastBlk, lastBlk ); */
    swapped = lastBlk;
    swabShort( &swapped );
    /* printf( "swapped %hx %hd\n", swapped, swapped ); */

    /* firstBlk is probably 0, but last block will be a small int like 6 */
    doSwab = FALSE;
    if (swapped < 100) {
        doSwab = TRUE;
    }

    lerr = TE_NOERROR;
out:
    return lerr;
}


#ifdef UNUSED
short fileKind;

    if (fread( &fileKind, sizeof(short), (size_t) 1, infp ) != 1) {
        lerr = TE_BADREAD;
        goto out;
    }
#endif
