
/* dbprintf.c - Debugging printf() for Windows */
/* Copyright 1994 Syndesis Corporation */
/* July 12, 1990 */

#include <stdio.h>
#include <string.h>

#include "diskdecl.h"

#include "ucsddecl.h"
#include "ucsdvars.h"

#define DEBUG

#ifdef DEBUG
#define DBG(x)  x
#else
#define DBG(x)
#endif


/* For Windows only */
#if defined(_MSC_VER)

#define NOCOMM
#include <windows.h>

#include <string.h>
#include <stdio.h>
#include <stdarg.h>             /* va_start */


/* */

void dbPrintf( char *format, ... )
{
#ifdef DEBUG
va_list marker;             /* variable argument access */
char string[ 512 ];         /* area to build output */


    /* Prepare the string they want */
    va_start( marker, format );         /* mark stack arguments */
    vsprintf( string, format, marker ); /* variable sprintf */
    va_end( marker );                   /* clean up */

    /* Now output it */
    OutputDebugString(string);
#endif
}

#else

void dbPrintf( char *format, ... )
{
}

#endif

