;	FILE IS COMLOOP1.ASM

;	Serial interface loopback test for the Printer connector of the
;	Type 1, Type 2, and Type 3 (Display) terminals.

;	Printer interface on the Type 2 terminal is the SERIAL connector
;	located to the right of the PARALLEL connector on the terminal.

;	Printer interface on the Type 1 terminal is the RS-232 connector.

;	Printer interface on the Type 3 terminal is the Port A connector
;	(J1) on the dual port interface expansion.

;	This program accepts input from keyboard and sends it on the printer
;	interface.
;	It accepts input from the printer interface and displays it on the
;	console.

;	With a loopback plug this is a test of operation.
;	With a modem, this is a simple 'dumb' terminal program.

;	The sequence <ESC> <ESC> will terminate the program and return to
;	CP/M

;	This sample program is written using the BDOS interface.  A similar
;	program could be written using a BIOS interface but that version would
;	then possibly require rewriting in going to the next version of CP/M

;	Revised 12 November, 1981
;	The original version used BDOS call 11 to get console status to
;	determine if a character was available.  This is an error if you are 
;	using BDOS call 6 for direct input.  The BDOS call 11 actually reads
;	a character from the input if it is available and stores it in a 
;	1 character buffer internal to BDOS.  This results in CALL 11 always 
;	returning a character present (regardless of the actual device) and the
;	character in the buffer is never read by the program!!!

;	This version uses BDOS call 6 for all input and status.  There is a
;	problem that this program can never receive or transmit the null 
;	character.  If you want to do this you will have to use direct BIOS calls.


	org	100h
	jmp	start

;	temporary storage
c1	db	0
c2	db	0

;	ASCII equates
cr	equ	0dh
lf	equ	0ah
cls	equ	1Ah
esc	equ	1bh

signon:	db	cls,'Control Data 110',cr,lf,lf
	db	'printer interface Channel Loopback program',cr,lf
	db	'Any character typed on the keyboard will be transmitted',cr,lf
	db	' on the printer interface channel',cr,lf
	db	'printer input will be displayed on the screen.',cr,lf,lf
	db	'Type <ESC><ESC> to return to CP/M.',cr,lf
	db	'$'

;	BIOS location definitions

combyt	equ	0Eh		;Communications channel selector byte
				;0 = printer interface
				;1 = serial printer interface
				;2 = Dual port B on Viking X
				;3 = Modem port on Viking X

;	BDOS interface and equates

bdos	equ	5
iobc	db	0		;I/O byte for console input/output
iobs	db	2		;I/O byte for serial input/output

ci:		;Read console character to A (wait for input)
	mvi	c,1
	jmp	bdos

co:		;send E to console output
	mvi	c,2
	jmp	bdos

lo:		;send E to list device
	mvi	c,5
	jmp	bdos

cio:		;direct console I/O E=FF => input to A
		;otherwise output char from E
	mvi	c,6
	jmp	bdos

giob:		;i/o byte to A
	mvi	c,7
	jmp	bdos

siob:		;store i/o byte in E
	mvi	c,8
	jmp	bdos

ps:		;print string at (DE) stop on '$'
	mvi	c,9
	jmp	bdos

;	Serial interface routines which change I/O byte to substitute
;	Serial for Console interface and then restore

conin:		;console get char to A register (dont use echo)
	mvi	e,0ffh
	call	cio
	ret


serin:		;Serial character in to A register
	lda	iobs
	mov	e,a
	call	siob		;select serial input
	mvi	e,0ffh
	call	cio
	push	a		;save character
	lda	iobc
	mov	e,a
	call	siob
	pop	a
	ret

serout:		;Serial character out from E
	push	d
	lda	iobs
	mov	e,a
	call	siob		;select serial input
	pop	d
	call	cio
	lda	iobc
	mov	e,a
	call	siob
	ret

;	main program

start:
	lxi	d,signon
	call	ps		;print signon message
	mvi	a,1
	sta	combyt		;Select Printer interface channel
	call	giob
	sta	iobc		;save console select
	ori	2		;set in serial for console
	sta	iobs		;save serial select

loop:		;transfer loop
	call	conin		;get char
	mov	e,a
	ana	a
	jz	l1		;no char from keyboard
	push	a		;save for move
	lda	c1
	sta	c2
	mov	c,a
	pop	a
	sta	c1
	cmp	c		;are chars the same?
	jnz	loop1
	cpi	esc
	rz			;if two escapes in a row
loop1:	call	serout		;send it

l1:	call	serin		;get character or status to A
	ana	a
	jz	loop		;no serial input
	mov	e,a
	call	co		;display it
	jmp	loop

	end
in:		;Serial character in to A register
	lda	iobs