	title	TURBODOS OPERATING SYSTEM - FLOPPY DISK DRIVE SPECIFICATION TABLES
	subttl	copyright 1983, software 2000, inc.
	.z80
;
; copyright 1983, software 2000, inc.
;	converted to MICROSOFT M80 format by
;	  Advanced Digital Corp.
;
; version: 01/27/84 doc
;
	name	('dskfmt')		;module id
;
	include DREQUATE.LIB	;driver symbolic equivalences
;
false	equ	0		;logical equates
true	equ	not false
;
;
cpm	equ	TRUE 		;set to false for TURBODOS 0 track offsets
				; on double density disks
;
tsd	equ	2		;two-sided disk bit (type code)
ddd	equ	3		;double density disk bit (type code)
mini	equ	4		;mini-floppy disk bit (type code)
tpi96	equ	5		;96-tpi disk bit (type code)
;
	public	xltbl,dtco,typcod,gaplen
;
	cseg			;locate in program area
;
;	1024 byte sector, double-density, two-sided
;
dstbls::
	dw	$+dstl	;disk spec table link pointer
	db	4		;block size

	if	cpm
	dw	(76*(16*(1 shl 3)))/(1 shl 4);number of blocks
	else
	dw	(77*(16*(1 shl 3)))/(1 shl 4);number of blocks
	endif

	db	4		;number of directory blocks
	db	3		;physical sector size (2^n*128)
	dw	16		;physical sectors per track
	dw	77		;physical tracks per disk

	if	cpm
	dw	1		;number of reserved tracks
	else
	dw	0		;number of reserved tracks
	endif

	dw	0		;translation table address
	db	1 shl ddd or 1 shl tsd or 3	;disk type code
	db	35h		;gap length
;
;	1024 byte sector, double-density, two-sided, 96-tpi (mini)
;
	dw	$+dstl		;disk spec table link pointer
	db	4		;block size

	if	cpm
	dw	(76*(8*(1 shl 3)))/(1 shl 4);number of blocks
	db	2		;number of directory blocks
	db	3		;physical sector size (2^n*128)
	dw	8		;physical sectors per track
	dw	77		;physical tracks per disk
	dw	1		;number of reserved tracks
	else
	dw	(80*(10*(1 shl 3)))/(1 shl 4);number of blocks
	db	4		;number of directory blocks
	db	3		;physical sector size (2^n*128)
	dw	10		;physical sectors per track
	dw	80		;physical tracks per disk
	dw	0		;number of reserved tracks
	endif

	dw	0		;translation table address
	db	1 shl tpi96 or 1 shl mini or 1 shl ddd or 1 shl tsd or 3;disk type code
	db	35h		;gap length
;
;	1024 byte sector, double-density, two-sided (mini)
;
	dw	$+dstl		;disk spec table link pointer
	db	4		;block size

	if	cpm
	dw	(39*(8*(1 shl 3)))/(1 shl 4);number of blocks
	db	2		;number of directory blocks
	db	3		;physical sector size (2^n*128)
	dw	8		;physical sectors per track
	dw	40		;physical tracks per disk
	dw	1		;number of reserved tracks
	else
	dw	(40*(10*(1 shl 3)))/(1 shl 4);number of blocks
	db	2		;number of directory blocks
	db	3		;physical sector size (2^n*128)
	dw	10		;physical sectors per track
	dw	40		;physical tracks per disk
	dw	0		;number of reserved tracks
	endif

	dw	0		;translation table address
	db	1 shl mini or 1 shl ddd or 1 shl tsd or 3;disk type code
	db	35h		;gap length
;
;	1024 byte sector, double-density, one-sided
;
	dw	$+dstl		;disk spec table link pointer
	db	4		;block size

	if	cpm
	dw	(76*(8*(1 shl 3)))/(1 shl 4);number of blocks
	else
	dw	(77*(8*(1 shl 3)))/(1 shl 4);number of blocks
	endif

	db	3		;number of directory blocks
	db	3		;physical sector size (2^n*128)
	dw	8		;physical sectors per track
	dw	77		;physical tracks per disk

	if	cpm
	dw	1		;reserved tracks
	else
	dw	0		;reserved tracks
	endif

	dw	0		;translation table address
	db	1 shl ddd or 3		;disk type code
	db	35h		;gap length
;
;	1024 byte sector, double-density, one-sided, 96-tpi (mini)
;
	dw	$+dstl		;disk spec table link pointer
	db	4		;block size

	if	cpm
	dw	(76*(4*(1 shl 3)))/(1 shl 4);number of blocks
	db	1		;number of directory blocks
	db	3		;physical sector size (2^n*128)
	dw	4		;physical sectors per track
	dw	77		;physical tracks per disk
	dw	1		;reserved tracks
	else
	dw	(80*(5*(1 shl 3)))/(1 shl 4);number of blocks
	db	2		;number of directory blocks
	db	3		;physical sector size (2^n*128)
	dw	5		;physical sectors per track
	dw	80		;physical tracks per disk
	dw	0		;reserved tracks
	endif

	dw	0		;translation table address
	db	1 shl tpi96 or 1 shl mini or 1 shl ddd or 3;disk type code
	db	35h		;gap length
;
;	1024 byte sector, double-density, one-sided (mini)
;
	dw	$+dstl		;disk spec table link pointer
 	db	3		;block size
;	db	4

	if	cpm
	dw	(39*(4*(1 shl 3)))/(1 shl 3);number of blocks
;	db	1		;number of directory blocks

 	db	2

	db	3		;physical sector size (2^n*128)
	dw	4		;physical sectors per track
	dw	40		;physical tracks per disk
	dw	1		;reserved tracks
	else
	dw	(40*(5*(1 shl 3)))/(1 shl 3);number of blocks
	db	2		;number of directory blocks
	db	3		;physical sector size (2^n*128)
	dw	5		;physical sectors per track
	dw	40		;physical tracks per disk
	dw	0		;reserved tracks
	endif

	dw	0		;translation table address
	db	1 shl mini or 1 shl ddd or 3	;disk type code
	db	35h		;gap length
;
;	512 byte sector, double-density, one-sided mini (Kaypro DD)
; * two-sided patch 2-85
;
 	dw	$+dstl	;disk spec table link pointer
 	db	3	;block size
 	dw	(39*(10*(1 shl 2)))/(1 shl 3)  ;number of blocks
 	db	2	;number of directory blocks
 	db	2	;physical sector size (2^n*128)
 	dw	10	;physical sectors per track
 	dw	40	;physical tracks per disk
 	dw	1	;reserved tracks
 	dw	kayskw	;translation table address
 	db	1 shl ddd or 1 shl mini or 1 shl tsd or 3  ; type 
 	db	1bh	;gap length
;
;	512 byte sector, single-density, two-sided
;
 	dw	$+dstl		;disk spec table link pointer
 	db	4		;block size
 	dw	(77*(16*(1 shl 2)))/(1 shl 4);number of blocks
 	db	3		;number of directory blocks
 	db	2		;physical sector size (2^n*128)
 	dw	16		;physical sectors per track
 	dw	77		;physical tracks per disk
 	dw	0		;reserved tracks
 	dw	0		;translation table address
 	db	1 shl tsd or 2		;disk type code
 	db	1bh		;gap length
;
;	512 byte sector, single-density, one-sided
;
 	dw	$+dstl		;disk spec table link pointer
 	db	4		;block size
 	dw	(77*(8*(1 shl 2)))/(1 shl 4);number of blocks
 	db	2		;number of directory blocks
 	db	2		;physical sector size (2^n*128)
 	dw	8		;physical sectors per track
 	dw	77		;physical tracks per disk
 	dw	0		;reserved tracks
 	dw	0		;translation table address
 	db	2		;disk type code
 	db	1bh		;gap length
;
;	256 byte sector, single-density, two-sided
;
 	dw	$+dstl	;disk spec table link pointer
 	db	4	;block size
 	dw	(77*(30*(1 shl 1)))/(1 shl 4)  ;number of blocks
 	db	3	;number of directory blocks
 	db	1	;physical sector size (2^n*128)
 	dw	30	;physical sectors per track
 	dw	77	;physical tracks per disk
 	dw	0	;reserved tracks
 	dw	0	;translation table address
 	db	1 shl tsd or 1	;disk type code
 	db	0eh	;gap length
;
;	256 byte sector, single-density, one-sided
;
 	dw	$+dstl	;disk spec table link pointer
 	db	4	;block size
 	dw	(77*(15*(1 shl 1)))/(1 shl 4)  ;number of blocks
 	db	2	;number of directory blocks
 	db	1	;physical sector size (2^n*128)
 	dw	15	;physical sectors per track
 	dw	77	;physical tracks per disk
 	dw	0	;reserved tracks
 	dw	0	;translation table address
 	db	1	;disk type code
 	db	0eh	;gap length
;
;	256 byte sector, single-density, one-sided 48-tpi mini (Osborne SD)
;
	dw	$+dstl	;disk spec table link pointer
	db	4	;block size
	dw	(37*(10*(1 shl 1)))/(1 shl 4)  ;number of blocks
	db	1	;number of directory blocks
	db	1	;physical sector size (2^n*128)
	dw	10	;physical sectors per track
	dw	37	;physical tracks per disk WAS 37
	dw	3	;reserved tracks
	dw	osbskw	;translation table address
	db	1 shl mini or 1	;disk type code
	db	0eh	;gap length
;
;	128 byte sector, single-density, two-sided
;
 	dw	$+dstl	;disk spec table link pointer
 	db	4	;block size
 	dw	(77*(52*(1 shl 0)))/(1 shl 4)  ;number of blocks
 	db	2	;number of directory blocks
 	db	0	;physical sector size (2^n*128)
 	dw	52	;physical sectors per track
 	dw	77	;physical tracks per disk
 	dw	0	;reserved tracks
 	dw	0	;translation table address
 	db	1 shl tsd	;disk type code
 	db	7	;gap length
;
;	128 byte sector, single-density, single-sided 48-tpi mini (Xerox SD)
;
 	dw	$+dstl	;disk spec table link pointer
 	db	3	;block size
 	dw	(37*(18*(1 shl 0)))/(1 shl 3)  ;number of blocks
 	db	1	;number of directory blocks
 	db	0	;physical sector size (2^n*128)
 	dw	18	;physical sectors per track
 	dw	40	;physical tracks per disk
 	dw	3	;reserved tracks
 	dw	xrxskw	;translation table address
 	db	1 shl mini	;disk type code
 	db	7	;gap length
;
;	128 byte sector, single-density, one-sided
;
dsta:	dw	0		;disk spec table link pointer
dstb:	db	3		;block size
	dw	(75*(26*(1 shl 0)))/(1 shl 3);number of blocks
	db	2		;number of directory blocks
	db	0		;physical sector size (2^n*128)
	dw	26		;physical sectors per track
	dw	77		;physical tracks per disk
	dw	2		;reserved tracks
;
xltbl	equ	$-dstb	;translation table address offset
;
	dw	trtbl		;translation table address
;
dtco	equ	$-dsta		;disk type code offset
typcod	equ	$-dstb		;disk type code offset
;
	db	0		;disk type code
;
gaplen	equ	$-dstb		;gap length offset
;
	db	7		;gap length
;
dstl	equ	$-dsta		;disk spec table length
;
; single-density/single-sided (8", IBM-3740) sector translation table
;
trtbl:	db	0,6,12,18,24,4,10,16,22
	db	2,8,14,20,1,7,13,19,25
	db	5,11,17,23,3,9,15,21
;
; Kaypro II sector translation table
;
kayskw:	db	0FFH,00,01,02,03,04,05,06,07,08
;
; Osborne SD sector translation table
;
osbskw:	db	0,2,4,6,8,1,3,5,7,9
;
; Xerox SD sector translation table
;
xrxskw:	db	0,5,10,15,2,7,12,17,4,9,14,1,6,11,16,3,8,13
;
	END
