.SLIST	.XLIST
;
; ASCII EQUIVALENCES
;
ANUL	== 00H		;NULL
ASOH	== 01H		;SOH
ASTX	== 02H		;STX
AETX	== 03H		;ETX
AEOT	== 04H		;EOT
AENQ	== 05H		;ENQ
AACK	== 06H		;ACK
ABEL	== 07H		;BELL
ABS	== 08H		;BS
AHT	== 09H		;HT
ALF	== 0AH		;LF
AVT	== 0BH		;VT
AFF	== 0CH		;FF
ACR	== 0DH		;CR
ASO	== 0EH		;SO
ASI	== 0FH		;SI
ADLE	== 10H		;DLE
ADC1	== 11H		;DC1
ADC2	== 12H		;DC2
ADC3	== 13H		;DC3
ADC4	== 14H		;DC4
ANAK	== 15H		;NAK
ASYN	== 16H		;SYN
AETB	== 17H		;ETB
ACAN	== 18H		;CAN
AEM	== 19H		;EM
ASUB	== 1AH		;SUB
AESC	== 1BH		;ESC
AFS	== 1CH		;FS
AGS	== 1DH		;GS
ARS	== 1EH		;RS
AUS	== 1FH		;US
ASP	== 20H		;SPACE
ARUB	== 7FH		;RUBOUT (DEL)
;
; OPERATING SYSTEM EQUIVALENCES
;
WBOOT	== 0000H	;WARM START ENTRYPOINT
IOBYTE	== 0003H	;I/O CONFIGURATION BYTE
CURDRV	== 0004H	;CURRENT DEFAULT DRIVE
OPSYS	== 0005H	;OPERATING SYSTEM ENTRYPOINT
TFCB	== 005CH	;DEFAULT FILE CONTROL BLOCK
TBUF	== 0080H	;DEFAULT DISK BUFFER ADDRESS
TPA	== 0100H	;TRANSIENT PROGRAM AREA BASE
;
WSFCN	== 0		;FUNCTION 0 (WARM START)
CIFCN	== 1		;FUNCTION 1 (CONSOLE INPUT)
COFCN	== 2		;FUNCTION 2 (CONSOLE OUTPUT)
RCIFCN	== 3		;FUNCTION 3 (RAW CONSOLE INPUT)
RCOFCN	== 4		;FUNCTION 4 (RAW CONSOLE OUTPUT)
LOFCN	== 5		;FUNCTION 5 (LIST OUTPUT)
DCFCN	== 6		;FUNCTION 6 (DIRECT CONSOLE I/O)
RIBFCN	== 7		;FUNCTION 7 (RETURN I/O BYTE)
SIBFCN	== 8		;FUNCTION 8 (SET I/O BYTE)
PBFCN	== 9		;FUNCTION 9 (PRINT BUFFER)
CIBFCN	== 10		;FUNCTION 10 (CONSOLE IN BUFFERED)
CSFCN	== 11		;FUNCTION 11 (CONSOLE STATUS)
RVNFCN	== 12		;FUNCTION 12 (RETURN VERSN NUMBER)
RDSFCN	== 13		;FUNCTION 13 (RESET DISK SYSTEM)
SELFCN	== 14		;FUNCTION 14 (SELECT DISK)
OFFCN	== 15		;FUNCTION 15 (OPEN FILE)
CFFCN	== 16		;FUNCTION 16 (CLOSE FILE)
SFFFCN	== 17		;FUNCTION 17 (SEARCH FOR 1ST FILE)
SNFFCN	== 18		;FUNCTION 18 (SEARCH FOR NEXT FILE)
DFFCN	== 19		;FUNCTION 19 (DELETE FILE)
RSFFCN	== 20		;FUNCTION 20 (READ SEQUENTIAL FILE)
WSFFCN	== 21		;FUNCTION 21 (WRITE SEQ FILE)
MFFCN	== 22		;FUNCTION 22 (MAKE FILE)
RFFCN	== 23		;FUNCTION 23 (RENAME FILE)
RLIFCN	== 24		;FUNCTION 24 (RETURN LOGIN VECTOR)
RCDFCN	== 25		;FUNCTION 25 (RETURN CURRENT DISK)
SDFCN	== 26		;FUNCTION 26 (SET DMA)
;
WPDFCN	== 28		;FUNCTION 28 (WRITE PROTECT DISK)
RROFCN	== 29		;FUNCTION 29 (RETURN R/O VECTOR)
SFAFCN	== 30		;FUNCTION 30 (SET FILE ATTRIBUTES)
DPBFCN	== 31		;FUNCTION 31 (DISK PARAMETER BLOCK)
SRUFCN	== 32		;FUNCTION 32 (SET/RETURN USER)
RRFFCN	== 33		;FUNCTION 33 (READ RANDOM FILE)
WRFFCN	== 34		;FUNCTION 34 (WRITE RANDOM FILE)
CFSFCN	== 35		;FUNCTION 35 (COMPUTE FILE SIZE)
SRRFCN	== 36		;FUNCTION 36 (SET RANDOM RECORD)
RDFCN	== 37		;FUNCTION 37 (RESET DRIVE)
;
LKRFCN	== 42		;FUNCTION 42 (LOCK RECORD)
FRRFCN	== 43		;FUNCTION 43 (FREE RECORD)
;
DFSFCN	== 46		;FUNCTION 46 (DISK FREE SPACE)
CHNFCN	== 47		;FUNCTION 47 (CHAIN TO PROGRAM)
;
ROSFCN	== 73		;FUNCTION 73 (RESET O/S)
RAVFCN	== 74		;FUNCTION 74 (RETURN ALV INFO)
RDPFCN	== 75		;FUNCTION 75 (RETURN DISK PARMS)
SRPFCN	== 76		;FUNCTION 76 (SET/RET PRINT MODE)
EOPFCN	== 77		;FUNCTION 77 (SIGNAL END OF PRINT)
SRDFCN	== 78		;FUNCTION 78 (SET/RET DE-SPOOL)
QPFFCN	== 79		;FUNCTION 79 (QUEUE PRINT FILE)
NLOFCN	== 80		;FUNCTION 80 (NETWORK LIST OUT)
FLBFCN	== 81		;FUNCTION 81 (FLUSH LIST BUFFER)
;
SDTFCN	== 83		;FUNCTION 83 (SET DATE/TIME)
RDTFCN	== 84		;FUNCTION 84 (RETURN DATE/TIME)
SRSFCN	== 85		;FUNCTION 85 (SET/RET DISK STATUS)
PDAFCN	== 86		;FUNCTION 86 (PHYSICAL DISK ACCESS)
CCSFCN	== 87		;FUNCTION 87 (COMM CHANNEL STATUS)
CCIFCN	== 88		;FUNCTION 88 (COMM CHANNEL INPUT)
CCOFCN	== 89		;FUNCTION 89 (COMM CHANNEL OUTPUT)
SCBFCN	== 90		;FUNCTION 90 (SET COMM BAUD RATE)
RCBFCN	== 91		;FUNCTION 91 (RETURN COMM BAUD)
SMCFCN	== 92		;FUNCTION 92 (SET COMM MODEM CTRL)
RMCFCN	== 93		;FUNCTION 93 (RET COMM MODEM CTRL)
;
EBPFCN	== 95		;FUNCTION 95 (ENABLE BOOT PROM)
SBPFCN	== 96		;FUNCTION 96 (SET BUFFER PARMS)
RBPFCN	== 97		;FUNCTION 97 (RETURN BUFFER PARMS)
ADFFCN	== 98		;FUNCTION 98 (ACTIVATE DO FILE)
ALDFCN	== 99		;FUNCTION 99 (AUTO LOAD DISABLE)
;
DT1FCN	== 104		;FUNCTION 104 (SET DATE/TIME)
DT2FCN	== 105		;FUNCTION 105 (RETURN DATE/TIME)
;
RSNFCN	== 107		;FUNCTION 107 (RETURN S/N)
SCLFCN	== 108		;FUNCTION 108 (SEND COMMAND LINE)
SESFCN	== 109		;FUNCTION 109 (SET ERROR SERVICE)
SERFCN	== 110		;FUNCTION 110 (SET ERROR RETURN)
LOGFCN	== 111		;FUNCTION 111 (LOG ON/OFF)
LFDFCN	== 112		;FUNCTION 112 (LOCKOUT/FREE DRIVE)
LFFCN	== 113		;FUNCTION 113 (LOAD FILE)
RDMFCN	== 114		;FUNCTION 114 (REBUILD DISK MAP)
FFBFCN	== 115		;FUNCTION 115 (FLUSH/FREE BUFFERS)
;
RCFCN	== 118		;FUNCTION 118 (REMOTE CONSOLE)
ROUFCN	== 119		;FUNCTION 119 (RETURN ORIGIN/UNIT)
SCFFCN	== 120		;FUNCTION 120 (SET COMPATABILITY)
AMFCN	== 121		;FUNCTION 121 (ALLOCATE MEMORY)
DMFCN	== 122		;FUNCTION 122 (DE-ALLOCATE MEMORY)
SMFCN	== 123		;FUNCTION 123 (SEND MESSAGE)
RMFCN	== 124		;FUNCTION 124 (RECEIVE MESSAGE)
DPFCN	== 125		;FUNCTION 125 (DISPATCH PROCESS)
CTPFCN	== 126		;FUNCTION 126 (CREATE/TERM PROCESS)
USRFCN	== 127		;FUNCTION 127 (USER DEFINED)
.RLIST
                           