(* WRITTEN BY RUSSELL F. BUSHNELL JR. *)
(* JUNE 1, 1988 *)





PROGRAM MAIDIII5046;

CONST
  RECSIZ = 128;
  DEPTH = 300; (* MAXIMUM NUMBER OF TEST PACKETS *)
  MAXOMEMBUFFSIZ = 5;
  MAXIMEMBUFFSIZ = 5;
  MAXINFOSIZ = 5;

TYPE

  COMMANDA = (INSTRUC,DIR,MAKPKT,MANUAL,DELPKT,DMPPKT,DMPDAT,CMPDAT,
              EXECPKT,POSTA,PRNT,TERMTALK,PHONETERM,QUIT);
  CREG = ARRAY [1..50] OF CHAR;
  TREG = ARRAY [1..3] OF CHAR;
  IREG = ARRAY [1..20] OF CHAR;
  A2B = ARRAY [1..2] OF INTEGER;
  WDTEMPLATE = ARRAY [1..5] OF INTEGER;
  BUFFOUT = ARRAY [1..MAXOMEMBUFFSIZ] OF INTEGER;
  BUFFIN  = ARRAY [1..MAXIMEMBUFFSIZ] OF INTEGER;
  BUFINFO = ARRAY [1..MAXINFOSIZ] OF REAL;

VAR

  NAME : IREG;
  F1A : ARRAY [1..12] OF CHAR;
  F1B : ARRAY [1..12] OF CHAR;
  F1C : ARRAY [1..12] OF CHAR;
  EFW : WDTEMPLATE;
  AFW : WDTEMPLATE;
  ODW : WDTEMPLATE;
  IDW : WDTEMPLATE;
  STW : WDTEMPLATE;
  XSTW : WDTEMPLATE;
  EF : BOOLEAN;
  AF : BOOLEAN;
  OD : BOOLEAN;
  ID : BOOLEAN;
  ST : BOOLEAN;
  ODWR : REAL;
  TALK : CHAR;
  CTRLE : CHAR;
  X : CHAR;
  BASEREQ : CHAR;
  XINT : INTEGER;
  SADD : ARRAY [1..2] OF INTEGER;
  EADD : ARRAY [1..2] OF INTEGER;
  SDATA : WDTEMPLATE;
  PRGCMD : INTEGER;
  PRGMOD : INTEGER;
  CMDMOD : INTEGER;
  DATMOD : INTEGER;
  PRGCNT : ARRAY [1..2] OF INTEGER;
  CBIAS : ARRAY [1..2] OF INTEGER;
  HSTATS : ARRAY [1..2] OF INTEGER;
  PSTATS : ARRAY [1..2] OF INTEGER;
  ERRCNT : INTEGER;
  RETRYC : ARRAY [1..2] OF INTEGER;
  XFCNT : WDTEMPLATE;
  WDXFLEN : REAL;
  LOWSP : BOOLEAN;
  HIGHSP : BOOLEAN;
  CMP : BOOLEAN;
  CLR : BOOLEAN;
  PAR : BOOLEAN;
  MSTOP : BOOLEAN;
  ONERR : BOOLEAN;
  INVEF : BOOLEAN;
  INVTAG : BOOLEAN;
  INVPAR : BOOLEAN;
  INVTIM : BOOLEAN;
  TIMCNT : ARRAY [1..2] OF INTEGER;
  RECSB : BOOLEAN;
  RECUL : BOOLEAN;
  DRECA : BOOLEAN;
  SAVIBF : BOOLEAN;
  BUFRPT : BOOLEAN;
  WRDRPT : BOOLEAN;
  LSTPAC : BOOLEAN;
  FSTPAC : BOOLEAN;
  PRPCNT : ARRAY [1..2] OF INTEGER;
  PHTERM : BOOLEAN;

PROCEDURE M5046(VAR PRGCMD : INTEGER);
CONST
  ORG = $A800;
VAR
  XI : INTEGER;
  XC : CHAR;
  XB : BOOLEAN;
BEGIN
  XI := PRGCMD;
  INLINE("LDA / XI /
         "STA / $A825);
  XI := PRGMOD;
  INLINE("LDA / XI /
         "STA / $A826);
  XI := CMDMOD;
  INLINE("LDA / XI /
         "STA / $A827);
  XI := DATMOD;
  INLINE("LDA / XI /
         "STA / $A828);
  XI := PRGCNT[1];
  INLINE("LDA / XI /
         "STA / $A829);
  XI := PRGCNT[2];
  INLINE("LDA / XI /
         "STA / $A82A);
  XI := SADD[1];
  INLINE("LDA / XI /
         "STA / $A80D);
  XI := SADD[2];
  INLINE("LDA / XI /
         "STA / $A80E);
  XI := EADD[1];
  INLINE("LDA / XI /
         "STA / $A80F);
  XI := EADD[2];
  INLINE("LDA / XI /
         "STA / $A810);
  XI := SDATA[1];
  INLINE("LDA / XI /
         "STA / $A811);
  XI := SDATA[2];
  INLINE("LDA / XI /
         "STA / $A812);
  XI := SDATA[3];
  INLINE("LDA / XI /
         "STA / $A813);
  XI := SDATA[4];
  INLINE("LDA / XI /
         "STA / $A814);
  XI := SDATA[5];
  INLINE("LDA / XI /
         "STA / $A815);
  XI := DATMOD;
  INLINE("LDA / XI /
         "STA / $A828);
  XC := F1A[1];
  INLINE("LDA / XC /
         "STA / $A83A);
  XC := F1A[2];
  INLINE("LDA / XC /
         "STA / $A83B);
  XC := F1A[3];
  INLINE("LDA / XC /
         "STA / $A83C);
  XC := F1A[4];
  INLINE("LDA / XC /
         "STA / $A83D);
  XC := F1A[5];
  INLINE("LDA / XC /
         "STA / $A83E);
  XC := F1A[6];
  INLINE("LDA / XC /
         "STA / $A83F);
  XC := F1A[7];
  INLINE("LDA / XC /
         "STA / $A840);
  XC := F1A[8];
  INLINE("LDA / XC /
         "STA / $A841);
  XC := F1A[9];
  INLINE("LDA / XC /
         "STA / $A842);
  XC := F1A[10];
  INLINE("LDA / XC /
         "STA / $A843);
  XC := F1A[11];
  INLINE("LDA / XC /
         "STA / $A844);
  XC := F1B[1];
  INLINE("LDA / XC /
         "STA / $A85E);
  XC := F1B[2];
  INLINE("LDA / XC /
         "STA / $A85F);
  XC := F1B[3];
  INLINE("LDA / XC /
         "STA / $A860);
  XC := F1B[4];
  INLINE("LDA / XC /
         "STA / $A861);
  XC := F1B[5];
  INLINE("LDA / XC /
         "STA / $A862);
  XC := F1B[6];
  INLINE("LDA / XC /
         "STA / $A863);
  XC := F1B[7];
  INLINE("LDA / XC /
         "STA / $A864);
  XC := F1B[8];
  INLINE("LDA / XC /
         "STA / $A865);
  XC := F1B[9];
  INLINE("LDA / XC /
         "STA / $A866);
  XC := F1B[10];
  INLINE("LDA / XC /
         "STA / $A867);
  XC := F1B[11];
  INLINE("LDA / XC /
         "STA / $A868);
  XC := F1C[1];
  INLINE("LDA / XC /
         "STA / $A882);
  XC := F1C[2];
  INLINE("LDA / XC /
         "STA / $A883);
  XC := F1C[3];
  INLINE("LDA / XC /
         "STA / $A884);
  XC := F1C[4];
  INLINE("LDA / XC /
         "STA / $A885);
  XC := F1C[5];
  INLINE("LDA / XC /
         "STA / $A886);
  XC := F1C[6];
  INLINE("LDA / XC /
         "STA / $A887);
  XC := F1C[7];
  INLINE("LDA / XC /
         "STA / $A888);
  XC := F1C[8];
  INLINE("LDA / XC /
         "STA / $A889);
  XC := F1C[9];
  INLINE("LDA / XC /
         "STA / $A88A);
  XC := F1C[10];
  INLINE("LDA / XC /
         "STA / $A88B);
  XC := F1C[11];
  INLINE("LDA / XC /
         "STA / $A88C);
  XI := EFW[1];
  INLINE("LDA / XI /
         "STA / $AAB8);
  XI := EFW[2];
  INLINE("LDA / XI /
         "STA / $AAB9);
  XI := EFW[3];
  INLINE("LDA / XI /
         "STA / $AABA);
  XI := EFW[4];
  INLINE("LDA / XI /
         "STA / $AABB);
  XI := EFW[5];
  INLINE("LDA / XI /
         "STA / $AABC);
  XI := AFW[1];
  INLINE("LDA / XI /
         "STA / $AABD);
  XI := AFW[2];
  INLINE("LDA / XI /
         "STA / $AABE);
  XI := AFW[3];
  INLINE("LDA / XI /
         "STA / $AABF);
  XI := AFW[4];
  INLINE("LDA / XI /
         "STA / $AAC0);
  XI := AFW[5];
  INLINE("LDA / XI /
         "STA / $AAC1);
  XI := ODW[1];
  INLINE("LDA / XI /
         "STA / $AAC2);
  XI := ODW[2];
  INLINE("LDA / XI /
         "STA / $AAC3);
  XI := ODW[3];
  INLINE("LDA / XI /
         "STA / $AAC4);
  XI := ODW[4];
  INLINE("LDA / XI /
         "STA / $AAC5);
  XI := ODW[5];
  INLINE("LDA / XI /
         "STA / $AAC6);
  XI := IDW[1];
  INLINE("LDA / XI /
         "STA / $AAC7);
  XI := IDW[2];
  INLINE("LDA / XI /
         "STA / $AAC8);
  XI := IDW[3];
  INLINE("LDA / XI /
         "STA / $AAC9);
  XI := IDW[4];
  INLINE("LDA / XI /
         "STA / $AACA);
  XI := IDW[5];
  INLINE("LDA / XI /
         "STA / $AACB);
  XI := STW[1];
  INLINE("LDA / XI /
         "STA / $AACC);
  XI := STW[2];
  INLINE("LDA / XI /
         "STA / $AACD);
  XI := STW[3];
  INLINE("LDA / XI /
         "STA / $AACE);
  XI := STW[4];
  INLINE("LDA / XI /
         "STA / $AACF);
  XI := STW[5];
  INLINE("LDA / XI /
         "STA / $AAD0);
  XI := XFCNT[1];
  INLINE("LDA / XI /
         "STA / $AAD1);
  XI := XFCNT[2];
  INLINE("LDA / XI /
         "STA / $AAD2);
  XB := LOWSP;
  INLINE("LDA / XB /
         "STA / $AAD3);
  XB := HIGHSP;
  INLINE("LDA / XB /
         "STA / $AAD4);
  XB := CMP;
  INLINE("LDA / XB /
         "STA / $AAD5);
  XB := CLR;
  INLINE("LDA / XB /
         "STA / $AAD6);
  XB := EF;
  INLINE("LDA / XB /
         "STA / $AAD7);
  XB := AF;
  INLINE("LDA / XB /
         "STA / $AAD8);
  XB := ID;
  INLINE("LDA / XB /
         "STA / $AAD9);
  XB := OD;
  INLINE("LDA / XB /
         "STA / $AADA);
  XB := ST;
  INLINE("LDA / XB /
         "STA / $AADB);
  XB := PAR;
  INLINE("LDA / XB /
         "STA / $AADC);
  XB := MSTOP;
  INLINE("LDA / XB /
         "STA / $AADD);
  XB := ONERR;
  INLINE("LDA / XB /
         "STA / $AADE);
  XB := INVEF;
  INLINE("LDA / XB /
         "STA / $AADF);
  XB := INVTAG;
  INLINE("LDA / XB /
         "STA / $AAE0);
  XB := INVPAR;
  INLINE("LDA / XB /
         "STA / $AAE1);
  XB := INVTIM;
  INLINE("LDA / XB /
         "STA / $AAE2);
  XI := TIMCNT[1];
  INLINE("LDA / XI /
         "STA / $AAE3);
  XI := TIMCNT[2];
  INLINE("LDA / XI /
         "STA / $AAE4);
  XB := RECSB;
  INLINE("LDA / XB /
         "STA / $AAE5);
  XB := RECUL;
  INLINE("LDA / XB /
         "STA / $AAE6);
  XB := DRECA;
  INLINE("LDA / XB /
         "STA / $AAE7);
  XB := SAVIBF;
  INLINE("LDA / XB /
         "STA / $AAE8);
  XI := XSTW[1];
  INLINE("LDA / XI /
         "STA / $AAEF);
  XI := XSTW[2];
  INLINE("LDA / XI /
         "STA / $AAF0);
  XI := XSTW[3];
  INLINE("LDA / XI /
         "STA / $AAF1);
  XI := XSTW[4];
  INLINE("LDA / XI /
         "STA / $AAF2);
  XI := XSTW[5];
  INLINE("LDA / XI /
         "STA / $AAF3);
  XB := BUFRPT;
  INLINE("LDA / XB /
         "STA / $AAF4);
  XB := WRDRPT;
  INLINE("LDA / XB /
         "STA / $AAF5);
  XB := LSTPAC;
  INLINE("LDA / XB /
         "STA / $AAF6);
  XI := PRPCNT[1];
  INLINE("LDA / XI /
         "STA / $AAF7);
  XI := PRPCNT[2];
  INLINE("LDA / XI /
         "STA / $AAF8);
  INLINE("CALL / $A809);
  INLINE("LHLD / $A833);
  INLINE("SHLD / ERRCNT)
END; (* PASS TO MACHINE LANGUAGE RUN-TIME SYSTEM *)

PROCEDURE REALINT8B(NUMR : REAL;VAR NUMI : INTEGER; INDEX : INTEGER);
CONST
  BASE = 16;
  MAXPLACEVAL = 2;
VAR
  DIGITS : ARRAY[1..MAXPLACEVAL] OF INTEGER;
  PLACEVAL : INTEGER;
  CV : INTEGER;
  DENOM : INTEGER;
  REMAIN : REAL;
  NUMER : REAL;
  QUOTR : REAL;
BEGIN
  PLACEVAL := 1;
  DENOM := BASE;
  NUMER := NUMR;
  INDEX := INDEX * MAXPLACEVAL;
  FOR CV := 1 TO INDEX DO
    BEGIN
      QUOTR := NUMER / DENOM;
      QUOTR := QUOTR - 0.5;
      QUOTR := QUOTR / 10000.0;
      QUOTR := QUOTR * 10000.0;
      IF QUOTR <= 0.9999 THEN
        QUOTR := 0.0;
      REMAIN := NUMER - (DENOM * QUOTR);
      DIGITS[PLACEVAL] := TRUNC(REMAIN);
      IF PLACEVAL = MAXPLACEVAL THEN
        PLACEVAL := 0;
      PLACEVAL := PLACEVAL + 1;
      NUMER :=  QUOTR
    END;
  DIGITS[1] := DIGITS[1] * 1;
  DIGITS[2] := DIGITS[2] * BASE;
  NUMI := DIGITS[1] + DIGITS[2]
END; (* REAL TO 8 BIT INTEGERS *)

PROCEDURE KYBRD(VAR D : CREG; LENGTH : INTEGER; CARR : CHAR);
VAR
  CH : CHAR;
  C  : INTEGER;
BEGIN
  C := 1;
  REPEAT
    IF C < 1 THEN
      BEGIN
        WRITE(' ');
        C := 1;
      END;
    READ(CH);
    IF (CH = CHR(08)) AND (C > 0) THEN
      BEGIN
        C := C - 1
      END
    ELSE
      BEGIN
        IF CH = CHR(13) THEN
          BEGIN
            IF CARR = 'C' THEN
              BEGIN
                D[C] := CHR(13);
                C := C + 1
              END;
            FOR C := C TO LENGTH DO
              D[C] := ' ';
            EXIT
          END
        ELSE
          BEGIN
            IF C <= LENGTH THEN
              BEGIN
                D[C] := CH;
                C := C + 1
              END
            ELSE
              BEGIN
                WRITELN;
                WRITELN;
                WRITELN;
                WRITELN(' OOPS - LINE OVER FLOW - ');
                WRITELN;
                WRITE(' PLEASE REPHRASE INPUT, DO NOT EXCEED ',LENGTH);
                WRITELN(' CHARACTERS ');
                WRITELN;
                WRITE(' ? ');
                C := 1
              END
          END
      END
UNTIL CH = CHR(13);
EXIT
END; (* KYBRD *)

PROCEDURE CRT(VAR D : CREG; LENGTH : INTEGER);
VAR
  C :INTEGER;
BEGIN
  C := 1;
  REPEAT
    IF C > LENGTH THEN
      EXIT;
    IF D[C] = CHR(13) THEN
      EXIT;
    WRITE(D[C]);
    C := C + 1
  UNTIL FALSE
END; (* CRT *)

PROCEDURE OCTALPAD(VAR DATAR : REAL; MIN : REAL; MAX : REAL);
CONST
  BASE = 8;
  POSLEN = 15;
VAR
  CH : CHAR;
  C : INTEGER;
  SCRATCH : INTEGER;
  PLACEVAL : ARRAY [1..POSLEN] OF REAL;
  SUMS : ARRAY [1..POSLEN] OF REAL;
  STORE : ARRAY [0..POSLEN] OF REAL;
  TDATA : REAL;
  X : REAL;
BEGIN
  X := 1.0;
  FOR C := 1 TO POSLEN DO
    BEGIN
      PLACEVAL[C] := X;
      X := X * BASE;
    END;
  C := 1;
  DATAR := 0.0;
  TDATA := 0.0;
  SCRATCH := 0;
  WRITE(' (OCTAL): ');
  REPEAT
    READ(CH);
    CASE CH OF

      '0' : TDATA := 0.0;

      '1' : TDATA := 1.0;

      '2' : TDATA := 2.0;

      '3' : TDATA := 3.0;

      '4' : TDATA := 4.0;

      '5' : TDATA := 5.0;

      '6' : TDATA := 6.0;

      '7' : TDATA := 7.0;

      ELSE
        BEGIN
          IF (CH = CHR(08)) AND (C > 1) THEN
            BEGIN
              C := C - 2;
              FOR SCRATCH := 0 TO POSLEN DO
                STORE[SCRATCH] := STORE[SCRATCH + 1];
              FOR SCRATCH := 0 TO POSLEN DO
                STORE[SCRATCH] := STORE[SCRATCH + 1];
              TDATA := STORE[0]
            END
          ELSE
            BEGIN
              IF (CH = CHR(08)) AND (C <= 1) THEN
                BEGIN
                  WRITE(' ');
                  C := 0
                END
              ELSE
                BEGIN
                  IF CH = CHR(13) THEN
                    BEGIN
                      IF TDATA >= MIN THEN
                        BEGIN
                          DATAR := TDATA;
                          EXIT
                        END;
                      WRITELN;
                      WRITELN;
                      WRITELN;
                      WRITELN(' OOPS - VALUE OUT OF RANGE - ');
                      WRITELN;
     WRITELN(' PLEASE RE-ENTER - MINIMUM VALUE = ',MIN,' ');
                      WRITELN;
                      WRITE(' (OCTAL): ');
                      TDATA := MIN;
                      C := 0
                    END
                  ELSE
                    BEGIN
                      WRITELN;
                      WRITELN;
                      WRITELN;
                      WRITELN(' OOPS - VALUE OUT OF RANGE - ');
                      WRITELN;
     WRITE(' PLEASE RE-ENTER - MIN. VALUE = ',MIN);
                      WRITELN(', MAX. VALUE = ',MAX,' ');
                      WRITELN;
                      WRITE(' (OCTAL): ');
                      TDATA := MIN;
                      C := 0
                    END
                END
            END
        END
    END; (* CASE *)
    IF C < POSLEN THEN
      BEGIN
        STORE[0] := TDATA;
        TDATA := 0.0;
        FOR SCRATCH := POSLEN DOWNTO 1 DO
          STORE[SCRATCH] := STORE[SCRATCH - 1];
        FOR SCRATCH := 1 TO C DO
          SUMS[SCRATCH] := STORE[SCRATCH] * PLACEVAL[SCRATCH]
      END
    ELSE
      BEGIN
        WRITELN;
        WRITELN;
        WRITELN;
        WRITELN(' OOPS - THATS TO MANY NUMBERS - ');
        WRITELN;
        WRITE(' PLEASE REPHRASE INPUT, DO NOT EXCEED ',POSLEN -1);
        WRITELN(' CHARACTERS ');
        WRITELN;
        WRITE(' (OCTAL): ');
        TDATA := MIN;
        C := 0
      END;
    FOR SCRATCH := 1 TO C DO
      TDATA := TDATA + SUMS[SCRATCH];
    IF TDATA > MAX THEN
      BEGIN
        WRITELN;
        WRITELN;
        WRITELN;
        WRITELN(' OOPS - VALUE OUT OF RANGE - ');
        WRITELN;
        WRITELN(' PLEASE RE-ENTER - MAXIMUM VALUE = ',MAX,' ');
        WRITELN;
        WRITE(' (OCTAL): ');
        TDATA := MIN;
        C := 0
      END;
    C := C + 1
  UNTIL FALSE (* FOREVER LOOP *)
END; (* OCTAL KEYPAD *)

PROCEDURE HEXPAD(VAR DATAR : REAL; MIN : REAL; MAX : REAL);
CONST
  BASE = 16;
  POSLEN = 10;
VAR
  CH : CHAR;
  C : INTEGER;
  SCRATCH : INTEGER;
  PLACEVAL : ARRAY [1..POSLEN] OF REAL;
  SUMS : ARRAY [1..POSLEN] OF REAL;
  STORE : ARRAY [0..POSLEN] OF REAL;
  TDATA : REAL;
  X : REAL;
BEGIN
  X := 1.0;
  FOR C := 1 TO POSLEN DO
    BEGIN
      PLACEVAL[C] := X;
      X := X * BASE;
    END;
  C := 1;
  DATAR := 0.0;
  TDATA := 0.0;
  SCRATCH := 0;
  WRITE(' (HEX): ');
  REPEAT
    READ(CH);

    CASE CH OF

      '0' : TDATA := 0.0;

      '1' : TDATA := 1.0;

      '2' : TDATA := 2.0;

      '3' : TDATA := 3.0;

      '4' : TDATA := 4.0;

      '5' : TDATA := 5.0;

      '6' : TDATA := 6.0;

      '7' : TDATA := 7.0;

      '8' : TDATA := 8.0;

      '9' : TDATA := 9.0;

      'A' : TDATA := 10.0;

      'B' : TDATA := 11.0;

      'C' : TDATA := 12.0;

      'D' : TDATA := 13.0;

      'E' : TDATA := 14.0;

      'F' : TDATA := 15.0;

      ELSE
        BEGIN
          IF (CH = CHR(08)) AND (C > 1) THEN
            BEGIN
              C := C - 2;
              FOR SCRATCH := 0 TO POSLEN DO
                STORE[SCRATCH] := STORE[SCRATCH + 1];
              FOR SCRATCH := 0 TO POSLEN DO
                STORE[SCRATCH] := STORE[SCRATCH + 1];
              TDATA := STORE[0]
            END
          ELSE
            BEGIN
              IF (CH = CHR(08)) AND (C <= 1) THEN
                BEGIN
                  WRITE(' ');
                  C := 0
                END
              ELSE
                BEGIN
                  IF CH = CHR(13) THEN
                    BEGIN
                      IF TDATA >= MIN THEN
                        BEGIN
                          DATAR := TDATA;
                          EXIT
                        END;
                      WRITELN;
                      WRITELN;
                      WRITELN;
                      WRITELN(' OOPS - VALUE OUT OF RANGE - ');
                      WRITELN;
     WRITELN('PLEASE RE-ENTER - MINIMUM VALUE = ',MIN,' ');
                      WRITELN;
                      WRITE(' (HEX): ');
                      TDATA := MIN;
                      C := 0
                    END
                  ELSE
                    BEGIN
                      WRITELN;
                      WRITELN;
                      WRITELN;
                      WRITELN(' OOPS - VALUE OUT OF RANGE - ');
                      WRITELN;
     WRITE(' PLEASE RE-ENTER - MIN. VALUE = ',MIN);
                      WRITELN(', MAX. VALUE = ',MAX,' ');
                      WRITELN;
                      WRITE(' (HEX): ');
                      TDATA := MIN;
                      C := 0
                    END
                END
            END
        END
    END; (* CASE *)
    IF C < POSLEN THEN
      BEGIN
        STORE[0] := TDATA;
        TDATA := 0.0;
        FOR SCRATCH := POSLEN DOWNTO 1 DO
          STORE[SCRATCH] := STORE[SCRATCH -1];
        FOR SCRATCH := 1 TO C DO
          SUMS[SCRATCH] := STORE[SCRATCH] * PLACEVAL[SCRATCH]
      END
    ELSE
      BEGIN
        WRITELN;
        WRITELN;
        WRITELN;
        WRITELN(' OOPS - THATS TO MANY NUMBERS - ');
        WRITELN;
        WRITE(' PLEASE REPHRASE INPUT, DO NOT EXCEED ',POSLEN -1);
        WRITELN(' CHARACTERS ');
        WRITELN;
        WRITE(' (HEX): ');
        TDATA := MIN;
        C := 0
      END;
    FOR SCRATCH := 1 TO C DO
      TDATA := TDATA + SUMS[SCRATCH];
    IF TDATA > MAX THEN
      BEGIN
        WRITELN;
        WRITELN;
        WRITELN;
        WRITELN(' OOPS - VALUE OUT OF RANGE - ');
        WRITELN;
        WRITELN(' PLEASE RE-ENTER - MAXIMUM VALUE = ',MAX,' ');
        WRITELN;
        WRITE(' (HEX): ');
        TDATA := MIN;
        C := 0
      END;
    C := C + 1
  UNTIL FALSE (* FOREVER LOOP *)
END; (* HEX KEYPAD *)
    
PROCEDURE DECPAD(VAR DATAR : REAL; MIN : REAL; MAX : REAL);
CONST
  BASE = 10;
  POSLEN = 12;
VAR
  CH : CHAR;
  C : INTEGER;
  SCRATCH : INTEGER;
  PLACEVAL : ARRAY [1..POSLEN] OF REAL;
  SUMS : ARRAY [1..POSLEN] OF REAL;
  STORE : ARRAY [0..POSLEN] OF REAL;
  TDATA : REAL;
  X : REAL;
BEGIN
  X := 1.0;
  FOR C := 1 TO POSLEN DO
    BEGIN
      PLACEVAL[C] := X;
      X := X * BASE;
    END;
  C := 1;
  DATAR := 0.0;
  TDATA := 0.0;
  SCRATCH := 0;
  WRITE(' (DEC): ');
  REPEAT
    READ(CH);

    CASE CH OF

      '0' : TDATA := 0.0;

      '1' : TDATA := 1.0;

      '2' : TDATA := 2.0;

      '3' : TDATA := 3.0;

      '4' : TDATA := 4.0;

      '5' : TDATA := 5.0;

      '6' : TDATA := 6.0;

      '7' : TDATA := 7.0;

      '8' : TDATA := 8.0;

      '9' : TDATA := 9.0;

      ELSE
        BEGIN
          IF (CH = CHR(08)) AND (C > 1) THEN
            BEGIN
              C := C - 2;
              FOR SCRATCH := 0 TO POSLEN DO
                STORE[SCRATCH] := STORE[SCRATCH + 1];
              FOR SCRATCH := 0 TO POSLEN DO
                STORE[SCRATCH] := STORE[SCRATCH + 1];
              TDATA := STORE[0]
            END
          ELSE
            BEGIN
              IF (CH = CHR(08)) AND (C <= 1) THEN
                BEGIN
                  WRITE(' ');
                  C := 0
                END
              ELSE
                BEGIN
                  IF CH = CHR(13) THEN
                    BEGIN
                      IF TDATA >= MIN THEN
                        BEGIN
                          DATAR := TDATA;
                          EXIT
                        END;
                      WRITELN;
                      WRITELN;
                      WRITELN;
                      WRITELN(' OOPS - VALUE OUT OF RANGE - ');
                      WRITELN;
      WRITELN(' PLEASE RE-ENTER - MINIMUM VALUE = ',MIN,' ');
                      WRITELN;
                      WRITE(' (DEC): ');
                      TDATA := MIN;
                      C := 0
                    END
                  ELSE
                    BEGIN
                      WRITELN;
                      WRITELN;
                      WRITELN;
                      WRITELN(' OOPS - VALUE OUT OF RANGE - ');
                      WRITELN;
            WRITE(' PLEASE RE-ENTER - MIN. VALUE = ',MIN);
                      WRITELN(', MAX. VALUE = ',MAX,' ');
                      WRITELN;
                      WRITE(' (DEC): ');
                      TDATA := MIN;
                      C := 0
                    END
                END
            END
        END
    END; (* CASE *)
    IF C < POSLEN THEN
      BEGIN
        STORE[0] := TDATA;
        TDATA := 0.0;
        FOR SCRATCH := POSLEN DOWNTO 1 DO
          STORE[SCRATCH] := STORE[SCRATCH - 1];
        FOR SCRATCH := 1 TO C DO
          SUMS[SCRATCH] := STORE[SCRATCH] * PLACEVAL[SCRATCH]
      END
    ELSE
      BEGIN
        WRITELN;
        WRITELN;
        WRITELN;
        WRITELN(' OOPS - THATS TO MANY NUMBERS - ');
        WRITELN;
        WRITE(' PLEASE REPHRASE INPUT, DO NOT EXCEED ',POSLEN -1);
        WRITELN(' CHARACTERS ');
        WRITELN;
        WRITE(' (DEC): ');
        TDATA := MIN;
        C := 0
      END;
    FOR SCRATCH := 1 TO C DO
      TDATA := TDATA + SUMS[SCRATCH];
    IF TDATA > MAX THEN
      BEGIN
        WRITELN;
        WRITELN;
        WRITELN;
        WRITELN(' OOPS - VALUE OUT OF RANGE - ');
        WRITELN;
        WRITELN(' PLEASE RE-ENTER - MAXIMUM VALUE = ',MAX,' ');
        WRITELN;
        WRITE(' (DEC): ');
        TDATA := MIN;
        C := 0
      END;
    C := C + 1
  UNTIL FALSE (* FOREVER LOOP *)
END; (* DECIMAL KEYPAD *)

PROCEDURE SELBASE(VAR BASEX : CHAR);
BEGIN
  WRITELN('SELECT BASE ');
  WRITELN('1) - DECIMAL ');
  WRITELN('2) - HEX ');
  WRITELN('3) - OCTAL ');
  READ(BASEX);
  WRITELN;
  CASE BASEX OF

    '1' : BASEX := 'D';

    '2' : BASEX := 'H';

    '3' : BASEX := 'O';
    ELSE
      BASEX := 'H'
  END (* CASE *)
END; (* SELECT BASE *)

PROCEDURE CLEARSCREEN;

BEGIN
    WRITE(CHR(12));
    WRITE(CHR(27));
    WRITE(CHR(43));
END; (* CLEAR SCREEN *)

PROCEDURE AMPERIFHEADING;

BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
  WRITELN('                    * * *   AMPERIF - MAID-III   * * * ');
  WRITELN;
  WRITELN;
  WRITELN;
END; (* AMPERIF HEADING *)

PROCEDURE INIT1(VAR XXW : WDTEMPLATE;VAR XB : BOOLEAN);
VAR
  X : INTEGER;
BEGIN
  FOR X := 1 TO 5 DO
    XXW[X] := $0000;
  XB := FALSE
END; (* INIT 1 *)

PROCEDURE INITUSER(VAR NAME : IREG);
VAR
  X : CHAR;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITE('HI, NAME PLEASE? ');
  KYBRD(NAME,20,'C');
  AMPERIFHEADING;
  IF NAME[1] = CHR(13) THEN
    BEGIN
      NAME[1] := 'I'; NAME[2] := 'M'; NAME[3] := 'P'; NAME[4] := 'A';
      NAME[5] := 'T'; NAME[6] := 'I'; NAME[7] := 'E'; NAME[8] := 'N';
      NAME[9] := 'T'; NAME[10] := CHR(13)
    END;
  CRT(NAME,20);
  WRITELN(',');
  WRITELN;
  WRITELN;
  WRITELN('   TYPE CTRL - H :TO BACK SPACE. ');
  WRITELN('   TYPE CTRL - S :TO STOP SCROLL (XOFF). ');
  WRITELN('   TYPE CTRL - Q :TO START SCROLL (XON). ');
  WRITE('   TYPE RETURN TO CONTINUE. ');
  READ(X)
END; (* INITUSER *)

PROCEDURE EFHEADING;

BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
  WRITELN('                  * * *   MAID-III - EF WORD   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* EFW HEADING *)

PROCEDURE AFHEADING;

BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
  WRITELN('                  * * *   MAID-III - AF WORD   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* AFW HEADING *)

PROCEDURE STHEADING;

BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
  WRITELN('                * * *   MAID-III - STATUS WORD   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* STATUS WORD HEADING *)

PROCEDURE OUTBUFFHEADING;

BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
WRITELN('                  * * *   MAID-III - OUTPUT BUFFER   * * * ');
  WRITELN;
  WRITELN;
  WRITELN;
END; (* OUTPUT BUFFER HEADING *)

PROCEDURE INBUFFHEADING;

BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
  WRITELN('                 * * *   MAID-III - INPUT BUFFER   * * * ');
  WRITELN;
  WRITELN;
  WRITELN;
END; (* INPUT BUFFER HEADING *)

PROCEDURE DDFHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
  WRITELN('               * * *   MAID-III - DUMP DATA FILE   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* DUMP DATA FILE HEADING *)

PROCEDURE INSTRHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
  WRITELN('               * * *   MAID-III - INSTRUCTIONS   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* INSTRUCTION HEADING *)
PROCEDURE MAKHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
  WRITELN('               * * *   MAID-III - MAKE PACKET   * * * ');
  WRITELN;
   WRITELN
END; (* MAKE PACKET *)

PROCEDURE DMPHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
 WRITELN('              * * *   MAID-III - DUMP PACKET FILE   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* DUMP PACKET FILE *)

PROCEDURE CMPHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
 WRITELN('            * * *   MAID-III - COMPARE DATA FILES   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* COMPARE DATA FILES *)

PROCEDURE EXECHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
WRITELN('            * * *   MAID-III - EXECUTE PACKET FILE   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* EXECUTE PACKET *)

PROCEDURE TERMHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
WRITELN('            * * *   MAID-III - TERMINAL TALK   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* TERMINAL TALK *)

PROCEDURE PHTERMHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
WRITELN('            * * *   MAID-III - PHONE ON TERMINATION   * * *');
  WRITELN;
  WRITELN;
  WRITELN
END; (* PHONE ON TERMINATION *)

PROCEDURE DIRHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
WRITELN('            * * *   MAID-III - FILES DIRECTORY   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* DIRECTORY HEADING *)

PROCEDURE DELHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
WRITELN('            * * *   MAID-III - DELETE FILE   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* DELETE FILE HEADING *)

PROCEDURE MANUALHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
WRITELN('            * * *    MAID-III - MANUAL/OVER-RIDE   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* MANUAL/OVERRIDE HEADING *)

PROCEDURE POSTHEADING;
BEGIN
  CLEARSCREEN;
  WRITELN;
  WRITELN;
WRITE('            * * *   MAID-III - POST EXECUTION ANALYSIS');
WRITELN('   * * * ');
  WRITELN;
  WRITELN;
  WRITELN
END; (* POST ANALYSIS HEADING *)

PROCEDURE SETUPCOMM(C:CHAR);
VAR
  CMD : CHAR;
  TALK : CHAR;
  CMDSTR : ARRAY [1..27] OF CHAR;
  XM : INTEGER;
BEGIN
 IF C = 'C' THEN
  BEGIN
    WRITELN('EXAMPLE - "ATDT 1-(XXX) XXX-XXXX" ');
    WRITE('ENTER MODEM COMMAND STRING: ');
    KYBRD(CMDSTR,26,'C');
    WRITE('ENTER SPEED (ORIGINATE - A=300, B=1200, RET=LAST): ');
    READ(CMD);
    CASE CMD OF
      'A','a' : BEGIN
                  INLINE("MVI A / $40 /
                         "OUT / $C1 /
                         "MVI A / $CF /
                         "OUT / $C1 /
                         "MVI A / $27 /
                         "OUT / $C1)
                END;

      'B','b' : BEGIN
                  INLINE("MVI A / $40 /
                         "OUT / $C1 /
                         "MVI A / $CE /
                         "OUT / $C1 /
                         "MVI A / $27 /
                         "OUT / $C1)
                END
    END; (* CASE *)
    WRITELN;
    WRITE('SEND COMMAND STRING NOW (Y/N): ');
    READ(CMD);
    WRITELN;
  END;
 IF CMD = 'Y' THEN
   C := 'D';
 IF CMD = 'y' THEN
   C := 'D';
 IF C = 'D' THEN
   BEGIN
     XM := 0;
     REPEAT
       XM := XM + 1;
       TALK := CMDSTR[XM];
       INLINE( [LBL] );
       INLINE("IN / $C1 /
              "ANI / $01 /
              "JZ /  LBL /
              "LDA / TALK /
              "OUT / $C0);
       WRITE(TALK);
     UNTIL TALK = CHR(13)
   END
END; (* SET UP USART AND SMART MODEM *)

PROCEDURE DATANIBBLES(VAR XDN : WDTEMPLATE;BASEREQ : CHAR);
VAR
  DNR : REAL;
  DNI : INTEGER;
  NI : INTEGER;
  MAXVAL : REAL;
  TEMPREGI : ARRAY[1..9] OF INTEGER;
BEGIN
  WRITELN;
  FOR NI := 1 TO 9 DO
    BEGIN
      IF NI = 9 THEN
        MAXVAL := 15.0
      ELSE
        MAXVAL := 15.0;
      WRITE('NIBBLE ',NI);
      IF BASEREQ = 'D' THEN
        DECPAD(DNR,0.0,MAXVAL);
      IF BASEREQ = 'H' THEN
        HEXPAD(DNR,0.0,MAXVAL);
      IF BASEREQ = 'O' THEN
        OCTALPAD(DNR,0.0,MAXVAL);
      REALINT8B(DNR,DNI,1);
      TEMPREGI[NI] := DNI;
      WRITELN
    END;
  XDN[1] := (TEMPREGI[2] * 16) + TEMPREGI[1];
  XDN[2] := (TEMPREGI[4] * 16) + TEMPREGI[3];
  XDN[3] := (TEMPREGI[6] * 16) + TEMPREGI[5];
  XDN[4] := (TEMPREGI[8] * 16) + TEMPREGI[7];
  XDN[5] := TEMPREGI[9]
END; (* LOAD BITS 35 - 0 (NIBBLE FORMAT) *)

PROCEDURE DATABYTES(VAR XDB : WDTEMPLATE;BASEREQ : CHAR);
VAR
  DBR : REAL;
  DBI : INTEGER;
  BI : INTEGER;
  MAXVAL : REAL;
BEGIN
  WRITELN;
  FOR BI := 1 TO 5 DO
    BEGIN
      IF BI = 5 THEN
        MAXVAL := 15.0
      ELSE
        MAXVAL := 255.0;
      WRITE('BYTE ',BI);
      IF BASEREQ = 'D' THEN
        DECPAD(DBR,0.0,MAXVAL);
      IF BASEREQ = 'H' THEN
        HEXPAD(DBR,0.0,MAXVAL);
      IF BASEREQ = 'O' THEN
        OCTALPAD(DBR,0.0,MAXVAL);
      REALINT8B(DBR,DBI,1);
      XDB[BI] := DBI;
      WRITELN
    END
END; (* LOAD BITS 35 - 0 (BYTE FORMAT) *)

PROCEDURE DATAWORD(VAR XDW : WDTEMPLATE;MINV,MAXV : REAL;BREQ : CHAR;
                       BYTES : INTEGER);
CONST
  ZERO = $0000;
  ZMSK70   = $0000;
  ZMSK158  = $0000;
  ZMSK2316 = $0000;
  ZMSK3124 = $0000;
  ZMSK3932 = $0000;
  ZMSK3936 = $000F;
VAR
  DWR : REAL;
  DWI : INTEGER;
  BYT : INTEGER;
BEGIN
  IF BREQ = 'D' THEN
    DECPAD(DWR,MINV,MAXV);
  IF BREQ = 'H' THEN
    HEXPAD(DWR,MINV,MAXV);
  IF BREQ = 'O' THEN
    OCTALPAD(DWR,MINV,MAXV);
  FOR BYT := 1 TO BYTES DO
    BEGIN
      REALINT8B(DWR,DWI,BYT);
      XDW[BYT] := DWI;
    END;
  WRITELN
  END; (* LOAD BITS 35 - 0 (DATA WORD) *)

PROCEDURE MAKEBUFFER(VAR XWDA:WDTEMPLATE;VAR XFERLR:REAL;
VAR PRGCMD,DATMOD:INTEGER;VAR BUFRPT,WRDRPT:BOOLEAN;VAR PRGCNT:A2B);
VAR
  BUFFREPEATMAX : REAL;
  BUFFRPTCNT : REAL;
  ACTMBCT : REAL;
  OPTMBCT : REAL;
  REMBCT : REAL;
  DATRPTCNT : REAL;
  X : INTEGER;
  COMMR : REAL;
  COMM : INTEGER;
  DATAFORMT : CHAR;
  BASEREQ : CHAR;
  C : CHAR;

BEGIN
  DATRPTCNT := 0.0;
  BUFFREPEATMAX := 0.0;
  BUFFRPTCNT := 0.0;
  ACTMBCT := 0.0;
  OPTMBCT := 0.0;
  REMBCT := XFERLR;
  BUFRPT := FALSE;
  WRDRPT := FALSE;
  PRGCMD := $06;
  DATMOD := $FE; (* OPEN/CREATE - FILE *)
  M5046(PRGCMD);
  REPEAT
    IF OPTMBCT < 65536.0 THEN
      BEGIN
        OUTBUFFHEADING;
        WRITE('REMAINING BUFFER SPACE = ',REMBCT,'(DEC) ');
        WRITELN(' DATA TRANSFER LENGTH = ',XFERLR,'(DEC) ');
        WRITELN;
        SELBASE(BASEREQ);
        WRITELN('SELECT DATA FORMAT');
        WRITELN('1) - WORD ');
        WRITELN('2) - BYTE ');
        WRITELN('3) - NIBBLE ');
        READ(DATAFORMT);
        WRITELN;
        WRITE('DATA WORD');
        CASE DATAFORMT OF

          '1' : DATAWORD(XWDA,0.0,68719476735.0,BASEREQ,5);

          '2' : DATABYTES(XWDA,BASEREQ);

          '3' : DATANIBBLES(XWDA,BASEREQ)
          ELSE
            DATAWORD(XWDA,0.0,68719476735.0,BASEREQ,5)
        END; (* CASE *)
        OPTMBCT := OPTMBCT + 1.0;
        ACTMBCT := ACTMBCT + 1.0;
        REMBCT := XFERLR - ACTMBCT;
        IF ACTMBCT < XFERLR THEN
        BEGIN
          OUTBUFFHEADING;
          WRITE('REMAINING BUFFER SPACE = ',REMBCT,'(DEC) ');
          WRITELN(' DATA TRANSFER LENGTH = ',XFERLR,'(DEC) ');
          WRITELN;
          WRITE('DATA WORD REPEAT COUNT');
          DECPAD(DATRPTCNT,0.0,REMBCT);
          ACTMBCT := ACTMBCT + DATRPTCNT;
          REMBCT := XFERLR - ACTMBCT;
          IF DATRPTCNT > 0.0 THEN
            BEGIN
              WRITELN;
              WRITELN(' - MODIFY DATA THROUGH REPEAT COUNT - ');
              WRITELN;
              WRITELN('1) - NO OPERATION ');
              WRITELN('2) - INCREMENT ');
              WRITELN('3) - DECREMENT ');
              WRITELN('4) - SHIFT RIGHT ');
              WRITELN('5) - SHIFT LEFT ');
              WRITELN('6) - RANDOM ');
              WRITELN('7) - COMPLIMENT ');
              WRITELN;
              WRITE(' - enter number');
              DECPAD(COMMR,1.0,7.0);
              COMM := TRUNC(COMMR);
              WRITELN;
              CASE COMM OF

                1 : BEGIN
                        DATMOD := $01;
                        IF DATRPTCNT = XFERLR - 1 THEN
                          BEGIN
                            WRDRPT := TRUE;
                            BUFRPT := TRUE
                          END
                      END;

                2 : BEGIN
                        DATMOD := $02
                      END;

                3 : BEGIN
                        DATMOD := $03
                      END;

                4 : BEGIN
                        DATMOD := $04
                      END;

                5 : BEGIN
                        DATMOD := $05
                      END;

                6 : BEGIN
                        DATMOD := $06
                      END;

                7 : BEGIN
                        DATMOD := $07
                      END
              END (* CASE *)
            END
          ELSE
            BEGIN
              DATMOD := $01
            END;
          REALINT8B(DATRPTCNT,X,1);
          PRGCNT[1] := X;
          REALINT8B(DATRPTCNT,X,2);
          PRGCNT[2] := X;
          M5046(PRGCMD);
          DATRPTCNT := 0.0
        END;
        IF XFERLR > ACTMBCT THEN
          IF ACTMBCT <= RECSIZ / 5 THEN
          BEGIN
            OUTBUFFHEADING;
            WRITE('REMAINING BUFFER SPACE = ',REMBCT,'(DEC) ');
            WRITELN(' DATA TRANSFER LENGTH = ',XFERLR,'(DEC) ');
            WRITELN;
            WRITE('REPEAT BUFFER THROUGH TRANSFER LENGTH (Y/N) ');
            READ(C);
            IF C = 'Y' THEN
              BEGIN
                BUFRPT := TRUE;
                ACTMBCT := XFERLR
              END;
            REMBCT := XFERLR - ACTMBCT
          END
      END
    ELSE
      WRITELN('OUT OF BUFFER SPACE ');
  UNTIL ACTMBCT = XFERLR;
  DATMOD := $FF; (* CLOSE FILE AND REWRITE CONTROL RECORD *)
  M5046(PRGCMD)
END; (* MAKE BUFFER *)

PROCEDURE DSKUNIT(VAR BYTE4 : INTEGER);
CONST
  ZMSK2824 = $00E0;
VAR
  DSKUNTR : REAL;
  DSKUNTI : INTEGER;
BEGIN
  WRITE('DISK UNIT ADDRESS');
  DECPAD(DSKUNTR,0.0,31.0);
  DSKUNTI := TRUNC(DSKUNTR);
  BYTE4 := BYTE4 AND ZMSK2824;
  BYTE4 := BYTE4 OR DSKUNTI;
  WRITELN
END; (* LOAD BITS 28 - 24 (DSK) *)

PROCEDURE ZERO172(VAR XWRD : WDTEMPLATE);
CONST
  ZERO = $0000;
  ZMSK72   = $0003;
  ZMSK158  = $0000;
  ZMSK1716 = $00FC;
BEGIN
  XWRD[1] := XWRD[1] AND ZMSK72;
  XWRD[1] := XWRD[1] OR ZERO;
  XWRD[2] := XWRD[2] AND ZMSK158;
  XWRD[2] := XWRD[2] OR ZERO;
  XWRD[3] := XWRD[3] AND ZMSK1716;
  XWRD[3] := XWRD[3] OR ZERO
END; (* ZERO BITS 17 - 2 *)

PROCEDURE ZERO3429(VAR XWRD : WDTEMPLATE);
CONST
  ZERO = $0000;
  ZMSK3129 = $001F;
  ZMSK3432 = $00F8;
BEGIN
  XWRD[4] := XWRD[4] AND ZMSK3129;
  XWRD[4] := XWRD[4] OR ZERO;
  XWRD[5] := XWRD[5] AND ZMSK3432;
  XWRD[5] := XWRD[5] OR ZERO
END; (* ZERO BITS 34 - 29 *)

PROCEDURE SET35(VAR BYTE5 : INTEGER);
CONST
  BIT35 = $0008;
  ZMSK35 = $00F7;
BEGIN
  BYTE5 := BYTE5 AND ZMSK35;
  BYTE5 := BYTE5 OR BIT35
END; (* SET BIT 35 (EF) *)

PROCEDUR BACKFACTOR(VAR BYTE1 : INTEGER);
CONST
  ZMSK10 = $00FC;
VAR
  BACFACI : INTEGER;
  BACFACR : REAL;
BEGIN
  WRITE('BACKING FACTOR');
  DECPAD(BACFACR,0.0,3.0);
  BACFACI := TRUNC(BACFACR);
  BYTE1 := BYTE1 AND ZMSK10;
  BYTE1 := BYTE1 OR BACFACI;
  WRITELN
END; (* LOAD BITS 1 - 0 (BF) *)

PROCEDURE ZERO170(VAR XWRD : WDTEMPLATE);
CONST
  ZERO = $0000;
  ZMSK70   = $0000;
  ZMSK158  = $0000;
  ZMSK1716 = $00FC;
BEGIN
  XWRD[1] := XWRD[1] AND ZMSK70;
  XWRD[1] := XWRD[1] OR ZERO;
  XWRD[2] := XWRD[2] AND ZMSK158;
  XWRD[2] := XWRD[2] OR ZERO;
  XWRD[3] := XWRD[3] AND ZMSK1716;
  XWRD[3] := XWRD[3] OR ZERO
END; (* ZERO BITS 17 - 0 *)

PROCEDURE ZERO178(VAR XWRD : WDTEMPLATE);
CONST
  ZERO = $0000;
  ZMSK158  = $0000;
  ZMSK1716 = $00FC;
BEGIN
  XWRD[2] := XWRD[2] AND ZMSK158;
  XWRD[2] := XWRD[2] OR ZERO;
  XWRD[3] := XWRD[3] AND ZMSK1716;
  XWRD[3] := XWRD[3] OR ZERO
END; (* ZERO BITS 17 - 8 *)

PROCEDURE ZERO1716(VAR BYTE3 : INTEGER);
CONST
  ZERO = $0000;
  ZMSK1716 = 00FC;
BEGIN
  BYTE3 := BYTE3 AND ZMSK1716;
  BYTE3 := BYTE3 OR ZERO
END; (* ZERO BITS 17 - 16 *)

PROCEDURE WRDPREPLEN(VAR BYTE1 : INTEGER);
CONST
  ZMSK70= $0000;
VAR
  WPREPLR : REAL;
  WPREPLI : INTEGER;
BEGIN
  WRITE('WORD PREP LENGTH');
  DECPAD(WPREPLR,112.0,112.0);
  WPREPLI := TRUNC(WPREPLR);
  BYTE1 := BYTE1 AND ZMSK70;
  BYTE1 := BYTE1 OR WPREPLI;
  WRITELN
END; (* LOAD BITS 7 - 0 (WRDPREPLEN) *)

PROCEDURE WRDXFERLEN(VAR XWRD : WDTEMPLATE;VAR WDXFERLR : REAL);
CONST
  ZMSK70 =   $0000;
  ZMSK158  = $0000;
VAR
  WDXFERLI : INTEGER;
BEGIN
  WRITE('WORD TRANSFER LENGTH');
  DECPAD(WDXFERLR,1.0,65535.0);
  REALINT8B(WDXFERLR,WDXFERLI,1);
  XWRD[1] := XWRD[1] AND ZMSK70;
  XWRD[1] := XWRD[1] OR WDXFERLI;
  REALINT8B(WDXFERLR,WDXFERLI,2);
  XWRD[2] := XWRD[2] AND ZMSK158;
  XWRD[2] := XWRD[2] OR WDXFERLI;
  WRITELN
END; (* LOAD BITS 15 - 0 (XFERLEN) *)

PROCEDURE BYTERECLEN(VAR XWRD : WDTEMPLATE);
CONST
  ZMSK70   = 0000;
  ZMSK158  = 0000;
VAR
  BYTRECLR : REAL;
  BYTRECLI : INTEGER;
BEGIN
  WRITE('BYTE RECORD LENGTH');
  DECPAD(BYTRECLR,504.0,504.0);
  REALINT8B(BYTRECLR,BYTRECLI,1);
  XWRD[1] := XWRD[1] AND ZMSK70;
  XWRD[1] := XWRD[1] OR BYTRECLI;
  REALINT8B(BYTRECLR,BYTRECLI,2);
  XWRD[2] := XWRD[2] AND ZMSK158;
  XWRD[2] := XWRD[2] OR BYTRECLI;
  WRITELN
END; (* LOAD BITS 15 - 0 (BYTE REC LENGTH) *)

PROCEDURE WRDVERLEN(VAR XWRD : WDTEMPLATE);
CONST
  ZMSK70   = $0000;
  ZMSK158  = $0000;
VAR
  WVERLR : REAL;
  WVERLI : INTEGER;
BEGIN
  WRITE('WORD VERIFY LENGTH');
  DECPAD(WVERLR,0.0,65535.0);
  REALINT8B(WVERLR,WVERLI,1);
  XWRD[1] := XWRD[1] AND ZMSK70;
  XWRD[1] := XWRD[1] OR WVERLI;
  REALINT8B(WVERLR,WVERLI,2);
  XWRD[2] := XWRD[2] AND ZMSK158;
  XWRD[2] := XWRD[2] OR WVERLI;
  WRITELN
END; (* LOAD BIT 15 - 0 (WRD VERIFY LEN) *)

PROCEDURE RELWRDADD(VAR XWRD : WDTEMPLATE);
CONST
  ZMSK70   = $0000;
  ZMSK158  = $0000;
  ZMSK2316 = $0000;
  ZMSK2624 = $00F8;
VAR
  RWADDR : REAL;
  RWADDI : INTEGER;
BEGIN
  WRITE('RELATIVE WORD ADDRESS');
  DECPAD(RWADDR,0.0,134217727.0);
  REALINT8B(RWADDR,RWADDI,1);
  XWRD[1] := XWRD[1] AND ZMSK70;
  XWRD[1] := XWRD[1] OR RWADDI;
  REALINT8B(RWADDR,RWADDI,2);
  XWRD[2] := XWRD[2] AND ZMSK158;
  XWRD[2] := XWRD[2] OR RWADDI;
  REALINT8B(RWADDR,RWADDI,3);
  XWRD[3] := XWRD[3] AND ZMSK2316;
  XWRD[3] := XWRD[3] OR RWADDI;
  REALINT8B(RWADDR,RWADDI,4);
  XWRD[4] := XWRD[4] AND ZMSK2624;
  XWRD[4] := XWRD[4] OR RWADDI;
  WRITELN
END; (* LOAD BITS 26 - 0 (REL WRD ADD) *)

PROCEDURE ZERO3427(VAR XWRD : WDTEMPLATE);
CONST
  ZERO = $0000;
  ZMSK3127 = $0007;
  ZMSK3432 = $00F8;
BEGIN
  XWRD[4] := XWRD[4] AND ZMSK3127;
  XWRD[4] := XWRD[4] OR ZERO;
  XWRD[5] := XWRD[5] AND ZMSK3432;
  XWRD[5] := XWRD[5] OR ZERO
END; (* ZERO BITS 34 -27 *)

PROCEDURE ZERO70(VAR BYTE1 : INTEGER);
CONST
  ZERO = $0000;
  ZMSK70 = $0000;
BEGIN
  BYTE1 := BYTE1 AND ZMSK70;
  BYTE1 := BYTE1 OR ZERO
END; (* ZERO BITS 7 - 0 *)

PROCEDURE ZERO1713(VAR XWRD : WDTEMPLATE);
CONST
  ZERO = $0000;
  ZMSK1513 = $001F;
  ZMSK1716 = $00FC;
BEGIN
  XWRD[2] := XWRD[2] AND ZMSK1513;
  XWRD[2] := XWRD[2] OR ZERO;
  XWRD[3] := XWRD[3] AND ZMSK1716;
  XWRD[3] := XWRD[3] OR ZERO
END; (* ZERO BITS 17 - 13 *)

PROCEDURE ZERO3428(VAR XWRD : WDTEMPLATE);
CONST
  ZERO = $0000;
  ZMSK3128 = $000F;
  ZMSK3432 = $00F8;
BEGIN
  XWRD[4] := XWRD[4] AND ZMSK3128;
  XWRD[4] := XWRD[4] OR ZERO;
  XWRD[5] := XWRD[5] AND ZMSK3432;
  XWRD[5] := XWRD[5] OR ZERO
END; (* ZERO BITS 34 - 28 *)

PROCEDURE HEADADD(VAR BYTE2 : INTEGER);
CONST
  ZMSK128 = $00E0;
VAR
  HEADR : REAL;
  HEADI : INTEGER;
BEGIN
  WRITE('HEAD ADDRESS');
  DECPAD(HEADR,0.0,31.0);
  HEADI := TRUNC(HEADR);
  BYTE2 := BYTE2 AND ZMSK128;
  BYTE2 := BYTE2 OR HEADI;
  WRITELN
END; (* LOAD BITS 12 - 8 (HD) *)

PROCEDURE RESET35(VAR BYTE5 : INTEGER);
CONST
  BIT35 = $0000;
  ZMSK35 = 00F7;
BEGIN
  BYTE5 := BYTE5 AND ZMSK35;
  BYTE5 := BYTE5 OR BIT35
END; (* RESET BIT35 *)

PROCEDURE SECTORADD(VAR BYTE1 : INTEGER);
CONST
  ZMSK70 = $0000;
VAR
  SECTORR : REAL;
  SECTORI : INTEGER;
BEGIN
  WRITE('SECTOR ADDRESS');
  DECPAD(SECTORR,0.0,255.0);
  SECTORI := TRUNC(SECTORR);
  BYTE1 := BYTE1 AND ZMSK70;
  BYTE1 := BYTE1 OR SECTORI;
  WRITELN
END; (* LOAD BITS 7 - 0 (SECTOR) *)

PROCEDURE RECORDT(VAR BYTE1 : INTEGER);
CONST
  ZMSK70 = $0000;
VAR
  RECR : REAL;
  RECI : INTEGER;
BEGIN
  WRITE('RECORD');
  DECPAD(RECR,0.0,255.0);
  RECI := TRUNC(RECR);
  BYTE1 := BYTE1 AND ZMSK70;
  BYTE1 := BYTE1 OR RECI;
  WRITELN
END; (* LOAD BITS 7 - 0 (RECORD) *)

PROCEDURE CYLADD(VAR XWRD : WDTEMPLATE);
CONST
  ZMSK2318 = $0003;
  ZMSK2724 = $00F0;
VAR
  CYLR : REAL;
  CYLI : INTEGER;
BEGIN
  WRITE('CYLINDER ADDRESS');
  DECPAD(CYLR,0.0,1023.0);
  REALINT8B(CYLR,CYLI,1);
  XWRD[3] := XWRD[3] AND ZMSK2318;
  XWRD[3] := XWRD[3] OR CYLI;
  REALINT8B(CYLR,CYLI,2);
  XWRD[4] := XWRD[4] AND ZMSK2724;
  XWRD[4] := XWRD[4] OR CYLI;
  WRITELN
END; (* LOAD BITS 27 - 18 (CYL ADD) *)

PROCEDURE ZERO10(VAR BYTE1 : INTEGER);
CONST
  ZERO = $0000;
  ZMSK10 = $00FC;
BEGIN
  BYTE1 := BYTE1 AND ZMSK10;
  BYTE1 := BYTE1 OR ZERO
END; (* ZERO BITS 1 - 0 *)

PROCEDURE MENULANG5046(VAR EFW,AFW,ODW,IDW,STW:WDTEMPLATE;
                       VAR EF,AF,OD,ID,ST:BOOLEAN);
CONST
  SECPOSRELSK = $AC;
  TRKPOSRELSK = $2C;
  SEEK        = $1C;
  SEEKASETSEC = $9C;
  RECALIBRATE = $4C;
  NOOPERATION = $0C;
  WRTHMADDROS = $D4;
  PREPTRACK   = $04;
  PREPCYL     = $84;
  WRITEDATA   = $34;
  WRTDATAPADZ = $24;
  READIPL     = $00;
  READFULLTRK = $58;
  READHMADDSP = $D8;
  READCOUNT   = $48;
  SPCNTARDDAT = $98;
  READDATA    = $38;
  RDDATASPEC  = $F8;
  READVERIFY  = $28;
  READLABEL   = $C8;
  SENSEIO     = $10;
  RDARESBUFLG = $90;
  READCONFG   = $D0;
  RDBUFFREC   = $50;
  ZMSK2318 = $0003;
VAR
  CMD : CHAR;
BEGIN
    CLEARSCREEN;
    WRITELN;
    WRITELN;
    WRITELN;
    WRITELN('             * * *   MAID-III - 5046 COMMANDS   * * * ');
    WRITELN;
    WRITELN;
    WRITELN;
    WRITELN('1) - CONTROL COMMANDS ');
    WRITELN('2) - WRITE COMMANDS ');
    WRITELN('3) - READ COMMANDS ');
    WRITELN('4) - SENSE COMMANDS ');
    WRITELN;
    WRITE(' - enter number: ');
    READ(CMD);
    WRITELN;
    CASE CMD OF

      '1' : BEGIN
              CLEARSCREEN;
              WRITELN;
              WRITELN;
              WRITELN;
WRITE('            * * *   MAID-III - 5046 CONTROL COMMANDS   * * * ');
              WRITELN;
              WRITELN;
              WRITELN;
              WRITELN;
              WRITELN('1) - SECTOR POSITION RELATIVE SEEK ');
              WRITELN('2) - TRACK POSITION RELATIVE SEEK ');
              WRITELN('3) - SEEK ');
              WRITELN('4) - SEEK AND SET SECTOR ');
              WRITELN('5) - RECALIBRATE ');
              WRITELN('6) - NO OPERATION ');
              WRITELN;
              WRITE(' - enter number: ');
              READ(CMD);
              WRITELN;
              CASE CMD OF

                '1' : BEGIN
                        EFHEADING;
                        WRITELN('SECTOR POSITION RELATIVE SEEK ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR SECPOSRELSK;
                        DSKUNIT(EFW[4]);
                        BACKFACTOR(EFW[1]);
                        SET35(EFW[5]);
                        ZERO172(EFW);
                        ZERO3429(EFW);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3427(AFW);
                        RELWRDADD(AFW);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '2' : BEGIN
                        EFHEADING;
                        WRITELN('TRACK POSITION RELATIVE SEEK ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR TRKPOSRELSK;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO172(EFW);
                        ZERO10(EFW[1]);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3427(AFW);
                        RELWRDADD(AFW);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '3' : BEGIN
                        EFHEADING;
                        WRITELN('SEEK ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR SEEK;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3428(AFW);
                        CYLADD(AFW);
                        ZERO1713(AFW);
                        HEADADD(AFW[2]);
                        ZERO70(AFW[1]);
                        EF := TRUE;
                        AF := TRUE;
                      ZERO3428(AFW);
                        CYLADD(AFW);
                        ZERO1713(AFW);
                        HEADADD(AFW[2]);
                        ZERO70(AFW[1]);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '4' : BEGIN
                        EFHEADING;
                        WRITELN('SEEK AND SET SECTOR ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR SEEKASETSEC;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3428(AFW);
                        CYLADD(AFW);
                        ZERO1713(AFW);
                        HEADADD(AFW[2]);
                        SECTORADD(AFW[1]);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '5' : BEGIN
                        EFHEADING;
                        WRITELN('RECALIBRATE ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR RECALIBRATE;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        EF := TRUE;
                        AF := FALSE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '6' : BEGIN
                        EFHEADING;
                        WRITELN('NO OPERATION ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR NOOPERATION;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        EF := TRUE;
                        AF := FALSE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

              END (* CASE *)
            END;

      '2' : BEGIN
              CLEARSCREEN;
              WRITELN;
              WRITELN;
              WRITELN;
WRITELN('            * * *   MAID-III - 5046 WRITE COMMANDS   * * * ');
              WRITELN;
              WRITELN;
              WRITELN;
           WRITELN('1) - WRITE HOME ADDRESS AND RECORD ZERO SPECIAL ');
              WRITELN('2) - PREP TRACK ');
              WRITELN('3) - PREP CYLINDER ');
              WRITELN('4) - WRITE DATA ');
              WRITELN('5) - WRITE DATA AND PAD ZEROS ');
              WRITELN;
              WRITE(' - enter number: ');
              READ(CMD);
              WRITELN;
              CASE CMD OF

                '1' : BEGIN
                        EFHEADING;
                   WRITELN('WRITE HOME ADDRESS AND RECORD ZERO SPECIAL ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR WRTHMADDROS;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3428(AFW);
                        CYLADD(AFW);
                        ZERO1713(AFW);
                        HEADADD(AFW[2]);
                        ZERO70(AFW[1]);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '2' : BEGIN
                        EFHEADING;
                        WRITELN('PREP TRACK ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR PREPTRACK;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO178(EFW);
                        WRDPREPLEN(EFW[1]);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3428(AFW);
                        CYLADD(AFW);
                        ZERO1713(AFW);
                        HEADADD(AFW[2]);
                        ZERO70(AFW[1]);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '3' : BEGIN
                        EFHEADING;
                        WRITELN('PREP CYLINDER ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR PREPCYL;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO178(EFW);
                        WRDPREPLEN(EFW[1]);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3428(AFW);
                        CYLADD(AFW);
                        ZERO1713(AFW);
                        HEADADD(AFW[2]);
                        ZERO70(AFW[1]);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '4' : BEGIN
                        EFHEADING;
                        WRITELN('WRITE DATA ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR WRITEDATA;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO1716(EFW[3]);
                        WRDXFERLEN(EFW,WDXFLEN);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3427(AFW);
                        RELWRDADD(AFW);
                        EF := TRUE;
                        AF := TRUE;
                        OD := TRUE;
                        ID := FALSE;
                        ST := FALSE;
                      END;

                '5' : BEGIN
                        EFHEADING;
                        WRITELN('WRITE DATA AND PAD ZEROS ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR WRTDATAPADZ;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO1716(EFW[3]);
                        WRDXFERLEN(EFW,WDXFLEN);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3427(AFW);
                        RELWRDADD(AFW);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

              END (* CASE *)
            END;

      '3' : BEGIN
              CLEARSCREEN;
              WRITELN;
              WRITELN;
              WRITELN;
WRITELN('            * * *   MAID-III - 5046 READ COMMANDS   * * * ');
              WRITELN;
              WRITELN;
              WRITELN;
              WRITELN('1) - READ INITIAL PROGRAM LOAD (IPL) ');
              WRITELN('2) - READ FULL TRACK ');
              WRITELN('3) - READ HOME ADDRESS SPECIAL ');
              WRITELN('4) - READ COUNT ');
              WRITELN('5) - SPACE COUNT AND READ DATA ');
              WRITELN('6) - READ DATA ');
              WRITELN('7) - READ DATA SPECIAL ');
              WRITELN('8) - READ VERIFY ');
              WRITELN('9) - READ LABEL ');
              WRITELN;
              WRITE(' - enter number: ');
              READ(CMD);
              WRITELN;
              CASE CMD OF

                '1' : BEGIN
                        EFHEADING;
                        WRITELN('READ INITIAL PROGRAM LOAD (IPL) ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR READIPL;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        EF := TRUE;
                        AF := FALSE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '2' : BEGIN
                        EFHEADING;
                        WRITELN('READ FULL TRACK ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR READFULLTRK;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO1716(EFW[3]);
                        WRDXFERLEN(EFW,WDXFLEN);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3428(AFW);
                        CYLADD(AFW);
                        ZERO1713(AFW);
                        HEADADD(AFW[2]);
                        ZERO70(AFW[1]);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '3' : BEGIN
                        EFHEADING;
                        WRITELN('READ HOME ADDRESS SPECIAL ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR READHMADDSP;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3428(AFW);
                        CYLADD(AFW);
                        ZERO1713(AFW);
                        HEADADD(AFW[2]);
                        ZERO70(AFW[1]);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '4' : BEGIN
                        EFHEADING;
                        WRITELN('READ COUNT ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR READCOUNT;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        EF := TRUE;
                        AF := FALSE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '5' : BEGIN
                        EFHEADING;
                        WRITELN('SPACE COUNT AND READ DATA ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR SPCNTARDDAT;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO1716(EFW[3]);
                        BYTERECLEN(EFW);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3428(AFW);
                        CYLADD(AFW);
                        ZERO1713(AFW);
                        HEADADD(AFW[2]);
                        RECORDT(AFW[1]);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '6' : BEGIN
                        EFHEADING;
                        WRITELN('READ DATA ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR READDATA;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO1716(EFW[3]);
                        WRDXFERLEN(EFW,WDXFLEN);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3427(AFW);
                        RELWRDADD(AFW);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := TRUE;
                        ST := FALSE
                      END;

                '7' : BEGIN
                        EFHEADING;
                        WRITELN('READ DATA SPECIAL ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR RDDATASPEC;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO1716(EFW[3]);
                        WRDXFERLEN(EFW,WDXFLEN);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3427(AFW);
                        RELWRDADD(AFW);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '8' : BEGIN
                        EFHEADING;
                        WRITELN('READ VERIFY ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR READVERIFY;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO1716(EFW[3]);
                        WRDVERLEN(EFW);
                        AFHEADING;
                        RESET35(AFW[5]);
                        ZERO3427(AFW);
                        RELWRDADD(AFW);
                        EF := TRUE;
                        AF := TRUE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '9' : BEGIN
                        EFHEADING;
                        WRITELN('READ LABEL ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR READLABEL;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        EF := TRUE;
                        AF := FALSE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

              END (* CASE *)
            END;

      '4' : BEGIN
              CLEARSCREEN;
              WRITELN;
              WRITELN;
              WRITELN;
WRITE('             * * *   MAID-III - 5046 SENSE COMMANDS   * * * ');
              WRITELN;
              WRITELN;
              WRITELN;
              WRITELN;
              WRITELN('1) - SENSE I/O ');
              WRITELN('2) - READ AND RESET BUFFERED LOG ');
              WRITELN('3) - READ CONFIGURATION ');
              WRITELN('4) - READ BUFFERED RECORD ');
              WRITELN;
              WRITE(' - enter number: ');
              READ(CMD);
              WRITELN;
              CASE CMD OF

                '1' : BEGIN
                        EFHEADING;
                        WRITELN('SENSE I/O ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR SENSEIO;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        EF := TRUE;
                        AF := FALSE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '2' : BEGIN
                        EFHEADING;
                        WRITELN('READ AND RESET BUFFERED LOG ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR RDARESBUFLG;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        EF := TRUE;
                        AF := FALSE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '3' : BEGIN
                        EFHEADING;
                        WRITELN('READ CONFIGURATION ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR READCONFG;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        EF := TRUE;
                        AF := FALSE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

                '4' : BEGIN
                        EFHEADING;
                        WRITELN('READ BUFFERED RECORD ');
                        EFW[3] := EFW[3] AND ZMSK2318;
                        EFW[3] := EFW[3] OR RDBUFFREC;
                        SET35(EFW[5]);
                        ZERO3429(EFW);
                        DSKUNIT(EFW[4]);
                        ZERO170(EFW);
                        EF := TRUE;
                        AF := FALSE;
                        OD := FALSE;
                        ID := FALSE;
                        ST := FALSE
                      END;

              END (* CASE *)

            END;

      ELSE
        BEGIN
          WRITELN;
          WRITELN('ENTER NUMBER 1 - 4 ');
        END (* ELSE *)

    END (* CASE *)
END; (* 5046MENULANG *)

FUNCTION MENUA_COMMANDA : INTEGER;
VAR CMD : CHAR;
BEGIN
  REPEAT
    CLEARSCREEN;
    WRITELN;
    WRITELN;
    WRITELN;
WRITE('             * * *   MAID-III - 5046 TEST PROCESSOR   * * * ');
    WRITELN;
    WRITELN;
    WRITELN;
    WRITELN;
    WRITELN('     *** MENU *** ');
    WRITELN;
    WRITELN('A) - INSTRUCTIONS ');
    WRITELN('B) - DIRECTORY (.INS .PAC .DAT) ');
    WRITELN('C) - MAKE PACKET (FILE ) ');
    WRITELN('D) - MANUAL/OVER-RIDE ');
    WRITELN('E) - DELETE (FILE) ');
    WRITELN('F) - DUMP PACKET (FILE) ');
    WRITELN('G) - DUMP DATA (FILE) ');
    WRITELN('H) - COMPARE DATA FILES ');
    WRITELN('I) - EXECUTE PACKET (FILE) ');
    WRITELN('J) - POST EXECUTION ANALYSIS (PACKET FILE) ');
    WRITELN('K) - PRINTER (ON/OFF) ');
    WRITELN('L) - TERMINAL TALK ');
    WRITELN('M) - PHONE ON TERMINATION ');
    WRITELN('N) - QUIT ');
    WRITELN;
    WRITE(' - enter letter: ');
    READ(CMD);
    WRITELN;
    CASE CMD OF

      'A','a' : BEGIN MENUA_COMMANDA := INSTRUC; EXIT END;

      'B','b' : BEGIN MENUA_COMMANDA := DIR; EXIT END;

      'C','c' : BEGIN MENUA_COMMANDA := MAKPKT; EXIT END;

      'D','d' : BEGIN MENUA_COMMANDA := MANUAL; EXIT END;

      'E','e' : BEGIN MENUA_COMMANDA := DELPKT; EXIT END;

      'F','f' : BEGIN MENUA_COMMANDA := DMPPKT; EXIT END;

      'G','g' : BEGIN MENUA_COMMANDA := DMPDAT; EXIT END;

      'H','h' : BEGIN MENUA_COMMANDA := CMPDAT; EXIT END;

      'I','i' : BEGIN MENUA_COMMANDA := EXECPKT; EXIT END;

      'J','j' : BEGIN MENUA_COMMANDA := POSTA; EXIT END;

      'K','k' : BEGIN MENUA_COMMANDA := PRNT; EXIT END;

      'L','l' : BEGIN MENUA_COMMANDA := TERMTALK; EXIT END;

      'M','m' : BEGIN MENUA_COMMANDA := PHONETERM; EXIT END;

      'N','n' : BEGIN MENUA_COMMANDA := QUIT; EXIT END;

      ELSE
        BEGIN
          WRITELN;
          WRITELN('ENTER LETTER A - L ');
        END (* ELSE *)

    END (* CASE *)

  UNTIL FALSE (* FOREVER LOOP *)
END; (* MENUA_COMMANDA *)

BEGIN (* MAIN PROGRAM *)

  INITUSER(NAME);
  FSTPAC := TRUE;
  REPEAT
    INIT1(EFW,EF);
    INIT1(AFW,AF);
    INIT1(ODW,OD);
    INIT1(IDW,ID);
    INIT1(STW,ST);
    SADD[1] := 0;
    SADD[2] := 0;
    EADD[1] := 0;
    EADD[2] := 0;

    CASE MENUA_COMMANDA OF
     INSTRUC : BEGIN
                 INSTRHEADING;
                 WRITE('ENTER FILENAME.TXT: ');
                 KYBRD(F1A,11,' ');
                 PRGCMD := $04;
                 M5046(PRGCMD);
                 WRITELN;
                 WRITE('TYPE RETURN. ');
                 READ(X)
               END; (* CASE OF INSTRUC *)

         DIR : BEGIN
                 DIRHEADING;
                 WRITE('ENTER FILENAME: ');
                 KYBRD(F1A,11,' ');
                 PRGCMD := $05;
                 M5046(PRGCMD);
                 WRITELN;
                 WRITE('TYPE RETURN. ');
                 READ(X)
               END; (* CASE OF DIRECTORY *)

      MAKPKT : BEGIN
                 SAVIBF := FALSE;
                 CMP := FALSE;
                 MAKHEADING;
        MENULANG5046(EFW,AFW,ODW,IDW,STW,EF,AF,OD,ID,ST);
                 REALINT8B(WDXFLEN,XINT,1);
                 XFCNT[1] := XINT;
                 REALINT8B(WDXFLEN,XINT,2);
                 XFCNT[2] := XINT;
                 MAKHEADING;
                 IF EF = TRUE THEN
                   IF FSTPAC = TRUE THEN
                     BEGIN
                       WRITE('ENTER PACKET FILENAME: ');
                       KYBRD(F1C,11,' ')
                     END;
                 IF OD = TRUE THEN
                   BEGIN
                     WRITE('ENTER OUTPUT DATA FILENAME: ');
                     KYBRD(F1B,11,' ');
                     FOR XINT := 1 TO 12 DO
                       F1A[XINT] := F1B[XINT];
          WRITE('IS THIS AN EXISTING OUTPUT FILE OR MAKE NEW (E/N): ');
                     READ(X);
                     CASE X OF 
                       'N','n' : BEGIN
  MAKEBUFFER(ODW,WDXFLEN,PRGCMD,DATMOD,BUFRPT,WRDRPT,PRGCNT)
                                 END;
                     ELSE
                       BEGIN
                         WRITELN;
                         SELBASE(BASEREQ);
                         WRITELN;
                         WRITE('ENTER STARTING ADDRESS');
                         DATAWORD(SADD,0.0,65535.0,BASEREQ,2)
                       END
                     END (* CASE *)
                   END;
                 IF ID = TRUE THEN
                   BEGIN
                     WRITELN;
                     WRITE('SAVE INPUT DATA TO DISK (Y/N): ');
                     READ(X);
                     CASE X OF
                       'Y','y' : BEGIN
                                   SAVIBF := TRUE
                                 END;
                     ELSE
                       SAVIBF := FALSE
                     END
                   END;
                 IF ID = TRUE THEN
                   IF SAVIBF = TRUE THEN
                     BEGIN
                       WRITELN;
                       WRITE('ENTER INPUT DATA FILENAME: ');
                       KYBRD(F1B,11,' ')
                     END;
                 IF ID = TRUE THEN
                   BEGIN
                     WRITELN;
                     WRITE('COMPARE INPUT DATA (Y/N): ');
                     READ(X);
                     CASE X OF
                       'Y','y' : BEGIN
                                 CMP := TRUE;
                                 WRITELN;
                                 WRITE('ENTER FILENAME TO COMPARE: ');
                                 KYBRD(F1A,11,' ')
                                 END;
                     ELSE
                       CMP := FALSE
                     END
                   END;
                 IF EF = TRUE THEN
                   BEGIN
                     WRITELN;
                     WRITE('ENTER PACKET REPEAT COUNT');
                     BASEREQ := 'D';
                     DATAWORD(PRPCNT,0.0,65535.0,BASEREQ,2);
                     WRITE('IS THIS THE LAST PACKET (Y/N): ');
                     READ(X);
                     CASE X OF
                       'Y','y' : BEGIN
                                   LSTPAC := TRUE
                                 END;
                       ELSE
                         LSTPAC := FALSE
                     END
                   END;
                 IF FSTPAC = TRUE THEN
                   PRGMOD := $01;
                 IF FSTPAC = FALSE THEN
                   PRGMOD := $00;
                 PRGCMD := $09;
                 IF EF = TRUE THEN
                   BEGIN
                     M5046(PRGCMD);
                     FSTPAC := FALSE;
                     IF LSTPAC = TRUE THEN
                       FSTPAC := TRUE
                   END;
                 WRITELN;
                 WRITELN('TYPE RETURN. ');
                 READ(X)
               END; (* CASE OF MAKPKT *)

      MANUAL : BEGIN
                 MANUALHEADING;
                 WRITELN('SELECT BASE FOR INPUT VALUE ');
                 WRITELN;
                 SELBASE(BASEREQ);
                 WRITELN;
                 WRITE('ENTER TEST - CHANNEL STATUS WORD');
                 DATAWORD(XSTW,0.0,68719476735.0,BASEREQ,5)
               END; (* CASE OF CHNGPKT *)

      DELPKT : BEGIN
                 DELHEADING;
                 WRITE('ENTER FILENAME: ');
                 KYBRD(F1A,11,' ');
                 PRGCMD := $0B;
                 M5046(PRGCMD);
                 WRITELN;
                 WRITE('TYPE RETURN. ');
                 READ(X)
               END; (* CASE OF DELPKT *)

     DMPPKT : BEGIN
                DMPHEADING;
                WRITE('ENTER PACKET FILENAME: ');
                KYBRD(F1C,11,' ');
                PRGCMD := $0B;
                M5046(PRGCMD);
                WRITELN;
                WRITE('TYPE RETURN. ');
                READ(X)
              END; (* CASE OF DMPPKT *)

     DMPDAT : BEGIN
                 DDFHEADING;
                 WRITELN('SELECT BASE FOR INPUT VALUE ');
                 WRITELN;
                 SELBASE(BASEREQ);
                 WRITELN;
                 WRITE('ENTER STARTING ADDRESS');
                 DATAWORD(SADD,0.0,65535.0,BASEREQ,2);
                 WRITE('ENTER ENDING ADDRESS');
                 DATAWORD(EADD,0.0,65535.0,BASEREQ,2);
                 WRITE('ENTER FILENAME: ');
                 KYBRD(F1A,11,' ');
                 PRGCMD := $07;
                 M5046(PRGCMD);
                 WRITELN;
                 WRITE('TYPE RETURN. ');
                 READ(X)
               END; (* CASE OF DMPDAT *)

      CMPDAT : BEGIN
                 CMPHEADING;
                 WRITELN('SELECT BASE FOR INPUT VALUE ');
                 WRITELN;
                 SELBASE(BASEREQ);
                 WRITELN;
                 WRITE('ENTER STARTING ADDRESS');
                 DATAWORD(SADD,0.0,65535.0,BASEREQ,2);
                 WRITE('ENTER ENDING ADDRESS');
                 DATAWORD(EADD,0.0,65535.0,BASEREQ,2);
                 WRITE('ENTER PRIMARY FILENAME 1: ');
                 KYBRD(F1A,11,' ');
                 WRITE('ENTER SECONDARY FILENAME 2: ');
                 KYBRD(F1B,11,' ');
                 PRGCMD := $08;
                 M5046(PRGCMD);
                 WRITELN;
                 WRITE('TOTAL COMPARE ERRORS = ');
                 WRITELN(ERRCNT);
                 WRITELN;
                 WRITE('TYPE RETURN. ');
                 READ(X)
               END; (* CASE OF CMPDAT *)

     EXECPKT : BEGIN
                 EXECHEADING;
                 WRITE('ENTER PACKET FILENAME: ');
                 KYBRD(F1C,11,' ');
                 PRGCMD := $03;
                 M5046(PRGCMD);
                 IF PHTERM = TRUE THEN
                   SETUPCOMM('D');
                 WRITELN;
                 WRITE('TYPE RETURN. ');
                 READ(X)
               END; (* CASE OF EXECPKT *)

       POSTA : BEGIN
                 POSTHEADING;
               END;

        PRNT : BEGIN
                 PRGCMD := $0A;
                 M5046(PRGCMD);
                 WRITELN;
                 WRITE('TYPE RETURN ');
                 READ(X)
               END; (* CASE OF PRNT *)

    TERMTALK : BEGIN
                 REPEAT
                   CTRLE := ' ';
                   TERMHEADING;
WRITELN('   TYPE CTRL - C :TO ENTER MODEM COMMAND STRING (ORGINATE) ');
                   WRITELN('   TYPE CTRL - H :TO BACK SPACE. ');
                   WRITELN('   TYPE CTRL - L :TO CLEAR SCREEN. ');
                   WRITELN('   TYPE CTRL - E :TO RETURN TO MENU. ');
                   WRITELN;
                   WRITELN;
                   WRITELN;
                   WRITELN;
                   REPEAT
                     READ(TALK);
                     IF TALK = CHR(05) THEN
                       BEGIN
                         CTRLE := CHR(05);
                         TALK := CHR(12)
                       END;
                     IF TALK = CHR(3) THEN
                       SETUPCOMM('C');
                   UNTIL TALK = CHR(12);
                 UNTIL CTRLE = CHR(05)
               END; (* CASE OF TERMINAL TALK *)

   PHONETERM : BEGIN
                 PHTERM := FALSE;
                 PHTERMHEADING;
                 WRITE('PHONE ON TERMINATION (Y/N): ');
                 READ(X);
                 IF X = 'Y' THEN
                   PHTERM := TRUE;
                 IF X = 'y' THEN
                   PHTERM := TRUE;
               END; (* CASE OF PHONE ON TERMINATION *)

      QUIT   : BEGIN

               EXIT
               END (* CASE OF QUIT *)

    END (* CASE *)
  UNTIL FALSE (* FOREVER *)

END.
