;--------------------------------------------------------------------
;
; CB-80 RECORD LOCKING FIXES.                     DATE: 20 OCT 82
;                                             MODIFIED: 12 APR 83
;
; THE FOLLOWING FIXES APPLY TO CB-80 VERSION 1.3 ONLY.  USE WITH
; OTHER VERSIONS WILL PROBABLY MALFUNCTION.
;
; TurboDOS VERSION 1.20 OR LATER IS REQUIRED.  HOWEVER, THIS PATCH
; IS NOT REQUIRED IN TurboDOS VERSION 1.30 OR LATER.
;
; WHEN USING THIS PATCH, ENSURE THAT IN THE .PAR FILES FOR
; THE MASTER PROCESSOR AND ALL OF THE SLAVES:
;
;  CPMVER = 30  ;DEFAULT, ALLOWS CB-80 LOCKING TO FUNCTION.
;  COMPAT = 0F8 ;SET LOGICAL FLAG, OTHERS.  YOU MAY ALSO USE 0B8.
;               ;0F8 CAUSES THE REQUESTOR TO SUSPEND WHEN ANOTHER
;               ;USER HAS LOCKED THE RECORD, 0B8 CAUSES THE NORMAL CB-80
;               ;ERROR RETURNS.
;
; ALSO, PLEASE NOTE THE FOLLOWING ERRORS IN THE CB-80 LANGUAGE MANUAL
; DATED September, 1981 (First Printing):
;
; 1.  PAGE 81 - THE DESCRIPTION OF "OPEN" AND "CREATE" OMITS THE
; KEYWORDS "LOCKED", "UNLOCKED", AND "READONLY", WHICH SHOULD
; APPEAR AFTER THE "AS FILENO%" CLAUSE.  THE DEFAULT MODE IS
; "LOCKED", WHICH CAUSES TurboDOS TO OPEN IN EITHER EXCLUSIVE OR
; PERMISSIVE MODE, ACCORDING TO THE PERMISSIVE BIT IN "COMPAT".
; "UNLOCKED" MUST BE USED FOR SHARED ACCESS, OTHERWISE THE "LOCK"
; AND "UNLOCK" FUNCTIONS RETURN NO ERRORS, AND DO NOT LOCK.
; "READONLY" MAY BE SPECIFIED TO CAUSE THE READ-ONLY FILE INTERFACE
; ATTRIBUTE TO BE SET.
;
; 2.  PAGES 91-93 - THE RETURN CODES FOR "LOCK" AND "UNLOCK" ARE WRONG.
; A ZERO VALUE IS A GOOD RETURN, NON-ZERO IS A BAD RETURN.
;
; NOW, HERE IS THE PATCH FOR THE CB-80 LIBRARY TO FIX THE "ERROR IF" BUG:
;
SET CB80.IRL ;N-RGF
LIB FRONT.REL=CB80.IRL(CBINIT,CBARIT,CBPRIN,CBCON)
LIB MIDDLE.REL=CB80.IRL(CBFILE)
LIB REAR.REL=CB80.IRL(CBCHN,CBSTR,CBMISC,CBDIM,CBMATC,CBTRAN)
;
; PLEASE VERIFY THE FOLLOWING CHANGES WHEN PERFORMED BY MONITOR:
;
; AT 046A CHANGE 0D TO 0C
; AT 046B CHANGE 2A TO 3A
; AT 046C CHANGE F0 TO 42
;
MONITOR
L MIDDLE.REL
E 46A
0C
3A
42

S MIDDLE.REL
Q
RENAME CB80.IRL CB80-13.ORG
LIB CB80[I]=FRONT,MIDDLE,REAR
SET CB80.IRL ;RG
DDLE.REL
E 46A
0C
3A
42
 
S MIDDLE.REL
Q
RENAME CB80.IRL CB80-13.ORG
LIB CB80[I]=FRONT,