	de
	pop	bc
	ld	a,(hl)			;test if last char
	bit	7,a
	ret	nz			;return if true
	inc	hl			;else do more
	jr	..cdrvl
;
conso:					;error message pre & post call
consi:
	call	dms##			;position to next line
	db	acr,alf+80h
	ret				;done
;
	end	
hr)		;get form feed character
	or	a			;form feed character=0?
	jp	z,serial##		;if so, continue
	push	de			;save function number
	push	bc			;save channel number/character
	ld	c,a			;form feed character to c-reg
	call	..cdrva			;output form feed
	pop	bc			;restore channel number/character
	pop	de			;restore function number
	jp	serial##		;and exit
;
..cdrv:	ld	a,(ffchr)		;do we have a ff char defined
	or	a
	jp	z,serial##		;leave if not
	cp	c			;otherwise if outgoing char a ff
	jp	nz,serial##		;leave if not
..cdrva:
	ld	hl,clsstr		;otherwise get clear screen string address
..cdrvl:
	ld	a,(hl)			;get char to send
	and	7fh			;clear parity bit
	ld	c,a			;get set to send it
	push	bc
	push	de
	push	hl
	call	serial##		;send char
	pop	hl
	poptitle	Hard disk specification table
subttl	Advanced Digital 7/3/84

	name	('DMA5F')	; Module name (6 chars only)

tracks	equ	306		; physical tracks
heads	equ	4		; physical heads

steprt	equ	15		; step rate (refer to the hdc1001 manual 
				; for step rates)

dirsiz	equ	1024		; number of directory entries
blksiz	equ	4096		; block size

trkoff	equ	1		; res tracks (can be used to partition drives)
hdoffst	equ	2		; set to amount of heads to ignore

phydrv	equ	0		; physical drive number set to 0,1,2 or 3 

ecc	equ	0		; set to 1 for ecc enabled else 0
sectrk	equ	32		; sectors per track (head)
secsiz	equ	256		; sector size 512 or 256
fixed	equ	1		; set to 1 for fixed media else 0 for removable


;Don't change anything below this point! 

setparm	macro	size		; macro to determine block sizes
	bls	set high size	; initialize bls
	blocks	set 0		; clear block value
	rept	8		; repeat a max of 8
	if 	bls ne 0	; is bls <> 0
	bls	set bls shr 1	; shift until bls=0
	blocks	set blocks+1	; increment block by 1
	endif			; end of if statement
	endm			; end of repeat
	endm			; end of macro


	dseg				; locate in data segment

DMA5F@::			; Global entry point for patching (6 chrs only)

	setparm blksiz			; determine block size
	db  fixed shl 7 or blocks	; block size       
	if  sectrk*secsiz lt blksiz	; test for underflow
	dw  sectrk*secsiz*(heads-hdoffst)/blksiz*(tracks-trkoff) ; total blocks
	else
	dw  sectrk*secsiz/blksiz*(heads-hdoffst)*(tracks-trkoff) ; total blocks
	endif
	db  ((dirsiz*8)/blksiz)*4	; directory blocks
	setparm secsiz			; determine sector size
	db  blocks			; sector size
	dw  sectrk*(heads-hdoffst)	; sectors per cylinder
	dw  tracks			; tracks per disk
	dw  trkoff			; track offset
	db  ecc shl 7 or ((blocks and 1) shl 6) or steprt ;ecc,drvtyp,step rate
	db  hdoffst			; head offset
	db  phydrv			; physical drive number
	dw  sectrk			; physical sectors per track

	end
z,..out		;if so, continue
	push	bc			;else, save output character
	ld	c,aetx			;get etx character
	call	..sout			;output etx character
..wait:	call	..sin			;else, get serial input
	and	7fh			;strip sign bit
	sub	aack			;character=ack?
	jr	nz,..wait		;if not, wait
	call	..gcca			;else, get character count address
	ld	(hl),a			;reset character count
	pop	bc			;restore output character
..out:	ld	a,c			;get output character
	and	7fh			;strip sign bit
	cp	aesc			;character=escape?
	jr	nz,..nesc		;if not, continue
	call	..gsca			;else, get sequence count address
	ld	a,(etxseq)		;get max escape sequence length
	ld	(hl),a			;set sequence count
..nesc:	call	..sout			;output character
	call	..gcca			;get character count address
	inc	(hl)			;increment character count
	call	..gsca			;get sequence count address
	dec	(hl)			;decrement sequence count
	ret	p			;if positive, done
	inc	(hl)			;else, restore count to 0
	ret				;done
..sin:	push	bc			;save channel number/character
	push	de			;save function number
	ld	e,1			;set function number=1
	call	serial##		;get serial input
	jr	..sioc			;continue
..sout:	push	bc			;save channel number/character
	push	de			;save function number
	call	serial##		;output character
..sioc:	pop	de			;restore function number
	pop	bc			;restore channel number/character
	ret				;done
..gcca:	ld	hl,chrcnt		;get character count table
	jr	index			;continue
..gsca:	ld	hl,seqcnt		;get sequence count table
;
index:	push	de			;save function number
	ld	e,b			;channel number to de-reg
	ld	d,0			;double length
	add	hl,de			;index into table
	pop	de			;restore function number
	ret				;done
;
	end
nt character count
	call	..gsca			;get sequence count address
	dec	(hl)			;decrement sequence count
	ret	p			;if positive, done
	inc	(hl)			;else, restore count to 0
	ret				;done
..sin:	push	bc			;save channel number/character
	push	de			;save func	title	TURBODOS OPERATING SYSTEM - ADC PARALLEL PRINTER DRIVER
	subttl	copyright 1983 by software 2000, inc.
	.z80
;
; copyright 1983 by software 2000, inc.
;	converted to MICROSOFT M80 format by
;	  Advanced Digital Corp.
;
; version: 10/03/83
;
	name	('LSTPAR')		;module id
;
	include DREQUATE.LIB		;driver symbolic equivalences
;
pio0d	equ	4			;parallel port 0 data port
pio0c	equ	6
pio1d	equ	5			;parallel port 1 data port
pio1c	equ	7
;
	DSEG				;locate in data area
;
parff::	db	aff			;form feed character
outchr:	db	0			;output character
initc:	db	0			;initialization complete flag
;
imssph:					;character output semaphore
	defw	0			;semaphore count
..imsh:	defw	..imsh			;semaphore p/d list head
	defw	..imsh
;
	cseg				;locate in program area
;
lstdr@::
	ld	hl,initc		;get initialization complete flag
	ld	a,(hl)
	or	a			;initialization complete flag set?
	call	z,..init		;if not, initialize list channel
	ld	a,e			;get function number
	cp	2			;function number=2?
	jr	z,lstout		;if so, continue
	cp	7			;function number=7?
	jr	z,lstwsr		;if so, continue
	ret				;else, done

..init:	dec	(hl)			;set initialization complete flag
	ld	a,00fh			;put port a in output mode
	out	(pio0c),a
	ld	a,0cfh			;put port b in bit mode
	out	(pio1c),a
	ld	a,01fh			;bits 0-4 input, bits 5-7 output
	out	(pio1c),a
	ret				;done
;
lstwsr:	ld	a,(parff)		;get form feed character
	ld	c,a			;form feed character to c-reg
;
lstout:	ld	hl,outchr		;get output character
	ld	(hl),c			;save output character
	ld	de,imspol		;get poll routine address
	call	lnkpol##		;create poll routine
	call	imspr			;execute poll routine
	ld	hl,imssph		;get semaphore address
	jp	wait##			;dispatch if necessary
;
imspol:					;parallel out poll routine
	defw	0
	defw	0
;
imspr:	in	a,(pio1d)		;get printer status
	and	1			;printer busy?
	ret	z			;if so, done
	ld	a,(outchr)		;get output character
	out	(pio0d),a		;output it
	ld	a,80h			;toggle data strobe
	out	(pio1d),a
	xor	a
	out	(pio1d),a
	ld	hl,imspol		;get poll routine address
	call	unlink##		;unlink poll routine
	ld	hl,imssph		;get semaphore
	jp	signal##		;signal process as ready
;
	end
t	(pio1c),a
	ld	a,01fh			;bits 0-4 input, bits 5-7 output
	out	(pio1c),a
	ret				;done
;
lstwsr:	ld	a,(parff)		;get form feed character
	ld	c,a			;form feed character to c-reg
;
lstout:	ld	hl,outchr		;get output character
	ld	(hl),c			;save output character
	ld	de,imspol		;get poll routine address
	call	lnkpol##		;create poll routine
	call	imspr			;execute poll routine
	ld	hl,imssph		;get semaphore address
	jp	wait##			;dispatch if necessary
;
imspol:					;parallel out poll routine
	defw	0
	defw	0
;
imspr:	in	a,(pio1d)		;get printer status
	and	1			;printer busy?
	ret	z			;if so, done
	ld	a,(outchr)		;get output character
	out	(pio0d),a		;output it
	ld	a,80h			;toggle data strobe
	out	(pio1d),a
	xor	a
	out	(pio1d),a
	ld	hl,imspol