;
;
;
;
		MACLIB MACRO
;
;FORMAT PROGRAM FOR THE WD1791 FDISK CONTROLLER
; INTERLEAVED SECTOR VERSION
;
; **************  DD DISK CONTROLLER ****************
;
TRUE	EQU	0FFFFH
FALSE	EQU	NOT TRUE
;
;
;****************************************************
;
;
;DISK DRIVE TYPE
MINI	EQU	false		;FALSE FOR 8 INCH DRIVES
;
;***************************************************
;
;
;
;
;
;****************************************
;
;DOUBLE DENSITY CODE FLAG
;
;THIS FLAG IS PLACED ON TRACK 0
;SECTOR 1 FOR DOUBLE DENSITY DISKS
;
CODE1	EQU	0e6H		;single sided
CODEQ	EQU	0e7H		;double sided
;*********************************************
;
BDOS	EQU	5
WBOOT	EQU	0
CMD	EQU	00CH
DAL	EQU	CMD+3
WAIT	EQU	014H
WTRACK	EQU	0F4H
SEEK	EQU	19H
DSEL	EQU	014H
TRACK	EQU	CMD+1
SECT	EQU	CMD+2
;
	IF NOT MINI
	SECNT	EQU	8
	SSECT	EQU	26
	MTK	EQU	76	;77 TRACKS (0-76)
	GAP1	EQU	80
	GAP3	EQU	80
	PRE0	EQU	12
	SGAP4F	EQU	40
	SGAP2F	EQU	26
	SGAP20	EQU	6
	SGAP1F	EQU	27
	ENDIF
;
;
	IF MINI
	SECNT	EQU	4	;1024 byte sectors
	SSECT	EQU	18
;DOUBLE DENSITY GAPS
	GAP1	EQU	255
	GAP3	EQU	255
	PRE0	EQU	12
;SINGLE DENSITY GAPS
	SGAP4F	EQU	11
	SGAP1F	EQU	7
	SGA1F6	EQU	3
	SGAP20	EQU	6
	MTK	EQU	39	;40 TRACKS (0-39)
	ENDIF
;
INTRP	EQU	0D0H
RESTO	EQU	1	;6MS STEP
ORG 100H
;
START:
	LXI SP,START
	PRINT <CR,LF,LF,'     SBC Z80 SUPER QUAD DOUBLE / SINGLE '>
	PRINT <CR,LF,'       DENSITY FORMAT PROGRAM vs 2.0'>

	IF	MINI
	PRINT <CR,LF,'         FOR MINI FLOPPY DISK DRIVES'>
	ENDIF
COMPLT:
	IF	MINI
	MVI	A,CODE1
	STA	CODE2			; set allways double density
	XRA	A

	ELSE				; 8 inch drives
	
	MVI A,0E5H			;INIZ CODE2 TO ISNT CODEQ
	STA CODE2
	PRINT <CR,LF,LF,'Enter Density,  Single or Double (S,D) :'>
	CALL IMPC				;GET CHAR
	CPI 'D'				;IS DOUBLE ?
	JNZ CKSINGL			;IF NOT SEE IF SINGLE
;
;
	XRA A			;SET DENS TO 0 FOR DOUBLE DENSITY
	JMP SETUP1
CKSINGL:
	CPI 'S'
	JNZ QUIT		;NOT SINGLE THEN QUIT
	MVI A,MTK+2		;DO ALL TRACKS SINGLE DENSITY
	ENDIF
SETUP1:
	STA DENS
;
;
	PRINT <CR,LF,'Enter Disk Drive to be Formatted (A,B,C,D) :'>

	MVI A,0FFH			;INIZ SYSTEM FLAG TO NOT
	STA FLAG			;SYSTEM
	CALL IMPC		;GET ANSWER
	SUI	'A'
	JC	QUIT
	CPI	4
	JNC	QUIT
;
START1:
	MOV C,A
	STA DISKNO	;SAVE DRIVE NUMBER
SYSTK:
	PRINT 	<CR,LF,'Format System Tracks only ?      (Y,N) :'>
	CALL IMPC
	CPI	'N'
	JZ	DOIT
	CPI	'Y'
	JNZ	SYSTK
	XRA	A
	STA	FLAG
DOIT:
	XRA	A
	STA	DBLFL
	LDA	DENS
	ORA	A
	JNZ	DOIT1
	MVI	A,CODE1				; assume single sided
	STA	CODE2
	PRINT 	<CR,LF,'Format Single or Double Sided    (S,D) :'>
	CALL IMPC
	CPI	'S'
	JZ	DOIT1
	CPI	'D'
	JNZ	DOIT
	MVI	A,CODEQ
	STA	CODE2
	MVI	A,1
	STA	DBLFL
DOIT1:
	PRINT	<CR,LF,'Insert diskette into drive '> 

	LDA	DISKNO
	ADI	41H
	CHAROUT
	PRINT	<': and press the Return key '>
	CHARIN
	CPI	0DH 
	JNZ	0	; exit if not return
	PRINT	<CR,LF>
	LDA DISKNO
	OUT WAIT	;SELECT DISK & SET SINGLE DENSITY
	MVI A,RESTO
	di
	OUT CMD
	IN WAIT		;WAIT FOR DONE
	ei
;
	XRA A
	MOV D,A		;START WITH TRACK 0
	STA SIDE	;SET SIDE ZERO
SLOOP2:
	MVI E,1		;SECTOR
	LXI H,BUFF	;DMA BUFFER
;
	IF NOT MINI
	MVI A,0FFH
	MVI B,SGAP4F
	CALL PUT
	XRA A
	MVI B,6
	CALL PUT
	MVI M,0FCH
	INX H
;	ENDIF
;
	MVI B,SGAP1F	;GAP 1
	MVI A,0FFH
	CALL PUT
	IF MINI
	MVI B,SGA1F6
	MVI A,0F6H
	CALL PUT
	ENDIF
SLOOP:
	XRA A
	MVI B,SGAP20
	CALL PUT
	MVI M,0FEH
	INX H
	MOV M,D		;TRACK
	INX H
	LDA SIDE
	MOV M,A		;SET SIDE
	INX H
	MOV M,E
	INX H
	MVI M,0
	INX H
	MVI M,0F7H
	INX H
	MVI A,0FFH
	MVI B,11
	CALL PUT
	MVI B,6
	XRA A
	CALL PUT
	MVI M,0FBH
	INX H
	MVI A,0E5H
	MVI B,128
	CALL PUT 	;DATA 128 BYTES
	MOV A,E
	DCR A		;SEE IF SECTOR 1
	ORA D		;MAKE SURE TRACK 0
	JNZ NO1
	LDA DENS
	ORA A
	JNZ NOTDD
	DCX H
	LDA CODE2		;DENSITY CODE
	MOV M,A
	INX H
NOTDD:
NO1:
	MVI M,0F7H
	INX H
	MVI A,0FFH
	MVI B,SGAP1F
	CALL PUT
	IF MINI
	MVI A,0F6H
	MVI B,SGA1F6
	CALL PUT
	ENDIF
	INR E
	MOV A,E
	CPI SSECT+1	;MAX SINGLE DENSITY SECTORS PER TRACK
	JNZ SLOOP
	MVI C,3
SLOOP3:
	MVI B,0
	MVI A,0FFH
	CALL PUT
	DCR C
	JNZ SLOOP3
	PUSH D
	LXI H,BUFF
	XCHG		;PUT IN D,E
	LXI H,WLOOP
	MVI A,WTRACK
	di
	OUT CMD
;
	CALL WLOOP
	ei
	POP D
	IN CMD		;GET STATUS
	ORA A		;TEST
	JNZ ERROR

	LDA	DENS
	ORA	A
	JZ	START2

	INR D
	MOV A,D
	OUT DAL 		;TELL 1791
	LDA DENS
	CMP D			;DENS IS 77+1 OR 0
	JZ COMPLT		;IF D=78 AND DENS = 78 THEN DONE
	MVI A,SEEK
	di
	OUT CMD
	IN WAIT			;WAIT FOR END OF SEEK
	ei
;
;SEE IF LAST TRACK
;
	LDA FLAG
	MOV B,A
	MOV A,D		;GET TRACK
	SUI 2
	ORA B		;IF D=2 AND FLAG = 0 THEN
			;DONE WITH SD SYSTEM
	JZ COMPLT
	JMP SLOOP2
	ENDIF		; NOT MINI
;
; DOUBLE DENSITY FORMAT ROUTINE
;
START2:
	XRA	A
	STA	SIDE

if	mini
	mvi	d,0ffh	;fake so double density starts at track 0
	jp	was12
endif
	LDA	DBLFL
	ORA	A
	MVI	D,0
	JZ	WAS12
	MVI	A,1
	STA	SIDE

LOOP2:
	LDA	SIDE
	ADD	A
	ADD	A
	MOV	B,A
	LDA	DISKNO
	ORA	B
	ORI	8
	OUT	WAIT			; SELECT DRIVE, DENSITY & HEAD

	MVI E,0		;RESET SECTOR COUNTER
	LXI H,TABLE	;RESET POINTER
	SHLD PTR	;RESET TABLE POINTER
	LXI H,BUFF	;DMA BUFFER
	MVI B,GAP1	;GAP 1
	MVI A,4EH
	CALL PUT
LOOP:
	LDA	DBLFL
	ORA	A
	JZ	INTER1
	MOV	A,D
	CPI	0	
	JNZ	INTERL
	JMP	INTER2
INTER1:
	MOV A,D	;SEE IF TRACK 1
	CPI 0
	JNZ INTERL	;IF NOT TK 0 THEN DO INTERLEAVE
;
;
	; NON INTERLEAVE SECTOR CALCULATION
;
INTER2:
	INR E
	MOV A,E
	CPI SECNT+1
	JMP NEXTSE
;
; INTERLEAVE SECTOR CALCULATION
; TABLE LOOK UP
;
INTERL:
	PUSH H
	LHLD PTR
	MOV E,M
	MOV A,E
	INX H
	SHLD PTR	;POINT NEXT AND SAVE
	POP H
	ORA A		;SET FLAGS
NEXTSE:
	JZ NEXTTK
	CALL PUTZERO
	MVI A,0F5H
	MVI B,3
	CALL PUT
	MVI M,0FEH
	INX H
	MOV M,D		;TRACK
	INX H
	LDA SIDE
	MOV M,A		;SET SIDE
	INX H
	MOV M,E
	INX H
	MVI M,3
	INX H
	MVI M,0F7H
	INX H
	MVI A,4EH
	MVI B,22
	CALL PUT
	MVI B,12
	XRA A
	CALL PUT
	MVI A,0F5H
	MVI B,3
	CALL PUT
	MVI M,0FBH
	INX H
	MVI A,0E5H
	MVI B,0
	CALL PUT 	;DATA 1024 BYTES
	CALL	PUT
	CALL	PUT
	CALL	PUT
	
IF	MINI
	MOV	A,E		; GET SECTOR
	DCR	A	
	ORA	D
	JNZ	MN0S1
	push	H
	push	D
	lxi	D,0fc7fh
	dad	D		;put code byte at end of 1st 128 bytes
	LDA	CODE2
	MOV	M,A
	pop	D
	pop	H
MN0S1:
	ENDIF
	MVI M,0F7H
	INX H
	MVI A,4EH
	MVI B,GAP3
	CALL PUT
	JMP LOOP
NEXTTK:
	MVI C,3
LOOP3:
	MVI B,0
	MVI A,4EH
	CALL PUT
	DCR C
	JNZ LOOP3
	PUSH D
	LXI H,BUFF
	XCHG		;PUT IN D,E
	LXI H,WLOOP
	MVI A,WTRACK
	di
	OUT CMD
;
	CALL WLOOP
	POP D
	IN CMD		;GET STATUS
	ei
	ORA A		;TEST
	JNZ ERROR
	LDA DBLFL	;SEE IF DOUBLE SIDED
	ORA	A
	JZ ONES2	;DO ONLY ONLY ONE SIDE
	LDA SIDE	;GET SIDE NUMBER
	DCR A		;TEST SIDE
	JZ WAS12
	MVI A,1		;DO SIDE 1
	STA SIDE
;DO OTHER SIDE
	JMP LOOP2
WAS12:
			;DO NEXT TRACK
	XRA	A
	STA SIDE	;SET SIDE 0
ONES2:
	INR D
	MOV A,D
	CPI MTK+1	;LAST TRACK?
	JZ COMPLT
	OUT DAL
	MVI A,SEEK
	di
	OUT CMD
	IN WAIT
	ei
	LDA FLAG	;TEST ALL DISK?
	ORA A
	JZ COMPLT
	JMP LOOP2
PUT:
	MOV M,A
	INX H
	DCR B
	JNZ PUT
	RET
PUTZERO:
	MVI B,PRE0
	XRA A
	CALL PUT
	RET
ERROR:
	PUSH PSW
	PRINT <CR,LF,LF,'Disk Formatting Error',CR,LF,'Disk drive Status : '>
	POP PSW
	PUSH PSW
	HEXOUT		;PRINT ERROR STATUS
	POP PSW
	PUSH PSW
	ANI 80H
	JZ ERROR1
	POP PSW
	PRINT <CR,LF,'Drive not ready'>
	JMP COMPLT
ERROR1:
	POP PSW
	ANI 40H		;SEE IF WRITE PROTECT
	JZ COMPLT
	PRINT <CR,LF,'Disk is write protected'>
	JMP COMPLT
QUIT:
	LDA 4   	;SELECT DRIVE 0 HEAD 0
	ANI	03H
	OUT WAIT	;DO IT
	JMP WBOOT	;GO BACK TO CPM
IMPC:		;INPUT A CHAR. FROM THE CONSOLE
	XRA A
	STA IBUFF+2
	INPUT IBUFF,80
	LDA IBUFF+2
	RET
;
;
WLOOP:
	IN WAIT
	ORA A
	RP
;
	LDAX D		;GET DATA
	OUT DAL		;PUT DATA IN 1791
	INX D
	PCHL		;JMP WLOOP
FLAG:	DB 0
DENS:	DB 0
PTR:	DW TABLE
DBLFL:	DB 0
DISKNO:	DB 0		;DISK NUMBER
SIDE:	DB 0		;SIDE OF DISK
SIDENO:	DB	0	;SET TO 1 IFF B COMMAND IS ENTERED
CODE2:	DB	0E5H
TABLE:
;
	IF NOT MINI
;	DB 1,18,35,10,27,44,2,19,36,11,28,45,3
;	DB 20,37,12,29,46,4,21,38,13,30,47,5
;	DB 22,39,14,31,48,6,23,40,15,32,49,7
;	DB 24,41,16,33,50,8,25,42,17,34,51
;	DB 9,26,43

	db 1,4,7,2,5,8,3,6
	ENDIF
;
	IF MINI
	db 1,3,2,4
	ENDIF
	DB 00
BUFF:
IBUFF:
	END START

