/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 27-Nov-85 | [301.4] Created
* 30-Nov-85 | [301.6] Split off from autocoder.e to use autoload feature
* 31-May-90 | [401.128] <jmn> disallow [ ] % from bcd set
*  3-Dec-91 | [1.221] <jmn> changed format to conform to new layout
*****************************************************************************/
/*****************************************************************************
   Changes and enhancements copyright 1986, Joseph M. Newcomer, all
   rights reserved.  These changes may be redistributed to valid
   Epsilon license holders providing both the Lugaru and my copyrights
   remain intact.  I assume no liability for the use or inability to
   use this software.  These changes may *NOT* be redistributed for
   profit.
*****************************************************************************/

#include "eel.h"
/*
          111111111122222222223333333333444444444455555555556...
0123456789012345678901234567890123456789012345678901234567890...
LLLLLL     OP___OPERAND________________________COMMENT

*/

#define OP_START 11
#define OP_LENGTH 5
#define OPERAND_START (OP_START + OP_LENGTH)
#define COMMENT_START 45

keytable autocoder_tab;


/****************************************************************************
*                           autocoder_tab_character
*				      C-I
* Effect: 
*       Establishes tabs for autocoder mode
****************************************************************************/

autocoder_tab_character() on autocoder_tab[CTRL('I')]
    {
     if(current_column() < OP_START)
        {
	 move_to_column(OP_START);

	 /* If we didn't have enough space, the following loop will extend
	    the line.
	 */

	if(point>0 && point!=size() && character(point) != '\n' )
	   while(character(point-1) != ' ' && character(point-1) != '\n')
	      { /* move over */
	       point--;
	      } /* move over */
	    
	 while(current_column() < OP_START)
	   { /* move over */
	    insert(' ');
	   } /* move over */

	while(curchar() == ' ')
	   { /* move back */
	    delete(point,point+1);
	   } /* move back */

	}
     else
     if(current_column() < OPERAND_START)
        { /* go to operand */
	 move_to_column(OPERAND_START);

	 /* If we didn't have enough space, the following loop will extend
	    the line.
	 */

	if(point>0 && point!=size() && character(point) != '\n' )
	   while(character(point-1) != ' ' && character(point-1) != '\n')
	      { /* move over */
	       point--;
	      } /* move over */
	    
	 while(current_column() < OPERAND_START)
	   { /* move over */
	    insert(' ');
	   } /* move over */

	while(curchar() == ' ')
	   { /* move back */
	    delete(point,point+1);
	   } /* move back */

	} /* go to operand */
     else

     if(current_column() < COMMENT_START)
        { /* go to comment */

	 /* If we didn't have enough space, the following loop will extend
	    the line.
	 */
	 move_to_column(COMMENT_START);

	 while(current_column() < COMMENT_START)
	   { /* move over */
	    insert(' ');
	   } /* move over */

	while(curchar() == ' ')
	   { /* move back */
	    delete(point,point+1);
	   } /* move back */

	} /* go to comment */
     else
        { /* space over */
	 stuff("  ");
	} /* space over */
	 
    }

/****************************************************************************
*                                 record_mark
* Result: void
*       
* Effect: 
*       Places a record mark
****************************************************************************/

command record_mark() on autocoder_tab[ALT('r')]
    {
     insert('\330');
    }


/****************************************************************************
*                                 segment_mark
* Result: void
*       
* Effect: 
*       Places a segment mark
****************************************************************************/

command segment_mark() on autocoder_tab[ALT('s')]
    {
     insert('\327');
    }

/****************************************************************************
*                                 group_mark
* Result: void
*       
* Effect: 
*       Places a group mark
****************************************************************************/

command group_mark() on autocoder_tab[ALT('g')]
    {
     insert('\316');
    }

when_loading()
   {
    int i;

    for(i = 0; i < NUMKEYS; i++)
       if(autocoder_tab[i] == 0 || autocoder_tab[i] == -1)
       		autocoder_tab[i] = reg_tab[i];

    /* Translate all lowercase input into uppercase */

    for(i='a';i<='z';i++)
    	autocoder_tab[i] = (short) case_indirect;

    /* Unbind the keys not in the bcd set, except ^ which is a word sep */

    autocoder_tab['{'] = -1;
    autocoder_tab['}'] = -1;
    autocoder_tab['"'] = -1;
    autocoder_tab['~'] = -1;
    autocoder_tab['`'] = -1;
    autocoder_tab['_'] = -1;
    autocoder_tab['|'] = -1;
    autocoder_tab['%'] = -1;  /* % not in set, use ( */
    autocoder_tab['['] = -1;
    autocoder_tab[']'] = -1;
   }
	    

/****************************************************************************
*                                    au008
* Effect: 
*	Sets up autocoder mode
****************************************************************************/

au008()
    {
     major_mode = "Autocoder";
     make_mode();
     mode_keys = autocoder_tab;
     return;
    }
