/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 30-Jul-86 | [1.398] Created
* 31-Jul-86 | [1.406] Log lamp test event
* 18-Aug-86 | [1.414] screen.h -> bscreen.h
* 10-Nov-91 | [1.428] <jmn> converted to Microsoft C 6.0
*****************************************************************************/
#include "stdio.h"
#include "boolean.h"

#include "btypes.h"
#include "scdspmsg.h"

#include "panel.h"
#include "hercules.h"
#include "graph.h"
#include "disp.h"
#include "color.h"
#include "diag.h"
#include "kb.h"
#include "scan.h"
#include "display.h"
#include "button.h"
#include "1401.h"
#include "length.h"

extern boolean lamp_test;

/****************************************************************************
*                                   draw_lamp_test
* Effect: 
*       Draws the Lamp Test button
****************************************************************************/

void draw_lamp_test()
    {
     unsigned char fore;
     unsigned char back;
     unsigned char h_fore;
     unsigned char h_back;

     if(ismono())
        { /* mono */
	 h_fore = fore = H_NORMAL;
	 h_back = back = 0;
	} /* mono */
     else
        { /* color */
	 fore = control_fore;
	 back = control_back;
	 h_fore = legend_fore;
	 h_back = legend_back;
	} /* color */

     hide_mouse_cursor();
     scdspmsg(lamp_Y,lamp_X,fore,back,  "   ");
     scdspmsg(lamp_Y+1,lamp_X,fore,back,"   ");
     mark_screen(lamp_X+1,lamp_Y+1," on",lamp_test);
     scdspmsg(lamp_Y+2,lamp_X,fore,back,"   ");
     mark_screen(lamp_X+1,lamp_Y+2,"off",(boolean)!lamp_test);
     scdspmsg(lamp_Y+3,lamp_X,fore,back,"ͼ");
     scdspmsg(lamp_Y,lamp_X+1,h_fore,h_back,"Lmp");
     show_mouse_cursor();
    }

/****************************************************************************
*                                   lamp_flip
* Effect: 
*       toggles lamp test switch
****************************************************************************/

void lamp_flip()
    {
     if(running()) 
	return;

     clear_off();
     lamp_test = !lamp_test;

     draw_lamp_test();

     draw_lights();

    }


/****************************************************************************
*				  in_lamp_test
* Inputs:
*       coord X: screen X of mouse hit
*	coord Y: screen Y of mouse hit
* Result: boolean
*       true if in lamp_test switch
*	false if not
****************************************************************************/

boolean in_lamp_test(coord X,coord Y)
    {
     return bounded(X,Y,lamp_X,lamp_Y,lamp_X+lamp_width-1,
     			lamp_Y+lamp_height);
    }

/****************************************************************************
*                                check_lamp
* Inputs:
*       coord X: screen X of mouse hit
*	coord Y: screen Y of mouse hit
* Effect: 
*       Handles lamp test toggling
****************************************************************************/

void check_lamp(coord X,coord Y)
    {
     if(in_lamp_test(X,Y))
        { /* hit it */
	 lamp_flip();
	 if(diagnostics_on)
	    { /* log it */
	     log_console_event("Lamp Test Switch ON");
	    } /* log it */
	 wait_for_mouse_up();
	 lamp_flip();
	 if(diagnostics_on)
	    { /* log it */
	     log_console_event("Lamp Test Switch OFF");
	    } /* log it */
	} /* hit it */
    }
