/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 24-Jan-86 | [1.306] Created change log
* 24-Jan-86 | [1.306] printer_ready() now takes argument
* 24-Jan-86 | [1.306] Added test on bit 0x20; printer which is not even
*           | connected returns this code
* 25-Feb-86 | [1.379] include <> => include ""
* 19-Nov-91 | [1.428] <jmn> printer_ready => physical_printer_ready
*  2-Jan-92 | [1.5] <jmn> parameters now consistent
*****************************************************************************/
#include "dos.h"
#include "boolean.h"
#include "rdy.h"

/****************************************************************************
*			    printer_ready
* Inputs:
*	int n: printer id
* Result: boolean
*       true if printer is online (or n=-1)
*	false if printer is offline
****************************************************************************/

boolean printer_ready(int n)
   {
    union REGS inregs;
    union REGS outregs;

    if(n < 0) 
       return true;

    inregs.h.ah = 2;	/* read printer status */
    inregs.x.dx = n;	/* for lpt 0 */
    int86(0x17,&inregs,&outregs);	/* BIOS call 17 - printer support */

    return (outregs.h.ah & 0x28) == 0;
   }
