/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 27-Dec-85 | [1.241] Created
* 28-Dec-85 | [1.255] Added decimal scan advanced feature
* 24-Jan-86 | [1.314] check_left_mouse_button => check_left_halt
* 27-Jan-86 | [1.350] declare single_cycle_decode()
* 25-Feb-86 | [1.379] include <> => include ""
*  6-Aug-86 | [1.410] Added NOTREACHED comment
*  6-Aug-86 | [1.410] Include bcd.h
* 10-Nov-91 | [1.428] <jmn> converted to Microsoft C 6.0 libraries
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/

#include "stdio.h"
#include "btypes.h"
#include "mem1401.h"
#include "boolean.h"
#include "mach.h"
#include "diag.h"
#include "instr.h"
#include "bcd.h"
#include "ifetch.h"
#include "kb.h"
#include "scan.h"

extern char * mce_state_decode(short state);
extern void tell_mce_state(void);

boolean debug_MCE = true;

/* Machine State:    */

#define MCE_init_a_fetch    single_cycle(i_MCE,local_microstate+1)
#define MCE_fetch_B         single_cycle(i_MCE,local_microstate+2)
#define MCE_store_B         single_cycle(i_MCE,local_microstate+3)
#define MCE_fetch_B_forward single_cycle(i_MCE,local_microstate+4)
#define MCE_float_dollar_f  single_cycle(i_MCE,local_microstate+5)
#define MCE_float_dollar_s  single_cycle(i_MCE,local_microstate+6)
#define MCE_fetch_A	    single_cycle(i_MCE,local_microstate+7)
#define MCE_store_B_forward single_cycle(i_MCE,local_microstate+8)
#define MCE_store_A         single_cycle(i_MCE,local_microstate+9)
#define MCE_store_blank	    single_cycle(i_MCE,local_microstate+10)
#define MCE_scan_point	    single_cycle(i_MCE,local_microstate+11)
	
extern char * single_cycle_decode();

/*****************************************************************************
				1401 Simulator

			   Move Characters and Edit

			 Move and Edit (Two Addresses)
			 -----------------------------

Instruction format

Mnemonic	Op Code	A-address	B-address
--------        ------- ---------       ---------
MCE		E	AAA		BBB

Function: The data field (A-field) is modified by the contents of the edit
control field (B-field) and the result is stored in the B-field.  The data
field and the control field are read from storage character-by-character under
control of the word marks and the editing rules.  Any sign in the units
poosition of the data field is removed during the operation.


Word Marks: The B-field word mark stops the operation.  If an A-field word
mark is sense during the transmission, remaining commas in the B-field are
blanked.

Note: This description of the instruction assumes a 1401 without the
expanded print-edit special feature.  If the feature is installed,
a decimal point does not start zero suppression.

Simulator note: We implement expanded print-edit.

Address Registers After Operation:

Without zero suppression:

I-Add		A-Add		B-Add
-----		-----		-----
NSI		A-La		B-Lb

With zero suppression:

I-Add		A-Add		B-Add
-----		-----		-----
NSI		A-La		location of control zero +1


Editing rules:

RULE 1:  All numerical, alphabetic and special characters can be used in the
control word.  However, some of these characters have special meaning:

space		This is replaced with the character from the corresponding
		position of the A-field.

0		This is used for zero suppression, and is replaced with a
		corresponding character from the A-field.  Also, the
		rightmost "0" in the control word indicates the rightmost
		limit of zero-suppression.

.		This remains in the edited field in the position where
		written.  When used with the expanded-print-edit feature
		it has an additional function.

,		This remains in the edited field in ht epoistion where 
		written.  It is removed during a zero-suppress operation
		if it is to the left of the high-order significant digit.

CR		This is undisturbed if the data sign is negative.  It is
		blanked out if the data sign is positive.  [It can be used
		in the body of a control word without being subject to sign
		control] --except it is not clear in the presence of
		the expanded print edit feature...

-		This is the same as CR

& +		This causes a space in the edited field.  It can be used
		in multiples.

*		This can be usied in singular or in multiples, usually to
		indicate a class of total.  When it is used with the
		expanded print edit feature, it takes on an additional 
		function.

$		This is undisturbed in the position where it is written.
		When used with the expanded-print-edit feature, it has
		and additional function.

RULE 2:  A word mark in the high-order position of the B-field controls
the operation.

RULE 3: When the A-field word mark is sensed, the remaining commas in the
control field are set to blanks.

RULE 4: The body of the control word is that portion beginning with the
rightmost blank or zero and continuing to the left to the control character
that governs the transfer of the last position of the data field.  The
remaining porition of the control field is the status portion.

RULE 5: If the data field is positive, and the CR or - symbols are located 
in the status portion of the control word, they are blanked out [somewhat
different with expanded print edit?]

RULE 6: The data field can contain fewer, but must not contain more, positions
than the number of blanks and zeroes in the body of the control word.  Dollar
signs and asterisks are included in the body of the control word with the
expanded print edit feature.

RULE 7: Zero suppression is used if unwanted zeros to the left of significant
digits in a data field are to be deleted.

*****************************************************************************/

/* Pieces of microstate */

static short init_B_addr;		/* initial B-address */
static boolean a_done;		/* A-field WM seen */
static boolean asterisk;	/* we want asterisk fill */
static boolean sig0;		/* '0' pattern seen as last character */
static boolean dollar;		/* Floating $ fill */
static boolean fwd_scan_done;	/* done with forward scan */
static boolean rev_scan_done;	/* done with reverse scan */
static boolean b_done;		/* B-field WM seen */
static short a_sign;		/* Sign of A-field */
static boolean decimal;		/* decimal point seen on reverse scan */
static short last_state;		/* for debug printout */
static boolean any_digit_placed;/* true if any significant digit seen */
static boolean digit_seen;	/* digit seen during backscan */

/*****************************************************************************
ͻ
                 
ͼ

	single-cycle-start
ͻ
 run = true      
ͼ
        single-cycle-run
       ͻ
        run = false     
       ͼ
          
   ͼ
       
       
         init_a_fetch
ͻ                    ͻ
 fetch A                                    fetch_A           
 a_sign = ?                   ͻ               
 A = numbits(A)                  fetch A                      
 A_addr--                        A_addr--                     
 asterisk = false                set a_done                   
 dollar = false               ͼ               
 sig0   = false                                                
 set a_done                                                   
ͼ                                             
                                                                        
                                                               ~b_done
       ͼ                                  
            fetch_B                                                  store_B
ͻ                                       ͻ
 fetch B                                                 B_addr--        ̻
 set   b_done                                            memory[B_addr]=A
ͼ                                       ͼ
                                                                     b_done
                       ͻ                       
          space                                                          
       ͹                       
                           determine digit                               
                       ͹                       
                        != '0'         ='0'                             
                       ͹                       
                        sig0 = true                                     
                       ͼ                       
                                                                         
                              ͹           
                                                                           
                                                                           
          0            ͻ                
          A = A | word_mark              ͹           
                          sig0 = true                                    
                       ͼ                
                                                                           
          ,            ͻ                
            fill determination                           
                       ͹                
                         a_done          ~a_done                        
                       ͹                
                       A = space                                        
                       ͼ                
                                                                         
                                ͹           
                                                                           
           .           ͻ                
                                         ͹           
                       ͼ                
                                                                           
                                                                           
           &/+         ͻ                
          A = space                      ͹           
                       ͼ                
                                                                           
                                                                           
          - C R        ͻ                
          sign determination                             
                       ͹                
                         plus               minus                       
                       ͹                
                       A = space                                        
                       ͼ                
                                                                         
                                ͹           
                                                                           
                                                                           
          *            ͻ                
          significant digit?                             
                       ͹                
                         sig0              ~sig0                        
                       ͹                
                       set asterisk                                     
                       ͼ                
                                                                         
                                ͹           
                                                                           
          $            ͻ                
          significant digit?                             
                        ͹                
                          sig0              ~sig0                        
                        ͹                
                        set dollar                                       
                        ͼ                
                                                                          
                                 ͼ           
                                                                             
                                                                             
       ͼ
            fetch_B_forward
ͻ
  B_addr++                       
͹      B_addr++;          
   termination?                  memory[B_addr] = B;
͹                       
 B_add>init_BB_add<=init_B               store_B_forward
 WM previous?                                    
͹                       
 dollar?     Fetch B                             
͹WM(B)?                              
             if asterisk                         
 no    yes       B='*'                           
ͼ                       
                                                 
                   ͼ
                                      
          ͻ
                    float_dollar_f   
     ͻ   
      B_addr--                      
      Fetch B                       
     ͹   
              WM(B)?                
     ͹   
        yes       B= space?        
     ͹   
                 yes     no       
     ͼ   
                                   
                            ͼ
  ͼ         
                     
                         float_dollar_s
              ͻ
               memory[B_addr] = '$'
              ͼ
                     
                     
  ͼ
  
single_cycle_complete
*****************************************************************************/


/****************************************************************************
*                                   inst_MCE
* result: boolean
*	true if instruction succeeded
*	false if instruction failed
* Effect: 
*	Executes move and suppress zeroes instruction
****************************************************************************/

boolean inst_MCE()
    {
     boolean quit;
     boolean result;
     boolean cycling;
     boolean run;
     boolean report;

     switch(I_cycle)
        { /* length dispatch */
	 case 1: /* chained */
	 	break;
         case 7: /* normal */
	 	break;
	 default: /* illegal length */
	 	illegal_length();
		return false;
	} /* length dispatch */

     tell_op(op_A|op_B);

      result = true;
      cycling = true;
      quit = false;

      while(cycling)
         { /* move chars */
	  last_state = single_cycle_state;
	  if(bad_address(A_addr))
	     { /* bogus */
	      cycle = cycle_A;
	      result = false;
	      quit = true;
	      cycling = false;
	      break;
	     } /* bogus */

	  if(bad_address(B_addr))
	     { /* bogus */
	      cycle = cycle_B;
	      result = false;
	      quit = true;
	      cycling = false;
	      break;
	     } /* bogus */
	      
	  switch(single_cycle_state)
	     { /* state decode */
	      case single_cycle_run:
	      		init_B_addr = B_addr;
			run = true;
			single_cycle_state = MCE_init_a_fetch;
			break;
	      case single_cycle_start:
	      		init_B_addr = B_addr;
			run = false;
			single_cycle_state = MCE_init_a_fetch;
			break;
	      case MCE_init_a_fetch:
	      		A = B = memory[A_addr];
			a_sign = ZONEBITS(A);
			a_done = WM(A);
			A = NUMBITS(A);
			A_addr--;

			/* Initialize microstate */
			asterisk = false;
			dollar = false;
			sig0 = false;
			any_digit_placed = false;
			fwd_scan_done = false;
			decimal = false;
			rev_scan_done = false;
			digit_seen = false;

			single_cycle_state = MCE_fetch_B;
			cycling = run;
			break;
	      case MCE_fetch_A:
	      		if(!a_done)
			   { /* fetch A */
			    A = B = memory[A_addr];
			    a_done = WM(A);
			    A_addr--;
			   } /* fetch A */
			else
				A = B = 10;	/* BCD 0 */

			single_cycle_state = MCE_fetch_B;
			cycling = run;
			break;
	      case MCE_fetch_B:
	      		B = memory[B_addr];
			cycle = cycle_B;
			b_done = WM(B);
			if(a_done) A = BA8421(A);
			switch(BA8421(B))
			   { /* char decode */
			    case 0:  /* BCD space */
			    	if(BA8421(A) < 10 && BA8421(A) >= 1)
					any_digit_placed = true;
			        single_cycle_state = MCE_store_A;
				sig0 = false;
			    	break;
			    case 10: /* BCD '0' */
			    	if(BA8421(A) < 10 && BA8421(A) >= 1)
					any_digit_placed = true;
			    	A |= word_mark;
				sig0 = true;
				single_cycle_state = MCE_store_A;
				break;
			    case 27: /* BCD ',' */
			        if(a_done) B = 0;  /* store space */
				single_cycle_state = MCE_store_B;
				sig0 = false;
				break;
			    case 59: /* BCD '.' */
			        single_cycle_state = MCE_store_B;
				sig0 = false;
			    	break;
			    case 48: /* BCD '&'/'+' */
			        B = 0;	/* store space */
				sig0 = false;
				single_cycle_state = MCE_store_B;
				break;
			    case 51: /* BCD 'C' */
			    case 41: /* BCD 'R' */
			    case 32: /* BCD '-' */
			    	if(a_sign != B_bits) B = 0; /* store space */
				sig0 = false;
				single_cycle_state = MCE_store_B;
				break;
			    case 44: /* BCD '*' */
			        if(sig0) 
				   { /* floating * */
				    asterisk = true;
				    single_cycle_state = MCE_store_A;
				   } /* floating * */
				else
				   { /* nonfloating * */
				    single_cycle_state = MCE_store_B;
				   } /* nonfloating * */
				sig0 = false;
				break;
			    case 43: /* BCD '$' */
			        if(sig0) 
				   { /* floating $ */
				    dollar = true;
				    single_cycle_state = MCE_store_A;
				   } /* floating $ */
				else
				   { /* nonfloating $ */
				    single_cycle_state = MCE_store_B;
				   } /* nonfloating $ */
				sig0 = false;
				break;
			    default: /* some other character */
			        single_cycle_state = MCE_store_B;
				sig0 = false;
				break;
			   } /* char decode */
			cycling = run;
			break;
		    case MCE_store_A:
		        memory[B_addr] = A;
			B_addr--;
			if(!b_done)
			    single_cycle_state = MCE_fetch_A;
			else
			    single_cycle_state = MCE_fetch_B_forward;
			break;
		    case MCE_store_B:
		        memory[B_addr] = B;
			B_addr--;
			if(!b_done)
			    single_cycle_state = MCE_fetch_B;
                        else
			    single_cycle_state = MCE_fetch_B_forward;
			break;
		    case MCE_fetch_B_forward:
		        B_addr++;
			if(fwd_scan_done || B_addr > init_B_addr )
			   { /* end reverse scan */
			    if(dollar)
			       { /* end of scan */
			        single_cycle_state = MCE_float_dollar_f;
				break;
			       } /* end of scan */
			    else
			       { /* done */
				quit = true;
				single_cycle_state = single_cycle_complete;
				break;
			       } /* done */
			   } /* end reverse scan */
			B = memory[B_addr];
			if(!WM(B))
			   { /* suppress */
			    
			    /* If we have already encoutered a significant
			       digit, we need only scan until we find the
			       WM set at the zero-suppress code point, so
			       we skip all other processing and recycle in
			       this state.
			    */
			    if(digit_seen)
			    	break;
				
			    /* Otherwise, we apply the various rules to
			       the pattern which apply during the left to 
			       right scan 
			    */
			       
			    switch(BA8421(B))
			       { /* decode */
				case 0:		/* BCD space */
					if(asterisk)
						B = 44;	/* BCD '*' */
					single_cycle_state = MCE_store_B_forward;
					break;
				case 10:	/* BCD '0' */
					    if(!decimal)
					       { /* not yet seen . */
						if(asterisk)
						   B = 44; /* BCD '*' */
						else
						   B = 0;
					       } /* not yet seen . */
					    /* else decimal seen,
					       leave leading
					       zeroes untouched */
					    single_cycle_state = MCE_store_B_forward;
					    break;
				case 27:	/* BCD ',' */
					    if(asterisk) 
					       B = 44;	/* BCD '*' */
					    else
					       B = 0;	/* BCD space */

					    single_cycle_state = MCE_store_B_forward;
					    break;
			        case 59:	/* BCD decimal */
					    decimal = true;
					    single_cycle_state = MCE_store_B_forward;
					    break;
				case 1:	/* BCD '1' */
				case 2:	/* BCD '2' */
				case 3:	/* BCD '3' */
				case 4:	/* BCD '4' */
				case 5:	/* BCD '5' */
				case 6:	/* BCD '6' */
				case 7:	/* BCD '7' */
				case 8:	/* BCD '8' */
				case 9:	/* BCD '9' */
				    digit_seen = true;
				    break;
			       } /* decode */
			   } /* suppress */
			else
			   { /* end of scan- WM seen */
			    fwd_scan_done = true;

			    if(decimal && !any_digit_placed)
			       { /* blank to . */
				single_cycle_state = MCE_store_blank;
			       } /* blank to . */
			    else
			       { /* zap WM */
				single_cycle_state = MCE_store_B_forward;
			       } /* zap WM */
			   } /* end of scan- WM seen */
			cycle = cycle_B;
			B = BA8421(B);
			cycling = run;
			break;
              case MCE_store_blank:
	      		B = 0;  /* BCD space */
			memory[B_addr] = B;
			B_addr--;
			single_cycle_state = MCE_scan_point;
			quit = rev_scan_done;
			cycling = run;
			break;
              case MCE_scan_point:
	      		B = memory[B_addr];
			if(BA8421(B) == 59)  /* BCD '.' */
			   { /* found point */
			    rev_scan_done = true;
			   } /* found point */
			single_cycle_state = MCE_store_blank;
			cycling = run;
			break;
	      case MCE_store_B_forward:
	      		memory[B_addr] = B;
			single_cycle_state = MCE_fetch_B_forward;
			cycling = run;
			break;
	      case MCE_float_dollar_f:
	      		B_addr--;
			B = memory[B_addr];
			if(BA8421(B) == 0)  /* space? */
			    single_cycle_state = MCE_float_dollar_s;
			else
				single_cycle_state = MCE_float_dollar_f;
			cycle = cycle_B;
			cycling = run;
			break;
	      case MCE_float_dollar_s:
	      		memory[B_addr] = B = 43; /* BCD '$' */
			cycle = cycle_B;
			cycling = run;
			single_cycle_state = single_cycle_complete;
			quit = true;
			B_addr--;
			break;
	      default:
	      		sprintf(diag_buffer,"Illegal microstate %s",single_cycle_decode());
			tell(diag_buffer);
			result = false;
			cycling = run;
			break;
	     } /* state decode */

	      if(quit) 
	      	{
		 single_cycle_state = single_cycle_complete;
		 break;
		}
 	  
	  report = diagnostics_on && (!run || debug_MCE ||
	  			single_cycle_state == single_cycle_complete);
          if(report)
	     { /* report */
	  	tell_mce_state();
		if(check_mouse_halt())
		   { /* abort */
		    tell("***** MOUSE ABORT *****");
		    cycling = false;
		    break;
		   } /* abort */
	     } /* report */
	 } /* move chars */
	  
      tell_new_state("MCE");
      return result;	
    }

/****************************************************************************
*                               tell_mce_state
* Effect: 
*       Puts state of MCE to diagnostic file
****************************************************************************/

void tell_mce_state()
    {
     char * p = diag_buffer;
     p += sprintf(p,"MCE: [%s] => %s",
     		mce_state_decode(last_state),
		mce_state_decode(single_cycle_state));

     p += sprintf(p,", A=%s%c, B=%s%c",
     			(WM(A) ? "^" : ""),
     			bcd_to_ascii(A),
			(WM(B) ? "^" : ""),
     			bcd_to_ascii(B));
     p += sprintf(p,", A_addr=%d, B_addr=%d", A_addr, B_addr);
     if(a_done)
     	p += sprintf(p,", A done");
     if(b_done)
        p += sprintf(p,", B done");
     if(dollar)
        p += sprintf(p," $");
     if(asterisk)
        p += sprintf(p," *");
     if(decimal)
        p += sprintf(p," -.-");
     if(sig0)
        p += sprintf(p," -0-");
     if(fwd_scan_done)
        p += sprintf(p," fwd-done");
     if(rev_scan_done)
        p += sprintf(p," rev-done");
     if(any_digit_placed)
        p += sprintf(p," digit-placed");
     if(digit_seen)
        p += sprintf(p,"digit_seen");
     tell(diag_buffer);
    }

/****************************************************************************
*                             mce_state_decode
* Inputs:
*	short state: State to decode
* Result: char *
*       printable state string
****************************************************************************/

char * mce_state_decode(state)
    short state;
    {
     switch(state)
        { /* decode */
	 case single_cycle_run:         return "run";
	 case single_cycle_start:	return "start";
	 case single_cycle_complete:	return "complete";
	 case MCE_init_a_fetch:		return "init_a_fetch";
	 case MCE_fetch_A:		return "fetch_A";
	 case MCE_fetch_B:		return "fetch_B";
	 case MCE_store_B:		return "store_B";
	 case MCE_store_A:		return "store_A";
	 case MCE_fetch_B_forward:	return "fetch_B_forward";
	 case MCE_store_B_forward:	return "store_B_forward";	 
	 case MCE_float_dollar_f:	return "float_dollar_f";
	 case MCE_float_dollar_s:	return "float_dollar_s";
	 case MCE_store_blank:		return "store_blank";
	 case MCE_scan_point:		return "scan_point";
	 default:			return "?";
	} /* decode */
     /*NOTREACHED */
     return NULL;
    }
