/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 16-Nov-85 | [1.58] Created
*  6-Aug-86 | [1.410] Call ascii_to_bcd with unsigned char argument
*  6-Aug-86 | [1.410] Include bcd.h
*  6-Aug-86 | [1.412] include disp.h, make pretty colors on color display
* 18-Aug-86 | [1.414] screen.h -> bscreen.h
* 10-Nov-91 | [1.428] <jmn> converted to Microsoft C 6.0
* 06-Mar-92	<jrj> fixed erroneous compaison of unsigned char to -1
*****************************************************************************/

#include "bcd.h"
#include "disp.h"
/* #include "graph.h" */
#include "boolean.h"

#include "btypes.h"
#include "scdspmsg.h"
#include "color.h"
#include "hercules.h"
#include "pause.h"
#include "display.h"
#include "beep.h"
#include "chars.h"

/*****************************************************************************
				1401 Simulator

			     Card Punch Simulation

Prints out an image of a card on the screen with a message shown as punched
holes

  Ŀ
/xxxx                                                                        
B                                                                          
A                                                                           
0                                                                          
1                                                                          
2                                                                           
3                                                                         
4                                                                           
5                                                                           
6                                                                           
7                                                                          
8                                                                          
9                                                                          


*****************************************************************************/

#define h12 04000
#define h11 02000
#define h0  01000
#define h1  00400
#define h2  00200
#define h3  00100
#define h4  00040
#define h5  00020
#define h6  00010
#define h7  00004
#define h8  00002
#define h9  00001
#define hnone 00000
/*   hole pattern +-0123456789     bcd   character
                  :::...:::...
     -------------------------     ---   ---------   */

short holes[64] = {hnone,	/*  0	 space */
		   h1,		/*  1    1 */
		   h2,		/*  2    2 */
		   h3,		/*  3	 3 */
		   h4,		/*  4	 4 */
		   h5,		/*  5    5 */
		   h6,		/*  6	 6 */
		   h7,		/*  7	 7 */
		   h8,		/*  8	 8 */
		   h9,		/*  9	 9 */
		   h0,		/*  10	 0 */
		   h3+h8,	/*  11	 =# 3-8   */
		   h0+h6+h8,	/*  12	 \  0-6-8 */
		   h5+h8,	/*  13	 :  5-8	  */
		   h6+h8,	/*  14	 >  6-8	  */
		   h7+h8,	/*  15	   7-8	  */
		   h2+h8,	/*  16	 b  2-8	  */
		   h0+h1,	/*  17	 /  0-1	  */
		   h0+h2,	/*  18	 S  0-2	  */
		   h0+h3,	/*  19 	 T  0-3	  */
		   h0+h4,	/*  20	 U  0-4	  */
		   h0+h5,	/*  21	 V  0-5	  */
		   h0+h6,	/*  22	 W  0-6	  */
		   h0+h7,	/*  23	 X  0-7	  */
		   h0+h8,	/*  24	 Y  0-8	  */
		   h0+h9,	/*  25	 Z  0-9	  */
		   h0+h2+h8,	/*  26	   0-2-8 */
		   h0+h3+h8,	/*  27	 ,  0-3-8 */
		   h0+h4+h8,	/*  28	 (  0-4-8 */
		   h0+h5+h8,	/*  29	 ^  0-5-8 */
		   h0+h6+h8,	/*  30	 \  0-6-8 */
		   h0+h7+h8,	/*  31	   0-7-8 */
		   h11,		/*  32	 -  11	  */
		   h11+h1,	/*  33	 J  11-1  */
		   h11+h2,	/*  34	 K  11-2  */
		   h11+h3,	/*  35	 L  11-3  */
		   h11+h4,	/*  36	 M  11-4  */
		   h11+h5,	/*  37	 N  11-5  */
		   h11+h6,	/*  38	 O  11-6  */
		   h11+h7,	/*  39	 P  11-7  */
		   h11+h8,	/*  40	 Q  11-8  */
		   h11+h9,	/*  41	 R  11-9  */
		   h11+h0,	/*  42	 !  11-0  */
		   h11+h3+h8,	/*  43	 $  11-3-8*/
		   h11+h4+h8,	/*  44	 *  11-4-8*/
		   h11+h5+h8,	/*  45	 ]  11-5-8*/
		   h11+h6+h8,	/*  46	 ;  11-6-8*/
		   h11+h7+h8,	/*  47	   11-7-8*/
		   h12,		/*  48	 +& 12	  */
		   h12+h1,	/*  49	 A  12-1  */
		   h12+h2,	/*  50	 B  12-2  */
		   h12+h3,	/*  51	 C  12-3  */
		   h12+h4,	/*  52	 D  12-4  */
		   h12+h5,	/*  53	 E  12-5  */
		   h12+h6,	/*  54	 F  12-6  */
		   h12+h7,	/*  55	 G  12-7  */
		   h12+h8,	/*  56	 H  12-8  */
		   h12+h9,	/*  57	 I  12-9  */
		   h12+h0,	/*  58	 ?  12-0  */
		   h12+h3+h8,	/*  59	 .  12-3-8*/
		   h12+h4+h8,	/*  60	 )  12-4-8*/
		   h12+h5+h8,	/*  61	 [  12-5-8*/
		   h12+h6+h8,	/*  62	 <  12-6-8*/
		   h12+h7+h8,	/*  63	   12-7-8*/
		};

#define CARD_X ((coord)0)
#define CARD_Y ((coord)5)
#define CARD_LENGTH ((coord)80)

/****************************************************************************
*                                 blank_card
* Inputs:
*	attrib fore: Foreground card color
*	attrib back: Background card color
* Effect: 
*       Draws a blank card on the screen
****************************************************************************/

void blank_card(attrib fore,attrib back)
    {
     coord j;
     static char columns[] = "  0123456789";

     sccurset(0,0);

     for(j=0;j<25;j++)
        { /* blank it out */
	 sccurset(j,0);
	 scattrib(fore,back,(char) ' ',80);
	} /* blank it out */
     sccurset(CARD_Y,CARD_X);
     scattrib(fore,back,(char) ' ',1);
     sccurset(CARD_Y,CARD_X+1);
     scattrib(fore,back,(char) char_corner1,1);
     sccurset(CARD_Y,CARD_X+2);
     scattrib(fore,back,(char) '',CARD_LENGTH-2);
     sccurset(CARD_Y,CARD_X+CARD_LENGTH-1);
     scattrib(fore,back,(char) '',1);
     sccurset(CARD_Y+1,CARD_X);
     scattrib(fore,back,(char) char_corner2,1);
     sccurset(CARD_Y+1,CARD_X+1);
     scattrib(fore,back,(char) ' ',CARD_LENGTH-2);
     sccurset(CARD_Y+1,CARD_X+CARD_LENGTH-1);
     scattrib(fore,back,(char) '',1);
     for(j=0;j<12;j++)
	{ /* draw row */
	 sccurset((coord)(CARD_Y+2+j),CARD_X);
	 scattrib(fore,back,(char) '',1);
	 sccurset((coord)(CARD_Y+2+j),CARD_X+1);
	 scattrib(fore,back,columns[j],CARD_LENGTH-2);
	 sccurset((coord)(CARD_Y+2+j),CARD_X+CARD_LENGTH-1);
	 scattrib(fore,back,(char) '',1);
	} /* draw row */
     sccurset(CARD_Y+14,CARD_X);
     scattrib(fore,back,(char) '',1);
     sccurset(CARD_Y+14,CARD_X+1);
     scattrib(fore,back,(char) '',CARD_LENGTH-2);
     sccurset(CARD_Y+14,CARD_X+CARD_LENGTH-1);
     scattrib(fore,back,(char) '',1);
    }

/****************************************************************************
*                                    card
* Inputs:
*       char * msg: Message to write
*		must be in the ASCII representation of the BCD set
*		message must not exceed 75 characters
* Effect: 
*       Draws on the screen a card image of the message.
****************************************************************************/

void card(char * msg)
    {
     coord i;
     char * p;
     attrib fore;
     attrib back;

     if(ismono())
        { /* mono */
	 fore = H_NORMAL;
	 back = COLOR_BLACK;
	} /* mono */
     else
        { /* color */
	 fore = COLOR_YELLOW;
	 back = COLOR_BLUE;
	} /* color */

     blank_card(fore,back);

     p = msg;

     for(i=0;i<CARD_LENGTH-2;i++)
        { /* punch holes */
	 coord j;
	 unsigned char bcd;
	 int hole_pattern;

	 if(*p == '\n' || *p == '\0') 
	    break;
	 bcd = ascii_to_bcd( (unsigned char) *p);
	 if(bcd == /* -1 */ 0xff) bcd = 0; /* illegal characters become spaces */

#if 0
	 sccurset(CARD_Y+15,CARD_X+1);
	 printf("%s",msg);
	 sccurset(CARD_Y+16,CARD_X+1+i);
	 printf("%c",*p);
	 sccurset(CARD_Y+17,CARD_X+1+i);
	 printf("%c",bcd_to_ascii(bcd));
#endif
	 hole_pattern = holes[bcd];

	 for(j=0;j<12;j++)
	    { /* punch one */
	     if(hole_pattern & 1)
	        { /* punch it */
		 sccurset((coord)(CARD_Y+13-j),(coord)(CARD_X+1+i));
		 scattrib(fore,back,(char) '',1);
		} /* punch it */
	     hole_pattern >>= 1;
	     if(hole_pattern == 0) 
		break;
	    } /* punch one */
	 click_on();
	 pause(100);
	 click_off();
	 speaker_off();
	 sccurset((coord)(CARD_Y+1),(coord)(CARD_X+1+i));
	 scattrib(fore,back,bcd_to_ascii(bcd),1);
	 p++;
	} /* punch holes */

    }

