/*****************************************************************************
*           Change Log
*  Date     | Change
*-----------+-----------------------------------------------------------------
* 15-Dec-85 | [1.212] Created
* 25-Jan-86 | [1.327] Check for bad length
* 25-Feb-86 | [1.379] Include <> => include ""
* 10-Nov-91 | [1.428] <jmn> added prototypes for C 6.0
* 18-Nov-91 | [1.428] <jmn> memory.h => mem1401.h, avoid ANSI name
*****************************************************************************/

#include "mem1401.h"
#include "boolean.h"
#include "mach.h"
#include "btypes.h"
#include "diag.h"
#include "instr.h"
#include "ifetch.h"
#include "arith.h"
#include "addr.h"

/*****************************************************************************
				1401 Simulator

			       Add Instruction


			      Add (Two Addresses)
			      -------------------

Instruction format

Mnemonic	Op Code	A-address	B-address
--------        ------- ---------       ---------
A		A	AAA		BBB

Function: The data in the A-field is added to the B-field.  The result
is stored in the B-field.

Word Marks: The B-field must have a defining word mark, because it is this
word mark which actually stops the add operation.

The A-field must have a word mark only if it is shorter than the B-field.
In this case, the transmission of data from the A-field stops after the
A-field word mark is sensed.  Zeros are then inserted in the A-register
until the B-field word mark is sensed.

If the A-field is longer than the B-field, the high-order positions of
the A-field that exceed the limits imposed by the B-field are not processed.
For overflow conditions and considerations, assume that the A-field is
the same length as the B-field.


Address Registers After Operation:

I-Add		A-Add		B-Add
-----		-----		-----
NSI		A-Lw		B-Lw

Chaining: This instruction can be chained to the preceding operation (if
that instruction left usable address-register contents) by supplying
only the operation code.


			       Add (One Address)
			       -----------------
Instruction format

Mnemonic	Op Code	A-address
--------        ------- ---------
A		A	AAA		

Function: The contents of the A-field is added to itself.

Address Registers After Operation:

I-Add		A-Add		B-Add
-----           -----           -----
NSI		A-La		A-La

Chaining: This instruction can be chained to the preceding operation (if
that instruction left usable address-register contents) by supplying
only the operation code.


*****************************************************************************/


/****************************************************************************
*                                   inst_A
* result: boolean
*	true if instruction succeeded
*	false if instruction failed
* Effect: 
*	Executes add instruction
****************************************************************************/

boolean inst_A()
    {
     boolean result;

     tell_op(op_A|op_B);

     switch(I_cycle)
         {
	  case 1: /* chained */
	  case 4: /* one-address */
	  case 7: /* two-address */
	  	break;
	  default: /* Illegal length */
	  	illegal_length();
	  	return false;
	 }

     result = arith(true);  /* arith(add-op) */
	  
     tell_new_state("A");
     return result;	
    }
